/*
 * Decompiled with CFR 0.152.
 */
package mp.isrpapi;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientBatchIndexBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.impl.SunEcmClientSocketApiImpl;
import com.sunyard.util.OptionKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mp.constant.IsrpConstant;
import mp.model.FileElementModel;
import mp.model.InitModel;
import mp.model.IsrpResult;
import mp.model.TxnElementModel;
import mp.tools.ImageUtil;
import mp.tools.StringUtil;
import org.apache.log4j.Logger;

public class SunEcmAPI {
    private static Logger logger = Logger.getLogger(SunEcmAPI.class);
    private SunEcmClientApi clientApi;
    private String groupName;

    public SunEcmAPI(String ip, String socketPort, String groupName) {
        this.groupName = groupName;
        this.clientApi = new SunEcmClientSocketApiImpl(ip, Integer.parseInt(socketPort));
        if (this.clientApi == null) {
            logger.info((Object)"###\u6784\u9020\u7ba1\u7406\u5e73\u53f0\u5931\u8d25\uff01###");
        }
        logger.info((Object)"###\u6784\u9020\u7ba1\u7406\u5e73\u53f0API\u5bf9\u8c61\u6210\u529f\uff01###");
    }

    public IsrpResult UploadOCX(InitModel tokenModel, TxnElementModel txnModel, List<FileElementModel> fileModelList) {
        try {
            String resultMsg;
            ClientBatchBean clientBatchBean = new ClientBatchBean();
            clientBatchBean.setModelCode(txnModel.getBatchModelCode());
            clientBatchBean.setBreakPoint(false);
            clientBatchBean.setOwnMD5(true);
            clientBatchBean.setToken_code(tokenModel.getToken());
            clientBatchBean.setAPP_ID(txnModel.getAppNo());
            clientBatchBean.setCredit_union_code(tokenModel.getLeganNo());
            clientBatchBean.setOrganization_code(tokenModel.getOrganNo());
            clientBatchBean.setEmployee_number(tokenModel.getOprId());
            ClientBatchIndexBean clientBatchIndexBean = new ClientBatchIndexBean();
            clientBatchIndexBean.addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
            clientBatchIndexBean.addCustomMap("BUSI_SERIAL_NO", txnModel.getTxnNo());
            if (!StringUtil.isEmpty(txnModel.getTreeJson())) {
                clientBatchIndexBean.addCustomMap("TREE_JSON", txnModel.getTreeJson());
            }
            if (!StringUtil.isEmpty(txnModel.getPieceTxnNo())) {
                clientBatchIndexBean.addCustomMap("ORG_SERIAL_NO", txnModel.getPieceTxnNo());
            }
            if (!StringUtil.isEmpty(txnModel.getPieceBatchVersion())) {
                clientBatchIndexBean.addCustomMap("ORG_BATCH_VERSION", txnModel.getPieceBatchVersion());
            }
            if (!StringUtil.isEmpty(txnModel.getPieceCreateDate())) {
                clientBatchIndexBean.addCustomMap("ORG_CREATE_DATE", txnModel.getPieceCreateDate());
            }
            if (!StringUtil.isEmpty(txnModel.getReferenceFile())) {
                clientBatchIndexBean.addCustomMap("REFERENCE_FILE", txnModel.getReferenceFile());
            }
            if (!StringUtil.isEmpty(txnModel.getBatchId())) {
                clientBatchIndexBean.setContentID(txnModel.getBatchId());
            }
            clientBatchBean.setIndex_Object(clientBatchIndexBean);
            if (fileModelList != null && fileModelList.size() > 0) {
                HashSet<String> fileModelCodeSet = new HashSet<String>();
                for (FileElementModel fileModel : fileModelList) {
                    String fileModelcode = fileModel.getFileModelCode();
                    fileModelCodeSet.add(fileModelcode);
                }
                for (String fileCode : fileModelCodeSet) {
                    ClientBatchFileBean clientBatchFileBean = new ClientBatchFileBean();
                    clientBatchFileBean.setFilePartName(fileCode);
                    for (FileElementModel fileModel : fileModelList) {
                        if (!fileModel.getFileModelCode().equals(fileCode)) continue;
                        String filePath = fileModel.getFilePath();
                        String fileFormat = fileModel.getFileType();
                        String fileSaveName = fileModel.getFileSaveName();
                        BufferedInputStream fileStream = null;
                        if (fileModel.getFileStream() != null) {
                            fileStream = new BufferedInputStream(fileModel.getFileStream());
                            fileStream.mark(Integer.MAX_VALUE);
                        }
                        String nodeSeq = fileModel.getNodeSeq();
                        String imageSeq = fileModel.getImageSeq();
                        String operType = fileModel.getOpertype();
                        String MD5 = fileModel.getMd5();
                        String noteStream = fileModel.getNoteStream();
                        String checkFile = fileModel.getCheckFile();
                        String Attribute2 = fileModel.getBusiAttribute();
                        String orgFileNo = fileModel.getOrgFileNo();
                        String orgTemplateCode = fileModel.getOrgTemplateCode();
                        String pieceCode = fileModel.getPieceCode();
                        String pieceName = fileModel.getPieceName();
                        String FieldCode = fileModel.getFieldCode();
                        String FieldName = fileModel.getFieldName();
                        Map<String, String> otherAttMap = fileModel.getFileOtherAttMap();
                        ClientFileBean fileBean = new ClientFileBean();
                        if (!StringUtil.isEmpty(filePath)) {
                            fileStream = new BufferedInputStream(new FileInputStream(filePath));
                            fileStream.mark(Integer.MAX_VALUE);
                            fileBean.setFileName(filePath);
                            fileBean.setISDOCFLOW(false);
                        } else {
                            fileBean.setISDOCFLOW(true);
                            fileBean.setDOCFLOW((InputStream)fileStream);
                            fileBean.setFileName(fileSaveName);
                        }
                        fileBean.setFileFormat(fileFormat);
                        if (StringUtil.isEmpty(fileSaveName)) {
                            int index = filePath.replace("\\", "/").replace("/", File.separator).lastIndexOf(File.separator);
                            fileSaveName = filePath.replace("\\", "/").replace("/", File.separator).substring(index + 1);
                        }
                        fileBean.addOtherAtt("ORG_FILENAME", fileSaveName);
                        String UUIDStr = UUID.randomUUID().toString().replace("-", "");
                        fileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "." + fileFormat);
                        fileBean.addOtherAtt("UPLOADED", "Y");
                        if (nodeSeq != null) {
                            fileBean.addOtherAtt("NODESEQ", nodeSeq);
                        }
                        if (imageSeq != null) {
                            fileBean.addOtherAtt("IMAGESEQ", imageSeq);
                        }
                        if (operType != null) {
                            fileBean.addOtherAtt("OPERTYPE", operType);
                        }
                        if (MD5 != null) {
                            fileBean.addOtherAtt("MD5", MD5);
                        }
                        if (noteStream != null) {
                            fileBean.addOtherAtt("NOTESTREAM", noteStream);
                        }
                        if (checkFile != null) {
                            fileBean.addOtherAtt("CHECKFILE", checkFile);
                        }
                        if (Attribute2 != null) {
                            fileBean.addOtherAtt("BUSIATTRIBUTE", Attribute2);
                        }
                        if (orgFileNo != null) {
                            fileBean.addOtherAtt("ORG_FILE_NO", orgFileNo);
                        }
                        if (orgTemplateCode != null) {
                            fileBean.addOtherAtt("ORG_TEMPLATE_CODE", orgTemplateCode);
                        }
                        if (pieceCode != null) {
                            fileBean.addOtherAtt("PIECE_CODE", pieceCode);
                        }
                        if (pieceName != null) {
                            fileBean.addOtherAtt("PIECE_NAME", pieceName);
                        }
                        if (FieldCode != null) {
                            fileBean.addOtherAtt("FIELD_CODE", FieldCode);
                        }
                        if (FieldName != null) {
                            fileBean.addOtherAtt("FIELD_NAME", orgFileNo);
                        }
                        if (otherAttMap != null) {
                            for (Map.Entry<String, String> entry : otherAttMap.entrySet()) {
                                fileBean.addOtherAtt(entry.getKey(), entry.getValue());
                            }
                        }
                        if (ImageUtil.isImage(fileStream)) {
                            InputStream smallStream = ImageUtil.getSmallImg(fileStream, tokenModel.getSmSize());
                            if (smallStream == null) {
                                return new IsrpResult(IsrpConstant.FAIL, "\u3010\u4e0a\u4f20\u5f02\u5e38\u3011\uff1a\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", null);
                            }
                            String uidStr = UUID.randomUUID().toString();
                            fileBean.setSAVE_UID(uidStr);
                            fileBean.setISSMALL(false);
                            fileBean.addOtherAtt("FILETYPE", "I");
                            ClientFileBean smallFileBean = new ClientFileBean();
                            smallFileBean.setISSMALL(true);
                            smallFileBean.setSAVE_UID(uidStr);
                            smallFileBean.setISDOCFLOW(true);
                            smallFileBean.setDOCFLOW(smallStream);
                            smallFileBean.setFileName(String.valueOf(UUIDStr) + "_SM." + fileFormat);
                            smallFileBean.setFileFormat(fileFormat);
                            smallFileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "_SM." + fileFormat);
                            smallFileBean.addOtherAtt("FILETYPE", "I");
                            smallFileBean.addOtherAtt("UPLOADED", "Y");
                            clientBatchFileBean.addFile(smallFileBean);
                        } else if (ImageUtil.isText(fileFormat)) {
                            fileBean.addOtherAtt("FILETYPE", "T");
                        } else if (ImageUtil.isAudio(fileFormat)) {
                            fileBean.addOtherAtt("FILETYPE", "M");
                        } else if (ImageUtil.isVideo(fileFormat)) {
                            fileBean.addOtherAtt("FILETYPE", "V");
                        } else {
                            fileBean.addOtherAtt("FILETYPE", "O");
                        }
                        clientBatchFileBean.addFile(fileBean);
                    }
                    clientBatchBean.addDocument_Object(clientBatchFileBean);
                }
            }
            if (!StringUtil.isEmpty(resultMsg = this.clientApi.upload(clientBatchBean, this.groupName)) && resultMsg.contains("SUCCESS")) {
                logger.info((Object)("#######\u4e0a\u4f20\u8fd4\u56de\u7684\u4fe1\u606f[" + resultMsg + "]#######"));
                String[] result = resultMsg.split("<<::>>");
                String contentId = result[1];
                return new IsrpResult(IsrpConstant.SUCCESS, "\u4e0a\u4f20\u6210\u529f\uff01", contentId);
            }
            return new IsrpResult(IsrpConstant.FAIL, resultMsg, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return new IsrpResult(IsrpConstant.FAIL, "\u3010\u4e0a\u4f20\u5f02\u5e38\u3011:" + e, null);
        }
    }

    public String checkOut(InitModel tokenModel, TxnElementModel txnModel) {
        String checkToken = "";
        if (!this.checkBatch(tokenModel, txnModel)) {
            return "";
        }
        ClientBatchBean clientBatchBean = new ClientBatchBean();
        clientBatchBean.setToken_code(tokenModel.getToken());
        clientBatchBean.setAPP_ID(txnModel.getAppNo());
        clientBatchBean.setModelCode(txnModel.getBatchModelCode());
        clientBatchBean.getIndex_Object().addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
        clientBatchBean.getIndex_Object().setContentID(txnModel.getBatchId());
        try {
            checkToken = this.clientApi.checkOut(clientBatchBean, this.groupName);
            if (!StringUtil.isEmpty(checkToken) && checkToken.contains("SUCCESS")) {
                String[] result = checkToken.split("<<::>>");
                checkToken = result[1];
                return checkToken;
            }
            logger.info((Object)("#######\u68c0\u51fa\u8fd4\u56de\u7684\u4fe1\u606f[" + checkToken + "]#######"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return checkToken;
    }

    public boolean checkBatch(InitModel tokenModel, TxnElementModel txnModel) {
        ClientBatchBean batchBean = new ClientBatchBean();
        batchBean.setToken_code(tokenModel.getToken());
        batchBean.setAPP_ID(txnModel.getAppNo());
        batchBean.setCredit_union_code(tokenModel.getLeganNo());
        batchBean.setModelCode(txnModel.getBatchModelCode());
        String version = txnModel.getBatchVersion();
        if ("".equals(version) || version == null) {
            version = "0";
        }
        batchBean.getIndex_Object().setVersion(version);
        batchBean.getIndex_Object().setContentID(txnModel.getBatchId());
        batchBean.getIndex_Object().addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
        if (batchBean != null) {
            try {
                String resultMsg = this.clientApi.queryBatch(batchBean, this.groupName);
                if (!StringUtil.isEmpty(resultMsg) && resultMsg.contains("CONTENT_ID")) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean checkIn(InitModel tokenModel, TxnElementModel txnModel, String checkToken) {
        String resultMsg;
        block4: {
            ClientBatchBean clientBatchBean = new ClientBatchBean();
            clientBatchBean.setToken_code(tokenModel.getToken());
            clientBatchBean.setAPP_ID(txnModel.getAppNo());
            clientBatchBean.setModelCode(txnModel.getBatchModelCode());
            clientBatchBean.getIndex_Object().addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
            clientBatchBean.getIndex_Object().setContentID(txnModel.getBatchId());
            if (StringUtil.isEmpty(checkToken)) {
                return false;
            }
            clientBatchBean.setCheckToken(checkToken);
            resultMsg = this.clientApi.checkIn(clientBatchBean, this.groupName);
            if (StringUtil.isEmpty(resultMsg) || !resultMsg.contains("SUCCESS")) break block4;
            return true;
        }
        try {
            logger.debug((Object)("#######\u68c0\u5165\u8fd4\u56de\u7684\u4fe1\u606f[" + resultMsg + "]#######"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public IsrpResult delete(InitModel tokenModel, TxnElementModel txnModel) {
        String newVersion = "-1";
        String checkToken = "";
        try {
            checkToken = this.checkOut(tokenModel, txnModel);
            if (StringUtil.isEmpty(checkToken)) {
                IsrpResult isrpResult = new IsrpResult(IsrpConstant.FAIL, "\u3010\u5220\u9664\u5f02\u5e38\u3011:\u6279\u6b21\u68c0\u51fa\u5931\u8d25\uff01", newVersion);
                return isrpResult;
            }
            ClientBatchBean clientBatchBean = new ClientBatchBean();
            clientBatchBean.setModelCode(txnModel.getBatchModelCode());
            clientBatchBean.setToken_code(tokenModel.getToken());
            clientBatchBean.setAPP_ID(txnModel.getAppNo());
            clientBatchBean.setCredit_union_code(tokenModel.getLeganNo());
            clientBatchBean.setEmployee_number(tokenModel.getOprId());
            clientBatchBean.getIndex_Object().setContentID(txnModel.getBatchId());
            clientBatchBean.getIndex_Object().setVersion(txnModel.getBatchVersion());
            clientBatchBean.getIndex_Object().addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
            clientBatchBean.setCheckToken(checkToken);
            String resultMsg = this.clientApi.delete(clientBatchBean, this.groupName);
            logger.info((Object)("#######\u5220\u9664\u6279\u6b21\u8fd4\u56de\u7684\u4fe1\u606f[" + resultMsg + "]#######"));
            if (!StringUtil.isEmpty(resultMsg) && resultMsg.contains("SUCCESS")) {
                newVersion = resultMsg.split("<<::>>")[2];
                IsrpResult isrpResult = new IsrpResult(IsrpConstant.SUCCESS, "\u6279\u6b21\u5220\u9664\u6210\u529f\uff01", newVersion);
                return isrpResult;
            }
            IsrpResult isrpResult = new IsrpResult(IsrpConstant.FAIL, resultMsg, newVersion);
            return isrpResult;
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        finally {
            this.checkIn(tokenModel, txnModel, checkToken);
        }
        return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38\uff01", newVersion);
    }

    public String getTemplateXml(String modelCode, String FileModelCode) {
        String[] modeCodes = new String[]{modelCode, FileModelCode};
        try {
            String resultMsg = this.clientApi.getModelTemplate_Client(modeCodes);
            logger.debug((Object)("#######\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u8fd4\u56de\u7684\u4fe1\u606f[" + resultMsg + "]#######"));
            if (!StringUtil.isEmpty(resultMsg) && resultMsg.contains("0001")) {
                String xmlstr = resultMsg.split("<<::>>")[1];
                return xmlstr;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public IsrpResult update(InitModel tokenModel, TxnElementModel txnModel, List<FileElementModel> fileModelList) {
        String newVersion = "-1";
        try {
            String resultMsg;
            ClientBatchBean clientBatchBean = new ClientBatchBean();
            clientBatchBean.setModelCode(txnModel.getBatchModelCode());
            clientBatchBean.setOwnMD5(true);
            clientBatchBean.setToken_code(tokenModel.getToken());
            clientBatchBean.setAPP_ID(txnModel.getAppNo());
            clientBatchBean.setCredit_union_code(tokenModel.getLeganNo());
            clientBatchBean.setEmployee_number(tokenModel.getOprId());
            clientBatchBean.getIndex_Object().setContentID(txnModel.getBatchId());
            clientBatchBean.getIndex_Object().setVersion(txnModel.getBatchVersion());
            clientBatchBean.getIndex_Object().addCustomMap("BUSI_START_DATE", txnModel.getCreateDate());
            if (!StringUtil.isEmpty(txnModel.getTreeJson())) {
                clientBatchBean.getIndex_Object().addCustomMap("TREE_JSON", txnModel.getTreeJson());
            }
            if (!StringUtil.isEmpty(txnModel.getReferenceFile())) {
                clientBatchBean.getIndex_Object().addCustomMap("REFERENCE_FILE", txnModel.getReferenceFile());
            }
            if (fileModelList != null && fileModelList.size() > 0) {
                HashSet<String> fileModelCodeSet = new HashSet<String>();
                if (fileModelList != null && fileModelList.size() > 0) {
                    for (FileElementModel fileModel : fileModelList) {
                        String fileModelcode = fileModel.getFileModelCode();
                        fileModelCodeSet.add(fileModelcode);
                    }
                }
                for (String fileCode : fileModelCodeSet) {
                    ClientBatchFileBean batchFileBean = new ClientBatchFileBean();
                    batchFileBean.setFilePartName(fileCode);
                    for (FileElementModel fileModel : fileModelList) {
                        ClientFileBean smallFileBean;
                        Object uidStr;
                        String UUIDStr;
                        ClientFileBean fileBean;
                        if (!fileModel.getFileModelCode().equals(fileCode)) continue;
                        String filePath = fileModel.getFilePath();
                        String fileFormat = fileModel.getFileType();
                        String fileSaveName = fileModel.getFileSaveName();
                        String fileNo = fileModel.getImageId();
                        BufferedInputStream fileStream = null;
                        if (fileModel.getFileStream() != null) {
                            fileStream = new BufferedInputStream(fileModel.getFileStream());
                            fileStream.mark(Integer.MAX_VALUE);
                        }
                        String nodeSeq = fileModel.getNodeSeq();
                        String imageSeq = fileModel.getImageSeq();
                        String operType = fileModel.getOpertype();
                        String MD5 = fileModel.getMd5();
                        String noteStream = fileModel.getNoteStream();
                        String checkFile = fileModel.getCheckFile();
                        String Attribute2 = fileModel.getBusiAttribute();
                        Map<String, String> otherAttMap = fileModel.getFileOtherAttMap();
                        if (OptionKey.U_ADD.equals(operType)) {
                            fileBean = new ClientFileBean();
                            if (!StringUtil.isEmpty(filePath)) {
                                fileStream = new BufferedInputStream(new FileInputStream(filePath));
                                fileStream.mark(Integer.MAX_VALUE);
                                fileBean.setFileName(filePath);
                                fileBean.setISDOCFLOW(false);
                            } else {
                                fileBean.setISDOCFLOW(true);
                                fileBean.setDOCFLOW((InputStream)fileStream);
                                fileBean.setFileName(fileSaveName);
                            }
                            fileBean.setOptionType(operType);
                            fileBean.setFileFormat(fileFormat);
                            if (StringUtil.isEmpty(fileSaveName)) {
                                int index = filePath.replace("\\", "/").replace("/", File.separator).lastIndexOf(File.separator);
                                fileSaveName = filePath.replace("\\", "/").replace("/", File.separator).substring(index + 1);
                            }
                            fileBean.addOtherAtt("ORG_FILENAME", fileSaveName);
                            UUIDStr = UUID.randomUUID().toString().replace("-", "");
                            fileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "." + fileFormat);
                            fileBean.addOtherAtt("UPLOADED", "Y");
                            if (nodeSeq != null) {
                                fileBean.addOtherAtt("NODESEQ", nodeSeq);
                            }
                            if (imageSeq != null) {
                                fileBean.addOtherAtt("IMAGESEQ", imageSeq);
                            }
                            if (MD5 != null) {
                                fileBean.addOtherAtt("MD5", MD5);
                            }
                            if (noteStream != null) {
                                fileBean.addOtherAtt("NOTESTREAM", noteStream);
                            }
                            if (checkFile != null) {
                                fileBean.addOtherAtt("CHECKFILE", checkFile);
                            }
                            if (Attribute2 != null) {
                                fileBean.addOtherAtt("BUSIATTRIBUTE", Attribute2);
                            }
                            if (otherAttMap != null) {
                                for (Map.Entry<String, String> entry : otherAttMap.entrySet()) {
                                    fileBean.addOtherAtt(entry.getKey(), entry.getValue());
                                }
                            }
                            if (ImageUtil.isImage(fileStream)) {
                                InputStream inputStream = ImageUtil.getSmallImg(fileStream, tokenModel.getSmSize());
                                if (inputStream == null) {
                                    return new IsrpResult(IsrpConstant.FAIL, "\u3010U_ADD\u5f02\u5e38\u3011\uff1a\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", "-1");
                                }
                                uidStr = UUID.randomUUID().toString();
                                fileBean.setSAVE_UID((String)uidStr);
                                fileBean.setISSMALL(false);
                                fileBean.addOtherAtt("FILETYPE", "I");
                                smallFileBean = new ClientFileBean();
                                smallFileBean.setISDOCFLOW(true);
                                smallFileBean.setDOCFLOW(inputStream);
                                smallFileBean.setFileName(String.valueOf(UUIDStr) + "_SM." + fileFormat);
                                smallFileBean.setFileFormat(fileFormat);
                                smallFileBean.setOptionType(operType);
                                smallFileBean.setISSMALL(true);
                                smallFileBean.setSAVE_UID((String)uidStr);
                                smallFileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "_SM." + fileFormat);
                                smallFileBean.addOtherAtt("FILETYPE", "I");
                                smallFileBean.addOtherAtt("UPLOADED", "Y");
                                batchFileBean.addFile(smallFileBean);
                            } else if (ImageUtil.isText(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "T");
                            } else if (ImageUtil.isAudio(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "M");
                            } else if (ImageUtil.isVideo(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "V");
                            } else {
                                fileBean.addOtherAtt("FILETYPE", "O");
                            }
                            batchFileBean.addFile(fileBean);
                            continue;
                        }
                        if (OptionKey.U_REPLACE.equals(operType)) {
                            fileBean = new ClientFileBean();
                            if (!StringUtil.isEmpty(filePath)) {
                                fileStream = new BufferedInputStream(new FileInputStream(filePath));
                                fileStream.mark(Integer.MAX_VALUE);
                                fileBean.setFileName(filePath);
                                fileBean.setISDOCFLOW(false);
                            } else {
                                fileBean.setISDOCFLOW(true);
                                fileBean.setDOCFLOW((InputStream)fileStream);
                                fileBean.setFileName(fileSaveName);
                            }
                            fileBean.setOptionType(operType);
                            fileBean.setFileNO(fileNo);
                            fileBean.setFileFormat(fileFormat);
                            if (StringUtil.isEmpty(fileSaveName)) {
                                int index = filePath.replace("\\", "/").replace("/", File.separator).lastIndexOf(File.separator);
                                fileSaveName = filePath.replace("\\", "/").replace("/", File.separator).substring(index + 1);
                            }
                            fileBean.addOtherAtt("ORG_FILENAME", fileSaveName);
                            UUIDStr = UUID.randomUUID().toString().replace("-", "");
                            fileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "." + fileFormat);
                            fileBean.addOtherAtt("FILETYPE", "");
                            if (nodeSeq != null) {
                                fileBean.addOtherAtt("NODESEQ", nodeSeq);
                            }
                            if (imageSeq != null) {
                                fileBean.addOtherAtt("IMAGESEQ", imageSeq);
                            }
                            if (MD5 != null) {
                                fileBean.addOtherAtt("MD5", MD5);
                            }
                            if (noteStream != null) {
                                fileBean.addOtherAtt("NOTESTREAM", noteStream);
                            }
                            if (checkFile != null) {
                                fileBean.addOtherAtt("CHECKFILE", checkFile);
                            }
                            if (Attribute2 != null) {
                                fileBean.addOtherAtt("BUSIATTRIBUTE", Attribute2);
                            }
                            if (otherAttMap != null) {
                                for (Map.Entry entry : otherAttMap.entrySet()) {
                                    fileBean.addOtherAtt((String)entry.getKey(), (String)entry.getValue());
                                }
                            }
                            if (ImageUtil.isImage(fileStream)) {
                                InputStream inputStream = ImageUtil.getSmallImg(fileStream, tokenModel.getSmSize());
                                if (inputStream == null) {
                                    return new IsrpResult(IsrpConstant.FAIL, "\u3010U_REPLACE\u5f02\u5e38\u3011\uff1a\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff01", newVersion);
                                }
                                uidStr = UUID.randomUUID().toString();
                                fileBean.setSAVE_UID((String)uidStr);
                                fileBean.setISSMALL(false);
                                fileBean.addOtherAtt("FILETYPE", "I");
                                smallFileBean = new ClientFileBean();
                                smallFileBean.setOptionType(operType);
                                smallFileBean.setFileNO(fileNo);
                                smallFileBean.setISDOCFLOW(true);
                                smallFileBean.setDOCFLOW(inputStream);
                                smallFileBean.setFileName(String.valueOf(UUIDStr) + "_SM." + fileFormat);
                                smallFileBean.setFileFormat(fileFormat);
                                smallFileBean.addOtherAtt("FILENAME", String.valueOf(UUIDStr) + "_SM." + fileFormat);
                                smallFileBean.addOtherAtt("FILETYPE", "I");
                                smallFileBean.setISSMALL(true);
                                smallFileBean.setSAVE_UID((String)uidStr);
                                batchFileBean.addFile(smallFileBean);
                            } else if (ImageUtil.isText(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "T");
                            } else if (ImageUtil.isAudio(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "M");
                            } else if (ImageUtil.isVideo(fileFormat)) {
                                fileBean.addOtherAtt("FILETYPE", "V");
                            } else {
                                fileBean.addOtherAtt("FILETYPE", "O");
                            }
                            batchFileBean.addFile(fileBean);
                            continue;
                        }
                        if (OptionKey.U_DEL.equals(operType)) {
                            fileBean = new ClientFileBean();
                            fileBean.setOptionType(operType);
                            fileBean.setFileNO(fileNo);
                            batchFileBean.addFile(fileBean);
                            continue;
                        }
                        if (!OptionKey.U_MODIFY.equals(operType)) continue;
                        fileBean = new ClientFileBean();
                        fileBean.setOptionType(operType);
                        if (!StringUtil.isEmpty(fileNo)) {
                            fileBean.setFileNO(fileNo);
                        }
                        if (nodeSeq != null) {
                            fileBean.addOtherAtt("NODESEQ", nodeSeq);
                        }
                        if (imageSeq != null) {
                            fileBean.addOtherAtt("IMAGESEQ", imageSeq);
                        }
                        if (MD5 != null) {
                            fileBean.addOtherAtt("MD5", MD5);
                        }
                        if (noteStream != null) {
                            fileBean.addOtherAtt("NOTESTREAM", noteStream);
                        }
                        if (checkFile != null) {
                            fileBean.addOtherAtt("CHECKFILE", checkFile);
                        }
                        if (Attribute2 != null) {
                            fileBean.addOtherAtt("BUSIATTRIBUTE", Attribute2);
                        }
                        if (otherAttMap != null) {
                            for (Map.Entry<String, String> entry : otherAttMap.entrySet()) {
                                fileBean.addOtherAtt(entry.getKey(), entry.getValue());
                            }
                        }
                        batchFileBean.addFile(fileBean);
                    }
                    clientBatchBean.addDocument_Object(batchFileBean);
                }
            }
            if (!StringUtil.isEmpty(resultMsg = this.clientApi.update(clientBatchBean, this.groupName, true)) && resultMsg.contains("SUCCESS")) {
                newVersion = resultMsg.split("<<::>>")[1];
                return new IsrpResult(IsrpConstant.SUCCESS, "\u6279\u6b21\u66f4\u65b0\u6210\u529f\uff01", newVersion);
            }
            return new IsrpResult(IsrpConstant.FAIL, resultMsg, newVersion);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38:" + e, newVersion);
        }
    }
}

