/*
 * Decompiled with CFR 0.152.
 */
package mp.isrpapi.isrpApiImpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mp.ocr.MPException;
import com.mp.ocr.MPREC;
import com.sunyard.util.OptionKey;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import mp.constant.ISRPOperConstant;
import mp.constant.IsrpConstant;
import mp.constant.UrlConstant;
import mp.enums.TxnOperType;
import mp.isrpapi.BaseProcess;
import mp.isrpapi.IsrpClientApi;
import mp.isrpapi.SunEcmAPI;
import mp.model.FileElementModel;
import mp.model.InitModel;
import mp.model.IsrpResult;
import mp.model.ResultModel;
import mp.model.TreeNode;
import mp.model.TxnElementModel;
import mp.model.WatermarkBean;
import mp.tools.FileUtil;
import mp.tools.ImageUtil;
import mp.tools.StringUtil;
import mp.tools.TokenBase64;
import org.apache.log4j.Logger;

public class IsrpClientApiHttpImpl
extends IsrpClientApi {
    private static Logger log = Logger.getLogger(IsrpClientApiHttpImpl.class);
    private BaseProcess baseProcess = new BaseProcess();
    private MPREC ocr = new MPREC();
    private String mode = "3";
    private String ip;
    private String socketPort;
    private String serverName;
    private String isrpURL;
    private InputStream is = this.getClass().getResourceAsStream("/image/123.png");

    public IsrpClientApiHttpImpl(String ip, String socketPort, String serverName) {
        this.ip = ip;
        this.socketPort = socketPort;
        this.socketPort = serverName;
        this.isrpURL = "http://" + ip + ":" + socketPort + "/" + serverName;
    }

    @Override
    public IsrpResult loginIsrp(String userId, String appCheck, String organNo, String leganNo, String appNo, String oprId) {
        String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_LOGIN;
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("userId", userId);
        textMap.put("appNo", appNo);
        textMap.put("appCheck", TokenBase64.encode(appCheck));
        textMap.put("oprId", oprId);
        textMap.put("leganNo", leganNo);
        textMap.put("organNo", organNo);
        StringBuffer respRes = new StringBuffer();
        try {
            if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
                return new IsrpResult(IsrpConstant.FAIL, respRes.toString(), null);
            }
            IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
            if (isrpResult == null) {
                return new IsrpResult(IsrpConstant.FAIL, "\u3010\u767b\u5f55\u5f02\u5e38\u3011:\u670d\u52a1\u5668\u7aef\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01", null);
            }
            if (isrpResult.getReasonId().equals(IsrpConstant.SUCCESS) && isrpResult.getObj() != null) {
                InitModel initModel = (InitModel)JSON.parseObject((String)isrpResult.getObj().toString(), InitModel.class);
                return new IsrpResult(IsrpConstant.SUCCESS, isrpResult.getMsg(), initModel);
            }
            return new IsrpResult(IsrpConstant.FAIL, isrpResult.getMsg(), null);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38\uff1a" + e, null);
        }
    }

    @Override
    public String logoutIsrp(String token) {
        String str = "";
        String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_LOGINOUT;
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("token", token);
        StringBuffer respRes = new StringBuffer();
        try {
            str = this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue() ? respRes.toString().trim() : "\u5f02\u5e38\uff1a" + respRes;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        return str;
    }

    @Override
    public IsrpResult getTreeJSON(InitModel tokenModel, String txnType) {
        JSONObject josnObject = new JSONObject();
        josnObject.put("tokenModel", (Object)tokenModel);
        String jsonstr = josnObject.toJSONString();
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("txnType", txnType);
        textMap.put("jsonstr", jsonstr);
        String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_TREEJSON;
        StringBuffer respRes = new StringBuffer();
        if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
            return new IsrpResult(IsrpConstant.FAIL, respRes.toString(), null);
        }
        IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
        return isrpResult;
    }

    @Override
    public IsrpResult filterQueryBatch(InitModel tokenModel, TxnElementModel txnModel, FileElementModel fileModel) {
        try {
            if (txnModel != null) {
                JSONObject josnObject = new JSONObject();
                josnObject.put("txnModel", (Object)txnModel);
                josnObject.put("fileModel", (Object)fileModel);
                String jsonstr = josnObject.toJSONString();
                HashMap<String, String> textMap = new HashMap<String, String>();
                textMap.put("token", tokenModel.getToken());
                textMap.put("jsonstr", jsonstr);
                String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_FILTER_QUERY;
                StringBuffer respRes = new StringBuffer();
                if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
                    return new IsrpResult(IsrpConstant.FAIL, respRes.toString(), null);
                }
                TxnElementModel txnEleModel = null;
                List fileModelList = null;
                IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
                if (isrpResult != null) {
                    if (isrpResult.getReasonId().equals(IsrpConstant.SUCCESS)) {
                        Map resultMap = new HashMap();
                        resultMap = (Map)isrpResult.getObj();
                        if (resultMap.get(ISRPOperConstant.TXN_ELEMENT_MODEL) != null) {
                            txnEleModel = (TxnElementModel)JSON.parseObject((String)resultMap.get(ISRPOperConstant.TXN_ELEMENT_MODEL).toString(), TxnElementModel.class);
                        }
                        if (resultMap.get(ISRPOperConstant.FILE_ELEMENT_MODEL) != null && (fileModelList = JSON.parseArray((String)resultMap.get(ISRPOperConstant.FILE_ELEMENT_MODEL).toString(), FileElementModel.class)) != null && fileModelList.size() > 0) {
                            for (FileElementModel model : fileModelList) {
                                String fileSaveName = model.getFileSaveName();
                                String fileName = model.getFileName();
                                if (!StringUtil.isEmpty(fileSaveName)) continue;
                                model.setFileSaveName(fileName);
                            }
                        }
                        HashMap<String, Object> modelMap = new HashMap<String, Object>();
                        modelMap.put(ISRPOperConstant.TXN_ELEMENT_MODEL, txnEleModel);
                        modelMap.put(ISRPOperConstant.FILE_ELEMENT_MODEL, fileModelList);
                        return new IsrpResult(IsrpConstant.SUCCESS, isrpResult.getMsg(), modelMap);
                    }
                    return new IsrpResult(IsrpConstant.FAIL, isrpResult.getMsg(), null);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38:" + e, null);
        }
        return null;
    }

    protected IsrpResult httpSend(String token, TxnElementModel txnElement, String urlStr) {
        HashMap<String, String> textMap = new HashMap<String, String>();
        JSONObject obj = new JSONObject();
        obj.put("txnModel", (Object)txnElement);
        String str = obj.toJSONString();
        textMap.put("jsonstr", str);
        textMap.put("token", token);
        StringBuffer respRes = new StringBuffer();
        try {
            if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
                return new IsrpResult(IsrpConstant.FAIL, respRes.toString(), null);
            }
            IsrpResult sendResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
            ResultModel resultModel = (ResultModel)JSON.parseObject((String)sendResult.getObj().toString(), ResultModel.class);
            return new IsrpResult(sendResult.getReasonId(), sendResult.getMsg(), resultModel);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38\uff1a" + e, null);
        }
    }

    protected List<String> elementControl(String treeJson, List<String> nodeSeqList) {
        TreeNode tree = (TreeNode)JSON.parseObject((String)treeJson, TreeNode.class);
        ArrayList<String> essNodeSeqList = new ArrayList<String>();
        if (tree != null) {
            this.getEssFlag(tree, essNodeSeqList);
        }
        if (nodeSeqList != null && nodeSeqList.size() > 0) {
            ArrayList<String> essFlagList = new ArrayList<String>();
            for (String ess : essNodeSeqList) {
                boolean flag = false;
                for (String nodeSeq : nodeSeqList) {
                    if (!ess.equals(nodeSeq)) continue;
                    flag = true;
                }
                if (flag) continue;
                essFlagList.add(ess);
            }
            return essFlagList;
        }
        return essNodeSeqList;
    }

    protected void getEssFlag(TreeNode tree, List<String> essNodeSeqList) {
        List<TreeNode> nodelList;
        if ("Y".equals(tree.getEssFlag())) {
            essNodeSeqList.add(tree.getNodeSeq());
        }
        if ((nodelList = tree.getTreeNodeList()).size() > 0) {
            for (TreeNode treeNode : nodelList) {
                this.getEssFlag(treeNode, essNodeSeqList);
            }
        }
    }

    @Override
    public IsrpResult createBatch(InitModel tokenModel, TxnElementModel txnElement, List<FileElementModel> fileModelList) {
        if (this.tokenVal(tokenModel)) {
            return new IsrpResult(IsrpConstant.FAIL, "token\u76f8\u5173\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", null);
        }
        if (txnElement == null || StringUtil.isEmpty(txnElement.getTxnNo()) || StringUtil.isEmpty(txnElement.getAppNo()) || StringUtil.isEmpty(txnElement.getBatchModelCode()) || StringUtil.isEmpty(txnElement.getCreateDate()) || StringUtil.isEmpty(txnElement.getTxnType())) {
            return new IsrpResult(IsrpConstant.FAIL, "\u6279\u6b21\u6a21\u578b\u5fc5\u8981\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", null);
        }
        if (fileModelList != null && fileModelList.size() > 0) {
            for (FileElementModel checkFile : fileModelList) {
                if (StringUtil.isEmpty(checkFile.getFilePath()) && (StringUtil.isEmpty(checkFile.getFileSaveName()) || checkFile.getFileStream() == null)) {
                    return new IsrpResult(IsrpConstant.FAIL, "\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", null);
                }
                if (!StringUtil.isEmpty(checkFile.getFileType()) && !StringUtil.isEmpty(checkFile.getFileModelCode()) && !StringUtil.isEmpty(checkFile.getNodeSeq()) && !StringUtil.isEmpty(checkFile.getImageSeq())) continue;
                return new IsrpResult(IsrpConstant.FAIL, "\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", null);
            }
        }
        txnElement.setOpertype(TxnOperType.ADD_PRE.toString());
        String perUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_OPR;
        IsrpResult preResult = this.httpSend(tokenModel.getToken(), txnElement, perUrlStr);
        if (IsrpConstant.SUCCESS.equals(preResult.getReasonId())) {
            List<String> essList;
            String Reference;
            IsrpResult treeResult;
            ResultModel resultModel = (ResultModel)preResult.getObj();
            if (resultModel != null) {
                if (StringUtil.isEmpty(txnElement.getAppNo())) {
                    txnElement.setAppNo(resultModel.getAppNo());
                }
                if (StringUtil.isEmpty(txnElement.getTxnNo())) {
                    txnElement.setTxnNo(resultModel.getTxnNo());
                }
                if (StringUtil.isEmpty(txnElement.getCreateDate())) {
                    txnElement.setCreateDate(resultModel.getWorkDate());
                }
                if (StringUtil.isEmpty(txnElement.getBatchId())) {
                    txnElement.setBatchId(resultModel.getBatchId());
                }
                if (StringUtil.isEmpty(txnElement.getBatchModelCode())) {
                    txnElement.setBatchModelCode(resultModel.getBatchModelCode());
                }
            }
            if (!IsrpConstant.SUCCESS.equals((treeResult = this.getTreeJSON(tokenModel, txnElement.getTxnType())).getReasonId())) {
                return new IsrpResult(IsrpConstant.FAIL, treeResult.getMsg(), null);
            }
            ArrayList<String> nodeSeqList = new ArrayList<String>();
            if (fileModelList != null && fileModelList.size() > 0) {
                for (FileElementModel fileModel : fileModelList) {
                    nodeSeqList.add(fileModel.getNodeSeq());
                }
            }
            if (!StringUtil.isEmpty(Reference = txnElement.getReferenceFile())) {
                String[] ReferenceFile = Reference.split(",");
                int i = 0;
                while (i < ReferenceFile.length) {
                    nodeSeqList.add(ReferenceFile[i].split(":")[3]);
                    ++i;
                }
            }
            if ((essList = this.elementControl(treeResult.getObj().toString(), nodeSeqList)).size() > 0) {
                return new IsrpResult(IsrpConstant.FAIL, "\u8981\u4ef6\u63a7\u5236\u8282\u70b9\uff1a" + essList.toString() + "\u65e0\u5bf9\u5e94\u6587\u6863\uff01", null);
            }
            txnElement.setTreeJson(treeResult.getObj().toString());
            txnElement.setCorpId(tokenModel.getLeganNo());
            txnElement.setOrgCode(tokenModel.getOrganNo());
            SunEcmAPI sunEcmAPI = new SunEcmAPI(tokenModel.getGroupIP(), tokenModel.getGroupPort(), tokenModel.getGroupName());
            IsrpResult upResult = sunEcmAPI.UploadOCX(tokenModel, txnElement, fileModelList);
            if (IsrpConstant.SUCCESS.equals(upResult.getReasonId())) {
                txnElement.setOpertype(TxnOperType.ADD.toString());
                txnElement.setBatchId(upResult.getObj().toString());
                txnElement.setBatchVersion("1");
                String sysUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_SYS;
                return this.httpSend(tokenModel.getToken(), txnElement, sysUrlStr);
            }
            return upResult;
        }
        return preResult;
    }

    @Override
    public IsrpResult deleteBatch(InitModel tokenModel, TxnElementModel txnModel) {
        if (this.tokenVal(tokenModel)) {
            return new IsrpResult(IsrpConstant.FAIL, "token\u76f8\u5173\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", null);
        }
        if (this.txnModelVal(txnModel)) {
            return new IsrpResult(IsrpConstant.FAIL, "\u6279\u6b21\u6a21\u578b\u5fc5\u8981\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", null);
        }
        txnModel.setOpertype(TxnOperType.PRE.toString());
        String perUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_OPR;
        IsrpResult preResult = this.httpSend(tokenModel.getToken(), txnModel, perUrlStr);
        if (IsrpConstant.SUCCESS.equals(preResult.getReasonId())) {
            SunEcmAPI sunEcmAPI;
            IsrpResult delResult;
            ResultModel resultModel = (ResultModel)preResult.getObj();
            if (resultModel != null) {
                if (StringUtil.isEmpty(txnModel.getAppNo())) {
                    txnModel.setAppNo(resultModel.getAppNo());
                }
                if (StringUtil.isEmpty(txnModel.getTxnNo())) {
                    txnModel.setTxnNo(resultModel.getTxnNo());
                }
                if (StringUtil.isEmpty(txnModel.getCreateDate())) {
                    txnModel.setCreateDate(resultModel.getCreateDate());
                }
                if (StringUtil.isEmpty(txnModel.getBatchId())) {
                    txnModel.setBatchId(resultModel.getBatchId());
                }
                if (StringUtil.isEmpty(txnModel.getBatchModelCode())) {
                    txnModel.setBatchModelCode(resultModel.getBatchModelCode());
                }
            }
            if (IsrpConstant.SUCCESS.equals((delResult = (sunEcmAPI = new SunEcmAPI(tokenModel.getGroupIP(), tokenModel.getGroupPort(), tokenModel.getGroupName())).delete(tokenModel, txnModel)).getReasonId())) {
                txnModel.setOpertype(TxnOperType.DEL.toString());
                txnModel.setBatchVersion(delResult.getObj().toString());
                String sysUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_SYS;
                return this.httpSend(tokenModel.getToken(), txnModel, sysUrlStr);
            }
            return delResult;
        }
        return preResult;
    }

    @Override
    public IsrpResult updateBatch(InitModel tokenModel, TxnElementModel txnModel, List<FileElementModel> fileModelList) {
        if (this.tokenVal(tokenModel)) {
            return new IsrpResult(IsrpConstant.FAIL, "\u3010\u66f4\u65b0\u5f02\u5e38\u3011:token\u76f8\u5173\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", "-1");
        }
        if (this.txnModelVal(txnModel)) {
            return new IsrpResult(IsrpConstant.FAIL, "\u3010\u66f4\u65b0\u5f02\u5e38\u3011:\u6279\u6b21\u6a21\u578b\u5fc5\u8981\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!", "-1");
        }
        if (fileModelList != null && fileModelList.size() > 0) {
            for (FileElementModel checkFile : fileModelList) {
                String operType = checkFile.getOpertype();
                String fileModelCode = checkFile.getFileModelCode();
                if (StringUtil.isEmpty(fileModelCode)) {
                    return new IsrpResult(IsrpConstant.FAIL, "\u3010\u66f4\u65b0\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u4ee3\u7801\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                }
                if (operType == null || !OptionKey.U_ADD.equals(operType) && !OptionKey.U_DEL.equals(operType) && !OptionKey.U_MODIFY.equals(operType) && !OptionKey.U_REPLACE.equals(operType)) {
                    return new IsrpResult(IsrpConstant.FAIL, "\u3010\u66f4\u65b0\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\uff01", "-1");
                }
                if (OptionKey.U_ADD.equals(operType)) {
                    if (StringUtil.isEmpty(checkFile.getFilePath()) && (StringUtil.isEmpty(checkFile.getFileSaveName()) || checkFile.getFileStream() == null)) {
                        return new IsrpResult(IsrpConstant.FAIL, "\u3010U_ADD\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                    }
                    if (!StringUtil.isEmpty(checkFile.getFileType()) && !StringUtil.isEmpty(checkFile.getNodeSeq()) && !StringUtil.isEmpty(checkFile.getImageSeq())) continue;
                    return new IsrpResult(IsrpConstant.FAIL, "\u3010U_ADD\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                }
                if (OptionKey.U_REPLACE.equals(operType)) {
                    if (StringUtil.isEmpty(checkFile.getFilePath()) && (StringUtil.isEmpty(checkFile.getFileSaveName()) || checkFile.getFileStream() == null)) {
                        return new IsrpResult(IsrpConstant.FAIL, "\u3010U_REPLACE\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                    }
                    if (!StringUtil.isEmpty(checkFile.getImageId()) && !StringUtil.isEmpty(checkFile.getFileType())) continue;
                    return new IsrpResult(IsrpConstant.FAIL, "\u3010U_REPLACE\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                }
                if (OptionKey.U_DEL.equals(operType)) {
                    if (!StringUtil.isEmpty(checkFile.getImageId())) continue;
                    return new IsrpResult(IsrpConstant.FAIL, "\u3010U_DEL\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
                }
                if (!OptionKey.U_MODIFY.equals(operType) || !StringUtil.isEmpty(checkFile.getImageId())) continue;
                return new IsrpResult(IsrpConstant.FAIL, "\u3010U_MODIFY\u5f02\u5e38\u3011:\u90e8\u5206\u6587\u6863\u6a21\u578b\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", "-1");
            }
        }
        txnModel.setOpertype(TxnOperType.PRE.toString());
        String perUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_OPR;
        IsrpResult preResult = this.httpSend(tokenModel.getToken(), txnModel, perUrlStr);
        if (IsrpConstant.SUCCESS.equals(preResult.getReasonId())) {
            SunEcmAPI sunEcmAPI;
            IsrpResult updateResult;
            ResultModel resultModel = (ResultModel)preResult.getObj();
            if (resultModel != null) {
                if (StringUtil.isEmpty(txnModel.getAppNo())) {
                    txnModel.setAppNo(resultModel.getAppNo());
                }
                if (StringUtil.isEmpty(txnModel.getTxnNo())) {
                    txnModel.setTxnNo(resultModel.getTxnNo());
                }
                if (StringUtil.isEmpty(txnModel.getCreateDate())) {
                    txnModel.setCreateDate(resultModel.getCreateDate());
                }
                if (StringUtil.isEmpty(txnModel.getBatchId())) {
                    txnModel.setBatchId(resultModel.getBatchId());
                }
                if (StringUtil.isEmpty(txnModel.getBatchModelCode())) {
                    txnModel.setBatchModelCode(resultModel.getBatchModelCode());
                }
            }
            if (IsrpConstant.SUCCESS.equals((updateResult = (sunEcmAPI = new SunEcmAPI(tokenModel.getGroupIP(), tokenModel.getGroupPort(), tokenModel.getGroupName())).update(tokenModel, txnModel, fileModelList)).getReasonId())) {
                txnModel.setOpertype(TxnOperType.UPD.toString());
                txnModel.setBatchVersion(updateResult.getObj().toString());
                String sysUrlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_SYS;
                IsrpResult oprResult = this.httpSend(tokenModel.getToken(), txnModel, sysUrlStr);
                if (IsrpConstant.SUCCESS.equals(oprResult.getReasonId())) {
                    return new IsrpResult(oprResult.getReasonId(), oprResult.getMsg(), updateResult.getObj().toString());
                }
                return oprResult;
            }
            return updateResult;
        }
        return preResult;
    }

    @Override
    public String getTemplateXml(InitModel tokenModel, String modelCode, String FileModelCode) {
        SunEcmAPI sunEcmAPI = new SunEcmAPI(tokenModel.getGroupIP(), tokenModel.getGroupPort(), tokenModel.getToken());
        String xmlStr = sunEcmAPI.getTemplateXml(modelCode, FileModelCode);
        return xmlStr;
    }

    @Override
    public IsrpResult queryTxnNoByCreateDate(String token, TxnElementModel txnModel) {
        List txnNolist = new ArrayList();
        if (txnModel == null || StringUtil.isEmpty(txnModel.getBatchModelCode()) || StringUtil.isEmpty(txnModel.getCreateDate()) || StringUtil.isEmpty(txnModel.getAppNo())) {
            return new IsrpResult(IsrpConstant.FAIL, "\u3010\u9ad8\u7ea7\u67e5\u8be2\u5f02\u5e38\u3011:\u6279\u6b21\u5fc5\u8981\u53c2\u6570\u83b7\u53d6\u5931\u8d25\uff01", txnNolist);
        }
        JSONObject josnObject = new JSONObject();
        josnObject.put("txnModel", (Object)txnModel);
        String jsonstr = josnObject.toJSONString();
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("token", token);
        textMap.put("jsonstr", jsonstr);
        String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_BUSSINESS_HIGHT;
        StringBuffer respRes = new StringBuffer();
        try {
            if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
                return new IsrpResult(IsrpConstant.FAIL, respRes.toString(), txnNolist);
            }
            IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
            if (IsrpConstant.SUCCESS.equals(isrpResult.getReasonId())) {
                txnNolist = JSON.parseArray((String)isrpResult.getObj().toString(), TxnElementModel.class);
                isrpResult.setObj(txnNolist);
            }
            return isrpResult;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return new IsrpResult(IsrpConstant.FAIL, "\u3010\u67e5\u8be2\u5f02\u5e38\u3011:\u7cfb\u7edf\u5f02\u5e38\uff01", txnNolist);
        }
    }

    @Override
    public IsrpResult downLoadFile(String downloadUrl, String localPath) {
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            URL url = new URL(downloadUrl);
            in = url.openStream();
            if (in == null) {
                IsrpResult isrpResult = new IsrpResult(IsrpConstant.FAIL, "\u65e0\u6548URL:[" + downloadUrl + "],\u8bf7\u68c0\u67e5\uff01", null);
                return isrpResult;
            }
            if (FileUtil.checkUrl(downloadUrl)) {
                IsrpResult isrpResult = new IsrpResult(IsrpConstant.FAIL, "\u8fc7\u671fURL:[" + downloadUrl + "],\u8bf7\u91cd\u65b0\u83b7\u53d6URL\uff01", null);
                return isrpResult;
            }
            File file = new File(localPath);
            fos = new FileOutputStream(file);
            byte[] buff = new byte[1024];
            int len = -1;
            while ((len = in.read(buff)) > 0) {
                fos.write(buff, 0, len);
            }
            IsrpResult isrpResult = new IsrpResult(IsrpConstant.SUCCESS, "\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0c\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\u4e3a:" + file.getAbsolutePath(), file);
            return isrpResult;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new IsrpResult(IsrpConstant.FAIL, "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25!", null);
    }

    @Override
    public IsrpResult downLoadSmallImg(String downloadUrl, String localPath) {
        try {
            BufferedImage src = ImageIO.read(new URL(downloadUrl));
            if (src == null) {
                return new IsrpResult(IsrpConstant.FAIL, "URL:[" + downloadUrl + "]\u5185\u5bb9\u4e0d\u662f\u56fe\u7247\uff0c\u8bf7\u68c0\u67e5\uff01", null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IsrpResult result = this.downLoadFile(String.valueOf(downloadUrl) + "&SMALL", localPath);
        if (IsrpConstant.SUCCESS.equals(result.getReasonId())) {
            File smallImg = (File)result.getObj();
            return new IsrpResult(IsrpConstant.SUCCESS, "\u7f29\u7565\u56fe\u4e0b\u8f7d\u6210\u529f\uff0c\u56fe\u7247\u4fdd\u5b58\u8def\u5f84\u4e3a:" + smallImg.getAbsolutePath(), smallImg);
        }
        return new IsrpResult(IsrpConstant.FAIL, result.getMsg(), null);
    }

    @Override
    public IsrpResult downLoadWaterImg(InitModel tokenModel, String downloadUrl, String localPath, String batchModelCode) {
        URL url = null;
        InputStream in = null;
        FileOutputStream out = null;
        BufferedImage src = null;
        try {
            url = new URL(downloadUrl);
            in = url.openStream();
            src = ImageIO.read(url);
            out = new FileOutputStream(localPath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            log.error((Object)e1);
        }
        if (in == null) {
            return new IsrpResult(IsrpConstant.FAIL, "\u65e0\u6548URL:[" + downloadUrl + "],\u8bf7\u68c0\u67e5\uff01", null);
        }
        if (FileUtil.checkUrl(downloadUrl)) {
            return new IsrpResult(IsrpConstant.FAIL, "\u8fc7\u671fURL:[" + downloadUrl + "],\u8bf7\u91cd\u65b0\u83b7\u53d6URL\uff01", null);
        }
        if (src == null) {
            return new IsrpResult(IsrpConstant.FAIL, "URL:[" + downloadUrl + "]\u5185\u5bb9\u4e0d\u662f\u56fe\u7247\uff0c\u8bf7\u68c0\u67e5\uff01", null);
        }
        try {
            HashMap<String, String> textMap = new HashMap<String, String>();
            textMap.put("token", tokenModel.getToken());
            textMap.put("batchModelCode", batchModelCode);
            String urlStr = String.valueOf(this.isrpURL) + UrlConstant.URL_WATERMARK;
            StringBuffer respRes = new StringBuffer();
            if (!this.baseProcess.httpSend(urlStr, textMap, respRes).booleanValue()) {
                IsrpResult isrpResult = new IsrpResult(IsrpConstant.FAIL, respRes.toString(), null);
                return isrpResult;
            }
            IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
            if (isrpResult == null) {
                IsrpResult isrpResult2 = new IsrpResult(IsrpConstant.FAIL, "\u670d\u52a1\u5668\u7aef\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01", null);
                return isrpResult2;
            }
            if (!IsrpConstant.SUCCESS.equals(isrpResult.getReasonId())) {
                IsrpResult isrpResult3 = new IsrpResult(IsrpConstant.FAIL, isrpResult.getMsg(), null);
                return isrpResult3;
            }
            Map waterMap = (Map)isrpResult.getObj();
            String waterUrl = (String)waterMap.get(ISRPOperConstant.WATER_IMG);
            String watertext = (String)waterMap.get(ISRPOperConstant.WATER_TEXT);
            if (!StringUtil.isEmpty(waterUrl)) {
                URL pressURL = new URL(waterUrl);
                BufferedImage src_biao = ImageIO.read(pressURL);
                if (src_biao == null) {
                    IsrpResult isrpResult4 = new IsrpResult(IsrpConstant.FAIL, "\u6c34\u5370\u56feURL\u5931\u6548\uff01", null);
                    return isrpResult4;
                }
                ImageUtil.pressImg(src_biao, url, (OutputStream)out, null);
            } else if (!StringUtil.isEmpty(watertext)) {
                String keyFlag = String.valueOf(batchModelCode) + "&" + tokenModel.getOprId();
                WatermarkBean watermark = (WatermarkBean)JSON.parseObject((String)watertext, WatermarkBean.class);
                String pressText = watermark.getContent();
                String fontName = watermark.getFontName();
                int fontStyle = watermark.getBold();
                int color = watermark.getColor();
                int fontSize = watermark.getFontSize();
                double alpha = watermark.getAlpha();
                int gradient = watermark.getGradient();
                Integer degree = null;
                if (gradient == 0) {
                    degree = 0;
                } else if (gradient == 1) {
                    degree = -45;
                } else if (gradient == 2) {
                    degree = 45;
                }
                ImageUtil.pressText(keyFlag, pressText, url, fontName, fontStyle, color, fontSize, (float)alpha, degree, out);
            } else {
                BufferedImage src_biao = ImageIO.read(this.is);
                if (src_biao == null) {
                    IsrpResult isrpResult5 = new IsrpResult(IsrpConstant.FAIL, "\u9ed8\u8ba4\u6c34\u5370\u56fe\u52a0\u8f7d\u5931\u8d25\uff01", null);
                    return isrpResult5;
                }
                ImageUtil.PressImgByDef(src_biao, url, out, null);
            }
            File file = new File(localPath);
            if (file.exists()) {
                IsrpResult isrpResult6 = new IsrpResult(IsrpConstant.SUCCESS, "\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u6210\u529f\uff0c\u56fe\u7247\u4fdd\u5b58\u8def\u5f84\u4e3a:" + file.getAbsolutePath(), file);
                return isrpResult6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
        }
        return new IsrpResult(IsrpConstant.FAIL, "\u7cfb\u7edf\u5f02\u5e38\uff01", null);
    }

    @Override
    public String OCRClassRec(InitModel tokenModel, String batchModelCode, InputStream image) throws MPException {
        String templetList = "";
        try {
            templetList = this.ocr.getTemplateListByLegal(tokenModel.getPieceIp(), tokenModel.getPiecePort(), batchModelCode, tokenModel.getLeganNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        return this.ocr.imgClassRec(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image, 0, UUID.randomUUID().toString().replace("-", ""), batchModelCode, templetList);
    }

    @Override
    public String OCRFileRec(InitModel tokenModel, String templetCode, String batchModelCode, InputStream image) throws MPException {
        return this.ocr.imgFieldRec(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image, 0, templetCode, UUID.randomUUID().toString().replace("-", ""), batchModelCode);
    }

    @Override
    public String OCRPiece(InitModel tokenModel, String batchModelCode, String templetCode, InputStream image, String txnType) throws MPException {
        String pieceModelCode = this.ocr.getPieceModelCode(tokenModel.getPieceIp(), tokenModel.getPiecePort(), batchModelCode, templetCode, txnType);
        if (StringUtil.isEmpty(pieceModelCode)) {
            throw new MPException("\u5207\u7247\u6a21\u5f0f\u83b7\u53d6\u5f02\u5e38\uff01");
        }
        return this.ocr.imgBase64Piece(tokenModel.getPieceIp(), tokenModel.getPiecePort(), image, 0, pieceModelCode, UUID.randomUUID().toString().replace("-", ""), this.mode, batchModelCode);
    }

    @Override
    public String QREncode(InitModel tokenModel, String content) throws MPException {
        return this.ocr.imgQREncode(tokenModel.getOcrIp(), tokenModel.getOcrPort(), content, UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public String QRDecode(InitModel tokenModel, InputStream image) throws MPException {
        return this.ocr.imgQRDecode(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image, 0, UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public String imgImageCompress(InitModel tokenModel, InputStream image, String compressWidth, String compressHeight, String compressQuality) throws MPException {
        return this.ocr.imgImageCompress(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image, 0, compressWidth, compressHeight, compressQuality, UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public String imgCheckQuality(InitModel tokenModel, InputStream image, String batchModelCode, String templetType) throws MPException {
        return this.ocr.imgCheckQuality(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image, 0, templetType, batchModelCode, UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public String imgCompare(InitModel tokenModel, InputStream image1, InputStream image2) throws MPException {
        return this.ocr.imageCompare(tokenModel.getOcrIp(), tokenModel.getOcrPort(), image1, 0, image2, 0);
    }

    @Override
    public String imgIDRec(InitModel tokenModel, InputStream idCardimage) throws MPException {
        return this.ocr.imgIDRec(tokenModel.getIdCardIp(), tokenModel.getIdCardPort(), idCardimage, 0, "-1", "100", UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public String multiIDCardRec(InitModel tokenModel, InputStream idCardimage) throws MPException {
        return this.ocr.multiIDCardRec(tokenModel.getIdCardIp(), tokenModel.getIdCardPort(), UUID.randomUUID().toString().replace("-", ""), "0", idCardimage, 0);
    }

    @Override
    public String checkRec(InitModel tokenModel, InputStream checkimage) throws MPException {
        return this.ocr.imgFieldRec(tokenModel.getOcrIp(), tokenModel.getOcrPort(), checkimage, 0, "cheque", UUID.randomUUID().toString().replace("-", ""), "");
    }
}

