/*
 * Decompiled with CFR 0.152.
 */
package mp.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.FileImageOutputStream;

public class FileOprUtil {
    public static String byteToFile(byte[] byteRtn, String path) {
        try {
            FileImageOutputStream output = new FileImageOutputStream(new File(path));
            output.write(byteRtn);
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public static byte[] fileToByte(String filePath) {
        byte[] content = null;
        try {
            BufferedInputStream bis = null;
            ByteArrayOutputStream out = null;
            try {
                int len;
                FileInputStream input = new FileInputStream(filePath);
                bis = new BufferedInputStream(input, 1024);
                byte[] bytes = new byte[1024];
                out = new ByteArrayOutputStream();
                while ((len = bis.read(bytes)) > 0) {
                    out.write(bytes, 0, len);
                }
                bis.close();
                content = out.toByteArray();
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static byte[] fileStreamToByte(InputStream input) {
        byte[] content = null;
        try {
            BufferedInputStream bis = null;
            ByteArrayOutputStream out = null;
            try {
                int len;
                bis = new BufferedInputStream(input, 1024);
                byte[] bytes = new byte[1024];
                out = new ByteArrayOutputStream();
                while ((len = bis.read(bytes)) > 0) {
                    out.write(bytes, 0, len);
                }
                bis.close();
                content = out.toByteArray();
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static void inputstreamToFile(InputStream ins, String filePath) {
        try {
            File file = new File(filePath);
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zipFile(String inputFileName, String outputFileName) throws Exception {
        File destFile = new File(outputFileName);
        if (!destFile.exists() && !destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFileName));
        FileOprUtil.zip(out, new File(inputFileName), "");
        System.out.println("zip done");
        out.flush();
        out.close();
    }

    public static void zip(ZipOutputStream out, File f, String base) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            if (System.getProperty("os.name").startsWith("Windows")) {
                out.putNextEntry(new ZipEntry(String.valueOf(base) + "/"));
                base = base.length() == 0 ? "" : String.valueOf(base) + "/";
            } else {
                out.putNextEntry(new ZipEntry(String.valueOf(base) + "/"));
                base = base.length() == 0 ? "" : String.valueOf(base) + "/";
            }
            int i = 0;
            while (i < fl.length) {
                FileOprUtil.zip(out, fl[i], String.valueOf(base) + fl[i].getName());
                ++i;
            }
        } else {
            int b;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream in = new FileInputStream(f);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
        }
    }

    public static boolean copyFile(String srcFileName, String destFileName) {
        File srcFile = new File(srcFileName);
        InputStream in = null;
        OutputStream out = null;
        try {
            if (!srcFile.exists()) {
                throw new FileNotFoundException("\u590d\u5236\u6587\u4ef6[" + srcFileName + "]\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
            if (!srcFile.isFile()) {
                throw new Exception("\u590d\u5236\u6587\u4ef6[" + srcFileName + "]" + "\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6");
            }
            File destFile = new File(destFileName);
            if (!(destFile.exists() || destFile.getParentFile().exists() || destFile.getParentFile().mkdirs())) {
                return false;
            }
            int byteread = 0;
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isExistAndCreateDir(String tempLocalImageDir) {
        File file = new File(tempLocalImageDir);
        if (file.exists()) {
            return true;
        }
        file.mkdirs();
        return true;
    }

    public static void zipExtracting(String filePath, String zipFile) {
        int BUFFER = 1024;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipEntry entry = null;
        ZipFile zipfile = null;
        Enumeration<? extends ZipEntry> enu = null;
        try {
            try {
                zipfile = new ZipFile(zipFile);
                enu = zipfile.entries();
                while (enu.hasMoreElements()) {
                    int count;
                    entry = enu.nextElement();
                    if (entry.isDirectory()) {
                        new File(String.valueOf(filePath) + entry.getName()).mkdirs();
                        continue;
                    }
                    is = new BufferedInputStream(zipfile.getInputStream(entry));
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(String.valueOf(filePath) + entry.getName());
                    dest = new BufferedOutputStream(fos, BUFFER);
                    while ((count = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (dest != null) {
                        dest.flush();
                        dest.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (dest != null) {
                    dest.flush();
                    dest.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = String.valueOf(sPath) + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = FileOprUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileOprUtil.deleteDirectory(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean DeleteFolder(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return FileOprUtil.deleteFile(sPath);
        }
        return FileOprUtil.deleteDirectory(sPath);
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public void delFile(String filePathAndName) {
        try {
            String filePath = filePathAndName;
            filePath = filePath.toString();
            File myDelFile = new File(filePath);
            myDelFile.delete();
        }
        catch (Exception e) {
            System.out.println("\u5220\u9664\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public void delFolder(String folderPath) {
        try {
            this.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            System.out.println("\u5220\u9664\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        int i = 0;
        while (i < tempList.length) {
            temp = path.endsWith(File.separator) ? new File(String.valueOf(path) + tempList[i]) : new File(String.valueOf(path) + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                this.delAllFile(String.valueOf(path) + "/" + tempList[i]);
                this.delFolder(String.valueOf(path) + "/" + tempList[i]);
            }
            ++i;
        }
    }

    public void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            int i = 0;
            while (i < file.length) {
                temp = oldPath.endsWith(File.separator) ? new File(String.valueOf(oldPath) + file[i]) : new File(String.valueOf(oldPath) + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(String.valueOf(newPath) + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (temp.isDirectory()) {
                    this.copyFolder(String.valueOf(oldPath) + "/" + file[i], String.valueOf(newPath) + "/" + file[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public void moveFile(String oldPath, String newPath) {
        FileOprUtil.copyFile(oldPath, newPath);
        this.delFile(oldPath);
    }

    public void moveFolder(String oldPath, String newPath) {
        this.copyFolder(oldPath, newPath);
        this.delFolder(oldPath);
    }

    public static boolean fileExist(String picFilePath) {
        File file = new File(picFilePath);
        return file.exists();
    }

    public static String ReadFileToString(String filePath) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }
}

