/*
 * Decompiled with CFR 0.152.
 */
package mp.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;

public class FileUtil {
    public static final String DOT = ".";

    public static String getExtension(String fileName) {
        int pos = fileName.lastIndexOf(DOT);
        String ext = "";
        if (pos > 0) {
            ext = fileName.substring(pos + 1);
        }
        return ext;
    }

    public Long getFileSize(File file) {
        long fileSize = file.length();
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileSize < 1024L ? String.valueOf(df.format((double)fileSize)) + "B" : (fileSize < 0x100000L ? String.valueOf(df.format((double)fileSize / 1024.0)) + "K" : (fileSize < 0x40000000L ? String.valueOf(df.format((double)fileSize / 1048576.0)) + "M" : String.valueOf(df.format((double)fileSize / 1.073741824E9)) + "G"));
        return Long.parseLong(fileSizeString);
    }

    public static boolean checkUrl(String urlStr) {
        InputStream in = null;
        BufferedReader br = null;
        boolean startflag = false;
        boolean contentflag = false;
        try {
            URL url = new URL(urlStr);
            in = url.openStream();
            if (in == null) {
                return true;
            }
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String startLine = br.readLine();
            if (startLine.contains(urlStr)) {
                startflag = true;
            }
            String buff = null;
            while ((buff = br.readLine()) != null) {
                if (!buff.contains("\u6587\u4ef6\u8bbf\u95ee\u65f6\u95f4\u8fc7\u671f\uff1a")) continue;
                contentflag = true;
            }
            if (startflag && contentflag) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

