/*
 * Decompiled with CFR 0.152.
 */
package mp.tools;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import mp.tools.FileOprUtil;
import mp.tools.FileUtil;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.log4j.Logger;

public class ImageUtil {
    private Logger logger = Logger.getLogger(ImageUtil.class);
    private static String[] suffix_txt = new String[]{"txt", "doc", "docx", "ppt", "pptx", "pdf", "xls", "xlsx"};
    private static String[] suffix_audio = new String[]{"mp3"};
    private static String[] suffix_video = new String[]{"mp4", "rmvb", "avi", "wmv"};

    public void pressImage(String pressImg, String targetImg, OutputStream out, Integer degree) {
        try {
            File _file = new File(targetImg);
            if (!_file.exists()) {
                return;
            }
            try {
                BufferedImage src = ImageIO.read(_file);
                int wideth = ((Image)src).getWidth(null);
                int height = ((Image)src).getHeight(null);
                BufferedImage image = new BufferedImage(wideth, height, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(src, 0, 0, wideth, height, null);
                File _filebiao = new File(pressImg);
                BufferedImage src_biao = ImageIO.read(_filebiao);
                int wideth_biao = ((Image)src_biao).getWidth(null);
                int height_biao = ((Image)src_biao).getHeight(null);
                int wh = wideth * 2 / 3;
                int ht = wideth / wideth_biao * height_biao;
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)wideth / 2.0, (double)height / 2.0);
                }
                float alpha = 0.4f;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                g.drawImage(src_biao, (wideth - wideth_biao) / 3, (height - height_biao) / 2, wh, ht, null);
                g.dispose();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
                src = null;
                src_biao = null;
                image = null;
                g = null;
                encoder = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void pressImg(Image pressImg, URL url, OutputStream out, Integer degree) {
        try {
            BufferedImage src = ImageIO.read(url);
            if (src == null) {
                return;
            }
            try {
                int wideth = ((Image)src).getWidth(null);
                int height = ((Image)src).getHeight(null);
                BufferedImage image = new BufferedImage(wideth, height, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(src, 0, 0, wideth, height, null);
                Image src_biao = pressImg;
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)wideth / 2.0, (double)height / 2.0);
                }
                float alpha = 1.0f;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                g.drawImage(src_biao, 0, 0, wideth, height, null);
                g.dispose();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
                src = null;
                src_biao = null;
                image = null;
                g = null;
                encoder = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void PressImgByDef(Image pressImg, URL url, OutputStream out, Integer degree) {
        try {
            BufferedImage src = ImageIO.read(url);
            if (src == null) {
                return;
            }
            try {
                int wideth = ((Image)src).getWidth(null);
                int height = ((Image)src).getHeight(null);
                BufferedImage image = new BufferedImage(wideth, height, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(src, 0, 0, wideth, height, null);
                Image src_biao = pressImg;
                int biao_wideth = src_biao.getWidth(null);
                int biao_height = src_biao.getHeight(null);
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)wideth / 2.0, (double)height / 2.0);
                }
                float alpha = 1.0f;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                g.drawImage(src_biao, 0, 0, biao_wideth, biao_height, null);
                g.dispose();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
                src = null;
                src_biao = null;
                image = null;
                g = null;
                encoder = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void pressImg(String pressImgPath, String srcPath, OutputStream out, Integer degree) {
        try {
            BufferedImage src = ImageIO.read(new File(srcPath));
            if (src == null) {
                return;
            }
            try {
                int wideth = ((Image)src).getWidth(null);
                int height = ((Image)src).getHeight(null);
                BufferedImage image = new BufferedImage(wideth, height, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(src, 0, 0, wideth, height, null);
                BufferedImage src_biao = ImageIO.read(new File(pressImgPath));
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)wideth / 2.0, (double)height / 2.0);
                }
                g.drawImage(src_biao, 0, 0, wideth, height, null);
                g.dispose();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
                src = null;
                src_biao = null;
                image = null;
                g = null;
                encoder = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void pressText(String keyFlag, String pressText, URL urlStr, String fontName, int fontStyle, int color, int fontSize, float alpha, Integer degree, OutputStream out) {
        try {
            try {
                BufferedImage src = ImageIO.read(urlStr);
                int width = ((Image)src).getWidth(null);
                int height = ((Image)src).getHeight(null);
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(src, 0, 0, width, height, null);
                g.setColor(new Color(color));
                Font font = new Font(fontName, fontStyle, fontSize);
                g.setFont(font);
                if (degree != null && degree == 45) {
                    g.rotate(Math.toRadians(degree.intValue()));
                }
                if (degree != null && degree == -45) {
                    g.rotate(Math.toRadians(degree.intValue()), width, height);
                }
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                double boundsWidth = 0.0;
                FontRenderContext context = g.getFontRenderContext();
                Rectangle2D keyBounds = font.getStringBounds(keyFlag, context);
                Rectangle2D textBounds = font.getStringBounds(pressText, context);
                boundsWidth = keyBounds.getWidth() > textBounds.getWidth() ? keyBounds.getWidth() : textBounds.getWidth();
                int rowsNumber = (int)((double)(height + width) / boundsWidth);
                int columnsNumber = (int)((double)(height + width) / boundsWidth);
                if (rowsNumber < 1) {
                    rowsNumber = 1;
                }
                if (columnsNumber < 1) {
                    columnsNumber = 1;
                }
                double x = boundsWidth * 2.0 / 3.0;
                double y = boundsWidth * 2.0 / 3.0;
                int j = 0;
                while (j < rowsNumber) {
                    int i = 0;
                    while (i < columnsNumber) {
                        if (degree == -45 || degree == 45) {
                            ((Graphics)g).drawString(keyFlag, (int)((double)(j + i) * x), (int)((double)(j - i) * x));
                            ((Graphics)g).drawString(pressText, (int)((double)(i + j) * x), (int)((double)(j - i) * x - textBounds.getHeight()));
                        } else {
                            ((Graphics)g).drawString(keyFlag, (int)((double)i * (boundsWidth + x)), (int)((double)j * (y + keyBounds.getHeight() + textBounds.getHeight())));
                            ((Graphics)g).drawString(pressText, (int)((double)i * (boundsWidth + x)), (int)((double)j * (y + keyBounds.getHeight() + textBounds.getHeight()) - textBounds.getHeight()));
                        }
                        ++i;
                    }
                    ++j;
                }
                g.dispose();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void markImageByIcon(String iconPath, String srcImgPath, String targerPath) {
        this.markImageByIcon(iconPath, srcImgPath, targerPath, null);
    }

    public void markImageByIcon(String iconPath, String srcImgPath, String targerPath, Integer degree) {
        OutputStream os = null;
        try {
            try {
                BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
                BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
                Graphics2D g = buffImg.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
                }
                ImageIcon imgIcon = new ImageIcon(iconPath);
                Image img = imgIcon.getImage();
                float alpha = 0.3f;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                int x = buffImg.getWidth() / 3;
                int y = buffImg.getHeight() / 3;
                g.drawImage(img, x, y, null);
                g.setComposite(AlphaComposite.getInstance(3));
                g.dispose();
                os = new FileOutputStream(targerPath);
                ImageIO.write((RenderedImage)buffImg, "JPG", os);
                System.out.println("\u56fe\u7247\u5b8c\u6210\u6dfb\u52a0Icon\u5370\u7ae0\u3002\u3002\u3002\u3002\u3002\u3002");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void markImageByText(String srcImgPath, String outImgPath, Color markContentColor, String waterMarkContent) {
        FileOutputStream outImgStream = null;
        try {
            try {
                File srcImgFile = new File(srcImgPath);
                BufferedImage srcImg = ImageIO.read(srcImgFile);
                int srcImgWidth = ((Image)srcImg).getWidth(null);
                int srcImgHeight = ((Image)srcImg).getHeight(null);
                BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
                Graphics2D g = bufImg.createGraphics();
                g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
                Font font = new Font("\u9ed1\u4f53", 0, 100);
                g.setColor(markContentColor);
                g.setFont(font);
                g.rotate(Math.toRadians(-30.0), (double)bufImg.getWidth() / 2.0, (double)bufImg.getHeight() / 2.0);
                float alpha = 0.2f;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                int x = (srcImgWidth - this.getWatermarkLength(waterMarkContent, g)) / 2;
                int y = (srcImgHeight - 30) / 2;
                g.drawString(waterMarkContent, x, y);
                g.dispose();
                outImgStream = new FileOutputStream(outImgPath);
                ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
                outImgStream.flush();
            }
            catch (Exception exception) {
                try {
                    if (outImgStream != null) {
                        outImgStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (outImgStream != null) {
                    outImgStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }

    public void Thumbnails(String srcImgPath, String targerPath, String iconPath) {
        try {
            Thumbnails.of((String[])new String[]{srcImgPath}).size(2080, 2024).watermark((Position)Positions.CENTER, ImageIO.read(new File(iconPath)), 0.5f).outputQuality(0.8f).toFile(targerPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String waterImageByText(String str, String path, int width, int height) {
        File file = new File(path);
        BufferedImage bi = new BufferedImage(width, height, 1);
        try {
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setBackground(Color.black);
            g2.clearRect(0, 0, width, height);
            Font font = new Font("\u9ed1\u4f53", 1, 75);
            g2.setFont(font);
            g2.setPaint(Color.WHITE);
            float alpha = 0.2f;
            g2.setComposite(AlphaComposite.getInstance(10, alpha));
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontRenderContext context = g2.getFontRenderContext();
            Rectangle2D bounds = font.getStringBounds(str, context);
            double x = ((double)width - bounds.getWidth()) / 2.0;
            double y = ((double)height - bounds.getHeight()) / 2.0;
            double ascent = -bounds.getY();
            double baseY = y + ascent;
            g2.drawString(str, (int)x, (int)baseY);
            g2.dispose();
            ImageIO.write((RenderedImage)bi, "png", file);
            context = null;
            bounds = null;
            bi = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getPath();
    }

    public static String waterImageByText(String keyFlag, String pressText, String path, String fontName, int fontStyle, int color, int fontSize, float alpha, Integer degree, int width, int height) {
        File file = new File(path);
        BufferedImage bi = new BufferedImage(width, height, 4);
        try {
            Graphics2D g = (Graphics2D)bi.getGraphics();
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, width, height);
            Font font = new Font(fontName, fontStyle, fontSize);
            g.setFont(font);
            g.setColor(new Color(0, 0, 255));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (degree != null && degree == 45) {
                g.rotate(Math.toRadians(degree.intValue()));
            }
            if (degree != null && degree == -45) {
                g.rotate(Math.toRadians(degree.intValue()), width, height);
            }
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            double boundsWidth = 0.0;
            FontRenderContext context = g.getFontRenderContext();
            Rectangle2D keyBounds = font.getStringBounds(keyFlag, context);
            Rectangle2D textBounds = font.getStringBounds(pressText, context);
            boundsWidth = keyBounds.getWidth() > textBounds.getWidth() ? keyBounds.getWidth() : textBounds.getWidth();
            int rowsNumber = (int)((double)(height + width) / boundsWidth);
            int columnsNumber = (int)((double)(height + width) / boundsWidth);
            if (rowsNumber < 1) {
                rowsNumber = 1;
            }
            if (columnsNumber < 1) {
                columnsNumber = 1;
            }
            double x = boundsWidth * 2.0 / 3.0;
            double y = boundsWidth * 2.0 / 3.0;
            int j = 0;
            while (j < rowsNumber) {
                int i = 0;
                while (i < columnsNumber) {
                    if (degree == -45 || degree == 45) {
                        g.drawString(keyFlag, (int)((double)(j + i) * x), (int)((double)(j - i) * x));
                        g.drawString(pressText, (int)((double)(i + j) * x), (int)((double)(j - i) * x - textBounds.getHeight()));
                    } else {
                        g.drawString(keyFlag, (int)((double)i * (boundsWidth + x)), (int)((double)j * (y + keyBounds.getHeight() + textBounds.getHeight())));
                        g.drawString(pressText, (int)((double)i * (boundsWidth + x)), (int)((double)j * (y + keyBounds.getHeight() + textBounds.getHeight()) - textBounds.getHeight()));
                    }
                    ++i;
                }
                ++j;
            }
            g.dispose();
            ImageIO.write((RenderedImage)bi, "png", file);
            bi = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file.getPath();
    }

    public static void transferAlpha(String srcImgPath) {
        block22: {
            File srcImgFile = new File(srcImgPath);
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                try {
                    BufferedImage image = ImageIO.read(srcImgFile);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ByteArrayInputStream in = null;
                    try {
                        try {
                            ImageIcon imageIcon = new ImageIcon(image);
                            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
                            Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
                            g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
                            int alpha = 0;
                            int j1 = bufferedImage.getMinY();
                            while (j1 < bufferedImage.getHeight()) {
                                int j2 = bufferedImage.getMinX();
                                while (j2 < bufferedImage.getWidth()) {
                                    int rgb = bufferedImage.getRGB(j2, j1);
                                    int R = (rgb & 0xFF0000) >> 16;
                                    int G = (rgb & 0xFF00) >> 8;
                                    int B = rgb & 0xFF;
                                    if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                                        rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                                    }
                                    bufferedImage.setRGB(j2, j1, rgb);
                                    ++j2;
                                }
                                ++j1;
                            }
                            g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
                            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                            in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                            FileOprUtil.inputstreamToFile(in, srcImgPath);
                        }
                        catch (IOException iOException) {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (byteArrayOutputStream == null) break block22;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void Thumbnails(String srcImgPath, String targerPath) {
        try {
            Thumbnails.of((String[])new String[]{srcImgPath}).size(400, 500).toFile(targerPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void imageRate(String srcImgPath, String targerPath, int rate) {
        try {
            Thumbnails.of((String[])new String[]{srcImgPath}).size(2080, 2024).rotate((double)rate).toFile(targerPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getImgHeight(String ImgPath) {
        FileInputStream is = null;
        BufferedImage src = null;
        int ret = -1;
        try {
            try {
                is = new FileInputStream(ImgPath);
                src = ImageIO.read(is);
                ret = src.getHeight();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static int getImgwidth(String ImgPath) {
        FileInputStream is = null;
        BufferedImage src = null;
        int ret = -1;
        try {
            try {
                is = new FileInputStream(ImgPath);
                src = ImageIO.read(is);
                ret = src.getWidth();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static InputStream getSmallImg(InputStream fileStream, int smSize) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            Thumbnails.of((InputStream[])new InputStream[]{fileStream}).size(smSize, smSize).toOutputStream((OutputStream)baos);
            fileStream.reset();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File CombinationImg(String ImgPath, String tempDir) {
        File _file = new File(ImgPath);
        if (!_file.exists()) {
            return null;
        }
        InputStream in = null;
        OutputStream out = null;
        byte[] buff = null;
        int len = -1;
        try {
            File dir = new File(tempDir);
            if (!dir.exists() && !dir.mkdirs()) {
                return null;
            }
            String tempPath = String.valueOf(dir.getPath()) + File.separator + UUID.randomUUID().toString().replace("_", "") + "." + FileUtil.getExtension(ImgPath);
            File tempFile = new File(tempPath);
            in = new FileInputStream(_file);
            out = new FileOutputStream(tempFile);
            buff = new byte[1024];
            while ((len = in.read(buff)) != -1) {
                out.write(buff, 0, len);
            }
            Thumbnails.of((String[])new String[]{ImgPath}).size(400, 500).toOutputStream(out);
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isImage(InputStream fileStream) {
        boolean flag = false;
        try {
            BufferedImage src = ImageIO.read(fileStream);
            fileStream.reset();
            if (src == null) {
                return flag;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return flag;
        }
    }

    public static boolean isAudio(String suffix) {
        boolean flag = false;
        int i = 0;
        while (i < suffix_audio.length) {
            if (suffix_txt[i].equals(suffix)) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    public static boolean isVideo(String suffix) {
        boolean flag = false;
        int i = 0;
        while (i < suffix_video.length) {
            if (suffix_txt[i].equals(suffix)) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    public static boolean isText(String suffix) {
        boolean flag = false;
        int i = 0;
        while (i < suffix_txt.length) {
            if (suffix_txt[i].equals(suffix)) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    public static void main(String[] args) throws FileNotFoundException, MalformedURLException {
        ImageUtil.pressImg("D:/ayin/getFile.png", "E:/ImagePool/test.jpg", (OutputStream)new FileOutputStream("D:/wwwww.jpg"), null);
        System.out.println("0000");
    }
}

