/*
 * Decompiled with CFR 0.152.
 */
package mp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    public static String stringMD5(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] inputByteArray = input.getBytes();
            messageDigest.update(inputByteArray);
            byte[] resultByteArray = messageDigest.digest();
            return MD5Util.byteArrayToHex(resultByteArray);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static String fileMD5(String inputFile) {
        block24: {
            int bufferSize = 262144;
            FileInputStream fileInputStream = null;
            FilterInputStream digestInputStream = null;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                fileInputStream = new FileInputStream(inputFile);
                digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
                byte[] buffer = new byte[bufferSize];
                while (digestInputStream.read(buffer) > 0) {
                }
                messageDigest = ((DigestInputStream)digestInputStream).getMessageDigest();
                byte[] resultByteArray = messageDigest.digest();
                String string = MD5Util.byteArrayToHex(resultByteArray);
                return string;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block24;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    digestInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public String getMd5ByFile(File file) {
        String value;
        block14: {
            value = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            try {
                try {
                    FileChannel fc = in.getChannel();
                    System.out.print(String.valueOf(fc.size()) + "\n");
                    MappedByteBuffer byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(byteBuffer);
                    BigInteger bi = new BigInteger(1, md5.digest());
                    value = bi.toString(16);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return value;
    }

    public static String byteArrayToHex(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            if (n < b.length - 1) {
                hs = String.valueOf(hs);
            }
            ++n;
        }
        return hs;
    }
}

