/*
 * Decompiled with CFR 0.152.
 */
package mp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static int[] conversionStrArrToInt(String[] arg) {
        int[] array = new int[arg.length];
        int i = 0;
        while (i < arg.length) {
            array[i] = Integer.parseInt(arg[i]);
            ++i;
        }
        return array;
    }

    public static String compact(String src) {
        Pattern p = Pattern.compile("\\s{2,}|\t|\r|\n");
        String finalresult = p.matcher(src).replaceAll("");
        return finalresult;
    }

    public static String arrayToString(String[] inputArray, String delim) {
        String outputString = "";
        if (inputArray == null || inputArray.length == 0) {
            return outputString;
        }
        outputString = inputArray[0].trim();
        int i = 1;
        while (i < inputArray.length) {
            outputString = String.valueOf(outputString) + delim + inputArray[i].trim();
            ++i;
        }
        return outputString;
    }

    public static String[] getStringArray(String inputValue, String delim) {
        if (inputValue == null) {
            inputValue = "";
        }
        inputValue = inputValue.trim();
        StringTokenizer t = new StringTokenizer(inputValue, delim);
        String[] ret = new String[t.countTokens()];
        int index = 0;
        while (t.hasMoreTokens()) {
            String token;
            ret[index] = token = t.nextToken().trim();
            ++index;
        }
        return ret;
    }

    public static String getEmptyStringIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String replace(String input, char from, String to) {
        if (input == null) {
            return null;
        }
        char[] s = input.toCharArray();
        int length = s.length;
        StringBuffer ret = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            if (s[i] == from) {
                ret.append(to);
            } else {
                ret.append(s[i]);
            }
            ++i;
        }
        return ret.toString();
    }

    public static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static String replace(String input, String from, String to) {
        if (input == null) {
            return "";
        }
        Pattern p = Pattern.compile(from);
        Matcher m = p.matcher(input);
        String output = m.replaceAll(to);
        return output;
    }

    public static Collection getSeparateString(String strContent, String pattern) {
        int beginIndex = 0;
        ArrayList<String> coResult = new ArrayList<String>();
        int position = strContent.indexOf(pattern, beginIndex);
        while (position != -1) {
            String result = strContent.substring(beginIndex, position);
            if (!result.trim().equals("")) {
                coResult.add(result);
            }
            beginIndex = position + pattern.length();
            position = strContent.indexOf(pattern, beginIndex);
        }
        return coResult;
    }

    public static String isoToGbk(String str) {
        String result = null;
        try {
            result = new String(str.getBytes("ISO8859_1"), "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String gbkToIso(String str) {
        String result = null;
        try {
            result = new String(str.getBytes("GBK"), "ISO8859_1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String gbkToUtf(String str) {
        String result = null;
        try {
            result = new String(str.getBytes("GBK"), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String utfToGbk(String str) {
        String result = null;
        try {
            result = new String(str.getBytes("UTF-8"), "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String leftFill(String fillChar, int strLength, String sourceStr) {
        int length = 0;
        try {
            length = sourceStr.getBytes().length;
            int i = 0;
            while (i < strLength - length) {
                sourceStr = sourceStr == null ? fillChar : String.valueOf(fillChar) + sourceStr;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sourceStr;
    }

    public static String rightFill(String fillChar, int strLength, String sourceStr) {
        int length = 0;
        try {
            length = sourceStr.getBytes().length;
            int i = 0;
            while (i < strLength - length) {
                sourceStr = sourceStr == null ? fillChar : String.valueOf(sourceStr) + fillChar;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sourceStr;
    }

    public static String reverseNum(String num) {
        String sTemp = "";
        long l = Long.valueOf(num);
        long lTemp = 0L;
        while (sTemp.length() != num.length()) {
            lTemp = l % 10L;
            sTemp = String.valueOf(sTemp) + String.valueOf(lTemp).toString();
            l /= 10L;
        }
        return sTemp;
    }

    public static String repaceStr(String str) {
        String newStr = "";
        if (str.length() <= 17) {
            newStr = str;
        }
        if (str.length() > 17 && str.length() <= 34) {
            newStr = String.valueOf(str.substring(0, 17)) + "\n" + str.substring(17, str.length());
        }
        if (str.length() > 34 && str.length() <= 51) {
            newStr = String.valueOf(str.substring(0, 17)) + "\n" + str.substring(17, 34) + "\n" + str.substring(34, str.length());
        }
        if (str.length() > 51 && str.length() <= 68) {
            newStr = String.valueOf(str.substring(0, 17)) + "\n" + str.substring(17, 34) + "\n" + str.substring(34, 51) + "\n" + str.substring(51, str.length());
        }
        return newStr;
    }

    public static String repaceDesc(String str) {
        String newStr = "";
        if (str.length() <= 7) {
            newStr = str;
        }
        if (str.length() > 7 && str.length() <= 14) {
            newStr = String.valueOf(str.substring(0, 7)) + "\n" + str.substring(7, str.length());
        }
        return newStr;
    }

    public static Collection strToCollection(String str, String sep) {
        Vector<String> vector = new Vector<String>();
        if (str != null) {
            StringTokenizer strToken = new StringTokenizer(str, sep);
            while (strToken.hasMoreTokens()) {
                vector.add(strToken.nextToken().trim());
            }
        }
        return vector;
    }

    public static Hashtable strToHashtable(String str, String sep) {
        Hashtable<String, Long> table = new Hashtable<String, Long>();
        if (str != null) {
            StringTokenizer strToken = new StringTokenizer(str, sep);
            long count = 0L;
            while (strToken.hasMoreTokens()) {
                table.put(strToken.nextToken().trim(), new Long(count));
                ++count;
            }
        }
        return table;
    }

    public static boolean isAcsiiAndGB(String str) {
        boolean result = true;
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                String subStr = str.substring(i, i + 1);
                if (!StringUtil.isAcsii(subStr) && !StringUtil.isGB2312(subStr)) {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isAcsiiAndGBK(String str) {
        boolean result = true;
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                String subStr = str.substring(i, i + 1);
                if (!StringUtil.isAcsii(subStr) && !StringUtil.isGBK(subStr)) {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isXCharSetAndGBK(String str) {
        boolean result = true;
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                String subStr = str.substring(i, i + 1);
                if (!StringUtil.isXCharSet(subStr) && !StringUtil.isGBK(subStr)) {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isAcsii(String str) {
        boolean isAcsii = true;
        if (str != null) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                byte[] bytes = ("" + chars[i]).getBytes();
                if (bytes.length == 1) {
                    if (bytes[0] < 0 || bytes[0] > 126) {
                        isAcsii = false;
                        break;
                    }
                } else {
                    isAcsii = false;
                    break;
                }
                ++i;
            }
        } else {
            isAcsii = false;
        }
        return isAcsii;
    }

    public static boolean isXCharSet(String str) {
        boolean isXCharSet = true;
        if (str != null) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                byte[] bytes = ("" + chars[i]).getBytes();
                if (bytes.length == 1) {
                    if (!(bytes[0] >= 65 && bytes[0] <= 90 || bytes[0] >= 95 && bytes[0] <= 127 || bytes[0] >= 32 && bytes[0] <= 90 || bytes[0] == 37 || bytes[0] == 34 || bytes[0] == 39)) {
                        isXCharSet = false;
                        break;
                    }
                } else {
                    isXCharSet = false;
                    break;
                }
                ++i;
            }
        } else {
            isXCharSet = false;
        }
        return isXCharSet;
    }

    public static boolean isGB2312(String str) {
        boolean isGB2312 = true;
        if (str != null) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                byte[] bytes = ("" + chars[i]).getBytes();
                if (bytes.length == 2) {
                    int[] ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF};
                    if (ints[0] < 161 || ints[0] > 254 || ints[1] < 161 || ints[1] > 254) {
                        isGB2312 = false;
                        break;
                    }
                } else {
                    isGB2312 = false;
                    break;
                }
                ++i;
            }
        } else {
            isGB2312 = false;
        }
        return isGB2312;
    }

    public static boolean isGBK(String str) {
        boolean isGBK = true;
        if (str != null) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                byte[] bytes = ("" + chars[i]).getBytes();
                if (bytes.length == 2) {
                    int[] ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF};
                    if (ints[0] < 129 || ints[0] > 254 || (ints[1] < 64 || ints[1] > 126) && (ints[1] < 128 || ints[1] > 254)) {
                        isGBK = false;
                        break;
                    }
                } else {
                    isGBK = false;
                    break;
                }
                ++i;
            }
        } else {
            isGBK = false;
        }
        return isGBK;
    }

    public static String byteToStr(byte[] buff) {
        String str = null;
        int i = 0;
        while (i < buff.length) {
            if (buff[i] == 0) {
                str = new String(buff, 0, i);
                break;
            }
            ++i;
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }
}

