/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleRelocator
implements Relocator {
    private String pattern;
    private String pathPattern;
    private String shadedPattern;
    private String shadedPathPattern;
    private Set excludes;

    public SimpleRelocator(String patt, String shadedPattern, List excludes) {
        this.pattern = patt.replace('/', '.');
        this.pathPattern = patt.replace('.', '/');
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern.replace('/', '.');
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = new LinkedHashSet();
            Iterator i = excludes.iterator();
            while (i.hasNext()) {
                String e = (String)i.next();
                String classExclude = e.replace('.', '/');
                this.excludes.add(classExclude);
                if (!classExclude.endsWith("/*")) continue;
                String packageExclude = classExclude.substring(0, classExclude.lastIndexOf(47));
                this.excludes.add(packageExclude);
            }
        }
    }

    public boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (this.excludes != null) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return false;
            }
        }
        return path.startsWith(this.pathPattern);
    }

    public boolean canRelocateClass(String clazz) {
        return this.canRelocatePath(clazz.replace('.', '/'));
    }

    public String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }
}

