/*
 * Decompiled with CFR 0.152.
 */
package com.bmc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class PatrolEvent {
    private static final byte[] head = new byte[]{60, 83, 84, 65, 82, 84, 62, 62};
    private static final byte tail = 1;
    private String message;
    private int level = -1;
    private String groupName;
    private String hostName;
    private String hostAddress;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    private static String getSeverity(int level) {
        switch (level) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "CRITICAL";
            }
            case 2: {
                return "MAJOR";
            }
            case 3: {
                return "MINOR";
            }
            case 4: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
        }
        return "UNKNOWN";
    }

    private String translate(String s) {
        return s.replace("\\", "\\\\").replace("'", "\\'");
    }

    public byte[] getData() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALARM;");
        if (this.message != null) {
            sb.append("msg='").append(this.translate(this.message)).append("';");
        }
        sb.append("severity=").append(PatrolEvent.getSeverity(this.level)).append(";");
        if (this.hostName != null) {
            sb.append("mc_host='").append(this.translate(this.hostName)).append("';");
        }
        if (this.hostAddress != null) {
            sb.append("mc_host_address='").append(this.translate(this.hostAddress)).append("';");
        }
        if (this.groupName != null) {
            sb.append("pn_groups=['").append(this.translate(this.groupName)).append("'];");
        }
        sb.append("END");
        byte[] body = null;
        try {
            body = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int len = body.length + 1;
        byte[] data = new byte[head.length + 28 + len];
        System.arraycopy(head, 0, data, 0, head.length);
        int pos = head.length;
        int i = 0;
        while (i < 20) {
            data[pos++] = 0;
            ++i;
        }
        data[pos++] = (byte)(len >> 24 & 0xFF);
        data[pos++] = (byte)(len >> 16 & 0xFF);
        data[pos++] = (byte)(len >> 8 & 0xFF);
        data[pos++] = (byte)(len >> 0 & 0xFF);
        data[pos++] = (byte)(len >> 24 & 0xFF);
        data[pos++] = (byte)(len >> 16 & 0xFF);
        data[pos++] = (byte)(len >> 8 & 0xFF);
        data[pos++] = (byte)(len >> 0 & 0xFF);
        System.arraycopy(body, 0, data, pos, body.length);
        data[pos += body.length] = 1;
        return data;
    }

    public void send(String serverAddress, int serverPort) throws UnknownHostException, IOException {
        Socket s = new Socket(serverAddress, serverPort);
        if (this.getHostName() == null || this.getHostAddress() == null) {
            InetAddress addr = s.getLocalAddress();
            if (this.getHostName() == null) {
                this.setHostName(addr.getHostName());
            }
            if (this.getHostAddress() == null) {
                this.setHostAddress(addr.getHostAddress());
            }
        }
        s.setTcpNoDelay(true);
        OutputStream os = s.getOutputStream();
        os.write(this.getData());
        os.close();
        s.close();
    }

    public void send(String serverAddress) throws UnknownHostException, IOException {
        this.send(serverAddress, 1828);
    }

    public static void send(String serverAddress, String message, int level) throws UnknownHostException, IOException {
        PatrolEvent event = new PatrolEvent();
        event.setMessage(message);
        event.setLevel(level);
        event.send(serverAddress, 1828);
    }
}

