/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.pptx.preprocessor;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.pptx.PPTXUtils;
import fr.opensagres.xdocreport.document.pptx.preprocessor.APBufferedRegion;
import fr.opensagres.xdocreport.document.pptx.preprocessor.ARBufferedRegion;
import fr.opensagres.xdocreport.document.pptx.preprocessor.PPTXSlideContentHandler;
import fr.opensagres.xdocreport.document.pptx.preprocessor.txbody.ATxBodyBufferedRegion;
import fr.opensagres.xdocreport.document.pptx.preprocessor.txbody.PTxBodyBufferedRegion;
import fr.opensagres.xdocreport.document.pptx.preprocessor.txbody.TxBodyBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocument;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PPTXSlideDocument
extends TransformedBufferedDocument {
    private APBufferedRegion currentAPRegion;
    private ARBufferedRegion currentARRegion;
    private TxBodyBufferedRegion currentTtxBodyRegion;
    private final PPTXSlideContentHandler handler;

    public PPTXSlideDocument(PPTXSlideContentHandler handler) {
        this.handler = handler;
    }

    protected boolean isTable(String arg0, String arg1, String arg2) {
        return false;
    }

    protected boolean isTableRow(String arg0, String arg1, String arg2) {
        return false;
    }

    protected BufferedElement createElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (PPTXUtils.isPTxBody(uri, localName, name)) {
            this.currentTtxBodyRegion = new PTxBodyBufferedRegion(parent, uri, localName, name, attributes);
            return this.currentTtxBodyRegion;
        }
        if (PPTXUtils.isATxBody(uri, localName, name)) {
            this.currentTtxBodyRegion = new ATxBodyBufferedRegion(parent, uri, localName, name, attributes);
            return this.currentTtxBodyRegion;
        }
        if (PPTXUtils.isAP(uri, localName, name)) {
            this.currentAPRegion = new APBufferedRegion(this, parent, uri, localName, name, attributes);
            if (this.currentTtxBodyRegion != null) {
                this.currentTtxBodyRegion.addRegion((ISavable)this.currentAPRegion);
            }
            return this.currentAPRegion;
        }
        if (PPTXUtils.isAPPr(uri, localName, name) && this.currentAPRegion != null) {
            Integer level = this.getLevel(attributes);
            this.currentAPRegion.setLevel(level);
        }
        if (PPTXUtils.isAR(uri, localName, name)) {
            this.currentARRegion = new ARBufferedRegion(parent, uri, localName, name, attributes);
            if (this.currentAPRegion != null) {
                this.currentAPRegion.addRegion((ISavable)this.currentARRegion);
            }
            return this.currentARRegion;
        }
        return super.createElement(parent, uri, localName, name, attributes);
    }

    private Integer getLevel(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return StringUtils.asInteger((String)attributes.getValue("lvl"));
    }

    public void onEndEndElement(String uri, String localName, String name) {
        if ((PPTXUtils.isPTxBody(uri, localName, name) || PPTXUtils.isATxBody(uri, localName, name)) && this.currentTtxBodyRegion != null) {
            super.onEndEndElement(uri, localName, name);
            this.currentTtxBodyRegion.process();
            this.currentTtxBodyRegion = null;
            return;
        }
        if (PPTXUtils.isAP(uri, localName, name) && this.currentAPRegion != null) {
            super.onEndEndElement(uri, localName, name);
            this.currentAPRegion = null;
            return;
        }
        if (PPTXUtils.isAR(uri, localName, name) && this.currentAPRegion != null) {
            super.onEndEndElement(uri, localName, name);
            this.currentARRegion = null;
            return;
        }
        super.onEndEndElement(uri, localName, name);
    }

    public APBufferedRegion getCurrentAPRegion() {
        return this.currentAPRegion;
    }

    public ARBufferedRegion getCurrentARRegion() {
        return this.currentARRegion;
    }

    public FieldsMetadata getFieldsMetadata() {
        return this.handler.getFieldsMetadata();
    }

    public IDocumentFormatter getFormatter() {
        return this.handler.getFormatter();
    }
}

