/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.wiki;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.properties.ListItemProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ParagraphProperties;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.wikimodel.wem.EmptyWemListener;
import org.wikimodel.wem.IWemConstants;
import org.wikimodel.wem.WikiFormat;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.WikiStyle;

public class WemListenerAdapter
extends EmptyWemListener {
    private static final Logger LOGGER = LogUtils.getLogger(WemListenerAdapter.class);
    protected final IDocumentHandler documentHandler;

    public WemListenerAdapter(IDocumentHandler visitor) {
        this.documentHandler = visitor;
    }

    public void beginDocument() {
        try {
            this.documentHandler.startDocument();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void endDocument() {
        try {
            this.documentHandler.endDocument();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void beginFormat(WikiFormat format) {
        List styles = format.getStyles();
        for (WikiStyle style : styles) {
            try {
                if (IWemConstants.STRONG.equals((Object)style)) {
                    this.documentHandler.startBold();
                    continue;
                }
                if (!IWemConstants.EM.equals((Object)style)) continue;
                this.documentHandler.startItalics();
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public void endFormat(WikiFormat format) {
        List styles = format.getStyles();
        for (WikiStyle style : styles) {
            try {
                if (IWemConstants.STRONG.equals((Object)style)) {
                    this.documentHandler.endBold();
                    continue;
                }
                if (!IWemConstants.EM.equals((Object)style)) continue;
                this.documentHandler.endItalics();
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public void beginList(WikiParameters params, boolean ordered) {
        try {
            ListProperties properties = null;
            if (ordered) {
                this.documentHandler.startOrderedList(properties);
            } else {
                this.documentHandler.startUnorderedList(properties);
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void beginListItem() {
        try {
            ListItemProperties properties = null;
            this.documentHandler.startListItem(properties);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void endListItem() {
        try {
            this.documentHandler.endListItem();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void endList(WikiParameters params, boolean ordered) {
        try {
            if (ordered) {
                this.documentHandler.endOrderedList();
            } else {
                this.documentHandler.endUnorderedList();
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void onSpace(String str) {
        try {
            this.documentHandler.handleString(str);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void onWord(String str) {
        try {
            this.documentHandler.handleString(str);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void beginParagraph(WikiParameters params) {
        try {
            ParagraphProperties properties = null;
            this.documentHandler.startParagraph(properties);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void endParagraph(WikiParameters params) {
        try {
            this.documentHandler.endParagraph();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void onReference(String ref) {
        try {
            this.documentHandler.handleReference(ref, ref);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public void onReference(WikiReference ref) {
        try {
            this.documentHandler.handleReference(ref.getLink(), ref.getLabel());
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }
}

