/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.converter.server;

import fr.opensagres.xdocreport.converter.ConverterRegistry;
import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.Assert;
import fr.opensagres.xdocreport.core.utils.HttpHeaderUtils;
import fr.opensagres.xdocreport.remoting.converter.ConverterService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

@Path(value="/")
public class ConverterServiceImpl
implements ConverterService {
    private static final Logger LOGGER = LogUtils.getLogger(ConverterServiceImpl.class);

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/convert")
    public Response convert(final @Multipart(value="document") DataSource content, @Multipart(value="outputFormat") String outputFormat, final @Multipart(value="via") String via, @Multipart(value="download") boolean download) {
        try {
            Assert.notNull((Object)content.getName(), (String)"file is required");
            Assert.notNull((Object)outputFormat, (String)"outputFormat is required");
            Assert.notNull((Object)via, (String)"via is required");
            ConverterTypeTo to = ConverterTypeTo.valueOf((String)outputFormat);
            if (to == null) {
                throw new XDocConverterException("Converter service cannot support the output format=" + outputFormat);
            }
            String mimeType = content.getContentType();
            DocumentKind documentKind = DocumentKind.fromMimeType((String)mimeType);
            if (documentKind == null) {
                throw new XDocConverterException("Converter service cannot support mime-type=" + mimeType);
            }
            final Options options = Options.getFrom((DocumentKind)documentKind).to(to).via(via);
            final IConverter converter = ConverterRegistry.getRegistry().findConverter(options);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException, WebApplicationException {
                    try {
                        long start = System.currentTimeMillis();
                        converter.convert(content.getInputStream(), out, options);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Time spent to convert " + content.getName() + ": " + (System.currentTimeMillis() - start) + " ms using " + via);
                        }
                    }
                    catch (XDocConverterException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Converter error", e);
                        }
                        throw new WebApplicationException((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "RuntimeException", e);
                        }
                        throw new WebApplicationException((Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
            };
            Response.ResponseBuilder responseBuilder = Response.ok((Object)output, (MediaType)MediaType.valueOf((String)to.getMimeType()));
            if (download) {
                String fileName = content.getName();
                responseBuilder.header("Content-Disposition", (Object)HttpHeaderUtils.getAttachmentFileName((String)this.getOutputFileName(fileName, to)));
            }
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getOutputFileName(String filename, ConverterTypeTo to) {
        StringBuilder name = new StringBuilder(filename.replace('.', '_'));
        name.append('.');
        name.append(to.getExtension());
        return name.toString();
    }
}

