/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import com.sunyard.client.conn.TransConn;
import com.sunyard.exception.SunECMException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.log4j.Logger;

public class HttpConn
implements TransConn {
    private Logger log = Logger.getLogger(HttpConn.class);
    private HttpClient httpClient = null;
    private HttpPost httppost = null;
    private HttpResponse response = null;
    private String url = "";

    public HttpConn(String url, int connTimeOut, int reqTimeOut) {
        this.log.info((Object)("\u5efa\u7acbHTTP\u8fde\u63a5,URL:" + url + ",\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4:" + connTimeOut + ",\u8bf7\u6c42\u8d85\u65f6\u65f6\u95f4:" + reqTimeOut));
        this.url = url;
        this.httpClient = new DefaultHttpClient();
        this.httppost = new HttpPost(url);
        this.httpClient.getParams().setIntParameter("http.connection.timeout", connTimeOut * 1000);
        this.httpClient.getParams().setIntParameter("http.socket.timeout", reqTimeOut * 1000);
    }

    public void destroy() {
        this.log.info((Object)"\u5173\u95edHTTP\u8fde\u63a5");
        if (this.httppost != null) {
            this.httppost.abort();
        }
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public String receiveMsg() throws IOException {
        this.log.info((Object)"HTTP\u63a5\u53d7\u6d88\u606f");
        String xmlString = "";
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                xmlString = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
        }
        catch (IOException e) {
            this.log.error((Object)("--HttpConn-->receiveMsg-->IOException-->" + e.getMessage()));
            throw new IOException(e.toString());
        }
        return xmlString;
    }

    public boolean sendFileData(String filePath, String contentID, String transType) throws UnsupportedEncodingException, ClientProtocolException, IOException, SunECMException {
        File file;
        this.log.info((Object)("\u53d1\u9001\u6587\u4ef6,\u6587\u4ef6\u8def\u5f84\uff1a" + filePath + ",contentID:" + contentID));
        int i = filePath.lastIndexOf(46);
        String format = "";
        if (i > -1 && i < filePath.length()) {
            format = filePath.substring(i + 1, filePath.length());
        }
        if (!(file = new File(filePath)).exists()) {
            this.log.debug((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84\uff1a" + file.getPath()));
            return false;
        }
        HttpPost httppost = new HttpPost(this.url);
        MultipartEntity reqEntity = new MultipartEntity();
        try {
            StringBody contentIDBody = new StringBody(contentID, CharsetUtil.getCharset((String)"UTF-8"));
            StringBody filePathBody = new StringBody(filePath, CharsetUtil.getCharset((String)"UTF-8"));
            StringBody formatBody = new StringBody(format, CharsetUtil.getCharset((String)"UTF-8"));
            StringBody fileSizeBody = new StringBody(String.valueOf(file.length()), CharsetUtil.getCharset((String)"UTF-8"));
            this.log.debug((Object)("--sendFileData-->transType:" + transType));
            if (transType != null) {
                StringBody msg = new StringBody(transType, CharsetUtil.getCharset((String)"UTF-8"));
                reqEntity.addPart("MSG", (ContentBody)msg);
            }
            reqEntity.addPart("CONTENTID", (ContentBody)contentIDBody);
            reqEntity.addPart("FILEPATH", (ContentBody)filePathBody);
            reqEntity.addPart("FORMAT", (ContentBody)formatBody);
            reqEntity.addPart("FILESIZE", (ContentBody)fileSizeBody);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("--HttpConn-->sendFileData-->UnsupportedEncodingException-->" + e.toString()));
            throw new UnsupportedEncodingException(e.toString());
        }
        FileBody fileBody = new FileBody(file, "application/octet-stream; charset=UTF-8");
        reqEntity.addPart("fileBody", (ContentBody)fileBody);
        httppost.setEntity((HttpEntity)reqEntity);
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httppost);
        }
        catch (ClientProtocolException e) {
            this.log.error((Object)("--HttpConn-->sendFileData-->ClientProtocolException-->" + e.toString()));
            throw new ClientProtocolException(e.toString());
        }
        catch (IOException e) {
            this.log.error((Object)("--HttpConn-->sendFileData-->IOException-->" + e.toString()));
            throw new IOException(e.toString());
        }
        int status = this.response.getStatusLine().getStatusCode();
        if (status != 200) {
            String res = EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)"UTF-8");
            this.log.error((Object)("--HttpConn-->sendFileData-->Exception-->" + res));
            throw new SunECMException(207, res);
        }
        return true;
    }

    public void sendMsg(String msg) throws UnsupportedEncodingException, IOException, SunECMException {
        this.log.info((Object)("HTTP\u53d1\u9001\u6d88\u606fmsg:" + msg));
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        String key = "HTTPMSG";
        String value = msg;
        nvps.add(new BasicNameValuePair(key, value));
        try {
            this.httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            this.response = this.httpClient.execute((HttpUriRequest)this.httppost);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("--HttpConn-->sendMsg-->UnsupportedEncodingException-->" + e.toString()));
            throw new UnsupportedEncodingException(e.toString());
        }
        catch (IOException e) {
            this.log.error((Object)"--HttpConn-->sendMsg-->IOException-->:", (Throwable)e);
            throw e;
        }
        int status = this.response.getStatusLine().getStatusCode();
        if (status != 200) {
            this.log.error((Object)("--HttpConn-->sendMsg-->Exception-->" + status));
            throw new SunECMException(status, EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)"utf-8"));
        }
    }
}

