/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.connQueueControl;

import com.sunyard.client.connQueueControl.SocketConnObject;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.RandomGUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SocketConnThreadControl {
    private static Logger log = Logger.getLogger(SocketConnThreadControl.class);
    private static Map<String, List<SocketConnObject>> connThreadMap = new HashMap<String, List<SocketConnObject>>();
    private static Map<String, Integer> runThreadSumMap = new HashMap<String, Integer>();
    public static int maxTreadSum = 30;
    private static final Object conObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRunThreadSum() {
        Object object = conObject;
        synchronized (object) {
            int runThreadSum = 0;
            for (int temp : runThreadSumMap.values()) {
                runThreadSum += temp;
            }
            return runThreadSum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnSocketConn(SocketConnObject object) {
        Object object2 = conObject;
        synchronized (object2) {
            if (object == null) {
                return;
            }
            log.debug((Object)("--SocketConnThreadControl-->returnSocketConn-->" + object.getName() + "\u8fd4\u56de\u8fde\u63a5\u5bf9\u8c61"));
            int temp = 0;
            if (runThreadSumMap.get(object.getIp()) != null) {
                temp = runThreadSumMap.get(object.getIp());
            }
            if (object != null && temp > 0) {
                object.setRunStatus(false);
                runThreadSumMap.put(object.getIp(), temp - 1);
                log.debug((Object)("--SocketConnThreadControl-->returnSocketConn-->" + runThreadSumMap.get(object.getIp()) + "ip==" + object.getIp()));
            }
        }
    }

    public static SocketConnObject getSocketConnObject(String ip, String port) throws SunECMException {
        SocketConnObject object = null;
        while (object == null) {
            object = SocketConnThreadControl.getConnObject(ip, port);
            if (object != null) continue;
            try {
                log.debug((Object)"\u8fde\u63a5\u5bf9\u8c61\u4e0d\u591f\uff0c\u7b49\u5f85\u5176\u5b83\u7ebf\u7a0b\u91ca\u653e\uff0c5\u79d2\u540e\u91cd\u65b0\u83b7\u53d6");
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Object)("--SocketConnObject-->InterruptedException:" + e.toString()));
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SocketConnObject getConnObject(String ip, String port) throws SunECMException {
        Object object = conObject;
        synchronized (object) {
            SocketConnObject object2 = null;
            int temp = 0;
            if (runThreadSumMap.get(ip) != null) {
                temp = runThreadSumMap.get(ip);
            }
            if (temp < maxTreadSum) {
                List<SocketConnObject> list = connThreadMap.get(ip);
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = connThreadMap.get(ip).get(i);
                        if (object2.isRunStatus(ip)) continue;
                        object2.resetRunTime();
                        object2.setRunStatus(true);
                        runThreadSumMap.put(ip, temp + 1);
                        log.debug((Object)("--SocketConnThreadControl--getConnObject-->" + runThreadSumMap.get(ip)));
                        return object2;
                    }
                }
                object2 = SocketConnThreadControl.createNewSocketConnObject(ip, port);
            }
            return object2;
        }
    }

    public static SocketConnObject createNewSocketConnObject(String ip, String port) throws SunECMException {
        log.info((Object)("--\u521b\u5efaip:" + ip + "\u7aef\u53e3\uff1a" + port + "\u8fde\u63a5\u5bf9\u8c61"));
        SocketConnObject object = null;
        object = new SocketConnObject(ip, port);
        object.setThreadName(RandomGUID.getGUIDStr());
        object.setRunStatus(true);
        int temp = 0;
        if (runThreadSumMap.get(ip) != null) {
            temp = runThreadSumMap.get(ip);
        }
        runThreadSumMap.put(ip, temp + 1);
        log.debug((Object)("--createNewSocketConnObject-->" + runThreadSumMap.get(ip)));
        if (connThreadMap.get(ip) == null || connThreadMap.get(ip).size() == 0) {
            ArrayList<SocketConnObject> list = new ArrayList<SocketConnObject>();
            list.add(object);
            connThreadMap.put(ip, list);
        } else {
            connThreadMap.get(ip).add(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConn(SocketConnObject object) {
        Object object2 = conObject;
        synchronized (object2) {
            if (object != null) {
                log.info((Object)("--removeConn-->\u5220\u9664\u8fde\u63a5\u5bf9\u8c61:" + object.getName() + ""));
                int temp = 0;
                if (runThreadSumMap.get(object.getIp()) != null) {
                    temp = runThreadSumMap.get(object.getIp());
                }
                runThreadSumMap.put(object.getIp(), temp - 1);
                log.debug((Object)("--removeConn-->" + runThreadSumMap.get(object.getIp()) + "ip:" + object.getIp()));
                connThreadMap.get(object.getIp()).remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeALlSocketConn() {
        Object object = conObject;
        synchronized (object) {
            if (connThreadMap != null) {
                log.info((Object)"--closeALlSocketConn-->\u5173\u95ed\u6240\u6709\u7684socket\u8fde\u63a5");
                ArrayList list = new ArrayList();
                String key2 = "";
                for (String key2 : connThreadMap.keySet()) {
                    list.addAll(connThreadMap.get(key2));
                    SocketConnObject object2 = null;
                    int temp = 0;
                    if (runThreadSumMap.get(key2) != null) {
                        temp = runThreadSumMap.get(key2);
                    }
                    log.debug((Object)("--closeALlSocketConn-->close before runThreadSumMap.get(" + key2 + ")=" + temp + "queue size=" + list.size()));
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = (SocketConnObject)list.get(i);
                        log.debug((Object)("--closeALlSocketConn-->\u79fb\u9664" + object2.getName() + "\u8fd0\u884c\u72b6\u6001\u4e3a" + object2.isRunStatus(key2)));
                        if (object2.isRunStatus(key2)) continue;
                        object2.closeConn();
                        connThreadMap.get(key2).remove(object2);
                    }
                    log.debug((Object)("--closeALlSocketConn-->close after runThreadSumMap.get(" + key2 + ")=" + temp + "queue size=" + list.size()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killSocketConn() {
        Object object = conObject;
        synchronized (object) {
            log.info((Object)"--killSocketConn-->\u5f3a\u5236\u5173\u95ed\u6240\u6709\u7684socket\u8fde\u63a5\uff0c\u4e0d\u7ba1\u8be5socket\u662f\u5426\u6b63\u5728\u8fd0\u884c");
            String key2 = "";
            for (String key2 : connThreadMap.keySet()) {
                SocketConnObject object2 = null;
                for (int i = 0; i < connThreadMap.get(key2).size(); ++i) {
                    object2 = connThreadMap.get(key2).get(i);
                    try {
                        object2.getClientTrans().destroy();
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("--killSocketConn-->socket close exception, error info-->" + e.getMessage()));
                    }
                }
            }
            connThreadMap.clear();
            runThreadSumMap.clear();
            log.debug((Object)("--killSocketConn-->runThreadSeumMap size:" + runThreadSumMap.size() + ", connThreadMap size:" + connThreadMap.size()));
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

