/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.FileMD5Verify;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.List;

public class MD5Util {
    public static void addBatchMD5Code(ClientBatchBean clientBatchBean) throws SunECMException {
        if (clientBatchBean.isOwnMD5()) {
            List<ClientBatchFileBean> fileobjs = clientBatchBean.getDocument_Objects();
            for (ClientBatchFileBean clientBatchFileBean : fileobjs) {
                List<ClientFileBean> files = clientBatchFileBean.getFiles();
                for (ClientFileBean clientFileBean : files) {
                    if (clientFileBean.getFileName() != null && !clientFileBean.isISDOCFLOW()) {
                        File file = new File(clientFileBean.getFileName());
                        clientFileBean.setMd5Str(MD5Util.getMD5Code(file));
                        continue;
                    }
                    if (!clientFileBean.isISDOCFLOW()) continue;
                    BufferedInputStream ds = new BufferedInputStream(clientFileBean.getDOCFLOW());
                    clientFileBean.setDOCFLOW(ds);
                    clientFileBean.setMd5Str(MD5Util.getMD5Code(ds));
                }
            }
        }
    }

    private static String getMD5Code(BufferedInputStream docflow) throws SunECMException {
        if (docflow != null) {
            FileMD5Verify md5Verify = new FileMD5Verify();
            String md5Code = md5Verify.getFileMD5String(docflow);
            return md5Code;
        }
        throw new SunECMException(707, "MD5\u7801\u751f\u6210\u65f6\u627e\u4e0d\u5230\u6587\u4ef6\u6d41");
    }

    private static String getMD5Code(File file) throws SunECMException {
        if (file.exists()) {
            FileMD5Verify md5Verify = new FileMD5Verify();
            String md5Code = md5Verify.getFileMD5String(file);
            return md5Code;
        }
        throw new SunECMException(707, "MD5\u7801\u751f\u6210\u65f6\u627e\u4e0d\u5230\u6587\u4ef6[" + file.getAbsolutePath() + "]");
    }
}

