/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.bean.ClientHeightQuery;
import com.sunyard.client.bean.HttpConnType;
import com.sunyard.client.conn.HttpsConn;
import com.sunyard.client.impl.MD5Util;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.OptionKey;
import com.sunyard.ws.client.WSConsoleClient;
import com.sunyard.ws.internalapi.SunEcmConsole;
import com.sunyard.ws.utils.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunEcmClientHttpsApiImpl
implements SunEcmClientApi {
    private static Logger log = Logger.getLogger(SunEcmClientHttpsApiImpl.class);
    protected HttpsConn conn;
    private String ip;
    private int httpsPort;
    private int connTimeOut = 30000;
    private int reqTimeOut = 30000;
    private String serverName = null;
    private String splitSym = "<<::>>";

    public SunEcmClientHttpsApiImpl(String ip, int httpsPort, String serverName) {
        this.ip = ip;
        this.httpsPort = httpsPort;
        this.serverName = serverName;
    }

    protected boolean connectToHost(String type) throws SunECMException {
        log.info((Object)("--connectToHost-->\u5efa\u7acbHTTP\u8fde\u63a5" + type));
        int connectretrytimes = 5;
        int i = 0;
        while (i < connectretrytimes) {
            if (this.newHost(type)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.debug((Object)("--SunEcmClientHttpsApiImpl-->connectToHost-->\u5f53\u524d\u8fde\u63a5\u6b21\u6570\uff1a" + (i + 1)));
            }
            if (i == connectretrytimes - 1) {
                log.warn((Object)("--SunEcmClientHttpsApiImpl-->connectToHost-->HTTP\u8fde\u63a5\u4e3b\u673a\uff1a" + this.ip + " \u7aef\u53e3:" + this.httpsPort + "\u5931\u8d25"));
                throw new SunECMException(736, "--SunEcmClientHttpsApiImpl-->connectToHost-->HTTP\u8fde\u63a5\u4e3b\u673a\uff1a" + this.ip + " \u7aef\u53e3:" + this.httpsPort + "\u5931\u8d25");
            }
            ++i;
        }
        return false;
    }

    private boolean newHost(String type) {
        log.info((Object)"--newHost-->\u65b0\u5efa\u8fde\u63a5");
        try {
            String url = "";
            url = type.equals(HttpConnType.MSG) ? this.createMsgURL(this.ip, this.httpsPort) : this.createFileURL(this.ip, this.httpsPort);
            log.debug((Object)("--newHost-->HTTPs\u8fde\u63a5\u5730\u5740\uff1a[" + url + "]"));
            this.conn = new HttpsConn(url, this.connTimeOut, this.reqTimeOut);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String checkIn(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        String result;
        block4: {
            log.info((Object)"--checkIn-->\u68c0\u5165clientBatchBean");
            this.connectToHost(HttpConnType.MSG);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "OPTION=" + OptionKey.CHECKIN + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
                this.conn.sendMsg(sendMsg);
                log.info((Object)("--checkIn-->\u68c0\u5165\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
                String msg = this.conn.receiveMsg();
                log.info((Object)("--checkIn-->\u68c0\u5165\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym : "FAIL";
                    break block4;
                }
                log.warn((Object)("\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
                throw new SunECMException("\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                this.conn.destroy();
            }
        }
        log.info((Object)("--checkIn(over)-->\u68c0\u5165" + result));
        return result;
    }

    @Override
    public String checkOut(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        String result;
        block4: {
            log.info((Object)"--checkOut-->\u68c0\u51fa clientBatchBean");
            this.connectToHost(HttpConnType.MSG);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "OPTION=" + OptionKey.CHECKOUT + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
                this.conn.sendMsg(sendMsg);
                log.debug((Object)("--checkOut-->\u68c0\u51fa\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
                String msg = this.conn.receiveMsg();
                log.debug((Object)("--checkOut-->\u68c0\u51fa\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
                    break block4;
                }
                throw new SunECMException("\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                this.conn.destroy();
            }
        }
        log.info((Object)("--checkOut-->\u68c0\u51fa(over)-->result:" + result));
        return result;
    }

    @Override
    public String delete(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--delete-->\u5220\u9664 clientBatchBean");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "OPTION=" + OptionKey.DEL + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--delete-->\u5220\u9664\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--delete-->\u5220\u9664\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--delete(over)");
        return resultStr;
    }

    @Override
    public String getAllModelMsg_Client() throws Exception {
        log.info((Object)"--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.ALLMODELMSG;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--getAllModelMsg_Client(over)");
        return resultStr;
    }

    @Override
    public String getContentServerInfo_Client() throws Exception {
        log.info((Object)"--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.GET_NODE;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f(over)");
        return resultStr;
    }

    @Override
    public String getModelTemplate_Client(String[] modeCodes) throws Exception {
        log.info((Object)"--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            StringBuffer modeNamesStr = new StringBuffer();
            String[] stringArray = modeCodes;
            int n = modeCodes.length;
            int n2 = 0;
            while (n2 < n) {
                String modeCode = stringArray[n2];
                modeNamesStr.append(modeCode).append("::");
                ++n2;
            }
            String sendMsg = "OPTION=" + OptionKey.METATEMPLATE + ",MODENAMES=" + modeNamesStr.toString();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248(over)");
        return resultStr;
    }

    @Override
    public String getPermissions_Client(String userName, String passWord) throws Exception {
        log.info((Object)("--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u83b7\u53d6 username:" + userName));
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.PERMISSION + ",USERNAME=" + userName + ",PASSWORD=" + CodeUtil.encode(passWord);
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u83b7\u53d6(over)");
        return resultStr;
    }

    @Override
    public String getToken(String ipAddress, String tokenCheckValue, String userName, String operationCode) throws Exception {
        log.info((Object)"--getToken-->\u83b7\u5f97\u4ee4\u724c");
        String token = "FAIL";
        WSConsoleClient consoleClient = new WSConsoleClient();
        SunEcmConsole console = consoleClient.getEcmConsoleClient(String.valueOf(ipAddress) + "/webservices/WsInterface", 300000L);
        token = console.getToken(tokenCheckValue, userName, operationCode);
        log.info((Object)("--getToken-->\u83b7\u5f97\u4ee4\u724c token:" + token));
        return token;
    }

    @Override
    public String heightQuery(ClientHeightQuery heightQuery, String dmsName) throws Exception {
        log.info((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(heightQuery);
        try {
            log.debug((Object)XMLUtil.bean2XML((Object)heightQuery));
            String sendMsg = "OPTION=" + OptionKey.HEIGHT_QUERY + ",XML=" + XMLUtil.bean2XML((Object)heightQuery) + ",DMSNAME=" + dmsName + ",USERNAME=" + heightQuery.getUserName() + ",PASSWORD=" + heightQuery.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String inquireDMByGroup(String userName, String groupName) throws Exception {
        log.info((Object)"--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.INQUIREDM + ",USERNAME=" + userName + ",DMSNAME=" + groupName;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--inquireDMByGroup-->\u67e5\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--inquireDMByGroup-->\u67e5\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740(over)");
        return resultStr;
    }

    @Override
    public String login(String userName, String password) throws Exception {
        password = CodeUtil.encode(password);
        log.info((Object)("--login-->\u767b\u5f55userName" + userName + "password" + password));
        this.connectToHost(HttpConnType.MSG);
        String resultMsg = "FAIL";
        try {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("OPTION=" + OptionKey.LOGIN + ",USERNAME=").append(userName).append(",PASSWORD=").append(password);
            this.conn.sendMsg(sbuf.toString());
            log.debug((Object)("--login-->\u767b\u5f55\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
            String msg = this.conn.receiveMsg();
            log.debug((Object)("--login-->\u767b\u5f55\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
            if (msg == null || "null".equals(msg)) {
                log.warn((Object)("--login-->\u767b\u9646\u5931\u8d25-->msg=" + msg));
                throw new SunECMException("--login-->\u767b\u9646\u5931\u8d25");
            }
            String[] strArray = msg.split(this.splitSym);
            if (strArray[0].equals("0001")) {
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                } else {
                    log.warn((Object)"\u767b\u9646\u5931\u8d25");
                }
            }
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)("--login-->\u767b\u5f55(over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String logout(String userName) throws Exception {
        String resultMsg;
        block4: {
            log.info((Object)("--logout-->\u767b\u51fauserName" + userName));
            this.connectToHost(HttpConnType.MSG);
            resultMsg = "FAIL";
            try {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("OPTION=" + OptionKey.LOGOUT + ",USERNAME=").append(userName);
                this.conn.sendMsg(sbuf.toString());
                log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
                String msg = this.conn.receiveMsg();
                log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (!strArray[0].equals("0001")) break block4;
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                    break block4;
                }
                log.warn((Object)"\u767b\u51fa\u5f02\u5e38");
                throw new SunECMException("\u767b\u51fa\u5f02\u5e38");
            }
            finally {
                this.conn.destroy();
            }
        }
        log.info((Object)"--logout-->\u767b\u51fa(over)");
        return resultMsg;
    }

    @Override
    public String operAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c clientBatchBean");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.A_OR_U_ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c(over)");
        return resultStr;
    }

    @Override
    public String queryAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        try {
            String sendMsg = "OPTION=" + OptionKey.ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String queryBatch(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--queryBatch-->\u67e5\u8be2");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "OPTION=" + OptionKey.QUERY + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--queryBatch-->\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String update(ClientBatchBean clientBatchBean, String dmsName, boolean isAutoCheck) throws Exception {
        log.info((Object)"--update-->\u66f4\u65b0");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL<<::>>707";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        if (isAutoCheck) {
            String OldPassWord = clientBatchBean.getPassWord();
            String checkOutMsg = this.checkOut(clientBatchBean, dmsName);
            if (!checkOutMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                log.warn((Object)("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg));
                throw new SunECMException("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg);
            }
            clientBatchBean.setCheckToken(checkOutMsg.split(this.splitSym)[1]);
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u6210\u529f..."));
            try {
                clientBatchBean.setPassWord(OldPassWord);
                resultStr = this.update(clientBatchBean, dmsName);
                log.debug((Object)("--update-->\u81ea\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
            }
            finally {
                clientBatchBean.setPassWord(OldPassWord);
                String checkInMsg = this.checkIn(clientBatchBean, dmsName);
                if (!checkInMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                    log.warn((Object)("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg));
                    throw new SunECMException("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg);
                }
            }
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u6210\u529f..."));
        } else {
            resultStr = this.update(clientBatchBean, dmsName);
            log.debug((Object)("--update-->\u624b\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
        }
        log.info((Object)"--update-->\u66f4\u65b0(over)");
        return resultStr;
    }

    private String update(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.info((Object)"--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        log.debug((Object)("--update-->\u66f4\u65b0\u65f6\u7684\u62a5\u6587:" + XMLUtil.bean2XML((Object)clientBatchBean)));
        this.connectToHost(HttpConnType.MSG);
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            this.conn.sendMsg("OPTION=" + OptionKey.UPDATE + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord());
            String msg = this.conn.receiveMsg();
            log.debug((Object)("--update-->\u66f4\u65b0\u524d\u5efa\u7acb\u8fde\u63a5\u65f6\u670d\u52a1\u7aef\u8fd4\u56de\uff1a" + msg));
            String[] msgArray = msg.split(this.splitSym);
            if (msgArray[0].equals("0001")) {
                if (clientBatchBean.isBreakPoint()) {
                    this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID(), clientBatchBean.getModelCode());
                } else {
                    this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID());
                }
                this.connectToHost(HttpConnType.MSG);
                this.conn.sendMsg("OPTION=" + OptionKey.UPDATE + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName);
                msg = this.conn.receiveMsg();
                log.debug((Object)("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u670d\u52a1\u7aef\u8fd4\u56de\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    if (strArray[1].equals("SUCCESS")) {
                        resultStr = "SUCCESS";
                    }
                } else {
                    resultStr = String.valueOf(resultStr) + "<<::>>" + msg;
                }
            } else {
                resultStr = msg;
            }
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)("update-->\u66f4\u65b0(over)-->resultStr=" + resultStr));
        return resultStr;
    }

    @Override
    public String upload(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--upload-->\u4e0a\u4f20");
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL";
        }
        CodeUtil.encodeInBean(clientBatchBean);
        MD5Util.addBatchMD5Code(clientBatchBean);
        log.debug((Object)"--upload-->\u4e0a\u4f20\u5f00\u59cb");
        String reslutMsg = "FAIL";
        StringBuffer uploadMsg = new StringBuffer();
        uploadMsg.append("OPTION=" + OptionKey.UPLOAD + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName).append(",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord());
        this.connectToHost(HttpConnType.MSG);
        try {
            log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + uploadMsg.toString()));
            this.conn.sendMsg(uploadMsg.toString());
            String returnMsg = this.conn.receiveMsg();
            log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + returnMsg));
            String[] params = returnMsg.split(this.splitSym);
            String contentID = "FAIL";
            if (!params[0].equals("0001")) {
                String string = "FAIL<<::>>" + returnMsg;
                return string;
            }
            if (params[0].equals("0001")) {
                contentID = params[1];
                reslutMsg = "FAIL<<::>>" + contentID;
                clientBatchBean.getIndex_Object().setContentID(contentID);
                long start = System.currentTimeMillis();
                if (clientBatchBean.isBreakPoint()) {
                    this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID, clientBatchBean.getModelCode());
                } else {
                    this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID);
                }
                long end = System.currentTimeMillis();
                log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u8017\u65f6\u6beb\u79d2\uff1a" + (end - start)));
            }
            this.connectToHost(HttpConnType.MSG);
            String sendMsg = "OPTION=" + OptionKey.UPLOAD + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--SunEcmClientHttpsApiImpl-->upload-->\u4e0a\u4f20\u6587\u4ef6\u540e\u53d1\u9001\u7684\u6d88\u606f" + sendMsg));
            returnMsg = this.conn.receiveMsg();
            log.debug((Object)("--SunEcmClientHttpsApiImpl-->upload-->\u4e0a\u4f20\u6587\u4ef6\u540e\u8fd4\u56de\u7684\u6d88\u606f" + returnMsg));
            String[] strArray = returnMsg.split(this.splitSym);
            if (strArray[0].equals("0001")) {
                if (strArray[1].equals("SUCCESS")) {
                    reslutMsg = "SUCCESS<<::>>" + strArray[2];
                }
            } else {
                reslutMsg = String.valueOf(reslutMsg) + "<<::>>" + returnMsg;
            }
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)("--upload-->\u4e0a\u4f20(over)-->reslutMsg=" + reslutMsg));
        return reslutMsg;
    }

    private void sendClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID) throws UnsupportedEncodingException, ClientProtocolException, IOException, SunECMException {
        log.debug((Object)("--sendClientBatchFileBean-->\u4e0a\u4f20\u6587\u4ef6contentID:" + contentID));
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                String url = this.createFileURL(this.ip, this.httpsPort);
                log.debug((Object)("--SunEcmClientHttpsApiImpl-->sendClientBatchFileBean-->\u4e0a\u4f20\u6587\u4ef6\u7684\u5730\u5740\uff1a" + url));
                this.conn = new HttpsConn(url, this.connTimeOut, this.reqTimeOut);
                this.conn.sendFileData(fileBean.getFileName(), contentID, null);
            }
        }
    }

    private void sendBreakClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID, String modeCode) throws UnsupportedEncodingException, IOException, SunECMException {
        log.debug((Object)("--sendBreakClientBatchFileBean-->\u65ad\u70b9\u4e0a\u4f20\u6587\u4ef6contentID:" + contentID));
        this.conn.sendMsg("OPTION=" + OptionKey.BREAK_POINT + ",CONTENTID=" + contentID + ",MODECODE=" + modeCode);
        String filesStr = this.conn.receiveMsg().split(this.splitSym)[1];
        log.debug((Object)("--SunEcmClientHttpsApiImpl-->sendBreakClientBatchFileBean-->\u65ad\u70b9\u7eed\u4f20\u8fd4\u56de\u6d88\u606f\uff1a" + filesStr));
        List completeFiles = XMLUtil.xml2list((String)filesStr, ClientFileBean.class);
        ArrayList<ClientFileBean> totalFileBean = new ArrayList<ClientFileBean>();
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                totalFileBean.add(fileBean);
            }
        }
        if (completeFiles.size() != 0) {
            for (ClientFileBean fileBean : totalFileBean) {
                boolean flag = true;
                for (ClientFileBean complteFile : completeFiles) {
                    if (!fileBean.getFileName().equals(complteFile.getFileName())) continue;
                    flag = false;
                }
                if (!flag) continue;
                String url = this.createFileURL(this.ip, this.httpsPort);
                log.debug((Object)("--SunEcmClientHttpsApiImpl-->sendBreakClientBatchFileBean-->\u4e0a\u4f20\u6587\u4ef6\u7684\u5730\u5740\uff1a" + url));
                this.conn = new HttpsConn(url, this.connTimeOut, this.reqTimeOut);
                this.conn.sendFileData(fileBean.getFileName(), contentID, null);
            }
        } else {
            this.sendClientBatchFileBean(ClientBatchFileBeans, contentID);
        }
    }

    private boolean checkFileExist(ClientBatchBean clientBatchBean) {
        log.info((Object)"--checkFileExist-->\u6821\u9a8c\u6587\u4ef6\u662f\u5426\u5b58\u5728,\u5e76\u7edf\u8ba1\u6587\u4ef6\u6570");
        boolean flag = false;
        if (clientBatchBean.getIndex_Object().getAmount() == null || clientBatchBean.getIndex_Object().getAmount() == "") {
            flag = true;
        }
        int totalFile = 0;
        List<ClientBatchFileBean> batchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean clientBatchFileBean : batchFileBeans) {
            List<ClientFileBean> files = clientBatchFileBean.getFiles();
            for (ClientFileBean clientFileBean : files) {
                if (clientBatchFileBean.getFilePartName().equals(clientBatchBean.getModelCode())) {
                    clientBatchBean.getIndex_Object().setCustomMap(clientFileBean.getOtherAtt());
                }
                if (clientFileBean.getFileName() == null) continue;
                File file = new File(clientFileBean.getFileName());
                if (!file.exists() || file.isDirectory()) {
                    log.debug((Object)("--checkFileExist-->" + file.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
                    return false;
                }
                if (!flag) continue;
                ++totalFile;
            }
        }
        if (flag) {
            clientBatchBean.getIndex_Object().setAmount(String.valueOf(totalFile));
        }
        return true;
    }

    private String createMsgURL(String ip, int httpsPort) {
        log.info((Object)"--createMsgURL-->\u5efa\u7acb\u6d88\u606f\u8fde\u63a5");
        String url = "https://" + ip + ":" + httpsPort + "/" + this.serverName + "/servlet/httpReqDispacher";
        return url;
    }

    private String createFileURL(String ip, int httpsPort) {
        log.info((Object)"--createFileURL-->\u5efa\u7acb\u6587\u4ef6\u8fde\u63a5");
        String url = "https://" + ip + ":" + httpsPort + "/" + this.serverName + "/servlet/httpFileReceive";
        return url;
    }

    @Override
    public String immedMigrate(MigrateBatchBean migrateBatchBean, String dmsName) throws Exception {
        log.info((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb");
        this.connectToHost(HttpConnType.MSG);
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(migrateBatchBean);
        try {
            String sendMsg = "OPTION=" + OptionKey.IMMEDIATEMIGRATE + ",XML=" + XMLUtil.bean2XML((Object)migrateBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + migrateBatchBean.getUserName() + ",PASSWORD=" + migrateBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--SunEcmClientHttpsApiImpl-->immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--SunEcmClientHttpsApiImpl-->immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb(over)");
        return resultStr;
    }

    @Override
    public String queryNodeInfoByGroupIdAndInsNo(String itemType, String insNo) throws Exception {
        log.info((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f,modelCode" + itemType + "insNo" + insNo));
        this.connectToHost(HttpConnType.MSG);
        String resultStr = null;
        try {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("OPTION=" + OptionKey.QUERY_NODEINFO_BY_GROUPID_AND_INSNO + ",MODELCODE=").append(itemType).append(",INSNO=").append(insNo);
            this.conn.sendMsg(sbuf.toString());
            log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f" + sbuf.toString()));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f" + resultStr));
        }
        finally {
            this.conn.destroy();
        }
        log.info((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String createToken(String username, String password, String organ_no, String legalNo, String appId) throws Exception {
        return null;
    }

    @Override
    public String getAppInfo(String token) throws Exception {
        return null;
    }

    @Override
    public String getLeganPerm(String leganNo) throws Exception {
        return null;
    }
}

