/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.bean.ClientHeightQuery;
import com.sunyard.client.common.ClientConfiguration;
import com.sunyard.client.conn.SocketConn;
import com.sunyard.client.impl.MD5Util;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.ecm.util.net.DummyTrustManager;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.OptionKey;
import com.sunyard.ws.client.WSConsoleClient;
import com.sunyard.ws.internalapi.SunEcmConsole;
import com.sunyard.ws.utils.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunEcmClientSocketApiImpl
implements SunEcmClientApi {
    private static Logger log = Logger.getLogger(SunEcmClientSocketApiImpl.class);
    protected SocketConn conn;
    protected String splitSym = "<<::>>";
    protected String ipAddress;
    protected int socketPort;
    private boolean ssl = false;

    static {
        ClientConfiguration.init();
    }

    public SunEcmClientSocketApiImpl(String ip, int socketPort) {
        this.ipAddress = ip;
        this.socketPort = socketPort;
    }

    public SunEcmClientSocketApiImpl(String ip, int socketPort, boolean ssl) {
        this.ipAddress = ip;
        this.socketPort = socketPort;
        this.ssl = ssl;
    }

    protected boolean connectToHost(String host, int port) throws SunECMException {
        log.debug((Object)("--connectToHost-->\u5efa\u7acbsocket\u8fde\u63a5-->host: " + host + "port: " + port));
        int connectretrytimes = ClientConfiguration.getInt("client.socket.retrytimes", 5);
        int i = 0;
        while (i < connectretrytimes) {
            if (this.newHost(host, port)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.debug((Object)("--connectToHost-->\u5efa\u7acbsocket\u8fde\u63a5\u5c1d\u8bd5\u8fde\u63a5\u6b21\u6570\uff1a" + (i + 1)));
            }
            if (i == connectretrytimes - 1) {
                log.warn((Object)("\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25"));
                throw new SunECMException(736, "\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25");
            }
            ++i;
        }
        return false;
    }

    private boolean newHost(String ip, int socketPort) {
        log.debug((Object)("--newHost-->\u5efa\u7acb\u8fde\u63a5-->ip: " + ip + " socketPort:" + socketPort));
        try {
            Socket socket = null;
            if (this.ssl) {
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                SSLSocketFactory factory = context.getSocketFactory();
                socket = (SSLSocket)factory.createSocket(ip, socketPort);
            } else {
                socket = new Socket(ip, socketPort);
            }
            socket.setSendBufferSize(ClientConfiguration.getInt("client.socket.sendbuffersize", 8192));
            this.conn = new SocketConn(socket);
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String checkIn(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String result;
        block4: {
            log.debug((Object)"--checkIn-->\u68c0\u5165");
            this.connectToHost(this.ipAddress, this.socketPort);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CHECKIN + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
                this.conn.sendMsg(sendMsg);
                log.debug((Object)("--checkIn-->\u68c0\u5165\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg));
                String msg = this.conn.receiveMsg();
                log.debug((Object)("--checkIn-->\u68c0\u5165\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym : "FAIL";
                    break block4;
                }
                log.warn((Object)("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
                throw new SunECMException("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                this.conn.sendMsg("0009");
                this.conn.destroy();
            }
        }
        log.debug((Object)("--checkIn-->\u68c0\u5165-->result:" + result));
        return result;
    }

    @Override
    public String checkOut(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String result;
        block4: {
            log.debug((Object)"---->checkOut-->\u68c0\u51fa");
            this.connectToHost(this.ipAddress, this.socketPort);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CHECKOUT + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
                this.conn.sendMsg(sendMsg);
                log.debug((Object)("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg));
                String msg = this.conn.receiveMsg();
                log.debug((Object)("--checkOut-->\u68c0\u51fa\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
                    break block4;
                }
                log.warn((Object)("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
                throw new SunECMException("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                this.conn.sendMsg("0009");
                this.conn.destroy();
            }
        }
        log.debug((Object)("---->checkOut-->\u68c0\u51fa(over)-->result:" + result));
        return result;
    }

    @Override
    public String delete(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--delete-->\u5220\u9664");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.DEL + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--delete-->\u5220\u9664\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--delete-->\u5220\u9664\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--delete-->\u5220\u9664(over)");
        return resultStr;
    }

    @Override
    public String login(String userName, String password) throws SunECMException, IOException {
        password = CodeUtil.encode(password);
        log.debug((Object)("--login-->\u767b\u5f55 userName:" + userName + "password:" + password));
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultMsg = "FAIL";
        try {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("0002").append(String.valueOf(this.splitSym) + "OPTION=" + OptionKey.LOGIN + ",USERNAME=").append(userName).append(",PASSWORD=").append(password);
            this.conn.sendMsg(sbuf.toString());
            log.debug((Object)("--login-->\u767b\u5f55\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
            String msg = this.conn.receiveMsg();
            log.debug((Object)("--login-->\u767b\u5f55\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg));
            if (msg == null || "null".equals(msg)) {
                throw new SunECMException("--login-->\u767b\u9646\u5931\u8d25");
            }
            String[] strArray = msg.split(this.splitSym);
            if (strArray[0].equals("0001")) {
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                } else {
                    log.warn((Object)"--login-->\u767b\u9646\u5931\u8d25");
                }
            }
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)("--login-->\u767b\u5f55(over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String logout(String userName) throws SunECMException, IOException {
        String resultMsg;
        block4: {
            log.debug((Object)("--logout-->\u767b\u51fa  userName:" + userName));
            this.connectToHost(this.ipAddress, this.socketPort);
            resultMsg = "FAIL";
            try {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("0002").append(String.valueOf(this.splitSym) + "OPTION=" + OptionKey.LOGOUT + ",USERNAME=").append(userName);
                this.conn.sendMsg(sbuf.toString());
                log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
                String msg = this.conn.receiveMsg();
                log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
                log.debug((Object)msg);
                String[] strArray = msg.split(this.splitSym);
                if (!strArray[0].equals("0001")) break block4;
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                    break block4;
                }
                log.warn((Object)"--logout-->\u767b\u51fa\u5f02\u5e38");
                throw new SunECMException("--logout-->\u767b\u51fa\u5f02\u5e38");
            }
            finally {
                this.conn.sendMsg("0009");
                this.conn.destroy();
            }
        }
        log.debug((Object)("--logout-->\u767b\u51fa (over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String operAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            this.conn.sendMsg("0002" + this.splitSym + "OPTION=" + OptionKey.A_OR_U_ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName);
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c(over)");
        return resultStr;
    }

    @Override
    public String queryAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String queryBatch(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--queryBatch-->\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        clientBatchBean.setPASSWD(clientBatchBean.getPassWord());
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.QUERY + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--queryBatch-->\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String createToken(String username, String password, String organ_no, String legalNo, String appId) throws Exception {
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=CREATETOKEN" + ",USERNAME=" + username + ",PASSWORD=" + password + ",ORGAN_NO=" + organ_no + ",LEGALNO=" + legalNo + ",APPID=" + appId;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--createToken-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--queryBatch-->\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String update(ClientBatchBean clientBatchBean, String dmsName, boolean isAutoCheck) throws SunECMException, IOException {
        log.debug((Object)"--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL<<::>>707";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        HashMap<String, InputStream> docFlows = new HashMap<String, InputStream>();
        int count = 1;
        List<ClientBatchFileBean> ClientBatchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (!fileBean.isISDOCFLOW()) continue;
                fileBean.addOtherAtt("FLOW_ID", String.valueOf(count));
                docFlows.put(String.valueOf(count++), fileBean.getDOCFLOW());
                fileBean.setDOCFLOW(null);
            }
        }
        if (isAutoCheck) {
            String OldPassWord = clientBatchBean.getPassWord();
            String checkOutMsg = this.checkOut(clientBatchBean, dmsName);
            log.debug((Object)("--update-->\u68c0\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f: " + checkOutMsg));
            if (!checkOutMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg);
            }
            clientBatchBean.setCheckToken(checkOutMsg.split(this.splitSym)[1]);
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u6210\u529f"));
            try {
                clientBatchBean.setPassWord(OldPassWord);
                resultStr = this.update(clientBatchBean, dmsName, docFlows);
                log.debug((Object)("--update-->\u81ea\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u6d88\u606f\uff1a" + resultStr));
            }
            finally {
                clientBatchBean.setPassWord(OldPassWord);
                String checkInMsg = this.checkIn(clientBatchBean, dmsName);
                if (!checkInMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                    throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg);
                }
            }
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u6210\u529f"));
        } else {
            resultStr = this.update(clientBatchBean, dmsName, docFlows);
            log.debug((Object)("--update-->\u624b\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u6d88\u606f\uff1a" + resultStr));
        }
        log.debug((Object)("--update-->\u66f4\u65b0(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    private String update(ClientBatchBean clientBatchBean, String dmsName, Map<String, InputStream> docFlows) throws SunECMException, IOException {
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.UPDATE + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--update-->\u66f4\u65b0\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            String msg = this.conn.receiveMsg();
            log.debug((Object)("--update-->\u66f4\u65b0\u524d\u5efa\u7acb\u8fde\u63a5\u65f6\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
            String[] msgArray = msg.split(this.splitSym);
            if (msgArray[0].equals("0001")) {
                if (clientBatchBean.isBreakPoint()) {
                    this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID(), clientBatchBean.getModelCode());
                } else {
                    this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID(), docFlows);
                }
                String sendMsg_1 = "0002" + this.splitSym + "OPTION=" + OptionKey.UPDATE + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
                this.conn.sendMsg(sendMsg_1);
                log.debug((Object)("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg_1));
                msg = this.conn.receiveMsg();
                log.debug((Object)("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u670d\u52a1\u7aef\u8fd4\u56de\uff1a" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    if (strArray[1].equals("SUCCESS")) {
                        resultStr = "SUCCESS<<::>>" + strArray[2];
                    }
                } else {
                    resultStr = String.valueOf(resultStr) + "<<::>>" + msg;
                }
            } else {
                resultStr = msg;
            }
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)("--update-->return:" + resultStr));
        return resultStr;
    }

    @Override
    public String upload(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--upload-->\u4e0a\u4f20");
        long start = System.currentTimeMillis();
        this.connectToHost(this.ipAddress, this.socketPort);
        if (!this.checkFileExist(clientBatchBean)) {
            return "false";
        }
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, InputStream> docFlows = new HashMap<String, InputStream>();
        MD5Util.addBatchMD5Code(clientBatchBean);
        String resultStr = "";
        String contentID = "FAIL";
        try {
            long beginstart = System.currentTimeMillis();
            long beginend = System.currentTimeMillis();
            log.debug((Object)("--upload-->socket\u8fde\u63a5\u548c\u6821\u9a8c\u8017\u65f6[" + (beginend - beginstart) + "]\u6beb\u79d2"));
            long end1 = System.currentTimeMillis();
            List<ClientBatchFileBean> ClientBatchFileBeans = clientBatchBean.getDocument_Objects();
            int count = 1;
            for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
                List<ClientFileBean> fileBeans = batchFileBean.getFiles();
                for (ClientFileBean fileBean : fileBeans) {
                    if (!fileBean.isISDOCFLOW()) continue;
                    fileBean.addOtherAtt("FLOW_ID", String.valueOf(count));
                    docFlows.put(String.valueOf(count++), fileBean.getDOCFLOW());
                    fileBean.setDOCFLOW(null);
                }
            }
            String str = XMLUtil.bean2XML((Object)clientBatchBean);
            long end3 = System.currentTimeMillis();
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.UPLOAD + ",START=START,XML=" + str + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            log.debug((Object)("--upload-->\u7ec4\u88c5BEAN\u7684XML\u8017\u65f6[" + (end3 - end1) + "]\u6beb\u79d2" + sendMsg));
            this.conn.sendMsg(sendMsg);
            String msg = this.conn.receiveMsg();
            long end2 = System.currentTimeMillis();
            log.debug((Object)("--upload-->\u53d1\u9001\u8017\u65f6[" + (end2 - end3) + "]\u6beb\u79d2"));
            log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u8fd4\u56de:" + msg));
            String[] params = msg.split(this.splitSym);
            if (params[0].equals("0001")) {
                long _end3 = System.currentTimeMillis();
                contentID = params[1];
                resultStr = "FAIL<<::>>" + contentID;
                clientBatchBean.getIndex_Object().setContentID(contentID);
                if (clientBatchBean.isBreakPoint()) {
                    this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID, clientBatchBean.getModelCode());
                } else {
                    this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID, docFlows);
                }
                long _end4 = System.currentTimeMillis();
                log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u8017\u65f6[" + (_end4 - _end3) + "]\u6beb\u79d2"));
                String sendMsg_1 = "0002" + this.splitSym + "OPTION=" + OptionKey.UPLOAD + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
                log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210" + sendMsg_1));
                this.conn.sendMsg(sendMsg_1);
                msg = this.conn.receiveMsg();
                long _end5 = System.currentTimeMillis();
                log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u540e\u53d1\u9001\u62a5\u6587\u8017\u65f6[" + (_end5 - _end4) + "]\u6beb\u79d2, \u670d\u52a1\u7aef\u8fd4\u56de\u4fe1\u606f" + msg));
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    if (strArray[1].equals("SUCCESS")) {
                        resultStr = "SUCCESS<<::>>" + strArray[2];
                    }
                } else {
                    resultStr = String.valueOf(resultStr) + "<<::>>" + msg;
                }
            } else {
                resultStr = "FAIL<<::>>" + msg;
            }
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        long end4 = System.currentTimeMillis();
        log.debug((Object)("--upload-->\u4e0a\u4f20\u64cd\u4f5c\u8017\u65f6[" + (end4 - start) + "]\u6beb\u79d2"));
        log.debug((Object)("--upload(over)-->resultStr=" + resultStr));
        return resultStr;
    }

    private void sendClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID, Map<String, InputStream> docFlows) throws SunECMException, IOException {
        log.debug((Object)("--sendClientBatchFileBean-->\u53d1\u9001\u6279\u6b21\u6587\u4ef6 contentID:" + contentID));
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() != null && !fileBean.isISDOCFLOW()) {
                    this.conn.sendFileData(fileBean.getFileName(), contentID, "0003<<::>>");
                    continue;
                }
                if (!fileBean.isISDOCFLOW()) continue;
                this.conn.sendFileData(fileBean.getFileName(), contentID, "0003<<::>>", docFlows.get(fileBean.getOtherAtt().get("FLOW_ID")));
            }
        }
    }

    private void sendBreakClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID, String modeCode) throws IOException, SunECMException {
        log.debug((Object)"--sendBreakClientBatchFileBean-->\u53d1\u9001\u6279\u6b21\u6587\u4ef6");
        this.conn.sendMsg("0002" + this.splitSym + "OPTION=" + OptionKey.BREAK_POINT + ",CONTENTID=" + contentID + ",MODECODE=" + modeCode);
        String filesStr = this.conn.receiveMsg().split(this.splitSym)[1];
        log.debug((Object)("--sendBreakClientBatchFileBean-->Break Point Msg is: " + filesStr));
        List completeFiles = XMLUtil.xml2list((String)filesStr, ClientFileBean.class);
        log.debug((Object)"--sendBreakClientBatchFileBean-->\u7edf\u8ba1\u6240\u6709\u7684\u5f85\u4e0a\u4f20\u6587\u4ef6");
        ArrayList<ClientFileBean> totalFileBean = new ArrayList<ClientFileBean>();
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                totalFileBean.add(fileBean);
            }
        }
        log.debug((Object)("--sendBreakClientBatchFileBean-->totalFileBean:" + ((Object)totalFileBean).toString()));
        log.debug((Object)"--sendBreakClientBatchFileBean-->\u5c06\u4e0d\u5c5e\u4e8e\u5df2\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0a\u4f20");
        if (completeFiles.size() != 0) {
            for (ClientFileBean fileBean : totalFileBean) {
                boolean flag = true;
                for (ClientFileBean complteFile : completeFiles) {
                    if (!fileBean.getFileName().equals(complteFile.getOrigName())) continue;
                    flag = false;
                }
                if (!flag) continue;
                this.conn.sendFileData(fileBean.getFileName(), contentID, "0003<<::>>");
            }
        } else {
            this.sendClientBatchFileBean(ClientBatchFileBeans, contentID, null);
        }
    }

    private boolean checkFileExist(ClientBatchBean clientBatchBean) {
        log.debug((Object)"--checkFileExist-->\u6821\u9a8c\u6587\u4ef6\u662f\u5426\u5b58\u5728");
        boolean flag = false;
        if (clientBatchBean.getIndex_Object().getAmount() == null || clientBatchBean.getIndex_Object().getAmount() == "") {
            flag = true;
        }
        int totalFile = 0;
        List<ClientBatchFileBean> batchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean clientBatchFileBean : batchFileBeans) {
            List<ClientFileBean> files = clientBatchFileBean.getFiles();
            for (ClientFileBean clientFileBean : files) {
                if (clientBatchFileBean.getFilePartName().equals(clientBatchBean.getModelCode())) {
                    clientBatchBean.getIndex_Object().setCustomMap(clientFileBean.getOtherAtt());
                }
                if (clientFileBean.getFileName() != null && !clientFileBean.isISDOCFLOW()) {
                    File file = new File(clientFileBean.getFileName());
                    if (!file.exists() || file.isDirectory()) {
                        log.debug((Object)("--checkFileExist-->" + file.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728..."));
                        return false;
                    }
                    if (!flag) continue;
                    ++totalFile;
                    continue;
                }
                if (!clientFileBean.isISDOCFLOW()) continue;
                if (clientFileBean.getDOCFLOW() == null) {
                    log.debug((Object)("--checkFileExist-->" + clientFileBean.getFileName() + "\u6587\u4ef6\u6d41\u4e0d\u5b58\u5728..."));
                    return false;
                }
                if (!flag) continue;
                ++totalFile;
            }
        }
        if (flag) {
            clientBatchBean.getIndex_Object().setAmount(String.valueOf(totalFile));
        }
        return true;
    }

    @Override
    public String heightQuery(ClientHeightQuery heightQuery, String dmsName) throws SunECMException, IOException {
        log.debug((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(heightQuery);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.HEIGHT_QUERY + ",XML=" + XMLUtil.bean2XML((Object)heightQuery) + ",DMSNAME=" + dmsName + ",USERNAME=" + heightQuery.getUserName() + ",PASSWORD=" + heightQuery.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--heightQuery-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--heightQuery-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String getAllModelMsg_Client() throws SunECMException, IOException {
        log.debug((Object)"--getAllModelMsg_Client-->\u5ba2\u6237\u7aef\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.ALLMODELMSG;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getAllModelMsg_Client-->\u5ba2\u6237\u7aef\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f(over)");
        return resultStr;
    }

    @Override
    public String getContentServerInfo_Client() throws SunECMException, IOException {
        log.debug((Object)"--getContentServerInfo_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.GET_NODE;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getContentServerInfo_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f(over)");
        return resultStr;
    }

    @Override
    public String getModelTemplate_Client(String[] modeCodes) throws SunECMException, IOException {
        log.debug((Object)"--getModelTemplate_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            StringBuffer modeNamesStr = new StringBuffer();
            String[] stringArray = modeCodes;
            int n = modeCodes.length;
            int n2 = 0;
            while (n2 < n) {
                String modeCode = stringArray[n2];
                modeNamesStr.append(modeCode).append("::");
                ++n2;
            }
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.METATEMPLATE + ",MODENAMES=" + modeNamesStr.toString();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getModelTemplate_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        return resultStr;
    }

    @Override
    public String getPermissions_Client(String userName, String passWord) throws SunECMException, IOException {
        log.debug((Object)("--getPermissions_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650 userName:" + userName));
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.PERMISSION + ",USERNAME=" + userName + ",PASSWORD=" + CodeUtil.encode(passWord);
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getPermissions_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getPermissions_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650(over)");
        return resultStr;
    }

    @Override
    public String getToken(String ipAddress, String tokenCheckValue, String userName, String operationCode) throws SunECMException {
        log.debug((Object)"--getToken-->\u5ba2\u6237\u7aef\u83b7\u53d6\u52a8\u6001\u4ee4\u724c");
        String token = "";
        WSConsoleClient consoleClient = new WSConsoleClient();
        SunEcmConsole console = consoleClient.getEcmConsoleClient(String.valueOf(ipAddress) + "/webservices/WsInterface", 300000L);
        log.debug((Object)("--getToken-->\u83b7\u53d6\u52a8\u6001\u4ee4\u724c\u53d1\u9001\u65f6\u7684\u53c2\u6570[tokenCheckValue,userName,operationCode]:" + tokenCheckValue + "," + userName + "," + operationCode));
        token = console.getToken(tokenCheckValue, userName, operationCode);
        log.debug((Object)("--getToken-->\u83b7\u53d6\u52a8\u6001\u4ee4\u724c\u53d1\u8fd4\u56de\u7684\u6d88\u606f:" + token));
        return token;
    }

    @Override
    public String inquireDMByGroup(String userName, String groupName) throws Exception {
        log.debug((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740userName:" + userName + "groupName" + groupName));
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.INQUIREDM + ",USERNAME=" + userName + ",DMSNAME=" + groupName;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u53d1\u9001\u7684\u6d88\u606f:" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u8fd4\u56de\u7684\u6d88\u606f:" + sendMsg));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String immedMigrate(MigrateBatchBean migrateBatchBean, String dmsName) throws Exception {
        log.debug((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(migrateBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.IMMEDIATEMIGRATE + ",XML=" + XMLUtil.bean2XML((Object)migrateBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + migrateBatchBean.getUser() + ",PASSWORD=" + migrateBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f:" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f:" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb(over)");
        return resultStr;
    }

    @Override
    public String queryNodeInfoByGroupIdAndInsNo(String itemType, String insNo) throws Exception {
        log.debug((Object)"--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.QUERY_NODEINFO_BY_GROUPID_AND_INSNO + ",MODELCODE=" + itemType + ",INSNO=" + insNo;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u5019\u53d1\u9001\u7684\u4fe1\u606f:" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u5019\u8fd4\u56de\u7684\u6d88\u606f:" + sendMsg));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String getAppInfo(String token) throws Exception {
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=GETAPPINFO,TOKEN=" + token;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getAppInfo-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getAppInfo()-->\u67e5\u8be2(over)");
        return resultStr;
    }

    @Override
    public String getLeganPerm(String leganNo) throws Exception {
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=GETLEGANPERM,LEGALNO=" + leganNo;
            this.conn.sendMsg(sendMsg);
            log.debug((Object)("--getAppInfo-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
            resultStr = this.conn.receiveMsg();
            log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug((Object)"--getAppInfo()-->\u67e5\u8be2(over)");
        return resultStr;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }
}

