/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.bean.ClientHeightQuery;
import com.sunyard.client.conn.WSConn;
import com.sunyard.client.impl.MD5Util;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.OptionKey;
import com.sunyard.ws.client.WSConsoleClient;
import com.sunyard.ws.internalapi.SunEcmConsole;
import com.sunyard.ws.utils.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunEcmClientWebserviceApiImpl
implements SunEcmClientApi {
    private Logger log = Logger.getLogger(SunEcmClientWebserviceApiImpl.class);
    private WSConn conn;
    private String splitSym = "<<::>>";

    public SunEcmClientWebserviceApiImpl(String ip, int httpPort, String serverName) {
        this.conn = new WSConn(ip, httpPort, serverName);
    }

    @Override
    public String checkIn(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--checkIn-->\u68c0\u5165");
        String result = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        String sendMsg = "OPTION=" + OptionKey.CHECKIN + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--checkIn-->\u68c0\u5165\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        String msg = this.conn.receiveMsg();
        this.log.debug((Object)("--checkIn-->\u68c0\u5165\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym : "FAIL";
        } else {
            this.log.warn((Object)("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
            throw new SunECMException("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
        }
        this.log.info((Object)("--checkIn-->\u68c0\u5165(over)-->result:" + result));
        return result;
    }

    @Override
    public String checkOut(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--checkOut-->\u68c0\u51fa");
        String result = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        String sendMsg = "OPTION=" + OptionKey.CHECKOUT + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        String msg = this.conn.receiveMsg();
        this.log.debug((Object)("--checkOut-->\u68c0\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
        } else {
            this.log.warn((Object)("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
            throw new SunECMException("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
        }
        this.log.info((Object)("--checkOut-->\u68c0\u51fa(over)-->result:" + result));
        return result;
    }

    @Override
    public String delete(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--delete-->\u5220\u9664");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        String sendMsg = "OPTION=" + OptionKey.DEL + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--delete-->\u5220\u9664\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--delete-->\u5220\u9664\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String getAllModelMsg_Client() throws Exception {
        this.log.info((Object)"--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f");
        String resultStr = "FAIL";
        String sendMsg = "OPTION=" + OptionKey.ALLMODELMSG;
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String getContentServerInfo_Client() throws Exception {
        this.log.info((Object)"--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f");
        String resultStr = "FAIL";
        String sendMsg = "OPTION=" + OptionKey.GET_NODE;
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String getModelTemplate_Client(String[] modeCodes) throws Exception {
        this.log.info((Object)"--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        String resultStr = "FAIL";
        StringBuffer modeNamesStr = new StringBuffer();
        String[] stringArray = modeCodes;
        int n = modeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String modeCode = stringArray[n2];
            modeNamesStr.append(modeCode).append("::");
            ++n2;
        }
        String sendMsg = "OPTION=" + OptionKey.METATEMPLATE + ",MODENAMES=" + modeNamesStr.toString();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String getPermissions_Client(String userName, String passWord) throws Exception {
        this.log.info((Object)"--getPermissions_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650");
        String resultStr = "FAIL";
        String sendMsg = "OPTION=" + OptionKey.PERMISSION + ",USERNAME=" + userName + ",PASSWORD=" + CodeUtil.encode(passWord);
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--getPermissions_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--getPermissions_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String getToken(String ipAddress, String tokenCheckValue, String userName, String operationCode) throws Exception {
        this.log.info((Object)"--getToken-->\u83b7\u53d6\u4ee4\u724c");
        String token = "FAIL";
        WSConsoleClient consoleClient = new WSConsoleClient();
        SunEcmConsole console = consoleClient.getEcmConsoleClient(String.valueOf(ipAddress) + "/webservices/WsInterface", 300000L);
        token = console.getToken(tokenCheckValue, userName, operationCode);
        this.log.info((Object)("--getToken-->\u83b7\u53d6\u4ee4\u724c(over)-->token:" + token));
        return token;
    }

    @Override
    public String heightQuery(ClientHeightQuery heightQuery, String dmsName) throws Exception {
        this.log.info((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(heightQuery);
        this.log.debug((Object)XMLUtil.bean2XML((Object)heightQuery));
        String sendMsg = "OPTION=" + OptionKey.HEIGHT_QUERY + ",XML=" + XMLUtil.bean2XML((Object)heightQuery) + ",DMSNAME=" + dmsName + ",USERNAME=" + heightQuery.getUserName() + ",PASSWORD=" + heightQuery.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String inquireDMByGroup(String userName, String groupName) throws Exception {
        this.log.info((Object)"--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740");
        String resultStr = "FAIL";
        String sendMsg = "OPTION=" + OptionKey.INQUIREDM + ",USERNAME=" + userName + ",DMSNAME=" + groupName;
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String login(String userName, String password) throws Exception {
        password = CodeUtil.encode(password);
        this.log.info((Object)("--login-->\u767b\u5f55 userName:" + userName + "password" + password));
        String resultMsg = "FAIL";
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("OPTION=" + OptionKey.LOGIN + ",USERNAME=").append(userName).append(",PASSWORD=").append(password);
        this.conn.sendMsg(sbuf.toString());
        this.log.debug((Object)("--login-->\u767b\u5f55\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
        String msg = this.conn.receiveMsg();
        this.log.debug((Object)("--login-->\u767b\u5f55\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        if (msg == null || "null".equals(msg)) {
            throw new SunECMException("--SunEcmClientSocketApiImpl-->login-->\u767b\u9646\u5931\u8d25");
        }
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            if (strArray[1].equals("SUCCESS")) {
                resultMsg = "SUCCESS";
            } else {
                this.log.warn((Object)"\u767b\u9646\u5931\u8d25");
            }
        }
        this.log.info((Object)("--login-->\u767b\u5f55(over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String logout(String userName) throws Exception {
        this.log.info((Object)("--logout-->\u767b\u51fa userName:" + userName));
        String resultMsg = "FAIL";
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("OPTION=" + OptionKey.LOGOUT + ",USERNAME=").append(userName);
        this.conn.sendMsg(sbuf.toString());
        this.log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString()));
        String msg = this.conn.receiveMsg();
        this.log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        this.log.debug((Object)msg);
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            if (strArray[1].equals("SUCCESS")) {
                resultMsg = "SUCCESS";
            } else {
                this.log.warn((Object)"\u767b\u51fa\u5f02\u5e38");
                throw new SunECMException("\u767b\u51fa\u5f02\u5e38");
            }
        }
        this.log.info((Object)("--logout-->\u767b\u51fa(over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String operAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c");
        String resultStr = "FAIL";
        this.conn.sendMsg("OPTION=" + OptionKey.A_OR_U_ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName);
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String queryAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2");
        String resultStr = "FAIL";
        this.conn.sendMsg("OPTION=" + OptionKey.ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName);
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String queryBatch(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--queryBatch-->\u67e5\u8be2");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        String sendMsg = "OPTION=" + OptionKey.QUERY + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String update(ClientBatchBean clientBatchBean, String dmsName, boolean isAutoCheck) throws Exception {
        this.log.info((Object)"--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL<<::>>707";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        if (isAutoCheck) {
            String OldPassWord = clientBatchBean.getPassWord();
            String checkOutMsg = this.checkOut(clientBatchBean, dmsName);
            if (!checkOutMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                this.log.warn((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg));
                throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg);
            }
            clientBatchBean.setCheckToken(checkOutMsg.split(this.splitSym)[1]);
            this.log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u6210\u529f..."));
            try {
                clientBatchBean.setPassWord(OldPassWord);
                resultStr = this.update(clientBatchBean, dmsName);
                this.log.debug((Object)("--update-->\u81ea\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
            }
            finally {
                clientBatchBean.setPassWord(OldPassWord);
                String checkInMsg = this.checkIn(clientBatchBean, dmsName);
                if (!checkInMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                    this.log.warn((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg));
                    throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg);
                }
            }
            this.log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u6210\u529f..."));
        } else {
            resultStr = this.update(clientBatchBean, dmsName);
            this.log.debug((Object)("--update-->\u624b\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
        }
        this.log.info((Object)"--update-->\u66f4\u65b0(over)");
        return resultStr;
    }

    private String update(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        this.log.info((Object)"--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        String sendMsg = "OPTION=" + OptionKey.UPDATE + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--update-->\u66f4\u65b0\u524d\u5efa\u7acb\u8fde\u63a5\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        String msg = this.conn.receiveMsg();
        this.log.debug((Object)("--update-->\u66f4\u65b0\u524d\u5efa\u7acb\u8fde\u63a5\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] msgArray = msg.split(this.splitSym);
        if (msgArray[0].equals("0001")) {
            if (clientBatchBean.isBreakPoint()) {
                this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID(), clientBatchBean.getModelCode());
            } else {
                this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID());
            }
            String sendMsg_1 = "OPTION=" + OptionKey.UPDATE + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg_1);
            this.log.debug((Object)("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg_1));
            msg = this.conn.receiveMsg();
            this.log.debug((Object)("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
            String[] strArray = msg.split(this.splitSym);
            if (strArray[0].equals("0001")) {
                if (strArray[1].equals("SUCCESS")) {
                    resultStr = "SUCCESS";
                }
            } else {
                resultStr = String.valueOf(resultStr) + "<<::>>" + msg;
            }
        } else {
            resultStr = msg;
        }
        this.log.info((Object)("--update-->\u66f4\u65b0(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String upload(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--upload-->\u4e0a\u4f20");
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        String reslutMsg = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        StringBuffer uploadMsg = new StringBuffer();
        uploadMsg.append("OPTION=" + OptionKey.UPLOAD + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName).append(",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord());
        this.conn.sendMsg(uploadMsg.toString());
        this.log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u53d1\u9001\u7684\u6d88\u606f\uff1a" + uploadMsg.toString()));
        String returnMsg = this.conn.receiveMsg();
        this.log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + returnMsg));
        String[] params = returnMsg.split(this.splitSym);
        String contentID = "FAIL";
        if (!params[0].equals("0001")) {
            return "FAIL<<::>>" + returnMsg;
        }
        if (params[0].equals("0001")) {
            contentID = params[1];
            reslutMsg = "FAIL<<::>>" + contentID;
            clientBatchBean.getIndex_Object().setContentID(contentID);
            if (clientBatchBean.isBreakPoint()) {
                this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID, clientBatchBean.getModelCode());
            } else {
                this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID);
            }
        }
        String sendMsg = "OPTION=" + OptionKey.UPLOAD + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210\u540e\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        returnMsg = this.conn.receiveMsg();
        this.log.debug((Object)("--upload-->\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210\u540e\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + returnMsg));
        String[] strArray = returnMsg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            if (strArray[1].equals("SUCCESS")) {
                reslutMsg = "SUCCESS<<::>>" + strArray[2];
            }
        } else {
            reslutMsg = String.valueOf(reslutMsg) + "<<::>>" + returnMsg;
        }
        this.log.info((Object)("--upload-->\u4e0a\u4f20(over)-->reslutMsg:" + reslutMsg));
        return reslutMsg;
    }

    private void sendClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID) throws IOException {
        this.log.info((Object)("--sendClientBatchFileBean-->\u4e0a\u4f20\u6587\u4ef6 contentID:" + contentID));
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                this.conn.sendFileData(fileBean.getFileName(), contentID, null);
            }
        }
    }

    private void sendBreakClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID, String modeCode) throws IOException {
        this.log.info((Object)"--sendBreakClientBatchFileBean-->\u65ad\u70b9\u4e0a\u4f20\u6587\u4ef6");
        this.conn.sendMsg("OPTION=" + OptionKey.BREAK_POINT + ",CONTENTID=" + contentID + ",MODECODE=" + modeCode);
        String filesStr = this.conn.receiveMsg().split(this.splitSym)[1];
        this.log.debug((Object)("--sendBreakClientBatchFileBean-->Break Point Msg is: " + filesStr));
        List completeFiles = XMLUtil.xml2list((String)filesStr, ClientFileBean.class);
        ArrayList<ClientFileBean> totalFileBean = new ArrayList<ClientFileBean>();
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                totalFileBean.add(fileBean);
            }
        }
        if (completeFiles.size() != 0) {
            for (ClientFileBean fileBean : totalFileBean) {
                boolean flag = true;
                for (ClientFileBean complteFile : completeFiles) {
                    if (!fileBean.getFileName().equals(complteFile.getFileName())) continue;
                    flag = false;
                }
                if (!flag) continue;
                this.conn.sendFileData(fileBean.getFileName(), contentID, null);
            }
        } else {
            this.sendClientBatchFileBean(ClientBatchFileBeans, contentID);
        }
    }

    private boolean checkFileExist(ClientBatchBean clientBatchBean) {
        this.log.info((Object)"--checkFileExist-->\u6821\u9a8c\u6587\u4ef6\u662f\u5426\u5b58\u5728");
        boolean flag = false;
        if (clientBatchBean.getIndex_Object().getAmount() == null || clientBatchBean.getIndex_Object().getAmount() == "") {
            flag = true;
        }
        int totalFile = 0;
        List<ClientBatchFileBean> batchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean clientBatchFileBean : batchFileBeans) {
            List<ClientFileBean> files = clientBatchFileBean.getFiles();
            for (ClientFileBean clientFileBean : files) {
                if (clientBatchFileBean.getFilePartName().equals(clientBatchBean.getModelCode())) {
                    clientBatchBean.getIndex_Object().setCustomMap(clientFileBean.getOtherAtt());
                }
                if (clientFileBean.getFileName() == null) continue;
                File file = new File(clientFileBean.getFileName());
                if (!file.exists() || file.isDirectory()) {
                    this.log.info((Object)("--checkFileExist-->" + file.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728..."));
                    return false;
                }
                if (!flag) continue;
                ++totalFile;
            }
        }
        if (flag) {
            clientBatchBean.getIndex_Object().setAmount(String.valueOf(totalFile));
        }
        return true;
    }

    @Override
    public String immedMigrate(MigrateBatchBean migrateBatchBean, String dmsName) throws Exception {
        this.log.info((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(migrateBatchBean);
        String sendMsg = "OPTION=" + OptionKey.IMMEDIATEMIGRATE + ",XML=" + XMLUtil.bean2XML((Object)migrateBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + migrateBatchBean.getUserName() + ",PASSWORD=" + migrateBatchBean.getPassWord();
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.debug((Object)("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String queryNodeInfoByGroupIdAndInsNo(String itemType, String insNo) throws Exception {
        this.log.info((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f,modelCode" + itemType + "insNo" + insNo));
        String resultStr = "FAIL";
        String sendMsg = "OPTION=" + OptionKey.QUERY_NODEINFO_BY_GROUPID_AND_INSNO + ",MODELCODE=" + itemType + ",INSNO=" + insNo;
        this.conn.sendMsg(sendMsg);
        this.log.debug((Object)("--getContentServerInfo_Client-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg));
        resultStr = this.conn.receiveMsg();
        this.log.info((Object)("--getContentServerInfo_Client-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        return resultStr;
    }

    @Override
    public String createToken(String username, String password, String organ_no, String legalNo, String appId) throws Exception {
        return null;
    }

    @Override
    public String getAppInfo(String token) throws Exception {
        return null;
    }

    @Override
    public String getLeganPerm(String leganNo) throws Exception {
        return null;
    }
}

