/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.ecm.util.net;

import com.sunyard.common.Configuration;
import com.sunyard.ecm.util.net.DummyTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;

public class JSSEClientSocketFactory
extends SocketFactory {
    private static SSLSocketFactory scf = null;

    private synchronized void setupSsl() throws IOException {
        if (scf != null) {
            return;
        }
        InputStream fis = null;
        try {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                KeyManager[] kms = null;
                TrustManager[] tms = null;
                if (Configuration.get((String)"ssl.client.keystore.location") != null) {
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    KeyStore ks = KeyStore.getInstance("JKS");
                    char[] ksPass = Configuration.get((String)"ssl.client.keystore.password", (String)"changeit").toCharArray();
                    String keyStoreFile = Configuration.get((String)"ssl.client.keystore.location", (String)"keystore.jks");
                    fis = JSSEClientSocketFactory.class.getResourceAsStream(keyStoreFile);
                    ks.load(fis, ksPass);
                    kmf.init(ks, Configuration.get((String)"ssl.client.keystore.keypassword", (String)"changeit").toCharArray());
                    kms = kmf.getKeyManagers();
                    fis.close();
                    fis = null;
                }
                if (Configuration.getBoolean((String)"ssl.client.do.not.authenticate.server", (boolean)false)) {
                    tms = new DummyTrustManager[]{new DummyTrustManager()};
                } else {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                    KeyStore ts = KeyStore.getInstance(Configuration.get((String)"ssl.client.truststore.type", (String)"JKS"));
                    char[] tsPass = Configuration.get((String)"ssl.client.truststore.password", (String)"changeit").toCharArray();
                    fis = JSSEClientSocketFactory.class.getResourceAsStream(Configuration.get((String)"ssl.client.truststore.location", (String)"truststore.jks"));
                    ts.load(fis, tsPass);
                    tmf.init(ts);
                    tms = tmf.getTrustManagers();
                }
                sc.init(kms, tms, new SecureRandom());
                scf = sc.getSocketFactory();
            }
            catch (Exception e) {
                IOException ioe = new IOException("Could not initialize SSLContext");
                ioe.initCause(e);
                throw ioe;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    public Socket createSocket(String ip, int port) throws IOException, UnknownHostException {
        this.setupSsl();
        return scf.createSocket(ip, port);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        this.setupSsl();
        return scf.createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        this.setupSsl();
        return scf.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        this.setupSsl();
        return scf.createSocket(host, port, localHost, localPort);
    }
}

