/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.exception.SunECMException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);

    public static String getRandomFolder() {
        return FileUtil.getRandomFolder(1000);
    }

    public static String getLayerRandomFolder() {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(random.nextInt(1000));
    }

    public static String getRandomFolder(int max) {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(random.nextInt(max)) + File.separator + String.valueOf(random.nextInt(max));
    }

    public static String getLayerRandomFolder(int max) {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(random.nextInt(max));
    }

    public static boolean creatFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String fileNameOption(String fileId, String fileName) {
        int index = fileName.indexOf(".");
        if (index < 0) {
            return fileId;
        }
        return fileId + fileName.substring(index);
    }

    public static boolean existsFile(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static void copyFile(String oldRootPath, String newRootPath, String filePath) throws Exception {
        File oldPathFile = new File(oldRootPath + filePath);
        String oldPath = oldPathFile.getParent();
        File oldFile = new File(oldRootPath);
        String s = oldFile.getName();
        oldPath = oldPath.substring(oldPath.indexOf(s) + s.length());
        String newPath = newRootPath + oldPath;
        while (!FileUtil.creatFolder(newPath)) {
        }
        FileUtil.copyFile(oldRootPath + filePath, newRootPath + filePath);
    }

    public static void copyFile(String oldPath, String newPath) throws Exception {
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        FileUtil.forChannel(oldFile, newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forChannel(File f1, File f2) throws Exception {
        int length = 0x200000;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        FileChannel inC = in.getChannel();
        FileChannel outC = out.getChannel();
        ByteBuffer b = null;
        try {
            while (inC.position() != inC.size()) {
                length = inC.size() - inC.position() < (long)length ? (int)(inC.size() - inC.position()) : 0x200000;
                b = ByteBuffer.allocateDirect(length);
                inC.read(b);
                b.flip();
                outC.write(b);
                outC.force(false);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            inC.close();
            outC.close();
            in.close();
            out.close();
            throw throwable;
        }
        inC.close();
        outC.close();
        in.close();
        out.close();
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static boolean isFileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static Properties readProperties(String path) {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static BufferedInputStream getFile(String filePath) throws SunECMException, FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SunECMException(707, "getFile: \u627e\u4e0d\u5230\u6587\u4ef6");
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readXml(String path) throws IOException, SunECMException {
        StringBuffer buffer;
        long date1;
        block7: {
            File file = new File(path);
            FileInputStream in = null;
            date1 = System.currentTimeMillis();
            buffer = new StringBuffer();
            if (!file.isFile()) {
                throw new SunECMException(707, "FileUtil-->readXml...path is not file name ...");
            }
            try {
                try {
                    byte[] tempbytes = new byte[1024];
                    in = new FileInputStream(file);
                    int len = 0;
                    while ((len = ((InputStream)in).read(tempbytes)) != -1) {
                        buffer.append(new String(tempbytes, 0, len));
                    }
                    Object var9_9 = null;
                    if (in == null) break block7;
                }
                catch (FileNotFoundException e) {
                    throw new SunECMException(707, "FileUtil-->readXml: " + e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        String anStr = buffer.toString();
        long date2 = System.currentTimeMillis();
        log.debug((Object)("\u8bfb\u53d6\u4e00\u4e2a\u6279\u6ce8xml\u6587\u4ef6\u82b1\u8d39\u65f6\u95f4\uff1a " + (date2 - date1) + "\u6beb\u79d2"));
        return anStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeXML(String xml, String filePath, String fileName) throws SunECMException {
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        File file = new File(filePath + fileName + ".xml");
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(xml.getBytes());
            }
            catch (FileNotFoundException e) {
                throw new SunECMException(707, "FileUtil-->writeXML: " + e.toString());
            }
            catch (IOException e) {
                throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.flush();
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
            }
        }
        try {}
        catch (IOException e) {
            throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
        }
        if (fileOutputStream == null) return;
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static String createSaveName(String filePath, String fileNO) {
        if (!FileUtil.isFileExists(filePath + fileNO)) {
            return fileNO;
        }
        int i = 1;
        while (FileUtil.isFileExists(filePath + fileNO + "-" + i)) {
            ++i;
        }
        return fileNO + "-" + i;
    }
}

