/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FlowContorlUtil
extends FilterInputStream {
    private long timestamp;
    private int maxbps;
    private int currentbps;
    private int bytesread;

    public FlowContorlUtil(InputStream in, int maxbps) {
        super(in);
        this.maxbps = maxbps;
        this.currentbps = 0;
        this.bytesread = 0;
        this.timestamp = System.currentTimeMillis();
    }

    public int check() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp >= 1000L) {
            this.timestamp = now;
            this.currentbps = this.bytesread;
            this.bytesread = 0;
            System.out.println("\u5f53\u524d\u901f\u7387\uff1a" + this.maxbps / 1000 + "kbps");
            return this.maxbps;
        }
        System.out.println("\u5f53\u524d\u901f\u7387\uff1a" + (this.maxbps - this.bytesread) / 1000 + "kbps");
        return this.maxbps - this.bytesread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            int avaliable = this.check();
            if (avaliable == 0) {
                this.waitForAvailable();
                avaliable = this.check();
            }
            int value = this.in.read();
            this.update(1);
            return value;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            int avaliable = this.check();
            if (avaliable == 0) {
                this.waitForAvailable();
                avaliable = this.check();
            }
            int n = this.in.read(b, off, Math.min(len, avaliable));
            this.update(n);
            return n;
        }
    }

    public void waitForAvailable() {
        long time = System.currentTimeMillis() - this.timestamp;
        boolean isInterrupted = false;
        while (time < 1000L) {
            try {
                Thread.sleep(1000L - time);
            }
            catch (InterruptedException e) {
                isInterrupted = true;
            }
            time = System.currentTimeMillis() - this.timestamp;
        }
        if (isInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void update(int n) {
        this.bytesread += n;
    }

    public int getCurrentbps() {
        return this.currentbps;
    }
}

