/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unionloan.common.util;

import com.baidu.unionloan.file.service.EncryptDecryptException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class Security {
    public static final String SIGN_ALGORITHM = "SHA256withRSA";
    public static final String CHARSET = "UTF-8";
    public static final String AES_ALGORITHM_CFB_PKCS5 = "AES/CFB/PKCS5Padding";
    public static final String RSA_ALGORITHM_ECB_PKCS1 = "RSA/ECB/PKCS1Padding";
    public static final String AES_ALGORITHM_ECB_PKCS5 = "AES/ECB/PKCS5Padding";
    public static final String RSA = "RSA";
    public static final String AES = "AES";
    private static final int KEY_SIZE = 2048;
    private static final String EQUAL = "=";
    private static final String AND = "&";

    public static KeyFactory getRSAKeyFactory() {
        try {
            return KeyFactory.getInstance(RSA);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptDecryptException(e, "\u6ca1\u6709\u8fd9\u4e2a\u7b97\u6cd5\uff1aRSA", "\u5bc6\u94a5\u521d\u59cb\u5316");
        }
    }

    public static KeyGenerator getAESKeyGenerator() {
        try {
            return KeyGenerator.getInstance(AES);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptDecryptException(e, "\u6ca1\u6709\u8fd9\u4e2a\u7b97\u6cd5\uff1aAES", "\u5bc6\u94a5\u521d\u59cb\u5316");
        }
    }

    public static String generateIv() {
        return Base64.encodeBase64String((byte[])RandomUtils.nextBytes((int)16));
    }

    public static String generateKey() throws Exception {
        KeyGenerator kgen = Security.getAESKeyGenerator();
        kgen.init(128);
        SecretKey skey = kgen.generateKey();
        return Base64.encodeBase64String((byte[])skey.getEncoded());
    }

    public static PublicKey getX509EncodedKeySpec(KeyFactory keyFactory, String key) {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)key));
        PublicKey publicKey = null;
        try {
            publicKey = keyFactory.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptDecryptException(e, "\u516c\u94a5\u975e\u6cd5", "\u5bc6\u94a5\u521d\u59cb\u5316");
        }
        return publicKey;
    }

    public static PrivateKey getPKCS8EncodedKeySpec(KeyFactory keyFactory, String key) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)key));
        PrivateKey privateKey = null;
        try {
            privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptDecryptException(e, "\u79c1\u94a5\u975e\u6cd5", "\u5bc6\u94a5\u521d\u59cb\u5316");
        }
        return privateKey;
    }

    public static String encryptRSA(PublicKey key, String content) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM_ECB_PKCS1);
            cipher.init(1, key);
            return Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes(CHARSET)));
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636e\u516c\u94a5\u548c\u539f\u59cb\u5185\u5bb9\u4ea7\u751f\u52a0\u5bc6\u5185\u5bb9.");
        }
    }

    public static String encryptRSA(String content, String publicKey) throws Exception {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM_ECB_PKCS1);
            cipher.init(1, pubKey);
            return Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes(CHARSET)));
        }
        catch (Exception e) {
            throw new Exception("\u52a0\u5bc6\u8fc7\u7a0b\u5931\u8d25, EncryptContent = " + content, e);
        }
    }

    public static String decryptRSA(String content, String privateKey) throws Exception {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM_ECB_PKCS1);
            cipher.init(2, priKey);
            return new String(cipher.doFinal(Base64.decodeBase64((String)content)), CHARSET);
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u5bc6\u8fc7\u7a0b\u5931\u8d25, EncodeContent = " + content, e);
        }
    }

    public static String decryptRSA(PrivateKey key, String content) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM_ECB_PKCS1);
        cipher.init(2, key);
        return new String(cipher.doFinal(Base64.decodeBase64((String)content)), CHARSET);
    }

    public static String sha256file(String fileName) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u8ba1\u7b97\u6587\u4ef6sha256\u6458\u8981");
        }
        DigestInputStream dis = null;
        try {
            dis = new DigestInputStream(new BufferedInputStream(new FileInputStream(fileName)), md);
        }
        catch (FileNotFoundException e) {
            throw new EncryptDecryptException(e, "sha256file error, " + fileName + " file not found!", "\u8ba1\u7b97\u6587\u4ef6sha256\u6458\u8981");
        }
        try {
            while (dis.read() != -1) {
            }
            dis.close();
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u8ba1\u7b97\u6587\u4ef6sha256\u6458\u8981");
        }
        return Base64.encodeBase64String((byte[])md.digest());
    }

    public static String[] encryptFiles(SecretKeySpec aesKey, IvParameterSpec iv, String decryptDir, String encryptDir, String targetFileSuffix) {
        String[] sortedFiles;
        for (String fileName : sortedFiles = Security.getSortedFiles(decryptDir, targetFileSuffix)) {
            File inFile = new File(decryptDir + File.separator + fileName);
            File outFile = new File(encryptDir + File.separator + fileName);
            Security.encryptFileAES(aesKey, inFile, outFile, iv);
        }
        return sortedFiles;
    }

    public static String[] getSortedFiles(String decryptDir, String targetFileSuffix) {
        File file = new File(decryptDir);
        String[] files = file.list();
        if (files == null) {
            return new String[0];
        }
        return Security.filterAndSortFiles(files, targetFileSuffix);
    }

    public static boolean verify(PublicKey key, String content, String sign) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initVerify(key);
            signature.update(content.getBytes(CHARSET));
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636e\u516c\u94a5\u8fdb\u884c\u9a8c\u7b7e.");
        }
    }

    public static void doTarGZip(String encryptDir, String keyFileName, String[] fileNames, String tarFileName) {
        try {
            TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(encryptDir + File.separator + tarFileName)))));
            for (String name : fileNames) {
                File file = new File(encryptDir + File.separator + name);
                TarArchiveEntry tarEntry = new TarArchiveEntry(name);
                tarEntry.setSize(file.length());
                tar.putArchiveEntry((ArchiveEntry)tarEntry);
                FileInputStream in = new FileInputStream(file);
                Security.copy(in, (OutputStream)tar);
                ((InputStream)in).close();
                tar.closeArchiveEntry();
            }
            File file = new File(encryptDir + File.separator + keyFileName);
            TarArchiveEntry tarEntry = new TarArchiveEntry(keyFileName);
            tarEntry.setSize(file.length());
            tar.putArchiveEntry((ArchiveEntry)tarEntry);
            FileInputStream in = new FileInputStream(file);
            Security.copy(in, (OutputStream)tar);
            ((InputStream)in).close();
            tar.closeArchiveEntry();
            tar.close();
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6253\u5305\u52a0\u5bc6\u6587\u4ef6");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doTarGZip(String encryptDir, String[] fileNames, String tarFileName) {
        TarArchiveOutputStream tar = null;
        try {
            tar = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(encryptDir + File.separator + tarFileName)))));
            for (String name : fileNames) {
                File file = new File(encryptDir + File.separator + name);
                TarArchiveEntry tarEntry = new TarArchiveEntry(name);
                tarEntry.setSize(file.length());
                tar.putArchiveEntry((ArchiveEntry)tarEntry);
                FileInputStream in = new FileInputStream(file);
                Security.copy(in, (OutputStream)tar);
                ((InputStream)in).close();
                tar.closeArchiveEntry();
            }
            if (tar == null) return;
        }
        catch (IOException e) {
            try {
                throw new EncryptDecryptException(e, e.getMessage(), "\u6253\u5305\u52a0\u5bc6\u6587\u4ef6");
            }
            catch (Throwable throwable) {
                if (tar == null) throw throwable;
                IOUtils.closeQuietly(tar);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)tar);
        return;
    }

    public static void doUnTarGZip(String encryptDir, String decryptDir, String tarFiles) {
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(new File(encryptDir + File.separator + tarFiles)))));
            while ((entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
                int count;
                File file = new File(decryptDir + File.separator + entry.getName());
                byte[] data = new byte[1024];
                FileOutputStream fos = new FileOutputStream(file);
                while ((count = tar.read(data, 0, 1024)) != -1) {
                    ((OutputStream)fos).write(data, 0, count);
                }
                ((OutputStream)fos).close();
            }
            tar.close();
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u89e3\u5305\u52a0\u5bc6\u6587\u4ef6");
        }
    }

    public static void copy(InputStream is, OutputStream os) {
        byte[] b = new byte[1024];
        try {
            int i;
            while ((i = is.read(b)) != -1) {
                os.write(b, 0, i);
            }
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6587\u4ef6\u62f7\u8d1d");
        }
    }

    public static void encryptFileAES(SecretKey key, File in, File out, IvParameterSpec iv) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(AES_ALGORITHM_CFB_PKCS5);
            cipher.init(1, (Key)key, iv);
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636eAES\u7684key\u548cIV\u52a0\u5bc6\u6587\u4ef6");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(in);
        }
        catch (FileNotFoundException e) {
            throw new EncryptDecryptException(e, "encryptFileAES error, " + in.getName() + " not found", "\u6839\u636eAES\u7684key\u548cIV\u52a0\u5bc6\u6587\u4ef6");
        }
        CipherOutputStream os = null;
        try {
            os = new CipherOutputStream(new FileOutputStream(out), cipher);
        }
        catch (FileNotFoundException e) {
            throw new EncryptDecryptException(e, "encryptFileAES error, " + out.getName() + " not found", "\u6839\u636eAES\u7684key\u548cIV\u52a0\u5bc6\u6587\u4ef6");
        }
        Security.copy(is, os);
        try {
            is.close();
            os.close();
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636eAES\u7684key\u548cIV\u52a0\u5bc6\u6587\u4ef6");
        }
    }

    public static String encryptAES(String str, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM_CFB_PKCS5);
            cipher.init(1, Security.getKey(keyStr), Security.getIv(iv));
            byte[] encryptData = cipher.doFinal(str.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])encryptData);
        }
        catch (Exception e) {
            throw new RuntimeException("AES encrypt error", e);
        }
    }

    public static String decryptAES(String str, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM_CFB_PKCS5);
            cipher.init(2, Security.getKey(keyStr), Security.getIv(iv));
            byte[] decryptData = cipher.doFinal(Base64.decodeBase64((byte[])str.getBytes(CHARSET)));
            return new String(decryptData, CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("AES decrypt error", e);
        }
    }

    public static boolean responseCheckSign(TreeMap<String, String> paramsMap, String sign, String publicKey) {
        String str = null;
        try {
            str = Security.map2str(paramsMap);
            System.out.println("map2str:" + str);
            return Security.rsa256CheckContent(str, sign, publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(" outside agencies response check sign error,str:{" + str + "},sign:{" + sign + "} ", e);
        }
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(CHARSET));
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25, RSAcontent = " + content + ",sign=" + sign, e);
        }
    }

    private static String map2str(TreeMap<String, String> map) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : map.keySet()) {
            String value = key + EQUAL + map.get(key);
            values.add(value);
        }
        return StringUtils.join(values, (String)AND);
    }

    public static String requestSign(TreeMap<String, String> paramsMap, String privateKey) {
        String str = null;
        try {
            str = Security.map2str(paramsMap);
            return Security.rsa256Sign(str, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("request outside agencies sign error.str:{" + str + "} ", e);
        }
    }

    public static String rsa256Sign(String content, String privateKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initSign(priKey);
            signature.update(content.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25, RSAcontent = " + content, e);
        }
    }

    private static AlgorithmParameterSpec getIv(String iv) {
        return new IvParameterSpec(Base64.decodeBase64((String)iv));
    }

    private static Key getKey(String keyStr) {
        return new SecretKeySpec(Base64.decodeBase64((byte[])keyStr.getBytes()), AES);
    }

    public static String sign(PrivateKey key, String content) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initSign(key);
            signature.update(content.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636e\u79c1\u94a5\u548c\u6570\u636e\u5185\u5bb9\u4ea7\u751f\u7b7e\u540d, base64\u7f16\u7801");
        }
    }

    public static String[] filterAndSortFiles(String[] files, final String targetFileSuffix) {
        List<String> fileList = Arrays.asList(files);
        ArrayList<String> newFileList = new ArrayList<String>();
        for (String fileName : fileList) {
            if (!fileName.endsWith(targetFileSuffix)) continue;
            newFileList.add(fileName);
        }
        Collections.sort(newFileList, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return a.substring(0, a.length() - targetFileSuffix.length()).compareTo(b.substring(0, b.length() - targetFileSuffix.length()));
            }
        });
        return newFileList.toArray(new String[0]);
    }

    public static void copyFile(String encryptDir, String downloadDir, String tarFileName) {
        Security.initFileDir(downloadDir);
        try {
            FileUtils.copyFileToDirectory((File)new File(encryptDir + File.separator + tarFileName), (File)new File(downloadDir));
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6587\u4ef6\u4ece\u4e00\u4e2a\u76ee\u5f55\u62f7\u8d1d\u5230\u53e6\u5916\u4e00\u4e2a\u76ee\u5f55");
        }
    }

    public static void initFileDir(String fileDir) {
        File file = new File(fileDir);
        if (!file.exists() && !file.mkdirs()) {
            throw new EncryptDecryptException(null, fileDir + "\u521b\u5efa\u5931\u8d25", "\u65b0\u5efa\u76ee\u5f55");
        }
    }

    public static void checkDecryptDir(String sourceFileDir) {
        File file = new File(sourceFileDir);
        if (!file.exists()) {
            throw new EncryptDecryptException(null, sourceFileDir + " source file not exists: ", "\u68c0\u67e5\u539f\u6587\u4ef6\u76ee\u5f55");
        }
    }

    public static void decryptfile(SecretKeySpec aesKey2, IvParameterSpec iv, String encryptDir, String decryptDir, String[] fileNames) {
        for (String name : fileNames) {
            File inFile = new File(encryptDir + File.separator + name);
            File outFile = new File(decryptDir + File.separator + name);
            Security.decryptFileAES(aesKey2, inFile, outFile, iv);
        }
    }

    public static void decryptFileAES(SecretKey key, File in, File out, IvParameterSpec iv) {
        CipherInputStream is = null;
        FileOutputStream os = null;
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM_CFB_PKCS5);
            cipher.init(2, (Key)key, iv);
            is = new CipherInputStream(new FileInputStream(in), cipher);
            os = new FileOutputStream(out);
            Security.copy(is, os);
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6839\u636eAES\u7684key\u548cIV, \u89e3\u5bc6\u6587\u4ef6.");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void createKeyFile(String decryptDir, String keyFileName, String key, String iv, String sign) {
        File file = new File(decryptDir + File.separator + keyFileName);
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(key);
            fw.write("\n");
            fw.write(iv);
            fw.write("\n");
            fw.write(sign);
            fw.close();
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u521b\u5efakey\u6587\u4ef6, \u5e76\u5c06key, iv, sign\u6309\u884c\u5199\u5165");
        }
    }

    public static void geneMd5(String encryptDir, String tarFileName) {
        File tarFile = new File(encryptDir + File.separator + tarFileName);
        if (!tarFile.exists()) {
            return;
        }
        try {
            String md5Value = Security.generateMD5(tarFile);
            File md5File = new File(encryptDir + File.separator + tarFileName.split("\\.")[0] + ".md5");
            FileUtils.write((File)md5File, (CharSequence)md5Value, (String)CHARSET);
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, "SecurityUtil generate md5 file error!", "\u68c0\u67e5\u539f\u6587\u4ef6\u76ee\u5f55");
        }
    }

    public static String generateMD5(File f) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static Map<KEY, String> getRSAKeys() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<KEY, String> map = new HashMap<KEY, String>();
        map.put(KEY.PUBLICKEY, Base64.encodeBase64String((byte[])rsaPublicKey.getEncoded()));
        map.put(KEY.PRIVATEKEY, Base64.encodeBase64String((byte[])rsaPrivateKey.getEncoded()));
        return map;
    }

    public static enum KEY {
        PUBLICKEY,
        PRIVATEKEY;

    }
}

