/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unionloan.file.service;

import com.baidu.unionloan.common.util.Security;
import com.baidu.unionloan.file.service.EncryptDecryptException;
import com.baidu.unionloan.file.service.decryption.DecryptParam;
import com.baidu.unionloan.file.service.decryption.DecryptResult;
import com.baidu.unionloan.file.service.encryption.EncryptParam;
import com.baidu.unionloan.file.service.encryption.EncryptResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileEncryptDecrypt {
    public static final int KEY_GEN_INIT = 128;
    public static final int IV_RANDOM_INIT_SIZE = 16;
    public static final String KEY_FILE_DEFAULT_NAME = "key";

    public DecryptResult decryptFile(DecryptParam param) {
        DecryptResult result = new DecryptResult();
        this.preHandleDecrypt(param);
        String[] fileNames = Security.getSortedFiles(param.getEncryptDir(), param.getFileSuffix());
        KeyFactory keyFactory = Security.getRSAKeyFactory();
        PublicKey publicKeyPartner = Security.getX509EncodedKeySpec(keyFactory, param.getPublicKeyPartner());
        PrivateKey privateKeyLocal = Security.getPKCS8EncodedKeySpec(keyFactory, param.getPrivateKeyLocal());
        if (!this.verify(param, fileNames, publicKeyPartner)) {
            result.setFailFlow("\u9a8c\u7b7e");
            result.setFailReason("\u9a8c\u7b7e\u7ed3\u679c\u4e0d\u4e00\u81f4");
            return result;
        }
        SecretKeySpec aesKey2 = null;
        byte[] iv2 = new byte[]{};
        try {
            String decryptKey = Security.decryptRSA(privateKeyLocal, param.getKey());
            String decryptIv = Security.decryptRSA(privateKeyLocal, param.getIv());
            aesKey2 = new SecretKeySpec(Base64.decodeBase64((String)decryptKey), "AES");
            iv2 = Base64.decodeBase64((String)decryptIv);
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "key&iv\u89e3\u5bc6");
        }
        try {
            Security.decryptfile(aesKey2, new IvParameterSpec(iv2), param.getEncryptDir(), param.getDecryptDir(), fileNames);
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u89e3\u5bc6\u6587\u4ef6");
        }
        return result;
    }

    public boolean verify(DecryptParam param, String[] fileNames, PublicKey publicKey) {
        String md = param.getKey() + param.getIv();
        try {
            for (String name : fileNames) {
                md = md + Security.sha256file(param.getEncryptDir() + File.separator + name);
            }
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u6458\u8981");
        }
        boolean flag = false;
        try {
            flag = Security.verify(publicKey, md, param.getSign());
        }
        catch (Exception e) {
            throw new EncryptDecryptException(e, e.getMessage(), "\u9a8c\u7b7e");
        }
        return flag;
    }

    public static void preHanleEncrypt(EncryptParam param) {
        Security.checkDecryptDir(param.getSourceDir());
        Security.initFileDir(param.getTargetDir());
        if (StringUtils.isEmpty((CharSequence)param.getKeyFileName())) {
            param.setKeyFileName(KEY_FILE_DEFAULT_NAME);
        }
    }

    public void preHandleDecrypt(DecryptParam param) {
        if (param.isNeedUnTar()) {
            Security.doUnTarGZip(param.getEncryptDir(), param.getEncryptDir(), param.getTarFileName());
        }
        if (param.isNeedReadKEYFile()) {
            this.readKEYFile(param);
        }
        Security.initFileDir(param.getDecryptDir());
    }

    private DecryptParam readKEYFile(DecryptParam param) {
        try {
            List lines = FileUtils.readLines((File)new File(param.getEncryptDir() + File.separator + param.getKeyFileName()), (Charset)Charset.forName("UTF-8"));
            if (lines.size() > 0) {
                param.setKey((String)lines.get(0));
            }
            if (lines.size() > 1) {
                param.setIv((String)lines.get(1));
            }
            if (lines.size() > 2) {
                param.setSign((String)lines.get(2));
            }
        }
        catch (IOException e) {
            throw new EncryptDecryptException(e, "\u8bfbKEY\u6587\u4ef6\u5f02\u5e38", "KEY\u6587\u4ef6\u5904\u7406");
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncryptDecryptException(e, "\u8bfb\u53d6KEY\u6587\u4ef6\u6307\u5b9a\u884c\u5f02\u5e38\uff0c\u8bfb\u53d6\u884c\u6570\u8d85\u8fc7\u5b9e\u9645\u6700\u5927\u884c\u6570", "KEY\u6587\u4ef6\u5904\u7406");
        }
        return param;
    }

    public static EncryptResult encryptFile(EncryptParam param) {
        EncryptResult result = new EncryptResult();
        FileEncryptDecrypt.preHanleEncrypt(param);
        KeyFactory keyFactory = Security.getRSAKeyFactory();
        PublicKey publicKeyPartner = Security.getX509EncodedKeySpec(keyFactory, param.getPublicKeyPartner());
        PrivateKey privateKeyLocal = Security.getPKCS8EncodedKeySpec(keyFactory, param.getPrivateKeyLocal());
        KeyGenerator keyGen = Security.getAESKeyGenerator();
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        SecretKeySpec aesKey = new SecretKeySpec(secretKey.getEncoded(), "AES");
        String key = Base64.encodeBase64String((byte[])secretKey.getEncoded());
        SecureRandom r = new SecureRandom();
        byte[] iv = new byte[16];
        r.nextBytes(iv);
        String ivParam = Base64.encodeBase64String((byte[])iv);
        String[] fileNames = Security.encryptFiles(aesKey, new IvParameterSpec(iv), param.getSourceDir(), param.getTargetDir(), param.getTargetFileSuffix());
        String encryptKey = Security.encryptRSA(publicKeyPartner, key);
        String encryptIvParam = Security.encryptRSA(publicKeyPartner, ivParam);
        String md = encryptKey + encryptIvParam;
        for (String name : fileNames) {
            String sha256file = Security.sha256file(param.getTargetDir() + File.separator + name);
            md = md + sha256file;
        }
        String sign = Security.sign(privateKeyLocal, md);
        Security.createKeyFile(param.getTargetDir(), param.getKeyFileName(), encryptKey, encryptIvParam, sign);
        if (param.isNeedTar()) {
            Security.doTarGZip(param.getTargetDir(), param.getKeyFileName(), fileNames, param.getTarFileName());
            Security.geneMd5(param.getTargetDir(), param.getTarFileName());
        }
        return result;
    }
}

