/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GenInfraclTask
extends BaseGenTask {
    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String package_prefix;
        String loginUserId = appInfo.getLoginUserId();
        String appCode = appInfo.getAppCode();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        tableParam.setObjectTypes(Arrays.asList(ObjectType.Table.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode()));
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSrvModelId())) {
            SrvModelInfoDTO srvModelInfo = new SrvModelInfoDTO();
            srvModelInfo.setSrvModelId(appInfo.getSrvModelId());
            srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
            if (srvModelInfo != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getTableModelId())) {
                tableParam.setObjectId(srvModelInfo.getTableModelId());
            }
        }
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
        ModelTableInfoDTO userTokenInfo = this.modelTableInfoService.generateUserTokenInfo(appInfo.getAppId());
        SrvModelInout userTokenInout = new SrvModelInout();
        userTokenInout.setTableModelCode(this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
        userTokenInout.setTableModelName(userTokenInfo.getObjectName());
        userTokenInout.setTableModelId(userTokenInfo.getObjectId());
        userTokenInout.setObjectType(userTokenInfo.getObjectType());
        userTokenInout.setListFlag(YesOrNO.NO.getCode());
        ModelTableInfoDTO isrvRspInfo = this.modelTableInfoService.generateIsrvRspInfo(appInfo.getAppId());
        ModelTableInfoDTO pageInfo = this.modelTableInfoService.generatePageInfo(appInfo.getAppId());
        SrvModelInout pageInfoInout = new SrvModelInout();
        pageInfoInout.setTableModelCode(this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
        pageInfoInout.setTableModelName(pageInfo.getObjectName());
        pageInfoInout.setTableModelId(pageInfo.getObjectId());
        pageInfoInout.setObjectType(pageInfo.getObjectType());
        pageInfoInout.setListFlag(YesOrNO.NO.getCode());
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                String bigDTOName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "DTO";
                String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                ModelTableInfoDTO inputDO = this.queryTableWithNameForInout(appInfo.getAppId(), inputDOName);
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                String TablebjectType = String.valueOf(table.getObjectType());
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(appInfo.getAppCode());
                tpib.setProjectCode(appInfo.getAppCode());
                tpib.setProjectName(appInfo.getAppName());
                tpib.setProjectType(TablebjectType);
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Repository %s-%s", appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                ModelTableInfoBo tableBo = this.generateTableBO(table);
                bo.setMainTableModel(tableBo);
                bo.getMapData().put("tableModelCode", table.getObjectCode());
                if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                    this.generateModelTableJoinDetail(tableBo);
                }
                HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                modelParam.setTableModelId(table.getObjectId());
                List modelList = this.srvModelInfoService.queryList((Object)modelParam);
                ArrayList methods = new ArrayList(modelList.size());
                HashMap imports = new HashMap();
                Map dataMap = bo.getMapData();
                dataMap.put("methods", methods);
                for (SrvModelInfoDTO modelInfo : modelList) {
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    method.put("modelInfo", modelInfo);
                    method.put("methodName", modelInfo.getSrvModelCode());
                    SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                    if (SrvModelTypeEnum.QUERY_BY_PK == srvModelTypeEnum || SrvModelTypeEnum.QUERY_SINGLE == srvModelTypeEnum) {
                        method.put("singleOutput", true);
                    } else {
                        method.put("singleOutput", false);
                    }
                    SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                    inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                    inoutParam.setIoType(IOType.Input.getCode());
                    List inputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                    SrvModelInoutDTO inputSingle = null;
                    for (SrvModelInoutDTO inout : inputParams) {
                        if (StringUtils.equals((CharSequence)inputDOName, (CharSequence)inout.getTableModelCode())) {
                            inputSingle = inout;
                        }
                        String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                        inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        OsrvArrangeImport importCls = new OsrvArrangeImport();
                        importCls.setClassName(inout.getTableModelCode());
                        importCls.setProjectCode(tpib.getProjectCode());
                        importCls.setTableModelId(inout.getTableModelId());
                        importCls.setImportType(importType);
                        importMap.put(importCls.getClassName(), importCls);
                    }
                    if (srvModelTypeEnum == SrvModelTypeEnum.QUERY) {
                        method.put("input", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                    } else if (srvModelTypeEnum == SrvModelTypeEnum.QUERY_BATCH || srvModelTypeEnum == SrvModelTypeEnum.QUERY_CUSTOMIZE) {
                        method.put("input", Arrays.asList(inputSingle, userTokenInout));
                    } else {
                        SrvModelInout inputTableDO = new SrvModelInout();
                        inputTableDO.setTableModelId(table.getObjectId());
                        inputTableDO.setTableModelCode(table.getObjectCode());
                        inputTableDO.setTableModelName(table.getObjectName());
                        inputTableDO.setObjectType(table.getObjectType());
                        inputTableDO.setIoType(IOType.Input.getCode());
                        inputTableDO.setListFlag(inputSingle.getListFlag());
                        String importType = this.judgeTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId());
                        inputTableDO.setTableModelCode(this.wrapperTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId()));
                        OsrvArrangeImport importCls = new OsrvArrangeImport();
                        importCls.setClassName(inputTableDO.getTableModelCode());
                        importCls.setProjectCode(tpib.getProjectCode());
                        importCls.setTableModelId(inputTableDO.getTableModelId());
                        importCls.setImportType(importType);
                        importMap.put(importCls.getClassName(), importCls);
                        method.put("input", Arrays.asList(inputTableDO, userTokenInout));
                    }
                    inoutParam.setIoType(IOType.Output.getCode());
                    List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                    SrvModelInoutDTO outputSingle = outputParams.isEmpty() ? null : (SrvModelInoutDTO)outputParams.get(0);
                    for (SrvModelInoutDTO inout : outputParams) {
                        String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                        inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        OsrvArrangeImport importCls = new OsrvArrangeImport();
                        importCls.setClassName(inout.getTableModelCode());
                        importCls.setProjectCode(tpib.getProjectCode());
                        importCls.setTableModelId(inout.getTableModelId());
                        importCls.setImportType(importType);
                        importMap.put(importCls.getClassName(), importCls);
                    }
                    method.put("output", outputParams.isEmpty() ? null : (Object)outputParams.get(0));
                    methods.add(method);
                }
                dataMap.put("importList", importMap.values());
                SrvModelInfoDTO countParam = new SrvModelInfoDTO();
                countParam.setAppId(appInfo.getAppId());
                countParam.setTableModelId(table.getObjectId());
                countParam.setSize(Integer.valueOf(1));
                this.srvModelInfoService.queryListByPage((Object)countParam);
                int serverNum = countParam.getTotal();
                if (ObjectType.Table.getCode().equals(String.valueOf(table.getObjectType()))) {
                    ctdbList.add(bo);
                    continue;
                }
                if (serverNum <= 0) continue;
                ctdbList.add(bo);
            }
        }
        for (CodeTemplateDataBo ctdb : ctdbList) {
            this.wrapAppsParam(appInfo.getAppId(), ctdb);
            package_prefix = this.getPackagePrefix(ctdb);
            Map mapData = ctdb.getMapData();
            TmProjectInfoBo tpib = (TmProjectInfoBo)mapData.get("TmProject");
            this.produceCodeFile("XXXRepository.java", "infracl", "src/main/java/" + package_prefix + "/" + GenInfraclTask.formatClassPath(appCode) + "/acl/repository/", appInfo, ctdb);
        }
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        TmProjectInfoBo pomTp = new TmProjectInfoBo();
        pomTp.setProjectId(appInfo.getAppCode());
        pomTp.setProjectCode(appInfo.getAppCode());
        pomTp.setProjectName(appInfo.getAppName());
        pomBo.setTmProjectInfo(pomTp);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("infracl-pom.xml", "", "infracl-", "infracl", "", appInfo, pomBo);
        return true;
    }
}

