/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasDuSysinfoRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasDuSysinfoDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEnvInfoSummaryDO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoSummaryDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoWorkerSummaryDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoSummaryDTO;
import com.irdstudio.allinapaas.design.console.acl.repository.PaasAppsInfoRepository;
import com.irdstudio.allinapaas.design.console.acl.repository.PaasAppsVariablesRepository;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsVariablesDO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.ssm.web.audit.AuditOperate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.test.util.ReflectionTestUtils;

@Service(value="paasEcsInfoPortalServiceImpl")
public class PaasEcsInfoPortalServiceImpl
extends BaseServiceImpl<PaasEcsInfoDTO, PaasEcsInfoDO, PaasEcsInfoRepository>
implements PaasEcsInfoPortalService {
    @Autowired
    private PaasDuSysinfoRepository paasDuSysinfoRepository;
    @Autowired
    private PaasAppsVariablesRepository paasAppsVariablesRepository;
    @Autowired
    private PaasAppsInfoRepository paasAppsInfoRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Ecs, moduleCode="allinpaas-admin", bizKey="${args[0].ecsId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('com.irdstudio.allinapaas.portal.types.EcsType', dynamicLog.moduleCode(), args[0].ecsType)} #${args[0].ecsId} ${args[0].ecsName}  ${args[0].ecsIp}")
    @AuditOperate(action=AuditOperate.Action.Add, auditType="${args[0].ecsType}", bizKey="${args[0].ecsId}", bizName="${args[0].ecsName}(${args[0].ecsIp})", text="${dynamicLog.action().getName()}\u4e86${#transformCode('com.irdstudio.allinapaas.portal.types.EcsType', '', args[0].ecsType)} #${args[0].ecsId} ${args[0].ecsName}  ${args[0].ecsIp}")
    public int insert(PaasEcsInfoDTO paramDTO) {
        PaasEcsInfoDO ecsParam = new PaasEcsInfoDO();
        ecsParam.setAppId(paramDTO.getAppId());
        ecsParam.setEnvId(paramDTO.getEnvId());
        Integer appEcsCount = ((PaasEcsInfoRepository)this.getRepository()).countAppEcsNum(ecsParam);
        if (appEcsCount == null) {
            appEcsCount = 0;
        }
        appEcsCount = appEcsCount + 1;
        paramDTO.setEcsOrder(appEcsCount);
        int output = super.insert((BaseInfo)paramDTO);
        this.refreshAppVariables(paramDTO);
        return output;
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Ecs, moduleCode="allinpaas-admin", bizKey="${args[0].ecsId}")
    @AuditOperate(action=AuditOperate.Action.Update, auditType="${args[0].ecsType}", bizKey="${args[0].ecsId}", bizName="${args[0].ecsName}(${args[0].ecsIp})")
    public int updateByPk(PaasEcsInfoDTO paramDO) {
        PaasEcsInfoDTO oldData = (PaasEcsInfoDTO)this.queryByPk((BaseInfo)paramDO);
        paramDO.setOldData((Object)oldData);
        List diffList = paramDO.diff();
        boolean needToRefresh = false;
        if (CollectionUtils.isNotEmpty((Collection)diffList)) {
            for (BaseInfo.DiffProp diff : diffList) {
                if (!StringUtils.equalsAny((CharSequence)diff.getPropCode(), (CharSequence[])new CharSequence[]{"ecsIp", "ecsLoginUser", "ecsLoginPwd", "ecsPort", "ecsOutIp"})) continue;
                needToRefresh = true;
                break;
            }
        }
        if (needToRefresh) {
            this.refreshAppVariables(paramDO);
        }
        return super.updateByPk((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Ecs, moduleCode="allinpaas-admin", bizKey="${args[0].ecsId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('com.irdstudio.allinapaas.portal.types.EcsType', dynamicLog.moduleCode(), args[0].ecsType)} #${args[0].ecsId} ${args[0].ecsName} ${args[0].ecsIp}")
    @AuditOperate(action=AuditOperate.Action.Delete, auditType="${args[0].ecsType}", bizKey="${args[0].ecsId}", bizName="${args[0].ecsName}(${args[0].ecsIp})", text="${dynamicLog.action().getName()}\u4e86${#transformCode('com.irdstudio.allinapaas.portal.types.EcsType', '', args[0].ecsType)} #${args[0].ecsId} ${args[0].ecsName} ${args[0].ecsIp}")
    public int deleteByPk(PaasEcsInfoDTO paramDO) {
        if (StringUtils.isBlank((CharSequence)paramDO.getAppId()) || StringUtils.isBlank((CharSequence)paramDO.getEnvId())) {
            paramDO = (PaasEcsInfoDTO)this.queryByPk((BaseInfo)paramDO);
        }
        PaasAppsVariablesDO delVarParam = new PaasAppsVariablesDO();
        delVarParam.setEnvId(paramDO.getEnvId());
        delVarParam.setEcsId(paramDO.getEcsId());
        this.paasAppsVariablesRepository.deleteByCond(delVarParam);
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public int deleteByPaasDuId(PaasEcsInfoDTO inPaasEcsInfoDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inPaasEcsInfoDTO);
        int num = 0;
        PaasEcsInfoDO paasEcsInfo = new PaasEcsInfoDO();
        this.beanCopy(inPaasEcsInfoDTO, paasEcsInfo);
        num = ((PaasEcsInfoRepository)this.getRepository()).deleteByPaasDuId(paasEcsInfo);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inPaasEcsInfoDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<PaasEcsInfoDTO> queryAllWithEnvInfoByPage(PaasEcsInfoDTO paasEcsInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfoDTO, paasEcsInfoDO);
        List paasEcsInfos = ((PaasEcsInfoRepository)this.getRepository()).queryAllWithEnvInfoByPage(paasEcsInfoDO);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + paasEcsInfos.size());
        list = this.beansCopy(paasEcsInfos, PaasEcsInfoDTO.class);
        return list;
    }

    public List<PaasEcsInfoSummaryDTO> queryPaasEcsInfoSummaryList(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasDuSysinfoDO sysinfoParam = new PaasDuSysinfoDO();
        sysinfoParam.setSubsId(paasEcsInfo.getSubsCode());
        List sysList = this.paasDuSysinfoRepository.queryList((Object)sysinfoParam);
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        if (CollectionUtils.isEmpty((Collection)sysList)) {
            paasEcsInfoDO.setModuleCode("apopaas");
            paasEcsInfoDO.setSubsCode(null);
            List doList = ((PaasEcsInfoRepository)this.getRepository()).queryCatalogEcsSummaryList(paasEcsInfoDO);
            return this.beansCopy(doList, PaasEcsInfoSummaryDTO.class);
        }
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryPaasEcsInfoSummaryList(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoSummaryDTO.class);
    }

    public List<PaasEcsInfoSummaryDTO> queryCatalogEcsSummaryList(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryCatalogEcsSummaryList(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoSummaryDTO.class);
    }

    public List<PaasEcsInfoWorkerSummaryDTO> queryTdpWorkerSummary(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryTdpWorkerSummary(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoWorkerSummaryDTO.class);
    }

    public String queryEcsInfoParamValue(String paramValue) {
        return this.parseParamValue(ParamSource.Env.getCode(), paramValue, null);
    }

    public String parseParamValue(String paramSource, String paramValue, String envId) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        String[] values = StringUtils.split((String)paramValue, (String)".");
        if (values == null || values.length < 2) {
            return "";
        }
        String value = "";
        try {
            String paasCatalogId = values[0];
            String fieldCode = values[1].toLowerCase();
            PaasEcsInfoDO ecsParam = new PaasEcsInfoDO();
            if (StringUtils.isNotBlank((CharSequence)envId)) {
                ecsParam.setEnvId(envId);
            }
            ecsParam.setPaasDuId(paasCatalogId);
            List ecsList = ((PaasEcsInfoRepository)this.getRepository()).queryListByPage((Object)ecsParam);
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                String prop;
                PaasEcsInfoDO ecs = (PaasEcsInfoDO)ecsList.get(0);
                Object obj = ReflectionTestUtils.invokeGetterMethod((Object)ecs, (String)(prop = TmModelUtil.fieldToProperty((String)fieldCode)));
                value = obj != null ? obj.toString() : "";
            } else {
                value = "";
                logger.info("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5bf9\u5e94\u670d\u52a1\u5668\u8bb0\u5f55\u4e3a\u7a7a " + paramValue + " envId:" + envId);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5931\u8d25 " + paramValue, (Throwable)e);
        }
        return value;
    }

    public String getTestEcsUrl(String paramValue) {
        String urlString = "";
        String ecsIpString = this.queryEcsInfoParamValue(paramValue + ".ECS_IP");
        if (ecsIpString.isEmpty()) {
            return null;
        }
        String ecsPortString = this.queryEcsInfoParamValue(paramValue + ".ECS_PORT");
        if (ecsPortString.isEmpty()) {
            return null;
        }
        urlString = "http://" + ecsIpString + ":" + ecsPortString;
        return urlString;
    }

    public String getPaasConsoleRequestUrl(PaasEcsInfoDTO paasEcsInfoVO) {
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfoVO, paasEcsInfoDO);
        List ecsInfos = ((PaasEcsInfoRepository)this.getRepository()).queryListByPage((Object)paasEcsInfoDO);
        String urlString = "";
        if (CollectionUtils.isNotEmpty((Collection)ecsInfos)) {
            PaasEcsInfoDO ecs = (PaasEcsInfoDO)ecsInfos.get(0);
            String ecsOutIpString = ecs.getEcsOutIp();
            String ecsIpString = ecs.getEcsIp();
            if (StringUtils.isBlank((CharSequence)ecsOutIpString)) {
                ecsOutIpString = ecsIpString;
            }
            if (StringUtils.isBlank((CharSequence)ecsOutIpString)) {
                return null;
            }
            String ecsPortString = ecs.getEcsPort();
            if (StringUtils.isBlank((CharSequence)ecsPortString)) {
                return null;
            }
            urlString = "http://" + ecsOutIpString + ":" + ecsPortString;
        }
        return urlString;
    }

    public PaasEnvInfoSummaryDTO queryEcsSummaryByEnvId(String envId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + envId);
        try {
            PaasEnvInfoSummaryDO paasEnvInfoSummaryDO = new PaasEnvInfoSummaryDO();
            paasEnvInfoSummaryDO.setEnvId(envId);
            PaasEnvInfoSummaryDO doObj = ((PaasEcsInfoRepository)this.getRepository()).queryEcsSummaryByEnvId(paasEnvInfoSummaryDO);
            if (Objects.nonNull(doObj)) {
                PaasEnvInfoSummaryDTO outputDTO = (PaasEnvInfoSummaryDTO)this.beanCopy(doObj, new PaasEnvInfoSummaryDTO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outputDTO.toString());
                return outputDTO;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<Map<String, Object>> paasEnvDuEcsListByPage(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paramDO = (PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class);
        List list = ((PaasEcsInfoRepository)this.getRepository()).paasEnvDuEcsListByPage(paramDO);
        return list;
    }

    public List<Map<String, Object>> paasEnvSubsEcsListByPage(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paramDO = (PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class);
        List list = ((PaasEcsInfoRepository)this.getRepository()).paasEnvSubsEcsListByPage(paramDO);
        return list;
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Ecs, moduleCode="allinpaas-admin", bizKey="${args[0].ecsId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].appId} ${args[0].appName}(${args[0].appCode})\u7684\u670d\u52a1\u5668")
    public Integer deleteByCond(PaasEcsInfoDTO param) {
        return ((PaasEcsInfoRepository)this.getRepository()).deleteByCond((PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class));
    }

    public Integer countAppEcsNum(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(param, paasEcsInfoDO);
        return ((PaasEcsInfoRepository)this.getRepository()).countAppEcsNum(paasEcsInfoDO);
    }

    private String wrapperCode(String code) {
        return code.replaceAll("-|\\.|\\(|\\)|\\+|\\!", "_");
    }

    private boolean refreshAppVariables(PaasEcsInfoDTO param) {
        String userId = param.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        String subsId = param.getSubsId();
        String appId = param.getAppId();
        String appCode = param.getAppCode();
        String appName = param.getAppName();
        String envId = param.getEnvId();
        String ecsId = param.getEcsId();
        PaasAppsInfoDO appInfo = new PaasAppsInfoDO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDO)this.paasAppsInfoRepository.queryByPk((Object)appInfo);
        String appType = appInfo.getAppType();
        AppType appTypeEnum = AppType.getByCode((String)appType);
        if (appTypeEnum != null) {
            PaasAppsVariablesDO delVarParam = new PaasAppsVariablesDO();
            delVarParam.setEnvId(envId);
            delVarParam.setEcsId(ecsId);
            this.paasAppsVariablesRepository.deleteByCond(delVarParam);
            Integer appEcsCount = param.getEcsOrder();
            if (appEcsCount == null) {
                appEcsCount = 1;
            }
            String prefix = String.format("%s_%s_server%s", this.wrapperCode(appInfo.getSubsCode()), this.wrapperCode(appInfo.getAppCode()), appEcsCount);
            List suffix = appTypeEnum.getVarSuffix();
            String varDesc = appTypeEnum.getVarDesc();
            PaasEcsInfoDO ecsParam = new PaasEcsInfoDO();
            ecsParam.setAppId(appId);
            ecsParam.setEnvId(envId);
            ArrayList<PaasAppsVariablesDO> insertVarList = new ArrayList<PaasAppsVariablesDO>(suffix.size());
            for (String s : suffix) {
                String varCode = String.format("%s_%s", prefix, s);
                PaasAppsVariablesDO appVar = new PaasAppsVariablesDO();
                appVar.setSubsId(subsId);
                appVar.setAppId(appId);
                appVar.setEnvId(envId);
                appVar.setEcsId(ecsId);
                appVar.setVarCode(varCode);
                appVar.setVarRealVal(this.getEcsVal(param, s));
                if (StringUtils.equals((CharSequence)s, (CharSequence)"password")) {
                    appVar.setSensitiveFlag(YesOrNO.YES.getCode());
                    appVar.setVarVal("******");
                } else {
                    appVar.setSensitiveFlag(YesOrNO.NO.getCode());
                    appVar.setVarVal(this.getEcsVal(param, s));
                }
                appVar.setVarDesc(String.format("%s\u7684%s%s\u7684%s", appName, varDesc, appEcsCount, StringUtils.upperCase((String)s)));
                appVar.setEcsOrder(appEcsCount);
                appVar.setCreateUser(userId);
                appVar.setCreateTime(now);
                appVar.setLastModifyTime(now);
                appVar.setLastModifyUser(userId);
                insertVarList.add(appVar);
            }
            if (CollectionUtils.isNotEmpty(insertVarList)) {
                this.paasAppsVariablesRepository.batchInsert(insertVarList);
            }
        }
        return true;
    }

    private String getEcsVal(PaasEcsInfoDTO ecsInfo, String key) {
        switch (key) {
            case "ip": {
                return ecsInfo.getEcsIp();
            }
            case "outIp": {
                return ecsInfo.getEcsOutIp();
            }
            case "port": {
                return ecsInfo.getEcsPort();
            }
            case "user": {
                return ecsInfo.getEcsLoginUser();
            }
            case "password": {
                return ecsInfo.getEcsLoginPwd();
            }
        }
        return "";
    }
}

