/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.admin.console.facade.PaasSubsToolService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsToolDTO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasDeployInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasDeployInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsPropertiesService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsVariablesService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsPropertiesDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsVariablesDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskAppdeployService;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskAppdeployDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.PropSource;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AppDeployTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (AppDeployTask.this.logger != null) {
                AppDeployTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (AppDeployTask.this.logger != null) {
                AppDeployTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };
    private Pattern configReg = Pattern.compile("\\s*([\\S\\.]+?)[\\=|\\:]++\\s*\\S*+\\s*.*");
    private Pattern xmlReg = Pattern.compile("\\s*<.*?>(.+)<\\/.*?>");
    private final String SAAS_SUBS_ID = "S11021";

    public AppDeployTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            String opsPath;
            PaasTaskAppdeployService paasTaskAppdeployService = (PaasTaskAppdeployService)SpringContextUtils.getBean(PaasTaskAppdeployService.class);
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            PaasDeployInfoService paasDeployInfoService = (PaasDeployInfoService)SpringContextUtils.getBean(PaasDeployInfoService.class);
            PaasTaskAppdeployDTO taskDeploy = new PaasTaskAppdeployDTO();
            taskDeploy.setTaskId(this.taskInfo.getTaskId());
            taskDeploy = (PaasTaskAppdeployDTO)paasTaskAppdeployService.queryByPk((Object)taskDeploy);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String envId = this.taskInfo.getEnvId();
            String filePath = taskDeploy.getFilePath();
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            if (appInfo == null) {
                throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            PaasEcsInfoDTO ecsInfo = new PaasEcsInfoDTO();
            ecsInfo.setAppId(appId);
            ecsInfo.setEnvId(envId);
            List ecsList = paasEcsInfoService.queryListByPage((Object)ecsInfo);
            if (CollectionUtils.isEmpty((Collection)ecsList)) {
                throw new RuntimeException("\u5e94\u7528\u672a\u5206\u914d\u670d\u52a1\u5668");
            }
            ecsInfo = (PaasEcsInfoDTO)ecsList.get(0);
            taskDeploy.setEcsId(ecsInfo.getEcsId());
            taskDeploy.setEcsName(ecsInfo.getEcsName());
            PaasEnvParamDTO deployRoot = paasEnvParamService.queryEnvParamByCodeReturnValue("deploy_root", ecsInfo.getEnvId());
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            File taskDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + taskId);
            if (!taskDir.exists()) {
                taskDir.mkdirs();
            }
            String targetAppFile = this.downloadAppFile(subsId, filePath, taskDir);
            String targetConfigFilePath = this.appConfigFileHandler(taskId, appInfo, envId, filePath, taskDir);
            this.logger.info((Object)("\u751f\u6210\u914d\u7f6e\u6587\u4ef6\uff1a" + new File(targetConfigFilePath).getName()));
            this.logger.info((Object)("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp()));
            RemoteSSHClient sshClient = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = sshClient.connect();
            if (!loginFlag) {
                this.logger.error((Object)"\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!sshClient.fileExists("/" + deployRootDir)) {
                sshClient.executeCommand("mkdir /" + deployRootDir, this.sshPrinter);
            }
            if (StringUtils.isBlank((CharSequence)(opsPath = SdEnvUtil.getTemplateScriptPath((PaasAppsInfo)((PaasAppsInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new PaasAppsInfo())))))) {
                this.logger.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                rtn.setSuccessFlag(false);
            }
            String localAgentPath = opsPath + File.separator;
            if (!sshClient.fileExists(deployRootDir)) {
                sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
                sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
            }
            if (!sshClient.fileExists(deployRootDir + "/" + taskId + "/config")) {
                sshClient.executeCommand("mkdir -p " + deployRootDir + "/" + taskId + "/config", this.sshPrinter);
            }
            if (!sshClient.fileExists(deployRootDir + "/startJarApp.sh")) {
                sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
            }
            this.logger.info((Object)String.format("\u5f00\u59cb\u4e0a\u4f20\u5e94\u7528\u5236\u54c1\u5230\u670d\u52a1\u5668%s", ecsInfo.getEcsIp()));
            sshClient.upload(targetAppFile, deployRootDir + "/" + taskId + "/");
            this.logger.info((Object)String.format("\u5f00\u59cb\u4e0a\u4f20\u5e94\u7528\u5236\u54c1\u914d\u7f6e\u6587\u4ef6\u5230\u670d\u52a1\u5668%s", ecsInfo.getEcsIp()));
            sshClient.upload(targetConfigFilePath, deployRootDir + "/" + taskId + "/config/");
            File startFile = new File(targetAppFile);
            String startFileName = startFile.getName().replace(".jar", "");
            String appDeployCommand = String.format("bash %s/startJarApp.sh  '%s/%s/%s' ", deployRootDir, deployRootDir, taskId, startFileName);
            this.logger.info((Object)String.format("\u542f\u52a8\u5e94\u7528 %s", appDeployCommand));
            int status = sshClient.executeCommand(appDeployCommand, this.sshPrinter);
            if (status != 0) {
                this.logger.info((Object)("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startJarApp.sh \u72b6\u6001 " + status));
            }
            this.updateDeployPath(envId, appInfo, ecsInfo, deployRootDir + "/" + taskId + "/" + startFile.getName(), appDeployCommand, null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u5e94\u7528\u624b\u52a8\u90e8\u7f72\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5e94\u7528\u624b\u52a8\u90e8\u7f72\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    public void updateDeployPath(String envId, PaasAppsInfoDTO appInfo, PaasEcsInfoDTO ecs, String deployPath, String appDeployCommand, String loggingFile) throws Exception {
        PaasDeployInfoService paasDeployInfoService = (PaasDeployInfoService)SpringContextUtils.getBean(PaasDeployInfoService.class);
        PaasDeployInfoDTO deployInfo = new PaasDeployInfoDTO();
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setEnvId(envId);
        List deployInfoList = paasDeployInfoService.queryListByPage((Object)deployInfo);
        if (CollectionUtils.isEmpty((Collection)deployInfoList)) {
            deployInfo = new PaasDeployInfoDTO();
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            deployInfo.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", appInfo.getSubsId()));
        } else {
            deployInfo = (PaasDeployInfoDTO)deployInfoList.get(0);
        }
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        deployInfo.setAppLogPath(loggingFile);
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setAppStartCommand(appDeployCommand);
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        int re = paasDeployInfoService.updateByPk((Object)deployInfo);
        if (re == 0) {
            paasDeployInfoService.insert((Object)deployInfo);
        }
        SummaryService summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        HashMap<String, String> summaryParam = new HashMap<String, String>();
        summaryParam.put("appId", appInfo.getAppId());
        summaryParam.put("subsId", appInfo.getSubsId());
        summaryService.updateMeasure("paasDeployAppWithRunSummary", summaryParam);
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private String downloadAppFile(String subsId, String filePath, File taskDir) {
        PaasSubsToolService paasSubsToolService = (PaasSubsToolService)SpringContextUtils.getBean(PaasSubsToolService.class);
        String rootPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.ftp.path");
        if (StringUtils.isBlank((CharSequence)rootPath)) {
            rootPath = "/tdpaas/ftp/";
        }
        PaasSubsToolDTO ftpToolInfo = new PaasSubsToolDTO();
        ftpToolInfo.setCbaCode("paas-tool-ftp");
        ftpToolInfo.setEnvId("peds");
        List ftpInfos = paasSubsToolService.queryListByPage((Object)ftpToolInfo);
        if (CollectionUtils.isEmpty((Collection)ftpInfos)) {
            throw new RuntimeException("\u7ec4\u4ef6\u5bf9\u5e94\u5de5\u5177\u672a\u914d\u7f6e");
        }
        ftpToolInfo = (PaasSubsToolDTO)ftpInfos.get(0);
        RemoteSSHClient sshClient = new RemoteSSHClient(ftpToolInfo.getToolUrl(), ftpToolInfo.getToolUserId(), ftpToolInfo.getToolPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error((Object)"\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
        }
        try {
            File file = new File(filePath);
            String fileName = file.getName();
            File targetFile = new File(taskDir, fileName);
            this.logger.info((Object)("\u83b7\u53d6\u5e94\u7528\u5236\u54c1\uff1a" + filePath));
            sshClient.download(rootPath + "/" + subsId + filePath, targetFile.getAbsolutePath());
            return targetFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("%s\u5e94\u7528\u5236\u54c1\u4e0b\u8f7d\u5931\u8d25", subsId + filePath), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String appConfigFileHandler(String taskId, PaasAppsInfoDTO appInfo, String envId, String filePath, File taskDir) {
        ArrayList<String> targetConfigList = new ArrayList<String>();
        File configFile = new File(filePath);
        String configFileName = configFile.getName();
        PaasAppsVariablesService paasAppsVariablesService = (PaasAppsVariablesService)SpringContextUtils.getBean(PaasAppsVariablesService.class);
        PaasAppsPropertiesService paasAppsPropertiesService = (PaasAppsPropertiesService)SpringContextUtils.getBean(PaasAppsPropertiesService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsParamPortalService paasAppsParamPortalService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
        PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
        HashMap<String, Object> root = new HashMap<String, Object>();
        PaasEnvParamDTO loggingFile = paasEnvParamService.queryEnvParamByCodeReturnValue("logging_path", envId);
        if (loggingFile == null) {
            loggingFile = new PaasEnvParamDTO();
            loggingFile.setParamCode("logging_path");
            loggingFile.setEnvId(envId);
            loggingFile.setParamValue("/var/tmp/logs/");
        }
        root.put("logging_path", loggingFile.getParamValue());
        PaasAppsVariablesDTO variablesParam = new PaasAppsVariablesDTO();
        variablesParam.setSubsId(appInfo.getSubsId());
        variablesParam.setEnvId(envId);
        List varList = paasAppsVariablesService.queryList((Object)variablesParam);
        if (CollectionUtils.isNotEmpty((Collection)varList)) {
            varList.forEach(var -> root.put(var.getVarCode(), var.getVarRealVal()));
        }
        Map appsParam = paasAppsParamPortalService.queryAppParamMap(appInfo.getAppId(), envId);
        String database_name = TdpAgentCommonUtil.getAppDatabaseName((PaasAppsInfo)((PaasAppsInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new PaasAppsInfo())), (Map)appsParam);
        appsParam.put("database_name", database_name);
        root.putAll(appsParam);
        PaasEcsInfoDTO envEcsParam = new PaasEcsInfoDTO();
        envEcsParam.setEnvId(envId);
        envEcsParam.setAppId(appInfo.getAppId());
        List ecsList = paasEcsInfoService.queryList((Object)envEcsParam);
        if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
            for (PaasEcsInfoDTO ecs : ecsList) {
                Map ecsMap = BeanUtility.bean2Map((Object)ecs);
                HashMap ecsParamMap = new HashMap();
                for (Map.Entry entry : ecsMap.entrySet()) {
                    String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                    ecsParamMap.put(key, entry.getValue());
                }
                root.put(ecs.getPaasDuId(), ecsParamMap);
            }
            root.put("client_host_url", String.format("http://%s:%s", ((PaasEcsInfoDTO)ecsList.get(0)).getEcsOutIp(), ((PaasEcsInfoDTO)ecsList.get(0)).getEcsPort()));
        }
        PaasAppsVariablesDTO saasVarParam = new PaasAppsVariablesDTO();
        saasVarParam.setEnvId(envId);
        saasVarParam.setSubsId("S11021");
        List saasVarList = paasAppsVariablesService.queryList((Object)saasVarParam);
        HashMap<String, Object> saasRoot = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)saasVarList)) {
            saasVarList.forEach(var -> saasRoot.put(var.getVarCode(), var.getVarRealVal()));
        }
        PaasAppsPropertiesDTO appPropParam = new PaasAppsPropertiesDTO();
        appPropParam.setAppId(appInfo.getAppId());
        ArrayList propConfigList = paasAppsPropertiesService.queryList((Object)appPropParam);
        if (CollectionUtils.isEmpty((Collection)propConfigList)) {
            propConfigList = new ArrayList();
        }
        ArrayList propList = new ArrayList();
        propList.addAll(propConfigList);
        HashMap configFileNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(propList)) {
            HashMap configFileMap = new HashMap();
            for (PaasAppsPropertiesDTO paasAppsPropertiesDTO : propList) {
                String line;
                Object split;
                String value;
                String fileName = paasAppsPropertiesDTO.getFileName();
                HashMap propMap = (HashMap)configFileNameMap.get(fileName);
                if (propMap == null) {
                    propMap = new HashMap();
                    configFileNameMap.put(fileName, propMap);
                }
                if (propMap.get(paasAppsPropertiesDTO.getPropName()) != null) continue;
                if (StringUtils.equals((CharSequence)PropSource.Saas.getCode(), (CharSequence)paasAppsPropertiesDTO.getPropSource())) {
                    value = this.generateValue(paasAppsPropertiesDTO.getPropValue(), saasRoot);
                    paasAppsPropertiesDTO.setPropValue(value);
                } else {
                    value = this.generateValue(paasAppsPropertiesDTO.getPropValue(), root);
                    paasAppsPropertiesDTO.setPropValue(value);
                }
                ArrayList<String> configList = (ArrayList<String>)configFileMap.get(paasAppsPropertiesDTO.getFileName());
                if (configList == null) {
                    configList = new ArrayList<String>();
                    configFileMap.put(paasAppsPropertiesDTO.getFileName(), configList);
                }
                if (paasAppsPropertiesDTO.getFileName().endsWith(".properties")) {
                    split = "=";
                    line = String.format("%s%s%s", paasAppsPropertiesDTO.getPropName(), split, paasAppsPropertiesDTO.getPropValue());
                    configList.add(line);
                    continue;
                }
                if (!paasAppsPropertiesDTO.getFileName().endsWith(".yml")) continue;
                split = "=";
                line = String.format("%s%s%s", paasAppsPropertiesDTO.getPropName(), split, paasAppsPropertiesDTO.getPropValue());
                configList.add(line);
            }
            if (!configFileMap.isEmpty()) {
                for (Map.Entry entry : configFileMap.entrySet()) {
                    String file = (String)entry.getKey();
                    List<String> lines = (List<String>)entry.getValue();
                    if (file.endsWith(".yml")) {
                        HashMap<String, Object> ymlRoot = new HashMap<String, Object>();
                        for (String line : lines) {
                            String[] line_arr = StringUtils.split((String)line, (String)"=");
                            String key = line_arr[0];
                            String val = line_arr[1];
                            this.setYmlMapVal(ymlRoot, key, val);
                        }
                        Yaml yaml = new Yaml();
                        String yml = yaml.dumpAs(ymlRoot, null, DumperOptions.FlowStyle.BLOCK);
                        lines = Arrays.asList(StringUtils.split((String)yml, (String)"\n"));
                    }
                    File targetFile = new File(taskDir, file);
                    FileOutputStream configOutStream = null;
                    try {
                        FileUtils.deleteQuietly((File)targetFile);
                        configOutStream = new FileOutputStream(targetFile);
                        IOUtils.writeLines((Collection)lines, (String)System.lineSeparator(), (OutputStream)configOutStream, (String)"UTF-8");
                        targetConfigList.add(targetFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        try {
                            this.logger.error((Object)String.format("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6%s\u5199\u5165\u5931\u8d25", file), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(configOutStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)configOutStream);
                        continue;
                    }
                    IOUtils.closeQuietly((OutputStream)configOutStream);
                }
                if (!targetConfigList.isEmpty()) {
                    return (String)targetConfigList.get(0);
                }
            }
        }
        return "";
    }

    public String generateValue(String valueTemplate, Map<String, Object> param) {
        if (StringUtils.isBlank((CharSequence)valueTemplate)) {
            return "";
        }
        try {
            String alDesc = ExpressionUtil.parse((String)valueTemplate, param);
            return alDesc;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u89e3\u6790\u5f02\u5e38:" + e.getMessage()));
            return "";
        }
    }

    private Map<String, String> convertYamlToProperties(Map<String, Object> root) {
        HashMap<String, String> prop = new HashMap<String, String>();
        if (root != null && root.size() > 0) {
            for (Map.Entry<String, Object> entry : root.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", entry.getKey(), i);
                        Map value = (Map)list.get(i);
                        this.recursionConvert(prop, key, value);
                    }
                    continue;
                }
                prop.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return prop;
    }

    private void recursionConvert(Map<String, String> prop, String parentKey, Map<String, Object> parentValue) {
        if (parentValue != null && parentValue.size() > 0) {
            for (Map.Entry<String, Object> entry : parentValue.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(parentKey + "." + entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, parentKey + "." + entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", parentKey + "." + entry.getKey(), i);
                        Object value = list.get(i);
                        if (value == null || !(value instanceof Map)) continue;
                        this.recursionConvert(prop, key, (Map)value);
                    }
                    continue;
                }
                prop.put(parentKey + "." + entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private void setYmlMapVal(Map<String, Object> root, String keyPath, String value) {
        try {
            String[] paths = StringUtils.split((String)keyPath, (String)".");
            if (paths != null && paths.length > 0) {
                HashMap<String, String> current = root;
                for (int i = 0; i < paths.length - 1; ++i) {
                    HashMap<String, String> _current = MapUtils.getMap(current, (Object)paths[i]);
                    if (_current == null) {
                        _current = new HashMap<String, String>();
                        current.put(paths[i], (String)((Object)_current));
                    }
                    current = _current;
                }
                if (current != null) {
                    current.put(paths[paths.length - 1], value);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("\u66f4\u65b0 yml \u914d\u7f6e\u6587\u4ef6 key %s \u5f02\u5e38 %s", keyPath, e.getMessage()), (Throwable)e);
        }
    }
}

