/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskMetascanService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskMetascanDTO;
import com.irdstudio.allinapaas.portal.console.types.DataStdFlag;
import com.irdstudio.allinapaas.portal.console.types.MetaPackageOption;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ConflictType;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZExcelMetaTask
extends AbstractMetaTask {
    private static final Logger logger = LoggerFactory.getLogger(GZExcelMetaTask.class);
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+)[,\uff0c]?(\\d*)(\\s+BYTE)*\\s*\\)");
    private PaasTaskInfoDTO taskInfo;

    public GZExcelMetaTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            PaasTaskMetascanService paasTaskMetascanService = (PaasTaskMetascanService)SpringContextUtils.getBean(PaasTaskMetascanService.class);
            PaasTaskMetascanDTO metaScan = new PaasTaskMetascanDTO();
            metaScan.setTaskId(this.taskInfo.getTaskId());
            metaScan = (PaasTaskMetascanDTO)paasTaskMetascanService.queryByPk((Object)metaScan);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskOption = metaScan.getTaskOption();
            String taskPackageId = metaScan.getPackageId();
            String packageOption = StringUtils.isBlank((CharSequence)metaScan.getPackageOption()) ? MetaPackageOption.SourcePackage.getCode() : metaScan.getPackageOption();
            String conflict = StringUtils.equals((CharSequence)taskOption, (CharSequence)"1") ? "recover" : "skip";
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            ModelTableIndexService modelTableIndexService = (ModelTableIndexService)SpringContextUtils.getBean(ModelTableIndexService.class);
            ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
            ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
            DictOptionInfoService dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
            SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            if (appInfo == null) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u672a\u9009\u62e9\u5e94\u7528");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            String projectId = appInfo.getAppId();
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            subsInfo.setSubsId(subsId);
            subsInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)subsInfo);
            String dslId = subsInfo.getDslId();
            String metaTaskRootPath = SdEnvUtil.METATASK_PATH;
            File file = new File(metaTaskRootPath, this.taskInfo.getTaskId() + ".xlsx");
            if (!file.exists()) {
                file = new File(metaTaskRootPath, this.taskInfo.getTaskId() + ".xls");
            }
            if (!file.exists()) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u91c7\u96c6\u6587\u4ef6\u4e0d\u5b58\u5728");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            String packageId = "";
            if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                packageId = taskPackageId;
            } else {
                ModelFolderInfoDTO packageParam = new ModelFolderInfoDTO();
                packageParam.setAppId(projectId);
                packageParam.setFolderCode("TABLE");
                List tablePackageList = modelFolderInfoService.queryListByPage((Object)packageParam);
                packageId = projectId;
                if (CollectionUtils.isNotEmpty((Collection)tablePackageList)) {
                    packageId = ((ModelFolderInfoDTO)tablePackageList.get(0)).getFolderId();
                }
            }
            TableInfoListener listener = new TableInfoListener();
            ((ExcelReaderBuilder)EasyExcel.read((File)file, (ReadListener)listener).headRowNumber(Integer.valueOf(4))).doReadAll();
            List<ExcelTableContext> excelDataList = listener.getTableInfoList();
            List<ProjectIndex> projectIndexList = listener.getIndexPackageInfoList();
            Map<String, ProjectIndex> objectCodePackageMap = this.handlePackageInfo(projectId, packageId, userId, projectIndexList);
            for (ExcelTableContext ctx : excelDataList) {
                ModelTableInfoDTO tableInfo = ctx.tableInfo;
                List<ModelTableIndexDTO> indexs = ctx.indexs;
                AtomicInteger indexLen = ctx.indexLen;
                List<ModelTableFieldDTO> fields = ctx.fields;
                ModelTableIndexDTO primaryKey = ctx.primaryKey;
                String createTime = CurrentDateUtil.getTodayDateEx2();
                String createUser = userId;
                ProjectIndex packageInfo = objectCodePackageMap.get(tableInfo.getObjectCode());
                ModelTableInfoDTO checkParam = new ModelTableInfoDTO();
                checkParam.setAppId(projectId);
                checkParam.setObjectCode(tableInfo.getObjectCode());
                List exists = modelTableInfoService.queryListByPage((Object)checkParam);
                if (CollectionUtils.isNotEmpty((Collection)exists)) {
                    if (conflict.equals(ConflictType.skip.getCode())) {
                        logger.info(String.format("%s\u6a21\u578b\u5e93\u4e2d\u5b58\u5728%s, \u4e14\u5904\u7406\u65b9\u5f0f\u4e3a\u8df3\u8fc7", projectId, tableInfo.getObjectCode()));
                        continue;
                    }
                    ModelTableInfoDTO model = (ModelTableInfoDTO)exists.get(0);
                    modelTableFieldService.deleteByObjectId(model.getObjectId());
                    modelTableIndexService.deleteByObjectId(model.getObjectId());
                    model = (ModelTableInfoDTO)exists.get(0);
                    model.setObjectName(tableInfo.getObjectName());
                    model.setObjectDesc(tableInfo.getObjectDesc());
                    if (packageInfo != null) {
                        model.setFolderId(packageInfo.getFolderId());
                        model.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)packageInfo.getSeq(), (int)1)));
                        model.setObjectDesc(packageInfo.getObjectDesc());
                    }
                    if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                        model.setFolderId(taskPackageId);
                    }
                    tableInfo = model;
                    tableInfo.setLastModifyUser(createUser);
                    tableInfo.setLastModifyTime(createTime);
                    modelTableInfoService.updateByPk((Object)tableInfo);
                } else {
                    tableInfo.setObjectId(UUIDUtil.getUUID());
                    tableInfo.setAppId(projectId);
                    tableInfo.setSubsId(subsId);
                    tableInfo.setFolderId(packageId);
                    tableInfo.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Table.getCode())));
                    tableInfo.setCreateUser(createUser);
                    tableInfo.setCreateTime(createTime);
                    tableInfo.setLastModifyUser(createUser);
                    tableInfo.setLastModifyTime(createTime);
                    if (packageInfo != null) {
                        tableInfo.setFolderId(packageInfo.getFolderId());
                        tableInfo.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)packageInfo.getSeq(), (int)1)));
                    }
                    if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                        tableInfo.setFolderId(taskPackageId);
                    }
                    modelTableInfoService.insert((Object)tableInfo);
                }
                for (ModelTableIndexDTO index : indexs) {
                    index.setObjectId(tableInfo.getObjectId());
                    index.setCreateUser(createUser);
                    index.setCreateTime(createTime);
                    index.setLastModifyUser(createUser);
                    index.setLastModifyTime(createTime);
                    index.setIndexName(StringUtils.upperCase((String)index.getIndexName()));
                    modelTableIndexService.insert((Object)index);
                }
                for (ModelTableFieldDTO field : fields) {
                    field.setObjectId(tableInfo.getObjectId());
                    field.setFieldId(UUIDUtil.getUUID());
                    field.setCreateTime(createTime);
                    field.setCreateUser(createUser);
                    field.setLastModifyUser(createUser);
                    field.setLastModifyTime(createTime);
                    field.setDataStdFlag(DataStdFlag.Auto.getCode());
                    if (!StringUtils.isNotBlank((CharSequence)field.getDictId())) continue;
                    DictOptionInfoDTO dictParam = new DictOptionInfoDTO();
                    dictParam.setDictId(field.getDictId());
                    dictParam.setSubsId(dslId);
                    List optionList = dictOptionInfoService.queryListByPage((Object)dictParam);
                    if (CollectionUtils.isEmpty((Collection)optionList)) {
                        dictParam.setDictCode(field.getDictId());
                        optionList = dictOptionInfoService.queryListByPage((Object)dictParam);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)optionList)) continue;
                    DictOptionInfoDTO optionInfo = (DictOptionInfoDTO)optionList.get(0);
                    field.setDictId(optionInfo.getDictId());
                    field.setDictDslId(optionInfo.getSubsId());
                    field.setFieldOption(optionInfo.getDictCode());
                }
                modelTableFieldService.batchInsert(fields);
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u6a21\u578b\u91c7\u96c6 \u4eceexcel\u4e2d\u8bfb\u53d6\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6a21\u578b\u91c7\u96c6 \u4eceexcel\u4e2d\u8bfb\u53d6\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private Map<String, ProjectIndex> handlePackageInfo(String projectId, String packageId, String userId, List<ProjectIndex> indexPackageInfoList) {
        if (CollectionUtils.isEmpty(indexPackageInfoList)) {
            return Collections.EMPTY_MAP;
        }
        ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
        HashMap<String, ProjectIndex> tablePackageMap = new HashMap<String, ProjectIndex>();
        HashMap<String, String> packageNameMap = new HashMap<String, String>();
        HashMap<String, ModelFolderInfoDTO> insertPackageMap = new HashMap<String, ModelFolderInfoDTO>();
        int i = 1;
        String now = CurrentDateUtil.getTodayDateEx2();
        for (ProjectIndex p : indexPackageInfoList) {
            ModelFolderInfoDTO objPackage;
            if (StringUtils.equals((CharSequence)p.getSeq(), (CharSequence)"\u5e8f\u53f7")) continue;
            if (StringUtils.isBlank((CharSequence)p.getFolderName())) {
                p.setFolderId(packageId);
            } else if (packageNameMap.get(p.getFolderName()) == null) {
                packageNameMap.put(p.getFolderName(), p.getFolderName());
                objPackage = new ModelFolderInfoDTO();
                objPackage.setFolderName(p.getFolderName());
                objPackage.setAppId(projectId);
                objPackage.setFolderAbvId(packageId);
                List checkList = modelFolderInfoService.queryListByPage((Object)objPackage);
                if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                    objPackage = (ModelFolderInfoDTO)checkList.get(0);
                } else {
                    objPackage.setFolderId(UUIDUtil.getUUID());
                    objPackage.setFolderCode("p" + i);
                    objPackage.setFolderName(p.getFolderName());
                    objPackage.setFolderDesc(p.getFolderName());
                    objPackage.setFolderType(Integer.valueOf(2));
                    objPackage.setOrderValue(Integer.valueOf(i));
                    objPackage.setCreateTime(now);
                    objPackage.setCreateUser(userId);
                    modelFolderInfoService.insert((Object)objPackage);
                    ++i;
                }
                insertPackageMap.put(p.getFolderName(), objPackage);
                p.setFolderId(objPackage.getFolderId());
            } else {
                objPackage = (ModelFolderInfoDTO)insertPackageMap.get(p.getFolderName());
                if (objPackage != null) {
                    p.setFolderId(objPackage.getFolderId());
                }
            }
            tablePackageMap.put(p.objectCode, p);
        }
        return tablePackageMap;
    }

    public static class ProjectIndex {
        private String seq;
        private String folderId;
        private String folderName;
        private String objectCode;
        private String objectName;
        private String objectDesc;

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getObjectCode() {
            return this.objectCode;
        }

        public void setObjectCode(String objectCode) {
            this.objectCode = objectCode;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public void setFolderName(String folderName) {
            this.folderName = folderName;
        }

        public String getFolderId() {
            return this.folderId;
        }

        public void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public String getObjectDesc() {
            return this.objectDesc;
        }

        public void setObjectDesc(String objectDesc) {
            this.objectDesc = objectDesc;
        }
    }

    public static class ExcelTableContext {
        ModelTableInfoDTO tableInfo = new ModelTableInfoDTO();
        List<ModelTableIndexDTO> indexs = new ArrayList<ModelTableIndexDTO>();
        AtomicInteger indexLen = new AtomicInteger(0);
        List<ModelTableFieldDTO> fields = new ArrayList<ModelTableFieldDTO>();
        ModelTableIndexDTO primaryKey;
    }

    public static class TableInfoListener
    extends AnalysisEventListener<Map<Integer, String>> {
        private List<ProjectIndex> indexPackageInfoList = new ArrayList<ProjectIndex>();
        private List<ExcelTableContext> tableInfoList = new ArrayList<ExcelTableContext>();
        private ExcelTableContext tableCtx = new ExcelTableContext();

        public List<ExcelTableContext> getTableInfoList() {
            return this.tableInfoList;
        }

        public List<ProjectIndex> getIndexPackageInfoList() {
            return this.indexPackageInfoList;
        }

        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                if (headMap.get(0) != null && StringUtils.equals((CharSequence)headMap.get(0), (CharSequence)"\u5e8f\u53f7")) {
                    return;
                }
                if (headMap.size() < 4) {
                    return;
                }
                ProjectIndex index = new ProjectIndex();
                if (headMap.get(0) != null) {
                    index.setSeq(headMap.get(0));
                }
                if (headMap.get(1) != null) {
                    index.setFolderName(headMap.get(1));
                }
                if (headMap.get(2) != null) {
                    index.setObjectCode(StringUtils.lowerCase((String)headMap.get(2)));
                }
                if (headMap.get(3) != null) {
                    index.setObjectName(headMap.get(3));
                }
                if (headMap.get(4) != null) {
                    index.setObjectDesc(headMap.get(4));
                }
                this.indexPackageInfoList.add(index);
                return;
            }
            logger.debug(headMap.toString());
            if (headMap.get(0).equals("\u7269\u7406\u8868\u540d\u79f0")) {
                this.tableCtx.tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(2)));
                this.tableCtx.tableInfo.setObjectName(headMap.get(4));
                this.tableCtx.tableInfo.setObjectDesc(headMap.get(4));
            } else if (headMap.get(0).equals("\u7269\u7406\u8868\u540d")) {
                this.tableCtx.tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(1)));
                this.tableCtx.tableInfo.setObjectName(headMap.get(3));
                this.tableCtx.tableInfo.setObjectDesc(headMap.get(3));
            } else if (headMap.get(0).equals("\u6240\u5c5e\u4e3b\u9898\u57df") && headMap.get(2) != null) {
                this.tableCtx.tableInfo.setSubjectId(headMap.get(2));
            } else if (headMap.get(0).equals("\u4e3b\u952e") && headMap.get(1) != null) {
                ModelTableIndexDTO primary = new ModelTableIndexDTO();
                primary.setIndexFields(StringUtils.lowerCase((String)headMap.get(1)));
                primary.setIndexName("PK_" + this.tableCtx.tableInfo.getObjectCode());
                primary.setIndexTypePrimary("Y");
                primary.setIndexTypeUnique("N");
                this.tableCtx.indexs.add(primary);
                this.tableCtx.primaryKey = primary;
            }
        }

        public void invoke(Map<Integer, String> data, AnalysisContext context) {
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                if (data.size() < 4) {
                    return;
                }
                ProjectIndex index = new ProjectIndex();
                if (data.get(0) != null) {
                    index.setSeq(data.get(0));
                }
                if (data.get(1) != null) {
                    index.setFolderName(data.get(1));
                }
                if (data.get(2) != null) {
                    index.setObjectCode(StringUtils.lowerCase((String)data.get(2)));
                }
                if (data.get(3) != null) {
                    index.setObjectName(data.get(3));
                }
                this.indexPackageInfoList.add(index);
                return;
            }
            logger.debug(data.toString());
            int len = data.size();
            if (len == 3) {
                String indexType = data.get(0);
                String indexName = data.get(1);
                String indexFields = data.get(2);
                if (StringUtils.isNotEmpty((CharSequence)data.get(0)) && (data.get(0).equals("\u5e8f\u53f7") || data.get(0).equals("\u5b57\u6bb5\u63cf\u8ff0") || data.get(0).equals("\u5b57\u6bb5\u540d\u79f0") || data.get(0).equals("\u5b57\u6bb5\u540d"))) {
                    int fieldIndex = context.readRowHolder().getRowIndex();
                    this.tableCtx.indexLen.set(fieldIndex + 1);
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)indexName)) {
                    return;
                }
                ModelTableIndexDTO index = new ModelTableIndexDTO();
                index.setIndexName(indexName);
                index.setIndexFields(StringUtils.lowerCase((String)indexFields));
                if (StringUtils.isNotBlank((CharSequence)indexType) && indexType.equals("\u4e3b\u952e\u7d22\u5f15")) {
                    index.setIndexTypePrimary("Y");
                    index.setIndexTypeUnique("N");
                } else if (StringUtils.isNotBlank((CharSequence)indexType) && indexType.equals("\u552f\u4e00\u7d22\u5f15")) {
                    index.setIndexTypeUnique("Y");
                    index.setIndexTypePrimary("N");
                } else {
                    index.setIndexTypePrimary("N");
                    index.setIndexTypeUnique("N");
                }
                if (index.getIndexTypePrimary().equalsIgnoreCase("Y")) {
                    this.tableCtx.primaryKey = index;
                }
                this.tableCtx.indexs.add(index);
            } else if (len >= 4) {
                if (StringUtils.isNotEmpty((CharSequence)data.get(0)) && (data.get(0).equals("\u5e8f\u53f7") || data.get(0).equals("\u5b57\u6bb5\u63cf\u8ff0") || data.get(0).equals("\u5b57\u6bb5\u540d\u79f0") || data.get(0).equals("\u5b57\u6bb5\u540d"))) {
                    int fieldIndex = context.readRowHolder().getRowIndex();
                    this.tableCtx.indexLen.set(fieldIndex + 1);
                    return;
                }
                String fieldCode = StringUtils.lowerCase((String)data.get(0));
                String fieldName = data.get(1);
                String fieldType = data.get(2);
                String isAllowNull = data.get(3);
                String fieldDesc = data.get(4);
                logger.debug(fieldCode + "-" + fieldName);
                ModelTableFieldDTO field = new ModelTableFieldDTO();
                field.setFieldOrder(Integer.valueOf(context.readRowHolder().getRowIndex() - this.tableCtx.indexLen.get()));
                field.setFieldCode(fieldCode);
                field.setFieldName(fieldName);
                if (fieldType.contains("(")) {
                    field.setFieldType(fieldType.substring(0, fieldType.indexOf("(")));
                    Matcher matcher = pattern.matcher(fieldType);
                    if (matcher.matches()) {
                        field.setFieldLength(Integer.valueOf(matcher.group(1)));
                        if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                            field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                        }
                    }
                } else {
                    field.setFieldType(fieldType);
                }
                field.setFieldDesc(fieldDesc);
                if (isAllowNull != null && (isAllowNull.equals("N") || isAllowNull.equals("Y"))) {
                    field.setIsAllowNull(isAllowNull);
                } else {
                    field.setIsAllowNull(isAllowNull != null && isAllowNull.equals("\u662f") ? "Y" : "N");
                }
                if (this.tableCtx.primaryKey != null && this.tableCtx.primaryKey.getIndexFields() != null && this.tableCtx.primaryKey.getIndexFields().contains(field.getFieldCode())) {
                    field.setIsPk("Y");
                } else {
                    field.setIsPk("N");
                }
                this.tableCtx.fields.add(field);
            }
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                return;
            }
            this.tableInfoList.add(this.tableCtx);
            this.tableCtx = new ExcelTableContext();
        }
    }
}

