/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenStartTask
extends BaseGenTask {
    @Autowired
    protected PaasEnvInfoService paasEnvInfoService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        TmProjectInfoBo tpib;
        String loginUserId = appInfo.getLoginUserId();
        String subsId = appInfo.getSubsId();
        String appCode = appInfo.getAppCode();
        Map e4aMap = Collections.emptyMap();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList<Object> ctdbList = new ArrayList<Object>(tableList.size());
        ArrayList<String> tableCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                int serNum;
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                String TablebjectType = String.valueOf(table.getObjectType());
                tpib = new TmProjectInfoBo();
                tpib.setProjectId(appInfo.getAppCode());
                tpib.setProjectCode(appInfo.getAppCode());
                tpib.setProjectName(appInfo.getAppName());
                tpib.setProjectType(TablebjectType);
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Dao %s-%s", appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                ModelTableInfoBo tableBo = this.generateTableBO(table);
                bo.setMainTableModel(tableBo);
                bo.getMapData().put("tableModelCode", table.getObjectCode());
                this.wrapAppsParam(appInfo.getAppId(), bo);
                ctdbList.add(bo);
                if (table.getObjectType().intValue() == Integer.valueOf(ObjectType.Inout.getCode()).intValue() || (serNum = this.srvModelInoutService.countByTableModelId(appInfo.getAppId(), table.getObjectId())) == 0 && table.getObjectType().intValue() == Integer.valueOf(ObjectType.Data.getCode()).intValue()) continue;
                String serviceClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                serviceClassName = StringUtils.uncapitalize((String)serviceClassName);
                tableCodeList.add(serviceClassName);
            }
        }
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        List modelList = this.srvModelInfoService.queryList((Object)modelParam);
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            for (SrvModelInfoDTO model : modelList) {
                String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                tableClassName = StringUtils.uncapitalize((String)tableClassName);
                tableCodeList.add(tableClassName);
            }
        }
        CodeTemplateDataBo ctdb = null;
        if (CollectionUtils.isEmpty(ctdbList)) {
            CodeTemplateDataBo bo = new CodeTemplateDataBo();
            tpib = new TmProjectInfoBo();
            tpib.setProjectId(appInfo.getAppCode());
            tpib.setProjectCode(appInfo.getAppCode());
            tpib.setProjectName(appInfo.getAppName());
            bo.setTmProjectInfo(tpib);
            bo.getEnvBo().setAuthor(loginUserId);
            bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
            bo.getEnvBo().setDesc(String.format("%s start", appInfo.getAppName()));
            this.wrapAppsParam(appInfo.getAppId(), bo);
            ctdb = bo;
        } else {
            ctdb = (CodeTemplateDataBo)ctdbList.get(0);
        }
        String package_prefix = this.getPackagePrefix(ctdb);
        ctdb.getMapData().put("tableModelCode", appInfo.getAppCode());
        ctdb.getMapData().put("tableCodeToClassName", TmModelUtil.tableCodeToClassName((String)appInfo.getAppCode()));
        ctdb.getMapData().put("database_name", GenStartTask.getAppDatabaseName(appInfo));
        ArrayList appCodes = new ArrayList();
        PaasAppsInfoDTO refAppParam = new PaasAppsInfoDTO();
        refAppParam.setSubsId(appInfo.getSubsId());
        refAppParam.setAppId(appInfo.getAppId());
        List referenceApps = this.paasAppsInfoPortalService.queryReferenceApp(refAppParam);
        if (CollectionUtils.isNotEmpty((Collection)referenceApps)) {
            List<String> compTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
            for (PaasAppsInfoDTO paas : referenceApps) {
                if (compTypes.contains(paas.getAppType())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("appCode", paas.getAppCode());
                appCodes.add(map);
            }
        }
        ctdb.getMapData().put("appCodes", appCodes);
        ctdb.getMapData().put("hasAppCode", appCodes.size() > 0 ? "Y" : "N");
        if (!StringUtils.equals((CharSequence)AppType.M81.getCode(), (CharSequence)appInfo.getAppType())) {
            ctdb.getMapData().put("e4a", e4aMap);
            this.produceCodeFile("XXXApplication.java", "start", "src/main/java/" + package_prefix + "/" + GenStartTask.formatClassPath(appCode) + "/start/", appInfo, ctdb);
        }
        if (AppType.M81.getCode().equals(appInfo.getAppType())) {
            this.produceCodeFile("application.yml", "start", "src/main/resources/", appInfo, ctdb);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(appInfo.getAppCode());
            pomTp.setProjectCode(appInfo.getAppCode());
            pomTp.setProjectName(appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(appInfo.getAppId(), pomBo);
            pomBo.getMapData().put("e4a", e4aMap);
            this.produceCodeFile("start-pom.xml", "", "start-", "start", "", appInfo, pomBo);
            this.produceCodeFile("project-pom.xml", "", "project-", null, "", appInfo, pomBo);
            this.produceCodeFile("logback-spring.xml", "", "", "start", "src/main/resources/", appInfo, pomBo);
        } else {
            ctdb.getMapData().put("MethodDealList", tableCodeList);
            ArchType archTypeEnum = ArchType.get((String)appInfo.getArchType());
            if (StringUtils.isNotBlank((CharSequence)archTypeEnum.getXmlPrefix())) {
                String xmlPrefix = archTypeEnum != null ? archTypeEnum.getXmlPrefix() : ArchType.Sofa.getXmlPrefix();
                this.produceCodeFile(xmlPrefix + "-provider-XXX.xml", appInfo.getAppCode(), CodeGenerateConstant.TABLE_VAR_NOSPLIT, "start", "src/main/resources/" + xmlPrefix + "/", appInfo, ctdb);
            }
            List envList = this.paasEnvInfoService.queryList((Object)new PaasEnvInfoDTO());
            this.wrapEnvInfoParam("dev", appInfo, ctdb);
            this.wrapComponentParams("dev", appInfo, ctdb);
            String appNameUnicode = StringEscapeUtils.escapeJava((String)appInfo.getAppName());
            ctdb.getMapData().put("appNameUnicode", appNameUnicode);
            this.produceCodeFile("application.properties", "start", "src/main/resources/", appInfo, ctdb);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(appInfo.getAppCode());
            pomTp.setProjectCode(appInfo.getAppCode());
            pomTp.setProjectName(appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(appInfo.getAppId(), pomBo);
            pomBo.getMapData().put("e4a", e4aMap);
            this.produceCodeFile("start-pom.xml", "", "start-", "start", "", appInfo, pomBo);
            this.produceCodeFile("logback-spring.xml", "", "", "start", "src/main/resources/", appInfo, pomBo);
            this.produceCodeFile("DruidConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + GenStartTask.formatClassPath(appCode) + "/start/config/", appInfo, pomBo);
            this.produceCodeFile("TransactionAspConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + GenStartTask.formatClassPath(appCode) + "/start/config/", appInfo, pomBo);
        }
        return true;
    }
}

