/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.quality.console.application.service.check.scheme.impl.front;

import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinapaas.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinapaas.quality.console.types.CheckScope;
import com.irdstudio.allinapaas.quality.console.types.RuleResult;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAF001Rule
implements CheckJavaRule {
    private static final Logger logger = LoggerFactory.getLogger(RAF001Rule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String serialNo, SCheckRuleDTO rule, Map<String, Object> param, IConnPool connTool) {
        SCheckResultDTO ruleResult = new SCheckResultDTO();
        ruleResult.setSerialNo(serialNo);
        ruleResult.setSchemeNo(rule.getSchemeNo());
        ruleResult.setRuleId(rule.getRuleId());
        ruleResult.setRuleName(rule.getRuleName());
        RuleResult flag = RuleResult.Pass;
        ArrayList<SCheckResultDtlDTO> ruleResultDtlList = new ArrayList<SCheckResultDtlDTO>();
        CheckScope ruleScope = (CheckScope)param.get("ruleScope");
        boolean resultFlag = true;
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            PageModelInfoDTO modelParam = new PageModelInfoDTO();
            SrvModelInfoDTO srvParam = new SrvModelInfoDTO();
            if (ruleScope == CheckScope.Page) {
                String pageModelId = MapUtils.getString(param, (Object)"pageModelId");
                modelParam.setPageModelId(pageModelId);
            }
            String appId = MapUtils.getString(param, (Object)"appId");
            modelParam.setAppId(appId);
            List checkList = pageModelInfoService.queryList((Object)modelParam);
            for (PageModelInfoDTO modelInfo : checkList) {
                RuleResult tmpFlag = this.checkPageModelInfo(modelInfo, ruleResultDtlList, rule, param, conn = connTool.getConnection(conn));
                if (tmpFlag == RuleResult.Pass) continue;
                flag = tmpFlag;
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u670d\u52a1\u6821\u9a8c " + e.getMessage(), (Throwable)e);
            resultFlag = false;
            ruleResult.setRuleResult(flag.getCode());
            ruleResult.setCreateUser(rule.getLoginUserId());
            ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            ruleResult.setRuleResult(RuleResult.Error.getCode());
            try {
                SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
                sCheckResultService.insert((Object)ruleResult);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
            catch (Exception e1) {
                logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e1.getMessage(), (Object)e1);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        ruleResult.setRuleResult(flag.getCode());
        ruleResult.setCreateUser(rule.getLoginUserId());
        ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        try {
            SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
            SCheckResultDtlService sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
            sCheckResultService.insert((Object)ruleResult);
            if (CollectionUtils.isNotEmpty(ruleResultDtlList)) {
                for (SCheckResultDtlDTO dtl : ruleResultDtlList) {
                    String subsId = MapUtils.getString(param, (Object)"subsId");
                    String subsCode = MapUtils.getString(param, (Object)"subsCode");
                    String subsName = MapUtils.getString(param, (Object)"subsName");
                    String appId = MapUtils.getString(param, (Object)"appId");
                    String appCode = MapUtils.getString(param, (Object)"appCode");
                    String appName = MapUtils.getString(param, (Object)"appName");
                    String appType = MapUtils.getString(param, (Object)"appType");
                    String objectId = MapUtils.getString(param, (Object)"objectId");
                    String objectCode = MapUtils.getString(param, (Object)"objectCode");
                    String objectName = MapUtils.getString(param, (Object)"objectName");
                    String dtlId = UUIDUtil.getUUID();
                    dtl.setSerialNo(serialNo);
                    dtl.setRuleId(rule.getRuleId());
                    dtl.setRuleName(rule.getRuleName());
                    dtl.setDtlId(dtlId);
                    dtl.setAppId(appId);
                    dtl.setAppCode(appCode);
                    dtl.setAppName(appName);
                    dtl.setSubsId(subsId);
                    dtl.setSubsCode(subsCode);
                    dtl.setSubsName(subsName);
                    dtl.setAppType(appType);
                    dtl.setObjectId(objectId);
                    dtl.setObjectCode(objectCode);
                    dtl.setObjectName(objectName);
                    dtl.setCreateUser(rule.getLoginUserId());
                }
                sCheckResultDtlService.batchInsert(ruleResultDtlList);
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return resultFlag;
    }

    public RuleResult checkPageModelInfo(PageModelInfoDTO modelInfo, List<SCheckResultDtlDTO> ruleResultDtlList, SCheckRuleDTO rule, Map<String, Object> param, Connection conn) throws Exception {
        RuleResult flag = RuleResult.Pass;
        boolean genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
        PageModelParamDTO modelParam = new PageModelParamDTO();
        modelParam.setPageModelId(modelInfo.getPageModelId());
        modelParam.setNeedState(YesOrNO.YES.getCode());
        modelParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        modelParam.setQueryRef("query");
        List paramList = pageModelParamService.queryList((Object)modelParam);
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (PageModelParamDTO vo : paramList) {
                String checkDesc;
                SCheckResultDtlDTO dtl;
                CheckResult cr;
                if (!StringUtils.equals((CharSequence)vo.getNeedState(), (CharSequence)YesOrNO.YES.getCode())) continue;
                if (StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.kv.getCode())) {
                    if (!StringUtils.isBlank((CharSequence)vo.getParamValue())) continue;
                    flag = RuleResult.Fail;
                    cr = CheckResult.Fail;
                    if (cr == CheckResult.Pass) continue;
                    flag = RuleResult.Fail;
                    if (!genDtl) continue;
                    dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr.getCode());
                    checkDesc = String.format("%s %s %s \u53c2\u6570\u662f\u5fc5\u586b\u9879\u53c2\u6570\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), vo.getParamCode());
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                    continue;
                }
                if (StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.fields.getCode()) || StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.formFields.getCode())) {
                    if (!CollectionUtils.isEmpty((Collection)vo.getFields())) continue;
                    flag = RuleResult.Fail;
                    cr = CheckResult.Fail;
                    if (cr == CheckResult.Pass) continue;
                    flag = RuleResult.Fail;
                    if (!genDtl) continue;
                    dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr.getCode());
                    checkDesc = String.format("%s %s %s \u53c2\u6570\u5b57\u6bb5\u5217\u8868\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), vo.getParamCode());
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                    continue;
                }
                if (StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.linkeds.getCode())) {
                    if (!CollectionUtils.isEmpty((Collection)vo.getLinkeds())) continue;
                    flag = RuleResult.Fail;
                    cr = CheckResult.Fail;
                    if (cr == CheckResult.Pass) continue;
                    flag = RuleResult.Fail;
                    if (!genDtl) continue;
                    dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr.getCode());
                    checkDesc = String.format("%s %s %s \u53c2\u6570\u94fe\u63a5\u5217\u8868\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), vo.getParamCode());
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                    continue;
                }
                if (StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.conds.getCode())) {
                    if (!CollectionUtils.isEmpty((Collection)vo.getQueryFields())) continue;
                    flag = RuleResult.Fail;
                    cr = CheckResult.Fail;
                    if (cr == CheckResult.Pass) continue;
                    flag = RuleResult.Fail;
                    if (!genDtl) continue;
                    dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr.getCode());
                    checkDesc = String.format("%s %s %s \u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), vo.getParamCode());
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)vo.getParamType(), (CharSequence)ParamType.buttons.getCode()) || !CollectionUtils.isEmpty((Collection)vo.getButtons())) continue;
                flag = RuleResult.Fail;
                cr = CheckResult.Fail;
                if (cr == CheckResult.Pass) continue;
                flag = RuleResult.Fail;
                if (!genDtl) continue;
                dtl = new SCheckResultDtlDTO();
                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                dtl.setCheckResult(cr.getCode());
                checkDesc = String.format("%s %s %s \u5217\u8868\u6309\u94ae\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), vo.getParamCode());
                dtl.setCheckDesc(checkDesc);
                ruleResultDtlList.add(dtl);
            }
        }
        return flag;
    }
}

