/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasAppsBatrefRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEnvInfoRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasAppsBatrefDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEnvInfoDO;
import com.irdstudio.allinapaas.deliver.console.facade.FlowConfMasterService;
import com.irdstudio.allinapaas.deliver.console.facade.FlowConfNodeService;
import com.irdstudio.allinapaas.deliver.console.facade.FlowConfSourceService;
import com.irdstudio.allinapaas.deliver.console.facade.FlowConfStageService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasAppsBatrefService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.FlowConfMasterDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.FlowConfNodeDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.FlowConfSourceDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.FlowConfStageDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasAppsBatrefDTO;
import com.irdstudio.allinapaas.deliver.console.types.BatchMgrType;
import com.irdstudio.allinapaas.deliver.console.types.BatchState;
import com.irdstudio.allinapaas.deliver.console.types.YesOrNO;
import com.irdstudio.allinapaas.executor.facade.PluginExecutorService;
import com.irdstudio.allinapaas.executor.facade.dto.PluginExecutorDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasAppsBatrefServiceImpl")
public class PaasAppsBatrefServiceImpl
extends BaseServiceImpl<PaasAppsBatrefDTO, PaasAppsBatrefDO, PaasAppsBatrefRepository>
implements PaasAppsBatrefService {
    @Autowired
    private PaasEnvInfoRepository paasEnvInfoRepository;
    @Autowired
    private FlowConfMasterService flowConfMasterService;
    @Autowired
    private FlowConfStageService flowConfStageService;
    @Autowired
    private FlowConfNodeService flowConfNodeService;
    @Autowired
    private FlowConfSourceService flowConfSourceService;
    @Autowired
    private PluginExecutorService pluginExecutorService;
    @Autowired
    private SeqInstInfoService seqService;

    public Integer deleteByCond(PaasAppsBatrefDTO param) {
        return ((PaasAppsBatrefRepository)this.getRepository()).deleteByCond((PaasAppsBatrefDO)this.beanCopy(param, PaasAppsBatrefDO.class));
    }

    public int insert(PaasAppsBatrefDTO paramDTO) {
        PaasEnvInfoDO envInfo = new PaasEnvInfoDO();
        envInfo.setEnvId(paramDTO.getEnvId());
        envInfo = (PaasEnvInfoDO)this.paasEnvInfoRepository.queryByPk((Object)envInfo);
        FlowConfStageDTO stageParam = new FlowConfStageDTO();
        stageParam.setBatchId(paramDTO.getBatchId());
        List stageList = this.flowConfStageService.queryList((Object)stageParam);
        FlowConfNodeDTO taskParam = new FlowConfNodeDTO();
        taskParam.setBatchId(paramDTO.getBatchId());
        List taskList = this.flowConfNodeService.queryList((Object)taskParam);
        String batchId = paramDTO.getBatchId();
        String subsId = paramDTO.getSubsId();
        String envId = paramDTO.getEnvId();
        String newBatchId = this.seqService.nextSequence("PAAS-BATCH-ID", StringUtils.join(Arrays.asList(subsId, envId), (String)","));
        FlowConfMasterDTO batchInfo = (FlowConfMasterDTO)this.beanCopy(paramDTO, FlowConfMasterDTO.class);
        batchInfo.setBatchId(newBatchId.toUpperCase());
        batchInfo.setBatchName(String.format("%s-%s-\u6d41\u6c34\u7ebf", paramDTO.getAppName(), envInfo.getEnvName()));
        batchInfo.setBatchMgrType(BatchMgrType.Instance.getCode());
        batchInfo.setBatchState(BatchState.Draft.getCode());
        batchInfo.setSubsId(paramDTO.getSubsId());
        batchInfo.setAppId(paramDTO.getAppId());
        batchInfo.setEnvId(paramDTO.getEnvId());
        batchInfo.setCbaCode(paramDTO.getCbaCode());
        batchInfo.setEcsId(paramDTO.getEcsId());
        batchInfo.setCreateUser(paramDTO.getLoginUserId());
        batchInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        batchInfo.setLastModifyUser(paramDTO.getLoginUserId());
        batchInfo.setLastModifyTime(batchInfo.getCreateTime());
        this.flowConfMasterService.insert((Object)batchInfo);
        FlowConfSourceDTO batSource = new FlowConfSourceDTO();
        batSource.setBatchId(batchInfo.getBatchId());
        batSource.setConfigType("A");
        batSource.setNeedRepo(YesOrNO.YES.getCode());
        batSource.setRepoType("git");
        batSource.setRepoUrl(paramDTO.getAppGitUrl());
        batSource.setUserName(paramDTO.getLoginUserId());
        this.flowConfSourceService.insert((Object)batSource);
        HashMap<String, String> stageMap = new HashMap<String, String>();
        for (FlowConfStageDTO stage : stageList) {
            String newStageId = StringUtils.substring((String)UUIDUtil.getUUID(), (int)8);
            stageMap.put(stage.getStageId(), newStageId);
            stage.setBatchId(batchInfo.getBatchId());
            stage.setStageId(newStageId);
        }
        this.flowConfStageService.batchInsert(stageList);
        for (FlowConfNodeDTO task : taskList) {
            task.setBatchId(batchInfo.getBatchId());
            String oldTaskId = task.getTaskId();
            task.setTaskId(StringUtils.replace((String)task.getTaskId(), (String)paramDTO.getBatchId(), (String)batchInfo.getBatchId()));
            task.setStageId((String)stageMap.get(task.getStageId()));
            if (StringUtils.isNotBlank((CharSequence)task.getPreviousTaskId())) {
                task.setPreviousTaskId(StringUtils.replace((String)task.getPreviousTaskId(), (String)paramDTO.getBatchId(), (String)batchInfo.getBatchId()));
            }
            PluginExecutorDTO validateParam = new PluginExecutorDTO();
            validateParam.setBatchId(task.getBatchId());
            validateParam.setTaskId(oldTaskId);
            validateParam.setNewTaskId(task.getTaskId());
            validateParam.setPluginClass(task.getPluginClass());
            ResponseData responseData = this.pluginExecutorService.copyConfig(validateParam);
        }
        this.flowConfNodeService.batchInsert(taskList);
        PaasAppsBatrefDO batref = (PaasAppsBatrefDO)this.beanCopy(paramDTO, PaasAppsBatrefDO.class);
        batref.setBatchId(batchInfo.getBatchId());
        return ((PaasAppsBatrefRepository)this.getRepository()).insert((Object)batref);
    }

    public int deleteByPk(PaasAppsBatrefDTO paramDTO) {
        FlowConfStageDTO stageParam = new FlowConfStageDTO();
        stageParam.setBatchId(paramDTO.getBatchId());
        this.flowConfStageService.deleteByBatchId(stageParam);
        FlowConfNodeDTO taskParam = new FlowConfNodeDTO();
        taskParam.setBatchId(paramDTO.getBatchId());
        this.flowConfNodeService.deleteByBatchId(taskParam);
        FlowConfSourceDTO deleteSource = new FlowConfSourceDTO();
        deleteSource.setBatchId(paramDTO.getBatchId());
        this.flowConfSourceService.deleteByPk((Object)deleteSource);
        FlowConfMasterDTO oldData = new FlowConfMasterDTO();
        oldData.setBatchId(paramDTO.getBatchId());
        oldData = (FlowConfMasterDTO)this.flowConfMasterService.queryByPk((Object)oldData);
        this.flowConfMasterService.deleteByPk((Object)oldData);
        return super.deleteByPk((BaseInfo)paramDTO);
    }
}

