/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocExecutorService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitRepoPushQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.task.WikiRepoPushTaskImpl;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.types.DataMarkFlag;
import com.irdstudio.allinapaas.portal.console.types.DataStdFlag;
import com.irdstudio.allinrdm.dam.console.facade.DictItemInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictWordInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictItemInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisTableMatchItemTask
implements Callable<ExecuteRtnInfo> {
    public static final ConcurrentMap<String, String> taskDebounce = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(AnalysisTableMatchItemTask.class);
    private String appId;
    private String subsId;
    private String objectId;
    private String dataMarkFlag;
    private String userId;
    private String dslId;
    public final int loadPageSize = 50;
    private ModelTableInfoService modelTableInfoService;
    private ModelTableFieldService modelTableFieldService;
    private DictItemInfoService dictItemInfoService;
    private DictWordInfoService dictWordInfoService;
    private DictOptionInfoService dictOptionInfoService;
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    private PaasDocTemplateService paasDocTemplateService;
    private SSubsInfoService sSubsInfoService;
    public static final ConcurrentMap<String, Object> itemMatchCached = new ConcurrentHashMap<String, Object>();
    private static final boolean cachedEnable = false;

    public AnalysisTableMatchItemTask(String subsId, String appId, String objectId, String dataMarkFlag, String userId) {
        this.subsId = subsId;
        this.appId = appId;
        this.objectId = objectId;
        this.dataMarkFlag = dataMarkFlag;
        this.userId = userId;
    }

    public AnalysisTableMatchItemTask(String subsId, String appId, String dataMarkFlag, String userId) {
        this(subsId, appId, null, dataMarkFlag, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteRtnInfo call() throws Exception {
        block16: {
            try {
                this.init();
                SSubsInfoDTO subsInfo = new SSubsInfoDTO();
                subsInfo.setSubsId(this.subsId);
                subsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)subsInfo);
                this.dslId = subsInfo.getDslId();
                DataMarkFlag markFlag = DataMarkFlag.getByCode((String)this.dataMarkFlag);
                Map pubDbmsDataMap = Collections.EMPTY_MAP;
                ModelTableInfoDTO param = new ModelTableInfoDTO();
                param.setSubsId(this.subsId);
                param.setAppId(this.appId);
                param.setObjectId(this.objectId);
                param.setSize(Integer.valueOf(50));
                param.setObjectCodes(Arrays.asList(String.valueOf(ObjectType.Table.getCode()), String.valueOf(ObjectType.Data.getCode()), String.valueOf(ObjectType.FreeStyleData.getCode()), String.valueOf(ObjectType.Main.getCode()), String.valueOf(ObjectType.Second.getCode()), String.valueOf(ObjectType.Inout.getCode())));
                List list = this.modelTableFieldService.queryFieldBySysCodeByPage(param);
                int total = param.getTotal();
                if (total < 50) {
                    this.matchItemLoop(markFlag, pubDbmsDataMap, list);
                } else {
                    this.matchItemLoop(markFlag, pubDbmsDataMap, list);
                    int loop = this.calcLoop(total);
                    for (int i = 2; i <= loop; ++i) {
                        logger.info(String.format("\u5f53\u524d\u7b2c %s, \u603b\u8ba1\uff1a%s", i, loop));
                        try {
                            int page = i;
                            param.setPage(Integer.valueOf(page));
                            list = this.modelTableFieldService.queryFieldBySysCodeByPage(param);
                            this.matchItemLoop(markFlag, pubDbmsDataMap, list);
                            continue;
                        }
                        catch (Exception sqlE) {
                            logger.error(sqlE.getMessage(), (Throwable)sqlE);
                            --i;
                        }
                    }
                }
                if (this.objectId != null || this.appId == null) break block16;
                DocTemplateRepoPullQueueExecutor.syncRun();
                String docsRootPath = SdEnvUtil.DOCS_PATH;
                File sysDir = new File(docsRootPath + File.separator + this.subsId);
                PaasDocTemplateDTO templateDocParam = new PaasDocTemplateDTO();
                templateDocParam.setDocTid("sys-dict-excel");
                PaasDocTemplateDTO template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)templateDocParam);
                template.setLoginUserId(this.userId);
                if (StringUtils.equals((String)"java", (String)template.getDocGenType())) {
                    try {
                        PaasDocExecutorService paasDocTemplateService = (PaasDocExecutorService)SpringContextUtils.getBean(PaasDocExecutorService.class);
                        List filePathList = paasDocTemplateService.docTemplateGenerate(template.getDocTid(), this.subsId, null, true, null, null, this.userId);
                        List files = filePathList.stream().map(p -> new File((String)p)).collect(Collectors.toList());
                        for (File file : files) {
                            WikiRepoPushTaskImpl task = new WikiRepoPushTaskImpl(this.subsId, this.userId, file, null, "\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\u62a5\u544a\u63d0\u4ea4");
                            GitRepoPushQueueExecutor.addTask(task);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                }
                GitRepoPushQueueExecutor.start();
            }
            catch (Exception e) {
                logger.error("\u5bf9\u6807\u4efb\u52a1\u6267\u884c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.appId == null) {
                    taskDebounce.remove(this.subsId);
                } else {
                    taskDebounce.remove(this.appId);
                }
            }
        }
        return null;
    }

    public void init() {
        this.modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        this.modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        this.dictItemInfoService = (DictItemInfoService)SpringContextUtils.getBean(DictItemInfoService.class);
        this.dictWordInfoService = (DictWordInfoService)SpringContextUtils.getBean(DictWordInfoService.class);
        this.dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
        this.pubDbmsDatatypeService = (PubDbmsDatatypeService)SpringContextUtils.getBean(PubDbmsDatatypeService.class);
        this.paasDocTemplateService = (PaasDocTemplateService)SpringContextUtils.getBean(PaasDocTemplateService.class);
        this.sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
    }

    public DictItemInfoDTO getItemByFieldName(final String fieldName, String objectId) {
        DictItemInfoDTO dictItemInfo = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return dictItemInfo;
        }
        List<String> itemNames = AnalysisTableMatchItemTask.splitName(fieldName);
        if (itemNames.isEmpty()) {
            return dictItemInfo;
        }
        List dictList = AnalysisTableMatchItemTask.matchItemFormCached(itemNames, DictItemInfoDTO.class);
        if (CollectionUtils.isNotEmpty(dictList)) {
            dictItemInfo = dictList.get(0);
            return dictItemInfo;
        }
        dictList = this.dictItemInfoService.queryByItemExtNames(itemNames, null, this.dslId, this.appId);
        if (CollectionUtils.isNotEmpty((Collection)dictList)) {
            AnalysisTableMatchItemTask.pushItemListIntoCached(dictList);
            dictList.sort(new Comparator<DictItemInfoDTO>(){

                @Override
                public int compare(DictItemInfoDTO o1, DictItemInfoDTO o2) {
                    if (StringUtils.equals((String)o1.getExtName(), (String)fieldName)) {
                        return -1;
                    }
                    if (StringUtils.equals((String)o2.getExtName(), (String)fieldName)) {
                        return 1;
                    }
                    return Integer.compare(o1.getExtName().length(), o2.getExtName().length()) * -1;
                }
            });
            dictItemInfo = (DictItemInfoDTO)dictList.get(0);
        }
        if (CollectionUtils.isEmpty((Collection)dictList) && CollectionUtils.isNotEmpty((Collection)(dictList = this.dictItemInfoService.queryByItemNames(itemNames, null, this.dslId, this.appId)))) {
            AnalysisTableMatchItemTask.pushItemListIntoCached(dictList);
            dictList.sort(new Comparator<DictItemInfoDTO>(){

                @Override
                public int compare(DictItemInfoDTO o1, DictItemInfoDTO o2) {
                    if (StringUtils.equals((String)o1.getItemName(), (String)fieldName)) {
                        return -1;
                    }
                    if (StringUtils.equals((String)o2.getItemName(), (String)fieldName)) {
                        return 1;
                    }
                    return Integer.compare(o1.getItemName().length(), o2.getItemName().length()) * -1;
                }
            });
            dictItemInfo = (DictItemInfoDTO)dictList.get(0);
        }
        return dictItemInfo;
    }

    public boolean updateField(ModelTableFieldDTO modelTableField) {
        return this.updateField(modelTableField, true);
    }

    public boolean updateField(ModelTableFieldDTO modelTableField, Boolean updateFieldName) {
        boolean flag = true;
        try {
            int num = this.modelTableFieldService.updateByPk(modelTableField, updateFieldName.booleanValue());
            flag = num > 0;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    public int calcLoop(int size) {
        int loop = size / 50;
        if (size % 50 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public void matchItemLoop(DataMarkFlag markFlag, Map<String, String> pubDbmsDatMap, List<ModelTableFieldDTO> list) throws Exception {
        if (CollectionUtils.isNotEmpty(list)) {
            for (ModelTableFieldDTO field : list) {
                if (StringUtils.equals((String)field.getDataStdFlag(), (String)DataStdFlag.NOT.getCode()) || StringUtils.equals((String)field.getDataStdFlag(), (String)DataStdFlag.Manual.getCode())) continue;
                boolean needUpdate = false;
                String fieldName = field.getFieldName();
                DictItemInfoDTO matchItemInfo = this.getItemByFieldName(fieldName, field.getObjectId());
                if (matchItemInfo != null) {
                    logger.info(String.format("\u5b57\u6bb5 %s \u5339\u914d\u6570\u636e\u9879 %s", field.getFieldCode(), matchItemInfo.getItemId()));
                    field.setItemCode(matchItemInfo.getItemCode());
                    field.setItemName(matchItemInfo.getItemName());
                    field.setItemId(matchItemInfo.getItemId());
                    field.setItemDslId(matchItemInfo.getSubsId());
                    field.setMiddleDataType(matchItemInfo.getItemDataType());
                    needUpdate = true;
                } else {
                    field.setItemId("");
                    field.setItemCode("");
                    field.setItemName("");
                    needUpdate = true;
                }
                if (!needUpdate) continue;
                field.setLastModifyUser(this.userId);
                field.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                this.updateField(field, false);
            }
        }
    }

    public static List<String> splitName(String fieldName) {
        int strLen = fieldName.length();
        ArrayList<String> itemNames = new ArrayList<String>();
        for (int i = 0; i < strLen; ++i) {
            int l = strLen - i;
            int k = 0;
            while (k + l <= strLen) {
                itemNames.add(StringUtils.substring((String)fieldName, (int)k, (int)(k + l)));
                ++k;
            }
        }
        return itemNames;
    }

    public static <T> List<T> matchItemFormCached(List<String> itemNames, Class<T> cls) {
        if (!CollectionUtils.isEmpty(itemNames)) {
            // empty if block
        }
        return Collections.EMPTY_LIST;
    }

    public static <T> void pushItemListIntoCached(List<T> dictList) {
        if (CollectionUtils.isNotEmpty(dictList)) {
            // empty if block
        }
    }

    public static void removeItemCached(String itemName) {
        itemMatchCached.remove(itemName);
    }

    public static void clearItemCached() {
        itemMatchCached.clear();
    }
}

