/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeClassContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDeclareVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeMethod;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GenFacdeTask
extends BaseGenTask {
    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        this.generateIsrvAppService(appInfo);
        this.generateOsrvAppService(appInfo);
        ArchType archTypeEnum = ArchType.get((String)appInfo.getArchType());
        if (StringUtils.isNotBlank((CharSequence)archTypeEnum.getXmlPrefix())) {
            this.generateSofaXML(appInfo);
        }
        ArrayList paramsList = new ArrayList();
        PaasAppsInfoDTO refAppParam = new PaasAppsInfoDTO();
        refAppParam.setAppId(appInfo.getAppId());
        refAppParam.setAppCategory(AppCategory.BusinessApp.getCode());
        List referenceApps = this.paasAppsInfoPortalService.queryReferenceApp(appInfo);
        if (CollectionUtils.isNotEmpty((Collection)referenceApps)) {
            for (PaasAppsInfoDTO paas : referenceApps) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (paas.getAppMavenPom() != null) {
                    map.put("code", paas.getAppMavenPom());
                } else {
                    map.put("code", "");
                }
                paramsList.add(map);
            }
        }
        SSubsInfoDTO sSubsInfo = new SSubsInfoDTO();
        sSubsInfo.setSubsId(appInfo.getSubsId());
        sSubsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfo);
        List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        TmProjectInfoBo pomTp = new TmProjectInfoBo();
        pomTp.setProjectId(appInfo.getAppCode());
        pomTp.setProjectCode(appInfo.getAppCode());
        pomTp.setProjectName(appInfo.getAppName());
        pomBo.setTmProjectInfo(pomTp);
        pomBo.getMapData().put("appCodes", paramsList);
        pomBo.getMapData().put("sdkList", dependencies);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("facade-pom.xml", "", "facade-", "facade", "", appInfo, pomBo);
        return true;
    }

    private void generateSofaXML(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        CodeTemplateDataBo bo = new CodeTemplateDataBo();
        String author = appInfo.getCreateUser();
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        bo.setTmProjectInfo(tpib);
        bo.getEnvBo().setAuthor(loginUserId);
        bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bo.getEnvBo().setDesc("");
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList<String> tableCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                int serNum;
                if (table.getObjectType().intValue() == Integer.valueOf(ObjectType.Inout.getCode()).intValue() || (serNum = this.srvModelInoutService.countByTableModelId(appInfo.getAppId(), table.getObjectId())) == 0 && table.getObjectType().intValue() == Integer.valueOf(ObjectType.Data.getCode()).intValue()) continue;
                String serviceClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                serviceClassName = StringUtils.uncapitalize((String)serviceClassName);
                tableCodeList.add(serviceClassName);
            }
        }
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        List modelList = this.srvModelInfoService.queryList((Object)modelParam);
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            for (SrvModelInfoDTO model : modelList) {
                String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                tableClassName = StringUtils.uncapitalize((String)tableClassName);
                tableCodeList.add(tableClassName);
            }
        }
        bo.getMapData().put("MethodDealList", tableCodeList);
        bo.getMapData().put("tableModelCode", appInfo.getAppCode());
        this.wrapAppsParam(appInfo.getAppId(), bo);
        String package_prefix = this.getPackagePrefix(bo);
        ArchType archTypeEnum = ArchType.get((String)appInfo.getArchType());
        String xmlPrefix = archTypeEnum != null ? archTypeEnum.getXmlPrefix() : ArchType.Sofa.getXmlPrefix();
        this.produceCodeFile(xmlPrefix + "-consumer-XXX.xml", appInfo.getAppCode(), CodeGenerateConstant.TABLE_VAR_NOSPLIT, "facade", "src/main/resources/" + xmlPrefix + "/", appInfo, bo);
    }

    private void generateIsrvAppService(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String subsCode = appInfo.getAppCode();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSrvModelId())) {
            SrvModelInfoDTO srvModelInfo = new SrvModelInfoDTO();
            srvModelInfo.setSrvModelId(appInfo.getSrvModelId());
            srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
            if (srvModelInfo != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getTableModelId())) {
                tableParam.setObjectId(srvModelInfo.getTableModelId());
            }
        }
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList ctdbList = new ArrayList(tableList.size());
        ModelTableInfoDTO userTokenInfo = this.modelTableInfoService.generateUserTokenInfo(appInfo.getAppId());
        ModelTableInfoDTO isrvRspInfo = this.modelTableInfoService.generateIsrvRspInfo(appInfo.getAppId());
        ModelTableInfoDTO pageInfo = this.modelTableInfoService.generatePageInfo(appInfo.getAppId());
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        ArrayList inoutParamList = new ArrayList(tableList.size());
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            String package_prefix;
            ArrayList<CodeTemplateDataBo> codeBoList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            ArrayList<CodeTemplateDataBo> ctdbDtoList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
            modelParam.setAppId(appInfo.getAppId());
            modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
            for (ModelTableInfoDTO table : tableList) {
                ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                if (objectTypeEnum == ObjectType.Inout || objectTypeEnum == ObjectType.Common || objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.FreeStyleData) continue;
                modelParam.setTableModelId(table.getObjectId());
                List modelList = this.srvModelInfoService.queryList((Object)modelParam);
                String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                ModelTableInfoDTO inputDO = this.queryTableWithNameForInout(appInfo.getAppId(), inputDOName);
                if (inputDO == null) continue;
                String tableClassName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode());
                String tableModelCode = table.getObjectCode();
                HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                HashMap<String, OsrvArrangeDeclareVar> propMap = new HashMap<String, OsrvArrangeDeclareVar>();
                OsrvArrangeDeclareVar inputDTOProp = new OsrvArrangeDeclareVar();
                String inputDO_className = this.wrapperTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId());
                inputDTOProp.setVarClassName(inputDO_className);
                inputDTOProp.setVarName(StringUtils.uncapitalize((String)inputDO_className));
                inputDTOProp.setListFlag(YesOrNO.NO.getCode());
                inputDTOProp.setComment(String.format("%s %s\u53ca\u6269\u5c55\u53c2\u6570\u5bf9\u8c61", IOType.Input.getName(), inputDO.getObjectName()));
                propMap.put(inputDTOProp.getVarName(), inputDTOProp);
                OsrvArrangeImport inputDTOProp_import = new OsrvArrangeImport();
                inputDTOProp_import.setClassName(inputDO_className);
                inputDTOProp_import.setProjectCode(tpib.getProjectCode());
                inputDTOProp_import.setImportType(this.judgeTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId()));
                importMap.put(inputDTOProp_import.getClassName(), inputDTOProp_import);
                OsrvArrangeImport isrvRspInfo_import = new OsrvArrangeImport();
                String isrvRspInfo_class = this.wrapperTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId());
                isrvRspInfo_import.setClassName(isrvRspInfo_class);
                isrvRspInfo_import.setProjectCode(tpib.getProjectCode());
                isrvRspInfo_import.setImportType(this.judgeTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId()));
                importMap.put(isrvRspInfo_import.getClassName(), isrvRspInfo_import);
                OsrvArrangeDeclareVar tableDO = new OsrvArrangeDeclareVar();
                String tableDO_className = this.wrapperTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId());
                tableDO.setVarClassName(tableDO_className);
                tableDO.setVarName(StringUtils.uncapitalize((String)tableDO_className));
                tableDO.setListFlag(YesOrNO.NO.getCode());
                tableDO.setComment(String.format("%s %s", IOType.Input.getName(), table.getObjectName()));
                propMap.put(tableDO.getVarName(), tableDO);
                OsrvArrangeImport tableDO_import = new OsrvArrangeImport();
                tableDO_import.setClassName(tableDO_className);
                tableDO_import.setProjectCode(tpib.getProjectCode());
                tableDO_import.setImportType(this.judgeTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId()));
                importMap.put(tableDO_import.getClassName(), tableDO_import);
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                importMap.put(serviceInput_import.getClassName(), serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                importMap.put(serviceOutput_import.getClassName(), serviceOutput_import);
                if (CollectionUtils.isNotEmpty((Collection)modelList)) {
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String author = table.getCreateUser();
                    String TablebjectType = String.valueOf(table.getObjectType());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Facade %s", appInfo.getAppName(), table.getObjectName()));
                    Map dataMap = bo.getMapData();
                    ArrayList methods = new ArrayList(modelList.size());
                    dataMap.put("methods", methods);
                    for (SrvModelInfoDTO modelInfo : modelList) {
                        HashMap<String, Object> method = new HashMap<String, Object>();
                        method.put("modelInfo", modelInfo);
                        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                        method.put("methodName", modelInfo.getSrvModelCode());
                        String inputGenClass = inputDO_className;
                        SrvModelInoutDTO serviceInputInout = new SrvModelInoutDTO();
                        serviceInputInout.setSrvModelId(modelInfo.getSrvModelId());
                        serviceInputInout.setListFlag(YesOrNO.NO.getCode());
                        serviceInputInout.setTableModelCode(String.format("%s<%s>", "ServiceInput", inputGenClass));
                        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        inoutParam.setIoType(IOType.Output.getCode());
                        List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                        String outputGenericsClass = tableDO_className;
                        if (CollectionUtils.isNotEmpty((Collection)outputParams)) {
                            SrvModelInoutDTO outputInout = (SrvModelInoutDTO)outputParams.get(0);
                            outputGenericsClass = this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId());
                        }
                        SrvModelInoutDTO serviceOutputInout = new SrvModelInoutDTO();
                        serviceOutputInout.setSrvModelId(modelInfo.getSrvModelId());
                        serviceOutputInout.setListFlag(YesOrNO.NO.getCode());
                        serviceOutputInout.setTableModelCode(String.format("%s<%s>", "ServiceOutput", outputGenericsClass));
                        method.put("input", serviceInputInout);
                        method.put("output", serviceOutputInout);
                        methods.add(method);
                    }
                    dataMap.put("importList", importMap.values());
                    bo.getMapData().put("tableModelCode", table.getObjectCode() + "_ds");
                    bo.getMapData().put("tableClassName", TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
                    codeBoList.add(bo);
                }
                CodeTemplateDataBo dtoBO = new CodeTemplateDataBo();
                dtoBO.setTmProjectInfo(tpib);
                ModelTableInfoBo inputDOBO = this.generateTableBO(inputDO);
                inputDOBO.setModelClassName(inputDO_className);
                dtoBO.setMainTableModel(inputDOBO);
                dtoBO.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)inputDO_className)));
                dtoBO.getEnvBo().setDesc(String.format("%s Facade DTO %s", appInfo.getAppName(), inputDO.getObjectName()));
                dtoBO.getEnvBo().setAuthor(loginUserId);
                dtoBO.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                ctdbDtoList.add(dtoBO);
            }
            Map<String, Object> appsParam = this.wrapAppsParam(appInfo.getAppId(), null);
            for (CodeTemplateDataBo ctdb : codeBoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                Map mapData = ctdb.getMapData();
                this.produceCodeFile("XXXService.java", "XXXService", "facade", "src/main/java/" + package_prefix + "/" + GenFacdeTask.formatClassPath(subsCode) + "/facade/channel/srv/", appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbDtoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXDTO.java", "XXXDTO", "facade", "src/main/java/" + package_prefix + "/" + GenFacdeTask.formatClassPath(subsCode) + "/facade/channel/srv/dto/", appInfo, ctdb);
            }
        }
    }

    private void generateOsrvAppService(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String subsCode = appInfo.getAppCode();
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbDtoList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbInputList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbOutputList = new ArrayList<CodeTemplateDataBo>();
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelId(appInfo.getSrvModelId());
        modelParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        List modelList = this.srvModelInfoService.queryList((Object)modelParam);
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        HashMap<CallSite, OsrvArrangeClassContext> clsCtxMap = new HashMap<CallSite, OsrvArrangeClassContext>();
        PaasAppsInfo executeAppInfo = (PaasAppsInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new PaasAppsInfo());
        HashMap<String, SrvModelInoutDTO> serverInoutMap = new HashMap<String, SrvModelInoutDTO>();
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            String package_prefix;
            OsrvArrangeClassContext clsCtx;
            for (Object model : modelList) {
                SrvModelInfo srvModelInfo = (SrvModelInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new SrvModelInfo());
                String className = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                clsCtx = (OsrvArrangeClassContext)clsCtxMap.get(className + model.getSrvModelCatalog());
                if (clsCtx == null) {
                    clsCtx = new OsrvArrangeClassContext(executeAppInfo, model.getSrvModelCatalog(), null);
                    clsCtx.setClassName(className);
                    clsCtxMap.put((CallSite)((Object)(className + model.getSrvModelCatalog())), clsCtx);
                }
                OsrvArrangeContext osrvCtx = new OsrvArrangeContext(executeAppInfo, srvModelInfo, null);
                osrvCtx.setTableClassName(className);
                SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                inoutParam.setSrvModelId(model.getSrvModelId());
                inoutParam.setIoType(IOType.Input.getCode());
                List inputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                inoutParam.setIoType(IOType.Output.getCode());
                List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                inoutParam.setIoType(IOType.Middle.getCode());
                List middleParams = this.srvModelInoutService.queryList((Object)inoutParam);
                this.initOsrvCtx(osrvCtx, inputParams, outputParams);
                clsCtx.getMethodCtxList().add(osrvCtx);
                CodeTemplateDataBo inputBo = this.createBigDTO(osrvCtx, inputParams, IOType.Input, serverInoutMap);
                CodeTemplateDataBo outputBo = this.createBigDTO(osrvCtx, outputParams, IOType.Output, serverInoutMap);
                if (!StringUtils.equals((CharSequence)model.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) || StringUtils.equals((CharSequence)model.getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
                    inputBo.setTmProjectInfo(tpib);
                    ctdbInputList.add(inputBo);
                    outputBo.setTmProjectInfo(tpib);
                    ctdbOutputList.add(outputBo);
                }
                for (SrvModelInoutDTO inout : middleParams) {
                    serverInoutMap.put(inout.getTableModelCode(), inout);
                }
            }
            Collection serverInouts = serverInoutMap.values();
            for (SrvModelInoutDTO srvModelInoutDTO : serverInouts) {
                CodeTemplateDataBo dtoBO = new CodeTemplateDataBo();
                dtoBO.setTmProjectInfo(tpib);
                dtoBO.getEnvBo().setAuthor(loginUserId);
                dtoBO.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                dtoBO.getEnvBo().setDesc(String.format("%s Facade DTO %s-%s", appInfo.getAppName(), srvModelInoutDTO.getTableModelName(), srvModelInoutDTO.getTableModelCode()));
                ModelTableInfoDTO table = new ModelTableInfoDTO();
                table.setObjectId(srvModelInoutDTO.getTableModelId());
                if ((table = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)table)).getObjectType().equals(ObjectType.Table.getIntCode()) || table.getObjectType().equals(ObjectType.Common.getIntCode())) continue;
                ModelTableInfoBo tableBo = this.generateTableBO(table);
                tableBo.setModelClassName(this.wrapperTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId()));
                dtoBO.setMainTableModel(tableBo);
                dtoBO.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)tableBo.getModelClassName())));
                dtoBO.getMapData().put("objectType", String.valueOf(table.getObjectType()));
                ctdbDtoList.add(dtoBO);
            }
            for (Map.Entry entry : clsCtxMap.entrySet()) {
                OsrvArrangeClassContext clsCtx2 = (OsrvArrangeClassContext)entry.getValue();
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                clsCtx2.addImport(serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                clsCtx2.addImport(serviceOutput_import);
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Facade %s", appInfo.getAppName(), clsCtx2.getClassName()));
                bo.getMapData().put("clsCtx", clsCtx2);
                for (OsrvArrangeContext osrvCtx : clsCtx2.getMethodCtxList()) {
                    clsCtx2.addImport(osrvCtx.getImportList());
                }
                ctdbList.add(bo);
            }
            Map<String, Object> appsParam = this.wrapAppsParam(appInfo.getAppId(), null);
            for (CodeTemplateDataBo ctdb : ctdbList) {
                clsCtx = (OsrvArrangeClassContext)ctdb.getMapData().get("clsCtx");
                ctdb.getMapData().put("appsParam", appsParam);
                String package_prefix2 = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppService.java", clsCtx.getClassName() + clsCtx.getServiceSuffix(), "XXXOsrvAppService", "facade", "src/main/java/" + package_prefix2 + "/" + GenFacdeTask.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/channel/srv/", appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbDtoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXDTO.java", "XXXDTO", "facade", "src/main/java/" + package_prefix + "/" + GenFacdeTask.formatClassPath(subsCode) + "/facade/channel/srv/dto/", appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbInputList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppServiceInput.java", "XXXOsrvAppServiceInput", "facade", "src/main/java/" + package_prefix + "/" + GenFacdeTask.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/channel/srv/dto/", appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbOutputList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppServiceInput.java", "XXXOsrvAppServiceInput", "facade", "src/main/java/" + package_prefix + "/" + GenFacdeTask.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/channel/srv/dto/", appInfo, ctdb);
            }
        }
    }

    private void initOsrvCtx(OsrvArrangeContext osrvCtx, List<SrvModelInoutDTO> inputParams, List<SrvModelInoutDTO> outputParams) {
        OsrvArrangeMethod method = new OsrvArrangeMethod();
        osrvCtx.setMethod(method);
        if (StringUtils.isNotBlank((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelMethod())) {
            method.setMethodName(osrvCtx.getSrvModelInfo().getSrvModelMethod());
        } else {
            method.setMethodName("handle");
        }
        this.getOsrvMethod(osrvCtx, inputParams, outputParams);
    }

    private void getOsrvMethod(OsrvArrangeContext osrvCtx, List<SrvModelInoutDTO> inputParams, List<SrvModelInoutDTO> outputParams) {
        OsrvArrangeMethod method = osrvCtx.getMethod();
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(osrvCtx.getSrvModelInfo().getSrvModelId());
        String input = this.getMethodParam(inputParams, osrvCtx, "Input");
        method.setInputListFlag(YesOrNO.NO.getCode());
        method.setInputBigFlag(YesOrNO.YES.getCode());
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Input);
        SrvModelInoutDTO inputInout = null;
        for (SrvModelInoutDTO inout : inputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            inputInout = inout;
        }
        mainParam = inputInout != null ? this.wrapperTableToClassName(inputInout.getTableModelCode(), inputInout.getObjectType().toString(), inputInout.getTableModelId()) : this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
        method.setMainInput("input.getInput()");
        method.setInput(input);
        String mainOutputParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Output);
        String output = this.getMethodParam(outputParams, osrvCtx, "Output");
        method.setOutputListFlag(YesOrNO.NO.getCode());
        method.setOutputBigFlag(YesOrNO.YES.getCode());
        SrvModelInoutDTO outputInout = null;
        for (SrvModelInoutDTO inout : outputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainOutputParam)) continue;
            outputInout = inout;
        }
        mainOutputParam = outputInout != null ? this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId()) : this.wrapperTableToClassName(mainOutputParam, ObjectType.Inout.getCode(), null);
        method.setOutput(output);
    }

    private CodeTemplateDataBo createBigDTO(OsrvArrangeContext osrvCtx, List<SrvModelInoutDTO> inoutParams, IOType ioType, Map<String, SrvModelInoutDTO> serverInoutMap) {
        HashMap otherFacadeImport = new HashMap();
        CodeTemplateDataBo bigBo = new CodeTemplateDataBo();
        PaasAppsInfo appInfo = osrvCtx.getAppInfo();
        String loginUserId = osrvCtx.getAppInfo().getLoginUserId();
        String mainParameter = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), ioType);
        bigBo.getEnvBo().setAuthor(loginUserId);
        bigBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bigBo.getEnvBo().setDesc(String.format("%s Facade DTO %s", appInfo.getAppName(), osrvCtx.getSrvModelInfo().getSrvModelName()));
        bigBo.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)mainParameter));
        bigBo.getMapData().put("tableClassName", mainParameter);
        ArrayList<Map> properties = new ArrayList<Map>();
        bigBo.getMapData().put("properties", properties);
        for (SrvModelInoutDTO inout : inoutParams) {
            serverInoutMap.put(inout.getTableModelCode(), inout);
            Map prop = MapBeanUtil.beanToMap((Object)inout);
            String propClass = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            prop.put("comment", String.format("%s %s", IOType.getIOType((String)inout.getIoType()).getName(), inout.getTableModelName()));
            prop.put("className", propClass);
            prop.put("propName", StringUtils.uncapitalize((String)propClass));
            ModelTableInfoDTO tableInfo = new ModelTableInfoDTO();
            tableInfo.setObjectId(inout.getTableModelId());
            tableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableInfo);
            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            prop.put("importType", importType);
            if (!tableInfo.getAppId().equals(appInfo.getAppId())) {
                PaasAppsInfoDTO otherAppParam = new PaasAppsInfoDTO();
                otherAppParam.setSubsId(appInfo.getSubsId());
                otherAppParam.setAppId(tableInfo.getAppId());
                List otherApps = this.paasAppsInfoService.queryList((Object)otherAppParam);
                if (CollectionUtils.isNotEmpty((Collection)otherApps)) {
                    PaasAppsInfoDTO otherApp = (PaasAppsInfoDTO)otherApps.get(0);
                    HashMap<String, String> importInfo = new HashMap<String, String>();
                    importInfo.put("projectCode", otherApp.getAppCode());
                    importInfo.put("className", propClass);
                    importInfo.put("propName", StringUtils.uncapitalize((String)propClass));
                    otherFacadeImport.put(propClass, importInfo);
                    prop.put("import", "N");
                    prop.put("projectCode", otherApp.getAppCode());
                }
            } else {
                prop.put("projectCode", appInfo.getAppCode());
                prop.put("import", "Y");
            }
            properties.add(prop);
        }
        bigBo.getMapData().put("otherFacadeImport", otherFacadeImport.values());
        return bigBo;
    }
}

