/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.portal.console.types.AppCreateWay;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasAppInitTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppInitTask.class);
    private PaasAppsInfoDO appInfo;

    public PaasAppInitTask(PaasAppsInfoDO appInfo) {
        this.appInfo = appInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        SSubsInfoPortalService sSubsInfoService = (SSubsInfoPortalService)SpringContextUtils.getBean(SSubsInfoPortalService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String userId = this.appInfo.getLoginUserId();
        try {
            if (StringUtils.equalsAny((CharSequence)this.appInfo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.BusinessApp.getCode()})) {
                modelTableInfoService.generateIsrvRspInfo(this.appInfo.getAppId());
                modelTableInfoService.generateUserTokenInfo(this.appInfo.getAppId());
                modelTableInfoService.generatePageInfo(this.appInfo.getAppId());
                modelTableInfoService.generateDateData(this.appInfo.getAppId());
                modelTableInfoService.generateGivenData(this.appInfo.getAppId());
                modelTableInfoService.generateRandomData(this.appInfo.getAppId());
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5e94\u7528\u516c\u5171\u6570\u636e\u6a21\u578b\u5931\u8d25 " + this.appInfo.getAppId() + " " + e.getMessage(), (Throwable)e);
        }
        try {
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String gitUrl;
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                if (StringUtils.isNotBlank((CharSequence)(gitUrl = this.appInfo.getAppGitUrl())) && !StringUtils.equalsAny((CharSequence)this.appInfo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.Middleware.getCode(), AppCategory.DBApp.getCode()}) && !StringUtils.equals((CharSequence)this.appInfo.getAppCreateWay(), (CharSequence)AppCreateWay.GitRepoCreate.getCode())) {
                    logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                    boolean result = true;
                    if (StringUtils.equals((CharSequence)"gitee", (CharSequence)gitType)) {
                        result = sSubsInfoService.giteeRepoHandler(gitUrl, userId, gitHostUrl, accessToken, Collections.emptyList(), this.appInfo.getAppName());
                    } else if (StringUtils.equals((CharSequence)"gitlab", (CharSequence)gitType)) {
                        result = sSubsInfoService.gitlabRepoHandler(gitUrl, userId, gitHostUrl, accessToken, Collections.emptyList(), this.appInfo.getAppName());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaSDK\u4ed3\u5e93\u5f02\u5e38 " + this.appInfo.getAppGitUrl() + " " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }
}

