/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.FadpaasPageRenderFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.IFadpaasPageRender;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskPagegenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskPagegenDTO;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelLogDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelSubpageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.dev.console.types.PageDevType;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageModelGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PageModelGenTask.class);
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");
    private PaasTaskInfoDTO taskInfo;
    private PaasTaskPagegenService paasPagegenService;
    private PaasAppsInfoService paasAppsInfoService;
    private ComBaseInfoService comBaseInfoService;
    private RdmModuleInfoService rdmModuleInfoService;
    private CodeProduceInfoService codeProduceInfoService;
    private PageModelInfoService pageModelInfoService;
    private PageModelLogService pageModelLogService;
    private PageModelParamService pageModelParamService;
    private PageTemplateInfoService pageTemplateInfoService;
    private PageTemplateFileService pageTemplateFileService;
    private PageModelFieldService pageModelFieldService;

    public PageModelGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List pageModelList;
            this.paasPagegenService = (PaasTaskPagegenService)SpringContextUtils.getBean(PaasTaskPagegenService.class);
            this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            this.comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
            this.rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
            this.codeProduceInfoService = (CodeProduceInfoService)SpringContextUtils.getBean(CodeProduceInfoService.class);
            this.pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            this.pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
            this.pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
            this.pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
            this.pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
            this.pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
            PaasTaskPagegenDTO pagegenDTO = new PaasTaskPagegenDTO();
            pagegenDTO.setTaskId(this.taskInfo.getTaskId());
            pagegenDTO = (PaasTaskPagegenDTO)this.paasPagegenService.queryByPk((Object)pagegenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String pageModelId = pagegenDTO.getPageModelId();
            String comId = pagegenDTO.getComId();
            String genPath = pagegenDTO.getGenPath();
            PageModelInfoDTO pageParam = new PageModelInfoDTO();
            pageParam.setSubsId(subsId);
            pageParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)pageModelId)) {
                pageParam.setPageModelId(pageModelId);
            }
            if (StringUtils.isNotBlank((CharSequence)comId)) {
                pageParam.setComId(comId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(pageModelList = this.pageModelInfoService.queryList((Object)pageParam)))) {
                String rootPath;
                File rootDir;
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                String appTemplatePath = templatePullTask.getAppTemplatePath() + File.separator + "page";
                String nowTime = CurrentDateUtil.getTodayDate();
                if (StringUtils.isBlank((CharSequence)genPath)) {
                    genPath = StringUtils.equals((CharSequence)appInfo.getAppType(), (CharSequence)AppType.A99.getCode()) ? "page/${comFeatureCodePackage}/" : (StringUtils.equals((CharSequence)appInfo.getAppType(), (CharSequence)AppType.A91.getCode()) ? "src/pages/${comFeatureCodePackage}/" : "${appCode}-start/src/main/resources/front/page/${comFeatureCodePackage}/");
                }
                if (!(rootDir = new File(rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId)).exists()) {
                    rootDir.mkdirs();
                }
                PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
                Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
                String packagePrefixVal = "com.irdstudio";
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
                    packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
                }
                String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                for (PageModelInfoDTO pageModel : pageModelList) {
                    pageModel.setLoginUserId(this.taskInfo.getLoginUserId());
                    String comFeatureCodePackage = "";
                    RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                    moduleInfo.setModuleId(pageModel.getModuleId());
                    moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
                    if (moduleInfo != null) {
                        comFeatureCodePackage = moduleInfo.getFeatureCode();
                        packagePrefixVal = moduleInfo.getOrgCode();
                    }
                    String appCodePackage = (packagePrefixVal + "." + comFeatureCodePackage).replaceAll("_|\\.|-", "/");
                    HashMap<String, String> expMap = new HashMap<String, String>();
                    expMap.put("appCode", SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode()));
                    expMap.put("appCodePackage", appCodePackage);
                    expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
                    String pageGenPath = ExpressionUtil.parse((String)genPath, expMap);
                    String targetPath = new File(SdEnvUtil.PROJECT_PATH + pageModel.getPageModelId() + File.separator + pageGenPath).getAbsolutePath();
                    if (StringUtils.equals((CharSequence)pageModel.getPageDevType(), (CharSequence)PageDevType.LowCodeConfig.getCode())) {
                        Map<String, String> pageModelJson;
                        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
                        ctdb.getEnvBo().setAuthor(userId);
                        ctdb.getEnvBo().setDesc(pageModel.getPageModelName());
                        ctdb.getEnvBo().setCurrentDate(nowTime);
                        Map root = ctdb.getMapData();
                        root.put("pageModel", pageModel);
                        root.put("optionList", Collections.emptyList());
                        root.put("BASE_PATH", this.getBasePath(comFeatureCodePackage.replaceAll("_|\\.|-", "/")));
                        if (StringUtils.isNotBlank((CharSequence)pageModel.getPageModelJson())) {
                            pageModelJson = (Map)JSON.parseObject((String)pageModel.getPageModelJson(), Map.class);
                            root.put("pageModelJson", pageModelJson);
                        } else {
                            pageModelJson = new HashMap<String, String>();
                            pageModelJson.put("ruleJson", "[]");
                            pageModelJson.put("optionsJson", "[]");
                            root.put("pageModelJson", Collections.emptyMap());
                        }
                        this.codeProduceInfoService.produceCodeFile("page", "XXXLCPage.html", pageModel.getPageModelCode(), "XXX", pageModel.getPageModelId(), null, pageGenPath, appInfo.getAppId(), ctdb);
                    } else {
                        ArrayList routes = new ArrayList();
                        IFadpaasPageRender render = FadpaasPageRenderFactory.get((String)(pageModel.getPageModelCategory() + pageModel.getPageModelType()));
                        if (render != null) {
                            render.render(pageModel, appTemplatePath, targetPath, Collections.emptyMap(), routes);
                        } else {
                            PageModelParamDTO param = new PageModelParamDTO();
                            param.setPageModelId(pageModel.getPageModelId());
                            param.setQueryRef("query");
                            List paramList = this.pageModelParamService.queryList((Object)param);
                            if (StringUtils.isBlank((CharSequence)pageModel.getPageTemplateId())) {
                                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", pageModel.getPageModelCode()));
                                continue;
                            }
                            PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
                            templateParam.setAppTemplateId(pageModel.getPageTemplateId());
                            PageTemplateInfoDTO template = (PageTemplateInfoDTO)this.pageTemplateInfoService.queryByPk((Object)templateParam);
                            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
                            fileParam.setPageTemplateId(template.getPageTemplateId());
                            fileParam.setSize(Integer.valueOf(1000));
                            List fileList = this.pageTemplateFileService.queryList((Object)fileParam);
                            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateCode();
                            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                                for (PageTemplateFileDTO file : fileList) {
                                    String templateName = file.getFileName() + ".vm";
                                    String tempPath = localAppTemplatePath + File.separator + templateName;
                                    File tempFile = new File(tempPath);
                                    if (!tempFile.exists()) continue;
                                    try {
                                        Object oriFileName;
                                        String packagePath = comFeatureCodePackage.replaceAll("_|\\.|-", "/");
                                        String basePath = this.getBasePath(packagePath);
                                        Map<String, Object> root = this.prepareParam(pageModel, paramList, appTemplatePath, basePath);
                                        ArrayList dataCodes = new ArrayList();
                                        paramList.forEach(pageModelParamVO -> {
                                            List fields = pageModelParamVO.getFields();
                                            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                                                fields.forEach(f -> {
                                                    if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                                        dataCodes.add(f.getFieldOption());
                                                    }
                                                });
                                            }
                                        });
                                        String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                                        root.put("BASE_PATH", basePath);
                                        root.put("pageModelInfo", pageModel);
                                        root.put("dataCodeJoin", dataCodeJoin);
                                        root.put("localAppTemplatePath", localAppTemplatePath);
                                        String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                                        File targetDir = new File(targetPath + File.separator + packagePath);
                                        if (!targetDir.exists()) {
                                            targetDir.mkdirs();
                                        }
                                        if (!StringUtils.endsWith((CharSequence)(oriFileName = pageModel.getPageModelCode()), (CharSequence)".html")) {
                                            oriFileName = (String)oriFileName + ".html";
                                        }
                                        File targetFile = new File(targetDir, (String)oriFileName);
                                        try (FileOutputStream output = new FileOutputStream(targetFile);){
                                            IOUtils.write((String)html, (OutputStream)output, (String)"utf-8");
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    PageModelLogDTO genLog = new PageModelLogDTO();
                    genLog.setLogId(UUIDUtil.getUUID());
                    BeanUtility.beanCopy((Object)pageModel, (Object)genLog);
                    genLog.setCreateUser(userId);
                    genLog.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    genLog.setGenState("S");
                    this.pageModelLogService.insert((Object)genLog);
                    String id = pageModel.getPageModelId();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    if (idDir.exists()) {
                        FileUtils.copyDirectory((File)idDir, (File)rootDir);
                    }
                    pageModel.setModelStat(ModelStat.Generated.getCode());
                    this.pageModelInfoService.updateByPk((Object)pageModel);
                }
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u9875\u9762\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u9875\u9762\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getBasePath(String codePackagePath) {
        String[] strs = StringUtils.split((String)codePackagePath, (String)"/");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("..");
        for (String s : strs) {
            paths.add("..");
        }
        return StringUtils.join(paths, (String)"/");
    }

    public String wrapperPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public String replaceSuffix(String fileName) {
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public boolean renderOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath, Map<String, Object> root, String targetPath, String packagePath, File targetDir) throws Exception {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = false;
        if (tempFile.exists()) {
            String content = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)templateFile, root);
            File contentTargetDir = new File(targetPath + File.separator + packagePath);
            if (!contentTargetDir.exists()) {
                contentTargetDir.mkdirs();
            }
            String fileName = this.replaceSuffix(pageModelCode) + suffix;
            File file = new File(targetDir, fileName);
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.write((String)content, (OutputStream)output, (String)"utf-8");
            }
            flag = true;
        }
        return flag;
    }

    public boolean checkOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath) {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = tempFile.exists();
        return flag;
    }

    public Map<String, Object> prepareParam(PageModelInfoDTO modelInfo, List<PageModelParamDTO> paramList, String appTemplatePath, String basePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("BASE_PATH", "../../../");
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                if (!ParamType.kv.getCode().equals(param.getParamType())) {
                    if (CollectionUtils.isNotEmpty((Collection)param.getFields()) && (ParamType.fields.getCode().equals(param.getParamType()) || ParamType.formFields.getCode().equals(param.getParamType()))) {
                        root.put(paramCode, param.getFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getQueryFields()) && ParamType.conds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getQueryFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getButtons()) && ParamType.buttons.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getButtons());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getLinkeds()) && ParamType.linkeds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getLinkeds());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getSubspages()) && ParamType.subpages.getCode().equals(param.getParamType())) {
                        List subpages = param.getSubspages();
                        ArrayList<Map<String, Object>> subPageMapList = new ArrayList<Map<String, Object>>();
                        if (CollectionUtils.isNotEmpty((Collection)subpages)) {
                            for (PageModelSubpageDTO sub : subpages) {
                                Map<String, Object> subPageParam = this.fetchSubPageParam(modelInfo, sub, sub.getModelInfo(), appTemplatePath, basePath);
                                subPageMapList.add(subPageParam);
                            }
                        }
                        root.put(paramCode, subPageMapList);
                        continue;
                    }
                    try {
                        List list = JSON.parseArray((String)param.getParamValue(), Map.class);
                        root.put(paramCode, list);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u53c2\u6570json\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    public String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }

    public Map<String, String> createPackageMap(List<PageModelPackageDTO> packageList) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(packageList)) {
            HashMap<String, PageModelPackageDTO> map = new HashMap<String, PageModelPackageDTO>();
            for (PageModelPackageDTO p : packageList) {
                map.put(p.getPackageId(), p);
            }
            for (PageModelPackageDTO p : packageList) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(p.getPackageCode());
                PageModelPackageDTO parent = (PageModelPackageDTO)map.get(p.getPackageAbvId());
                while (parent != null) {
                    paths.add(parent.getPackageCode());
                    parent = (PageModelPackageDTO)map.get(parent.getPackageAbvId());
                }
                Collections.reverse(paths);
                pathMap.put(p.getPackageId(), StringUtils.join(paths, (String)File.separator));
            }
        }
        return pathMap;
    }

    public Map<String, String> createRoute(String packagePath, File page) {
        Object[] paths = StringUtils.split((String)(packagePath + File.separator + this.replaceSuffix(page.getName())), (String)File.separator);
        String path = StringUtils.join((Object[])paths, (String)"/");
        HashMap<String, String> route = new HashMap<String, String>();
        route.put("path", path);
        route.put("name", StringUtils.join((Object[])paths, (String)"-"));
        route.put("pageName", page.getName());
        return route;
    }

    public Map<String, Object> fetchSubPageParam(PageModelInfoDTO rootModelInfo, PageModelSubpageDTO subPage, PageModelInfoDTO modelInfo, String appTemplatePath, String basePath) {
        if (modelInfo != null) {
            PageTemplateFileDTO file;
            String templateName;
            String tempPath;
            File tempFile;
            PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
            PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
            PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
            PageModelParamDTO param = new PageModelParamDTO();
            param.setPageModelId(modelInfo.getPageModelId());
            param.setSize(Integer.valueOf(1000));
            param.setQueryRef("query");
            List paramList = pageModelParamService.queryList((Object)param);
            if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                return Collections.emptyMap();
            }
            PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
            templateParam.setPageTemplateId(modelInfo.getPageTemplateId());
            PageTemplateInfoDTO template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)templateParam);
            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
            fileParam.setPageTemplateId(template.getPageTemplateId());
            List fileList = pageTemplateFileService.queryList((Object)fileParam);
            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateId();
            if (CollectionUtils.isNotEmpty((Collection)fileList) && (tempFile = new File(tempPath = localAppTemplatePath + File.separator + (templateName = (file = (PageTemplateFileDTO)fileList.get(0)).getFileName() + ".vm"))).exists()) {
                Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                ArrayList dataCodes = new ArrayList();
                paramList.forEach(pageModelParamVO -> {
                    List fields = pageModelParamVO.getFields();
                    if (CollectionUtils.isNotEmpty((Collection)fields)) {
                        fields.forEach(f -> {
                            if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                dataCodes.add(f.getFieldOption());
                            }
                        });
                    }
                });
                String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                root.put("templateName", templateName);
                root.put("templateFilePrefix", this.replaceSuffix(file.getFileName()));
                root.put("rootModelInfo", rootModelInfo);
                root.put("subPage", subPage);
                root.put("BASE_PATH", basePath);
                root.put("pageModelInfo", modelInfo);
                root.put("dataCodeJoin", dataCodeJoin);
                root.put("localAppTemplatePath", localAppTemplatePath);
                ArrayList<String> jsList = new ArrayList<String>();
                File localTemplateFile = new File(localAppTemplatePath);
                if (localTemplateFile.exists()) {
                    File[] files;
                    for (File f : files = localTemplateFile.listFiles()) {
                        if (!StringUtils.endsWithAny((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{".js.vm"})) continue;
                        jsList.add(f.getName());
                    }
                }
                root.put("jsList", jsList);
                boolean jsFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath);
                boolean cssFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath);
                root.put("jsFlag", jsFlag);
                root.put("cssFlag", cssFlag);
                return root;
            }
        }
        return Collections.emptyMap();
    }
}

