/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskMetascanService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskMetascanDTO;
import com.irdstudio.allinapaas.portal.console.types.DataStdFlag;
import com.irdstudio.allinapaas.portal.console.types.MetaPackageOption;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ConflictType;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScExcelMetaTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ScExcelMetaTask.class);
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+)[,\uff0c]?(\\d*)(\\s+BYTE)*\\s*\\)");
    private static final Pattern DICT_PATTERN = Pattern.compile("(\\S+?)\\[\\S+\\]");
    private PaasTaskInfoDTO taskInfo;

    public ScExcelMetaTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            PaasTaskMetascanService paasTaskMetascanService = (PaasTaskMetascanService)SpringContextUtils.getBean(PaasTaskMetascanService.class);
            PaasTaskMetascanDTO metaScan = new PaasTaskMetascanDTO();
            metaScan.setTaskId(this.taskInfo.getTaskId());
            metaScan = (PaasTaskMetascanDTO)paasTaskMetascanService.queryByPk((Object)metaScan);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskOption = metaScan.getTaskOption();
            String taskPackageId = metaScan.getPackageId();
            String packageOption = StringUtils.isBlank((CharSequence)metaScan.getPackageOption()) ? MetaPackageOption.SourcePackage.getCode() : metaScan.getPackageOption();
            String conflict = StringUtils.equals((CharSequence)taskOption, (CharSequence)"1") ? "recover" : "skip";
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            ModelTableIndexService modelTableIndexService = (ModelTableIndexService)SpringContextUtils.getBean(ModelTableIndexService.class);
            ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
            ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
            DictOptionInfoService dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
            SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            if (appInfo == null) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u672a\u9009\u62e9\u5e94\u7528");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            subsInfo.setSubsId(subsId);
            subsInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)subsInfo);
            String dslId = subsInfo.getDslId();
            String metaTaskRootPath = SdEnvUtil.METATASK_PATH;
            File file = new File(metaTaskRootPath, this.taskInfo.getTaskId() + ".xlsx");
            if (!file.exists()) {
                file = new File(metaTaskRootPath, this.taskInfo.getTaskId() + ".xls");
            }
            if (!file.exists()) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u91c7\u96c6\u6587\u4ef6\u4e0d\u5b58\u5728");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            String packageId = "";
            if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                packageId = taskPackageId;
            } else {
                ModelFolderInfoDTO packageParam = new ModelFolderInfoDTO();
                packageParam.setAppId(appId);
                packageParam.setFolderCode("TABLE");
                List tablePackageList = modelFolderInfoService.queryListByPage((Object)packageParam);
                packageId = appId;
                if (CollectionUtils.isNotEmpty((Collection)tablePackageList)) {
                    packageId = ((ModelFolderInfoDTO)tablePackageList.get(0)).getFolderId();
                }
            }
            TableInfoListener listener = new TableInfoListener();
            ((ExcelReaderBuilder)EasyExcel.read((File)file, (ReadListener)listener).headRowNumber(Integer.valueOf(4))).doReadAll();
            List<ExcelTableContext> excelDataList = listener.getTableInfoList();
            List<ProjectIndex> projectIndexList = listener.getIndexPackageInfoList();
            Map<String, ProjectIndex> objectCodePackageMap = this.handlePackageInfo(appId, packageId, userId, projectIndexList);
            for (ExcelTableContext ctx : excelDataList) {
                ModelTableInfoDTO tableInfo = ctx.tableInfo;
                List<ModelTableIndexDTO> indexs = ctx.indexs;
                AtomicInteger indexLen = ctx.indexLen;
                List<ModelTableFieldDTO> fields = ctx.fields;
                ModelTableIndexDTO primaryKey = ctx.primaryKey;
                String createTime = CurrentDateUtil.getTodayDateEx2();
                String createUser = userId;
                ProjectIndex packageInfo = objectCodePackageMap.get(tableInfo.getObjectCode());
                ModelTableInfoDTO checkParam = new ModelTableInfoDTO();
                checkParam.setAppId(appId);
                checkParam.setObjectCode(tableInfo.getObjectCode());
                List exists = modelTableInfoService.queryListByPage((Object)checkParam);
                if (CollectionUtils.isNotEmpty((Collection)exists)) {
                    if (conflict.equals(ConflictType.skip.getCode())) {
                        logger.info(String.format("%s\u6a21\u578b\u5e93\u4e2d\u5b58\u5728%s, \u4e14\u5904\u7406\u65b9\u5f0f\u4e3a\u8df3\u8fc7", appId, tableInfo.getObjectCode()));
                        continue;
                    }
                    ModelTableInfoDTO model = (ModelTableInfoDTO)exists.get(0);
                    modelTableFieldService.deleteByObjectId(model.getObjectId());
                    modelTableIndexService.deleteByObjectId(model.getObjectId());
                    model = (ModelTableInfoDTO)exists.get(0);
                    model.setObjectName(tableInfo.getObjectName());
                    model.setObjectDesc(tableInfo.getObjectDesc());
                    if (packageInfo != null) {
                        model.setFolderId(packageInfo.getPackageId());
                        model.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)packageInfo.getSeq(), (int)1)));
                        model.setObjectDesc(packageInfo.getObjectDesc());
                    }
                    if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                        model.setFolderId(taskPackageId);
                    }
                    tableInfo = model;
                    tableInfo.setLastModifyUser(createUser);
                    tableInfo.setLastModifyTime(createTime);
                    modelTableInfoService.updateByPk((Object)tableInfo);
                } else {
                    tableInfo.setObjectId(UUIDUtil.getUUID());
                    tableInfo.setAppId(appId);
                    tableInfo.setSubsId(subsId);
                    tableInfo.setFolderId(packageId);
                    tableInfo.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Table.getCode())));
                    tableInfo.setCreateUser(createUser);
                    tableInfo.setCreateTime(createTime);
                    tableInfo.setLastModifyUser(createUser);
                    tableInfo.setLastModifyTime(createTime);
                    if (packageInfo != null) {
                        tableInfo.setFolderId(packageInfo.getPackageId());
                        tableInfo.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)packageInfo.getSeq(), (int)1)));
                    }
                    if (StringUtils.equalsAny((CharSequence)MetaPackageOption.SpecifiedPackage.getCode(), (CharSequence[])new CharSequence[]{packageOption}) && StringUtils.isNotBlank((CharSequence)taskPackageId)) {
                        tableInfo.setFolderId(taskPackageId);
                    }
                    modelTableInfoService.insert((Object)tableInfo);
                }
                for (ModelTableIndexDTO index : indexs) {
                    index.setObjectId(tableInfo.getObjectId());
                    index.setCreateUser(createUser);
                    index.setCreateTime(createTime);
                    index.setLastModifyUser(createUser);
                    index.setLastModifyTime(createTime);
                    index.setIndexName(StringUtils.upperCase((String)index.getIndexName()));
                    modelTableIndexService.insert((Object)index);
                }
                for (ModelTableFieldDTO field : fields) {
                    field.setObjectId(tableInfo.getObjectId());
                    field.setFieldId(UUIDUtil.getUUID());
                    field.setCreateTime(createTime);
                    field.setCreateUser(createUser);
                    field.setLastModifyUser(createUser);
                    field.setLastModifyTime(createTime);
                    field.setDataStdFlag(DataStdFlag.Auto.getCode());
                    if (!StringUtils.isNotBlank((CharSequence)field.getDictId())) continue;
                    DictOptionInfoDTO dictParam = new DictOptionInfoDTO();
                    dictParam.setDictId(field.getDictId());
                    dictParam.setSubsId(dslId);
                    dictParam.setSubsId(subsId);
                    List optionList = dictOptionInfoService.queryListByPage((Object)dictParam);
                    if (CollectionUtils.isEmpty((Collection)optionList)) {
                        dictParam.setDictCode(field.getDictId());
                        optionList = dictOptionInfoService.queryListByPage((Object)dictParam);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)optionList)) continue;
                    DictOptionInfoDTO optionInfo = (DictOptionInfoDTO)optionList.get(0);
                    field.setDictId(optionInfo.getDictId());
                    field.setDictDslId(optionInfo.getSubsId());
                    field.setFieldOption(optionInfo.getDictCode());
                }
                modelTableFieldService.batchInsert(fields);
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u6a21\u578b\u91c7\u96c6 \u4eceexcel\u4e2d\u8bfb\u53d6\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6a21\u578b\u91c7\u96c6 \u4eceexcel\u4e2d\u8bfb\u53d6\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private Map<String, ProjectIndex> handlePackageInfo(String projectId, String packageId, String userId, List<ProjectIndex> indexPackageInfoList) {
        if (CollectionUtils.isEmpty(indexPackageInfoList)) {
            return Collections.EMPTY_MAP;
        }
        ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
        HashMap<String, ProjectIndex> tablePackageMap = new HashMap<String, ProjectIndex>();
        HashMap<String, String> packageNameMap = new HashMap<String, String>();
        HashMap<String, ModelFolderInfoDTO> insertPackageMap = new HashMap<String, ModelFolderInfoDTO>();
        int i = 1;
        String now = CurrentDateUtil.getTodayDateEx2();
        for (ProjectIndex p : indexPackageInfoList) {
            ModelFolderInfoDTO objPackage;
            if (StringUtils.equals((CharSequence)p.getSeq(), (CharSequence)"\u5e8f\u53f7")) continue;
            if (StringUtils.isBlank((CharSequence)p.getPackageName())) {
                p.setPackageId(packageId);
            } else if (packageNameMap.get(p.getPackageName()) == null) {
                packageNameMap.put(p.getPackageName(), p.getPackageName());
                objPackage = new ModelFolderInfoDTO();
                objPackage.setFolderName(p.getPackageName());
                objPackage.setAppId(projectId);
                objPackage.setFolderType(ObjectType.Table.getIntCode());
                objPackage.setFolderAbvId(packageId);
                List checkList = modelFolderInfoService.queryListByPage((Object)objPackage);
                if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                    objPackage = (ModelFolderInfoDTO)checkList.get(0);
                } else {
                    objPackage.setFolderId(UUIDUtil.getUUID());
                    objPackage.setFolderCode((String)(StringUtils.isNotBlank((CharSequence)p.getPackageCode()) ? p.getPackageCode() : "p" + i));
                    objPackage.setFolderName(p.getPackageName());
                    objPackage.setFolderDesc(p.getPackageName());
                    objPackage.setFolderType(ObjectType.Table.getIntCode());
                    objPackage.setOrderValue(Integer.valueOf(i));
                    objPackage.setCreateTime(now);
                    objPackage.setCreateUser(userId);
                    modelFolderInfoService.insert((Object)objPackage);
                    ++i;
                }
                insertPackageMap.put(p.getPackageName(), objPackage);
                p.setPackageId(objPackage.getFolderId());
            } else {
                objPackage = (ModelFolderInfoDTO)insertPackageMap.get(p.getPackageName());
                if (objPackage != null) {
                    p.setPackageId(objPackage.getFolderId());
                }
            }
            tablePackageMap.put(p.objectCode, p);
        }
        return tablePackageMap;
    }

    public static class ProjectIndex {
        private String seq;
        private String packageId;
        private String packageCode;
        private String packageName;
        private String objectCode;
        private String objectName;
        private String objectDesc;

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getObjectCode() {
            return this.objectCode;
        }

        public void setObjectCode(String objectCode) {
            this.objectCode = objectCode;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        public String getObjectDesc() {
            return this.objectDesc;
        }

        public void setObjectDesc(String objectDesc) {
            this.objectDesc = objectDesc;
        }

        public String getPackageCode() {
            return this.packageCode;
        }

        public void setPackageCode(String packageCode) {
            this.packageCode = packageCode;
        }
    }

    public static class ExcelTableContext {
        ModelTableInfoDTO tableInfo = new ModelTableInfoDTO();
        List<ModelTableIndexDTO> indexs = new ArrayList<ModelTableIndexDTO>();
        AtomicInteger indexLen = new AtomicInteger(0);
        List<ModelTableFieldDTO> fields = new ArrayList<ModelTableFieldDTO>();
        ModelTableIndexDTO primaryKey;
    }

    public static class TableInfoListener
    extends AnalysisEventListener<Map<Integer, String>> {
        private List<ProjectIndex> indexPackageInfoList = new ArrayList<ProjectIndex>();
        private List<ExcelTableContext> tableInfoList = new ArrayList<ExcelTableContext>();
        private ExcelTableContext tableCtx = new ExcelTableContext();

        public List<ExcelTableContext> getTableInfoList() {
            return this.tableInfoList;
        }

        public List<ProjectIndex> getIndexPackageInfoList() {
            return this.indexPackageInfoList;
        }

        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                if (headMap.get(0) != null && StringUtils.equals((CharSequence)headMap.get(0), (CharSequence)"\u82f1\u6587\u8868\u540d")) {
                    return;
                }
                if (headMap.size() < 3) {
                    return;
                }
                ProjectIndex index = new ProjectIndex();
                if (headMap.get(0) != null) {
                    index.setObjectCode(StringUtils.lowerCase((String)headMap.get(0)));
                }
                if (headMap.get(1) != null) {
                    index.setObjectName(headMap.get(1));
                }
                if (headMap.get(2) != null) {
                    index.setPackageName(headMap.get(2));
                }
                if (headMap.get(3) != null) {
                    index.setPackageCode(StringUtils.lowerCase((String)headMap.get(3)));
                }
                this.indexPackageInfoList.add(index);
                return;
            }
            logger.debug(headMap.toString());
            if (StringUtils.startsWith((CharSequence)headMap.get(0), (CharSequence)"\u82f1\u6587\u8868\u540d")) {
                this.tableCtx.tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(1)));
            } else if (StringUtils.startsWith((CharSequence)headMap.get(0), (CharSequence)"\u4e2d\u6587\u8868\u540d")) {
                this.tableCtx.tableInfo.setObjectName(headMap.get(1));
            } else if (StringUtils.startsWith((CharSequence)headMap.get(0), (CharSequence)"\u8868\u7528\u9014")) {
                this.tableCtx.tableInfo.setObjectDesc(headMap.get(1));
            }
        }

        public void invoke(Map<Integer, String> data, AnalysisContext context) {
            Matcher m;
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                if (data.size() < 3) {
                    return;
                }
                ProjectIndex index = new ProjectIndex();
                if (data.get(0) != null) {
                    index.setObjectCode(StringUtils.lowerCase((String)data.get(0)));
                }
                if (data.get(1) != null) {
                    index.setObjectName(data.get(1));
                }
                if (data.get(2) != null) {
                    index.setPackageName(data.get(2));
                }
                if (data.get(3) != null) {
                    index.setPackageCode(data.get(3));
                }
                this.indexPackageInfoList.add(index);
                return;
            }
            logger.debug(data.toString());
            int len = data.size();
            if (StringUtils.isNotEmpty((CharSequence)data.get(0)) && data.get(0).equals("\u5e8f\u53f7")) {
                int fieldIndex = context.readRowHolder().getRowIndex();
                this.tableCtx.indexLen.set(fieldIndex + 1);
                return;
            }
            String fieldOrder = StringUtils.lowerCase((String)data.get(0));
            String fieldCode = StringUtils.lowerCase((String)data.get(1));
            String fieldName = data.get(2);
            String fieldType = data.get(3);
            String isAllowNull = data.get(5);
            String fieldDesc = data.get(2);
            String isPk = data.get(7);
            String dictId = data.get(10);
            if (StringUtils.containsAny((CharSequence)dictId, (CharSequence[])new CharSequence[]{"[", "]"}) && (m = DICT_PATTERN.matcher(dictId)).matches()) {
                dictId = m.group(1);
            }
            logger.debug(fieldCode + "-" + fieldName);
            ModelTableFieldDTO field = new ModelTableFieldDTO();
            field.setFieldOrder(Integer.valueOf(context.readRowHolder().getRowIndex() - this.tableCtx.indexLen.get()));
            field.setFieldCode(fieldCode);
            field.setFieldName(fieldName);
            if (fieldType.contains("(")) {
                field.setFieldType(fieldType.substring(0, fieldType.indexOf("(")));
                Matcher matcher = pattern.matcher(fieldType);
                if (matcher.matches()) {
                    field.setFieldLength(Integer.valueOf(matcher.group(1)));
                    if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                        field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                    }
                }
            } else {
                field.setFieldType(fieldType);
            }
            field.setFieldDesc(fieldDesc);
            if (isAllowNull != null && (isAllowNull.equals("N") || isAllowNull.equals("Y"))) {
                field.setIsAllowNull(isAllowNull);
            } else {
                field.setIsAllowNull(isAllowNull != null && isAllowNull.equals("\u662f") ? "Y" : "N");
            }
            if (StringUtils.equals((CharSequence)isPk, (CharSequence)"Y")) {
                field.setIsPk("Y");
                if (this.tableCtx.primaryKey == null) {
                    ModelTableIndexDTO primary = new ModelTableIndexDTO();
                    primary.setIndexFields(fieldCode);
                    primary.setIndexName("PK_" + this.tableCtx.tableInfo.getObjectCode());
                    primary.setIndexTypePrimary("Y");
                    primary.setIndexTypeUnique("N");
                    this.tableCtx.indexs.add(primary);
                    this.tableCtx.primaryKey = primary;
                } else {
                    String indexField = this.tableCtx.primaryKey.getIndexFields();
                    this.tableCtx.primaryKey.setIndexFields(indexField + "," + fieldCode);
                }
            } else {
                field.setIsPk("N");
            }
            field.setDictId(dictId);
            this.tableCtx.fields.add(field);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
            int sheetNo = context.readSheetHolder().getSheetNo();
            if (sheetNo == 0) {
                return;
            }
            this.tableInfoList.add(this.tableCtx);
            this.tableCtx = new ExcelTableContext();
        }
    }
}

