/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.quality.console.application.service.check.scheme.impl.srv;

import com.irdstudio.allinapaas.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinapaas.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinapaas.quality.console.types.CheckScope;
import com.irdstudio.allinapaas.quality.console.types.RuleResult;
import com.irdstudio.allinapaas.quality.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalInsertService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalOutService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalUpdateService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlCondService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelValidateService;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvEvalUpdateDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAS002Rule
implements CheckJavaRule {
    private static final Logger logger = LoggerFactory.getLogger(RAS002Rule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String serialNo, SCheckRuleDTO rule, Map<String, Object> param, IConnPool connTool) {
        SCheckResultDTO ruleResult = new SCheckResultDTO();
        ruleResult.setSerialNo(serialNo);
        ruleResult.setSchemeNo(rule.getSchemeNo());
        ruleResult.setRuleId(rule.getRuleId());
        ruleResult.setRuleName(rule.getRuleName());
        RuleResult flag = RuleResult.Pass;
        ArrayList<SCheckResultDtlDTO> ruleResultDtlList = new ArrayList<SCheckResultDtlDTO>();
        CheckScope ruleScope = (CheckScope)param.get("ruleScope");
        boolean resultFlag = true;
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SrvModelInfoService srvModelInfoService = (SrvModelInfoService)SpringContextUtils.getBean(SrvModelInfoService.class);
            SrvModelInfoDTO srvParam = new SrvModelInfoDTO();
            if (ruleScope == CheckScope.Subs) {
                String srvModelId = MapUtils.getString(param, (Object)"srvModelId");
                srvParam.setSrvModelId(srvModelId);
            } else if (ruleScope == CheckScope.Subs) {
                String subsId = MapUtils.getString(param, (Object)"subsId");
                srvParam.setSubsId(subsId);
            } else {
                String appId = MapUtils.getString(param, (Object)"appId");
                srvParam.setAppId(appId);
            }
            srvParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.SrvServer.getCode()));
            List checkList = srvModelInfoService.queryList((Object)srvParam);
            for (SrvModelInfoDTO srvModelInfo : checkList) {
                RuleResult tmpFlag = this.checkSrvModelInfo(srvModelInfo, ruleResultDtlList, rule, param, conn = connTool.getConnection(conn));
                if (tmpFlag == RuleResult.Pass) continue;
                flag = tmpFlag;
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u670d\u52a1\u6821\u9a8c " + e.getMessage(), (Throwable)e);
            resultFlag = false;
            ruleResult.setRuleResult(flag.getCode());
            ruleResult.setCreateUser(rule.getLoginUserId());
            ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            ruleResult.setRuleResult(RuleResult.Error.getCode());
            try {
                SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
                sCheckResultService.insert((Object)ruleResult);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
            catch (Exception e1) {
                logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e1.getMessage(), (Object)e1);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        ruleResult.setRuleResult(flag.getCode());
        ruleResult.setCreateUser(rule.getLoginUserId());
        ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        try {
            SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
            SCheckResultDtlService sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
            sCheckResultService.insert((Object)ruleResult);
            if (CollectionUtils.isNotEmpty(ruleResultDtlList)) {
                for (SCheckResultDtlDTO dtl : ruleResultDtlList) {
                    String subsId = MapUtils.getString(param, (Object)"subsId");
                    String subsCode = MapUtils.getString(param, (Object)"subsCode");
                    String subsName = MapUtils.getString(param, (Object)"subsName");
                    String appId = MapUtils.getString(param, (Object)"appId");
                    String appCode = MapUtils.getString(param, (Object)"appCode");
                    String appName = MapUtils.getString(param, (Object)"appName");
                    String appType = MapUtils.getString(param, (Object)"appType");
                    String objectId = MapUtils.getString(param, (Object)"objectId");
                    String objectCode = MapUtils.getString(param, (Object)"objectCode");
                    String objectName = MapUtils.getString(param, (Object)"objectName");
                    String dtlId = UUIDUtil.getUUID();
                    dtl.setSerialNo(serialNo);
                    dtl.setRuleId(rule.getRuleId());
                    dtl.setRuleName(rule.getRuleName());
                    dtl.setDtlId(dtlId);
                    dtl.setAppId(appId);
                    dtl.setAppCode(appCode);
                    dtl.setAppName(appName);
                    dtl.setSubsId(subsId);
                    dtl.setSubsCode(subsCode);
                    dtl.setSubsName(subsName);
                    dtl.setAppType(appType);
                    dtl.setObjectId(objectId);
                    dtl.setObjectCode(objectCode);
                    dtl.setObjectName(objectName);
                    dtl.setCreateUser(rule.getLoginUserId());
                }
                sCheckResultDtlService.batchInsert(ruleResultDtlList);
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return resultFlag;
    }

    private RuleResult checkSrvModelInfo(SrvModelInfoDTO srvModelInfo, List<SCheckResultDtlDTO> ruleResultDtlList, SCheckRuleDTO rule, Map<String, Object> param, Connection conn) throws Exception {
        RuleResult flag = RuleResult.Pass;
        boolean genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        String testExp = rule.getRuleSucCondition();
        String errorMsgExp = rule.getRuleErrDesc();
        SrvModelInoutService srvModelInoutService = (SrvModelInoutService)SpringContextUtils.getBean(SrvModelInoutService.class);
        ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        IsrvEvalUpdateService isrvEvalUpdateService = (IsrvEvalUpdateService)SpringContextUtils.getBean(IsrvEvalUpdateService.class);
        IsrvEvalInsertService isrvEvalInsertService = (IsrvEvalInsertService)SpringContextUtils.getBean(IsrvEvalInsertService.class);
        IsrvEvalOutService isrvEvalOutService = (IsrvEvalOutService)SpringContextUtils.getBean(IsrvEvalOutService.class);
        IsrvSqlCondService isrvSqlCondService = (IsrvSqlCondService)SpringContextUtils.getBean(IsrvSqlCondService.class);
        SrvModelValidateService srvModelValidateService = (SrvModelValidateService)SpringContextUtils.getBean(SrvModelValidateService.class);
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(srvModelInfo.getSrvModelId());
        List inoutList = srvModelInoutService.queryList((Object)inoutParam);
        SrvModelInoutDTO input = null;
        SrvModelInoutDTO output = null;
        for (SrvModelInoutDTO inout : inoutList) {
            if (input == null && inout.getIoType().equals(IOType.Input.getCode())) {
                input = inout;
            }
            if (output != null || !inout.getIoType().equals(IOType.Output.getCode())) continue;
            output = inout;
        }
        SrvModelTypeEnum modelTypeEnum = SrvModelTypeEnum.getModelByType((String)srvModelInfo.getSrvModelType());
        if (modelTypeEnum == SrvModelTypeEnum.UPDATE_BY_PK) {
            IsrvEvalUpdateDTO evalParam = new IsrvEvalUpdateDTO();
            evalParam.setSrvModelId(srvModelInfo.getSrvModelId());
            List updateList = isrvEvalUpdateService.queryList((Object)evalParam);
            if (CollectionUtils.isEmpty((Collection)updateList)) {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.putAll(param);
                root.put("$result", BeanUtility.bean2Map((Object)srvModelInfo));
                String testRe = ExpressionUtil.parse((String)testExp, root);
                CheckResult cr = CheckResult.getCheckResult((String)testRe);
                if (cr != CheckResult.Pass) {
                    flag = RuleResult.Fail;
                    if (genDtl) {
                        SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                        dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                        dtl.setCheckResult(cr.getCode());
                        String checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                        dtl.setCheckDesc(checkDesc);
                        ruleResultDtlList.add(dtl);
                    }
                }
            }
        }
        return flag;
    }
}

