/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.quality.console.application.service.impl;

import com.irdstudio.allinapaas.quality.console.application.service.check.scheme.executor.SCheckSchemeExecutor;
import com.irdstudio.allinapaas.quality.console.facade.SCheckExecutorService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckSchemeDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckSchemeService;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sCheckExecutorServiceImpl")
public class SCheckExecutorServiceImpl
implements SCheckExecutorService {
    private static Logger logger = LoggerFactory.getLogger(SCheckExecutorServiceImpl.class);
    @Autowired
    private SCheckSchemeService sCheckSchemeService;
    @Autowired
    private SCheckResultDtlService sCheckResultDtlService;

    public List<String> executeSchemeSync(String schemeNo, String id, String userId) {
        SCheckSchemeDTO schemeParam = new SCheckSchemeDTO();
        schemeParam.setSchemeNo(schemeNo);
        schemeParam = (SCheckSchemeDTO)this.sCheckSchemeService.queryByPk((Object)schemeParam);
        if (Objects.nonNull(schemeParam)) {
            schemeParam.setLoginUserId(userId);
            String serialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
            SCheckSchemeExecutor executor = new SCheckSchemeExecutor(schemeParam, serialNo, id);
            try {
                executor.call();
                SCheckResultDtlDTO dtlParam = new SCheckResultDtlDTO();
                dtlParam.setSerialNo(serialNo);
                dtlParam.setCheckResult(CheckResult.Fail.getCode());
                List failureList = this.sCheckResultDtlService.queryListByPage((Object)dtlParam);
                ArrayList<String> failureMessageList = new ArrayList<String>();
                failureList.forEach(dtl -> failureMessageList.add(dtl.getCheckDesc()));
                if (dtlParam.getTotal() > 10) {
                    failureMessageList.add("\u7b49" + dtlParam.getTotal() + "\u6761\u9519\u8bef");
                }
                return failureMessageList;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        return Collections.emptyList();
    }
}

