/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.infra.repository.impl;

import com.irdstudio.allinapaas.design.console.domain.entity.SSubsInfoDO;
import com.irdstudio.allinapaas.design.console.infra.persistence.mapper.PaasAppsInfoMapper;
import com.irdstudio.allinapaas.design.console.infra.persistence.po.PaasAppsInfoPO;
import com.irdstudio.allinapaas.design.console.infra.persistence.po.SSubsInfoPO;
import com.irdstudio.allinapaas.portal.console.acl.repository.SSubsInfoPortalRepository;
import com.irdstudio.allinapaas.portal.console.infra.persistence.mapper.SSubsInfoPortalMapper;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="sSubsInfoPortalRepositoryImpl")
public class SSubsInfoPortalRepositoryImpl
extends BaseRepositoryImpl<SSubsInfoDO, SSubsInfoPO, SSubsInfoPortalMapper>
implements SSubsInfoPortalRepository {
    @Autowired
    private PaasAppsInfoMapper paasAppsInfoMapper;

    public Integer querySSubsInfoMaxOrder() {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        Integer result = null;
        try {
            result = ((SSubsInfoPortalMapper)this.getMapper()).querySSubsInfoPOMaxOrder();
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public String querySSubsInfoMaxOrderWithPrefix(String solutionType) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        Object result = null;
        try {
            String year = CurrentDateUtil.getYear();
            year = StringUtils.substring((String)year, (int)2);
            String prefix = solutionType + year;
            result = ((SSubsInfoPortalMapper)this.getMapper()).querySSubsInfoMaxOrderWithPrefix(prefix);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = prefix + "000";
            }
            String numStr = StringUtils.substring((String)result, (int)(((String)result).length() - 3));
            int num = Integer.parseInt(numStr);
            String seq = prefix + StringUtils.leftPad((String)String.valueOf(num + 1), (int)3, (String)"0");
            result = seq;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public List<SSubsInfoDO> queryAllExcludeSelf(String subsId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<SSubsInfoPO> sSubsInfos = ((SSubsInfoPortalMapper)this.getMapper()).queryAllExcludeSelf(subsId);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sSubsInfos.size());
            list = this.beansCopy(sSubsInfos, SSubsInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<Map<String, Object>> queryDdspaasSummaryByPage(SSubsInfoDO sSubsInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Map<String, Object>> list = null;
        SSubsInfoPO sSubsInfoPO = new SSubsInfoPO();
        this.beanCopy(sSubsInfoDO, (Object)sSubsInfoPO);
        try {
            list = ((SSubsInfoPortalMapper)this.getMapper()).queryDdspaasSummaryByPage(sSubsInfoPO);
            if (CollectionUtils.isNotEmpty(list)) {
                PaasAppsInfoPO appParam = new PaasAppsInfoPO();
                for (Map<String, Object> sub : list) {
                    String subsId = MapUtils.getString(sub, (Object)"subsId");
                    appParam.setSubsId(subsId);
                    appParam.setSize(1);
                    this.paasAppsInfoMapper.queryAllGroupByPage(appParam);
                    sub.put("bizDbNum", appParam.getTotal());
                }
            }
            sSubsInfoDO.setTotal(sSubsInfoPO.getTotal());
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<Map<String, Object>> querySubsSummary(SSubsInfoDO sSubsInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Map<String, Object>> list = null;
        SSubsInfoPO sSubsInfoPO = new SSubsInfoPO();
        this.beanCopy(sSubsInfoDO, (Object)sSubsInfoPO);
        try {
            list = ((SSubsInfoPortalMapper)this.getMapper()).querySubsSummary(sSubsInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public Integer countSubsInfoTbNum(String subsId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + subsId);
        Integer count = ((SSubsInfoPortalMapper)this.getMapper()).countSubsInfoTbNum(subsId);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + count);
        return count;
    }

    public List<Map<String, Object>> querySummary(Map<String, Object> param) {
        return ((SSubsInfoPortalMapper)this.getMapper()).querySummary(param);
    }

    public List<Map<String, Object>> querySubsInfoSummaryByPage(SSubsInfoDO param) {
        SSubsInfoPO poParam = (SSubsInfoPO)((Object)this.beanCopy(param, SSubsInfoPO.class));
        List<Map<String, Object>> outputVO = ((SSubsInfoPortalMapper)this.getMapper()).querySubsInfoSummaryByPage(poParam);
        param.setTotal(poParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySummaryBySolutionTypeGroup(SSubsInfoDO param) {
        SSubsInfoPO poParam = (SSubsInfoPO)((Object)this.beanCopy(param, SSubsInfoPO.class));
        List<Map<String, Object>> outputVO = ((SSubsInfoPortalMapper)this.getMapper()).querySummaryBySolutionTypeGroup(poParam);
        param.setTotal(poParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySubsCbaSummary(Map<String, Object> params) {
        return ((SSubsInfoPortalMapper)this.getMapper()).querySubsCbaSummary(params);
    }

    public List<SSubsInfoDO> queryWithEnvListByPage(SSubsInfoDO param) {
        SSubsInfoPO paramPO = (SSubsInfoPO)((Object)this.beanCopy(param, SSubsInfoPO.class));
        List<SSubsInfoPO> poList = ((SSubsInfoPortalMapper)this.getMapper()).queryWithEnvListByPage(paramPO);
        this.pageSet(poList, paramPO);
        return this.beansCopy(poList, SSubsInfoDO.class);
    }
}

