/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasDeployInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasDeployInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsActionService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsActionDTO;
import com.irdstudio.allinapaas.design.console.types.ActionGroup;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskAppopsService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasDeployInfoWithActionDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskAppopsDTO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasDeployInfoPortalController
extends AbstractController
implements FrameworkService {
    @Autowired
    protected PaasDeployInfoService paasDeployInfoService;
    @Autowired
    protected PaasAppsActionService paasAppsActionService;
    @Autowired
    protected PaasTaskAppopsService paasTaskAppopsService;
    @Autowired
    protected PaasEcsInfoService paasEcsInfoService;

    @RequestMapping(value={"/api/paas/deploy/infos/subs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasDeployInfoWithActionDTO>> queryAllBySubsCode(PaasDeployInfoDTO dto) {
        List list;
        List outputVo = null;
        this.setUserInfoToVO(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getAppType()) && dto.getAppType().contains(",")) {
            String[] appTyps = StringUtils.split((String)dto.getAppType(), (String)",");
            dto.setAppTypes(Arrays.asList(appTyps));
            dto.setAppType(null);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAppCategory()) && dto.getAppCategory().contains(",")) {
            String[] appCategorys = StringUtils.split((String)dto.getAppCategory(), (String)",");
            dto.setAppCategorys(Arrays.asList(appCategorys));
            dto.setAppCategory(null);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAppId()) && dto.getAppId().contains(",")) {
            dto.setAppIdList(Arrays.asList(StringUtils.split((String)dto.getAppId(), (String)",")));
            dto.setAppId(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.beansCopy(outputVo = this.paasDeployInfoService.queryAllBySubsCode(dto), PaasDeployInfoWithActionDTO.class))) && StringUtils.isBlank((CharSequence)dto.getGroupBy())) {
            PaasAppsActionDTO actionParam = new PaasAppsActionDTO();
            for (PaasDeployInfoWithActionDTO app : list) {
                if (StringUtils.isBlank((CharSequence)app.getAppId())) continue;
                actionParam.setAppId(app.getAppId());
                actionParam.setActionGroup(ActionGroup.Ops.getCode());
                actionParam.setActionId(dto.getActionId());
                List actionList = this.paasAppsActionService.queryList((Object)actionParam);
                if (!CollectionUtils.isNotEmpty((Collection)actionList)) continue;
                try {
                    app.setActionList(this.beansCopy(actionList, PaasAppsActionDTO.class));
                    for (PaasAppsActionDTO action : app.getActionList()) {
                        if (StringUtils.isBlank((CharSequence)action.getScriptId())) continue;
                        PaasTaskAppopsDTO appopsParam = new PaasTaskAppopsDTO();
                        appopsParam.setAppId(action.getAppId());
                        appopsParam.setScriptId(action.getScriptId());
                        List appopsTasks = this.paasTaskAppopsService.queryListByPage((Object)appopsParam);
                        if (!CollectionUtils.isNotEmpty((Collection)appopsTasks)) continue;
                        action.setTaskId(((PaasTaskAppopsDTO)appopsTasks.get(0)).getTaskId());
                    }
                }
                catch (Exception e) {
                    logger.error("\u52a0\u8f7d\u5e94\u7528\u64cd\u4f5c\u5217\u8868\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return this.getResponseData(list);
    }

    @PostMapping(value={"/app/start/{appDeployId}"})
    @ResponseBody
    public ResponseData<Boolean> appStart(@PathVariable(value="appDeployId") String appDeployId) {
        boolean result = false;
        PaasDeployInfoDTO inVo = new PaasDeployInfoDTO();
        inVo.setAppDeployId(appDeployId);
        PaasDeployInfoDTO deployInfo = (PaasDeployInfoDTO)this.paasDeployInfoService.queryByPk((Object)inVo);
        logger.info("\u6267\u884c\u5e94\u7528\u542f\u52a8\uff0c\u5e94\u7528\u540d\u79f0\uff1a{}\uff0c\u670d\u52a1\u5668IP\uff1a{}", (Object)deployInfo.getAppName(), (Object)deployInfo.getEcsIp());
        RemoteSSHClient rsc = new RemoteSSHClient(deployInfo.getEcsIp(), "root", "Ird2019q2");
        rsc.connect();
        String pid = rsc.executeCommand("/agent/run_tomcat.sh status " + deployInfo.getAppName());
        if (StringUtil.isStrNotEmpty((String)pid)) {
            rsc.executeCommand("/agent/run_tomcat.sh restart " + deployInfo.getAppName());
        } else {
            rsc.executeCommand("/agent/run_tomcat.sh start " + deployInfo.getAppName());
        }
        String pidNew = rsc.executeCommand("/agent/run_tomcat.sh status " + deployInfo.getAppName());
        if (StringUtil.isStrNotEmpty((String)pidNew) && !pidNew.equals(pid)) {
            result = true;
            PaasDeployInfoDTO updateBean = new PaasDeployInfoDTO();
            updateBean.setAppDeployId(appDeployId);
            updateBean.setAppState("R");
            this.paasDeployInfoService.updateByPk((Object)updateBean);
        }
        return this.getResponseData(result);
    }

    @PostMapping(value={"/app/stop/{appDeployId}"})
    @ResponseBody
    public ResponseData<Boolean> appStop(@PathVariable(value="appDeployId") String appDeployId) {
        boolean result = false;
        PaasDeployInfoDTO inVo = new PaasDeployInfoDTO();
        inVo.setAppDeployId(appDeployId);
        PaasDeployInfoDTO deployInfo = (PaasDeployInfoDTO)this.paasDeployInfoService.queryByPk((Object)inVo);
        logger.info("\u6267\u884c\u5e94\u7528\u505c\u6b62\uff0c\u5e94\u7528\u540d\u79f0\uff1a{}\uff0c\u670d\u52a1\u5668IP\uff1a{}", (Object)deployInfo.getAppName(), (Object)deployInfo.getEcsIp());
        RemoteSSHClient rsc = new RemoteSSHClient(deployInfo.getEcsIp(), "root", "Ird2019q2");
        rsc.connect();
        rsc.executeCommand("/agent/run_tomcat.sh stop " + deployInfo.getAppName());
        String pid = rsc.executeCommand("/agent/run_tomcat.sh status " + deployInfo.getAppName());
        if (StringUtil.isStrEmpty((String)pid)) {
            result = true;
            PaasDeployInfoDTO updateBean = new PaasDeployInfoDTO();
            updateBean.setAppDeployId(appDeployId);
            updateBean.setAppState("S");
            this.paasDeployInfoService.updateByPk((Object)updateBean);
        }
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/paas/deploy/info/get/files/{appDeployId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> getApplicationLogFileDirectory(@PathVariable(value="appDeployId") String appDeployId) {
        PaasDeployInfoDTO inVo = new PaasDeployInfoDTO();
        inVo.setAppDeployId(appDeployId);
        PaasDeployInfoDTO deployInfoVO = (PaasDeployInfoDTO)this.paasDeployInfoService.queryByPk((Object)inVo);
        logger.info("\u6839\u636e\u5e94\u7528\u90e8\u7f72\u6807\u8bc6\u3010{}\u3011\u83b7\u5f97\u90e8\u7f72\u4fe1\u606f\uff1a{}", (Object)appDeployId, (Object)JSON.toJSONString((Object)deployInfoVO));
        PaasEcsInfoDTO paasEcsInfo = new PaasEcsInfoDTO();
        paasEcsInfo.setEcsId(deployInfoVO.getEcsId());
        PaasEcsInfoDTO paasEcsInfoVO = (PaasEcsInfoDTO)this.paasEcsInfoService.queryByPk((Object)paasEcsInfo);
        logger.info("\u6839\u636eecs\u6807\u8bc6\u3010{}\u3011\u83b7\u5f97\u7cfb\u7edf\u670d\u52a1\u5668\u4fe1\u606f\u4fe1\u606f\uff1a{}", (Object)deployInfoVO.getEcsId(), (Object)JSON.toJSONString((Object)paasEcsInfoVO));
        String loggingPath = deployInfoVO.getAppLogPath();
        logger.info("\u5e94\u7528\u65e5\u5fd7\u8f93\u51fa\u76ee\u5f55:{}", (Object)loggingPath);
        logger.info("\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u5668\u4fe1\u606f");
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfoVO.getEcsIp(), paasEcsInfoVO.getEcsLoginUser(), paasEcsInfoVO.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
        }
        List fileList = sshClient.fetchFiles(loggingPath);
        return this.getResponseData(fileList);
    }

    @RequestMapping(value={"/api/paas/deploy/info/file/download"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, String>> logFileDownload(@RequestBody Map<String, Object> reqBody) {
        String appDeployId = MapUtils.getString(reqBody, (Object)"appDeployId");
        String parentFileName = MapUtils.getString(reqBody, (Object)"parentFileName");
        String fileName = MapUtils.getString(reqBody, (Object)"fileName");
        int last = MapUtils.getIntValue(reqBody, (Object)"last", (int)0);
        boolean isFirst = MapUtils.getBooleanValue(reqBody, (Object)"isFirst");
        PaasDeployInfoDTO inVo = new PaasDeployInfoDTO();
        inVo.setAppDeployId(appDeployId);
        PaasDeployInfoDTO deployInfoVO = (PaasDeployInfoDTO)this.paasDeployInfoService.queryByPk((Object)inVo);
        fileName = fileName.replaceAll("\\*", ".");
        HashMap<String, String> stringIntegerMap = new HashMap<String, String>();
        PaasEcsInfoDTO paasEcsInfo = new PaasEcsInfoDTO();
        paasEcsInfo.setEcsId(deployInfoVO.getEcsId());
        PaasEcsInfoDTO paasEcsInfoVO = (PaasEcsInfoDTO)this.paasEcsInfoService.queryByPk((Object)paasEcsInfo);
        logger.info("\u6839\u636eecs\u6807\u8bc6\u3010{}\u3011\u83b7\u5f97\u7cfb\u7edf\u670d\u52a1\u5668\u4fe1\u606f\u4fe1\u606f\uff1a{}", (Object)deployInfoVO.getEcsId(), (Object)JSON.toJSONString((Object)paasEcsInfoVO));
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfoVO.getEcsIp(), paasEcsInfoVO.getEcsLoginUser(), paasEcsInfoVO.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            return this.getResponseData(stringIntegerMap);
        }
        String loggingPath = deployInfoVO.getAppLogPath();
        fileName = StringUtils.isNotBlank((CharSequence)parentFileName) ? loggingPath + "/" + parentFileName + "/" + fileName : loggingPath + "/" + fileName;
        int head = last - 1000;
        String file = "";
        final StringBuffer sb = new StringBuffer();
        SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

            public void print(String line) {
                sb.append(line).append("\n");
            }

            public void printError(String line) {
                sb.append(line).append("\n");
            }
        };
        if (isFirst) {
            final int[] fileLen = new int[]{0};
            sshClient.executeCommand("cat " + fileName + " | wc -l ", new SSHOutputPrinter(){

                public void print(String line) {
                    fileLen[0] = NumberUtils.toInt((String)line);
                }

                public void printError(String line) {
                }
            });
            last = fileLen[0];
            head = fileLen[0] - 1000;
            if (head < 1) {
                head = 1;
            }
            if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)".gz")) {
                sshClient.executeCommand(String.format("gzip -dc %s | sed -n '%s,%sp'", fileName, head, last), sshPrinter);
            } else {
                sshClient.executeCommand(String.format("sed -n '%s,%sp' %s", head, last, fileName), sshPrinter);
            }
            file = sb.toString();
        } else {
            if (head < 1) {
                head = 1;
            }
            --last;
            if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)".gz")) {
                sshClient.executeCommand(String.format("gzip -dc %s | sed -n '%s,%sp'", fileName, head, last), sshPrinter);
            } else {
                sshClient.executeCommand(String.format("sed -n '%s,%sp' %s", head, last, fileName), sshPrinter);
            }
            file = sb.toString();
        }
        stringIntegerMap.put("file", file);
        stringIntegerMap.put("head", Integer.toString(head));
        return this.getResponseData(stringIntegerMap);
    }
}

