/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasTemplateComService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateComDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTemplateComController
extends BaseController<PaasTemplateComDTO, PaasTemplateComService> {
    @RequestMapping(value={"/api/paas/template/coms"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateComDTO>> queryPaasTemplateComAll(PaasTemplateComDTO dto) {
        List outputVo = ((PaasTemplateComService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/com/{appTemplateId}/{comId}/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTemplateComDTO> queryByPk(@PathVariable(value="appTemplateId") String appTemplateId, @PathVariable(value="comId") String comId, @PathVariable(value="subsId") String subsId) {
        PaasTemplateComDTO inVo = new PaasTemplateComDTO();
        inVo.setAppTemplateId(appTemplateId);
        inVo.setComId(comId);
        inVo.setSubsId(subsId);
        PaasTemplateComDTO outputVo = (PaasTemplateComDTO)((PaasTemplateComService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/com"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTemplateComDTO inPaasTemplateComDTO) {
        int outputVo = ((PaasTemplateComService)this.getService()).deleteByPk((Object)inPaasTemplateComDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/com"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTemplateComDTO inPaasTemplateComDTO) {
        this.setUserInfoToVO(inPaasTemplateComDTO);
        inPaasTemplateComDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTemplateComDTO.setLastModifyUser(inPaasTemplateComDTO.getLoginUserId());
        int outputVo = ((PaasTemplateComService)this.getService()).updateByPk((Object)inPaasTemplateComDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/com"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasTemplateCom(@RequestBody PaasTemplateComDTO inPaasTemplateComDTO) {
        this.setUserInfoToVO(inPaasTemplateComDTO);
        inPaasTemplateComDTO.setCreateUser(inPaasTemplateComDTO.getLoginUserId());
        inPaasTemplateComDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTemplateComDTO.setLastModifyUser(inPaasTemplateComDTO.getLoginUserId());
        inPaasTemplateComDTO.setLastModifyTime(inPaasTemplateComDTO.getCreateTime());
        int outputVo = ((PaasTemplateComService)this.getService()).insert((Object)inPaasTemplateComDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/com/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasTemplateCom(@RequestBody List<PaasTemplateComDTO> list) {
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        if (CollectionUtils.isNotEmpty(list)) {
            for (PaasTemplateComDTO com : list) {
                com.setCreateUser(userId);
                com.setCreateTime(now);
                com.setLastModifyUser(userId);
                com.setLastModifyTime(now);
            }
            int outputVo = ((PaasTemplateComService)this.getService()).batchInsert(list);
            return this.getResponseData(outputVo);
        }
        return this.getResponseData(0);
    }
}

