/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskMetascanService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskMetascanDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskMetascanController
extends BaseController<PaasTaskMetascanDTO, PaasTaskMetascanService> {
    @RequestMapping(value={"/api/paas/task/metascans"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTaskMetascanDTO>> queryPaasTaskMetascanAll(PaasTaskMetascanDTO dto) {
        List outputVo = ((PaasTaskMetascanService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/metascan/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTaskMetascanDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        PaasTaskMetascanDTO inVo = new PaasTaskMetascanDTO();
        inVo.setTaskId(taskId);
        PaasTaskMetascanDTO outputVo = (PaasTaskMetascanDTO)((PaasTaskMetascanService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/metascan"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTaskMetascanDTO inPaasTaskMetascanDTO) {
        int outputVo = ((PaasTaskMetascanService)this.getService()).deleteByPk((Object)inPaasTaskMetascanDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/metascan"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTaskMetascanDTO inPaasTaskMetascanDTO) {
        int outputVo = ((PaasTaskMetascanService)this.getService()).updateByPk((Object)inPaasTaskMetascanDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/metascan"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasTaskMetascan(@RequestBody PaasTaskMetascanDTO inPaasTaskMetascanDTO) {
        if (StringUtils.isBlank((CharSequence)inPaasTaskMetascanDTO.getTaskId())) {
            inPaasTaskMetascanDTO.setTaskId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasTaskMetascanService)this.getService()).insert((Object)inPaasTaskMetascanDTO);
        return this.getResponseData(inPaasTaskMetascanDTO.getTaskId());
    }

    @RequestMapping(value={"/api/paas/task/metascan/file"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertSSubsMetataskFile(@RequestParam(value="taskName") String taskName, @RequestParam(value="taskCatalog") String taskCatalog, @RequestParam(value="taskType") String taskType, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="damTemplateId", required=false) String damTemplateId, @RequestParam(value="packageId", required=false) String packageId, @RequestParam(value="taskOption") String taskOption, @RequestPart(value="file") MultipartFile file) {
        String metaTaskRootPath = SdEnvUtil.METATASK_PATH;
        File rootDir = new File(metaTaskRootPath);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        PaasTaskMetascanDTO requestVO = new PaasTaskMetascanDTO();
        requestVO.setTaskName(taskName);
        requestVO.setTaskCatalog(taskCatalog);
        requestVO.setTaskType(taskType);
        requestVO.setSubsId(subsId);
        requestVO.setAppId(appId);
        requestVO.setDamTemplateId(damTemplateId);
        requestVO.setPackageId(packageId);
        requestVO.setTaskOption(taskOption);
        if (StringUtils.isBlank((CharSequence)requestVO.getTaskId())) {
            requestVO.setTaskId(UUIDUtil.getShortUUID());
        }
        File taskFile = new File(rootDir, requestVO.getTaskId() + "." + file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1));
        try {
            file.transferTo(taskFile);
        }
        catch (IOException e) {
            logger.error("\u8f6c\u6362\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        this.setUserInfoToVO(requestVO);
        requestVO.setCreateUser(requestVO.getLoginUserId());
        requestVO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTaskMetascanService)this.getService()).insert((Object)requestVO);
        return this.getResponseData(requestVO.getTaskId());
    }

    @RequestMapping(value={"/api/paas/task/metascan/file/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> updateByPkFile(@RequestParam(value="taskId") String taskId, @RequestParam(value="taskName") String taskName, @RequestParam(value="taskCatalog") String taskCatalog, @RequestParam(value="taskType") String taskType, @RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="damTemplateId", required=false) String damTemplateId, @RequestParam(value="packageId", required=false) String packageId, @RequestParam(value="taskOption") String taskOption, @RequestPart(value="file") MultipartFile file) {
        PaasTaskMetascanDTO inSSubsMetataskVo = new PaasTaskMetascanDTO();
        inSSubsMetataskVo.setTaskName(taskName);
        inSSubsMetataskVo.setTaskCatalog(taskCatalog);
        inSSubsMetataskVo.setTaskType(taskType);
        inSSubsMetataskVo.setSubsId(subsId);
        inSSubsMetataskVo.setAppId(appId);
        inSSubsMetataskVo.setDamTemplateId(damTemplateId);
        inSSubsMetataskVo.setTaskId(taskId);
        inSSubsMetataskVo.setPackageId(packageId);
        inSSubsMetataskVo.setTaskOption(taskOption);
        this.setUserInfoToVO(inSSubsMetataskVo);
        inSSubsMetataskVo.setLastUpdateUser(inSSubsMetataskVo.getLoginUserId());
        inSSubsMetataskVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        String metaTaskRootPath = SdEnvUtil.METATASK_PATH;
        if (StringUtils.isBlank((CharSequence)metaTaskRootPath)) {
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage("\u672a\u914d\u7f6e\u91c7\u96c6\u4efb\u52a1\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55");
            return resp;
        }
        File rootDir = null;
        try {
            rootDir = new File(metaTaskRootPath);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u91c7\u96c6\u4efb\u52a1\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage("\u521d\u59cb\u5316\u91c7\u96c6\u4efb\u52a1\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55\u5f02\u5e38");
            return resp;
        }
        if (StringUtils.isBlank((CharSequence)inSSubsMetataskVo.getTaskId())) {
            inSSubsMetataskVo.setTaskId(UUIDUtil.getShortUUID());
        }
        File taskFile = new File(rootDir, inSSubsMetataskVo.getTaskId() + "." + file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1));
        try {
            file.transferTo(taskFile);
        }
        catch (IOException e) {
            logger.error("\u8f6c\u6362\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage("\u8f6c\u79fb\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
            return resp;
        }
        int outputVo = ((PaasTaskMetascanService)this.getService()).updateByPk((Object)inSSubsMetataskVo);
        return this.getResponseData(outputVo);
    }
}

