/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.portal.console.facade.HomePageService;
import com.irdstudio.allinapaas.portal.console.facade.dto.HomePageDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskInfoDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.WxService;
import com.irdstudio.allintcp.admin.facade.dto.SUserDTO;
import com.irdstudio.allintcp.admin.facade.dto.wx.WXSendSubscribe;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/wx/"})
public class WXApiController
extends AbstractController {
    @Autowired
    @Lazy
    private HomePageService homePageService;
    @Autowired
    private WxService wxService;
    @Autowired
    private AllinCloudPortalClient portalClient;
    @Value(value="${wx.app.miniprogram_state:trial}")
    private String miniprogram_state;

    @RequestMapping(value={"/indexInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> indexInfo(HomePageDTO param) {
        this.setUserInfoToVO(param);
        List outputVO = this.homePageService.queryWXIndex(param);
        return this.getResponseData(outputVO);
    }

    @RequestMapping(value={"/sendTaskSubscribe"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> sendTaskSubscribe(@RequestBody RdmTaskInfoDTO taskInfo) {
        String incharge = taskInfo.getIncharge();
        String taskCollaborator = taskInfo.getCollaborator();
        SUserDTO sUserVO = this.portalClient.querySUserByPk(incharge);
        if (sUserVO == null || StringUtils.isBlank((CharSequence)sUserVO.getWexinOpenid())) {
            return ResponseData.create((Object)"\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u5fae\u4fe1", (String)"-1", (String)"\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u5fae\u4fe1", (boolean)false);
        }
        WXSendSubscribe sendParam = new WXSendSubscribe();
        sendParam.setTemplate_id("3Ru-v3teVKn7HIkESzRgCZABOMKbJxo6VXbNh6KXEdY");
        sendParam.setPage("pages/developTask/taskInfoDetail?taskId=" + taskInfo.getTaskId());
        sendParam.setMiniprogram_state(this.miniprogram_state);
        sendParam.setTouser(sUserVO.getWexinOpenid());
        HashMap data = new HashMap();
        HashMap<String, String> taskId = new HashMap<String, String>();
        taskId.put("value", taskInfo.getTaskId());
        data.put("character_string7", taskId);
        HashMap<String, String> taskName = new HashMap<String, String>();
        taskName.put("value", taskInfo.getTaskName());
        data.put("thing4", taskName);
        HashMap<String, String> taskStarted = new HashMap<String, String>();
        taskStarted.put("value", taskInfo.getTaskStarted());
        data.put("time8", taskStarted);
        sendParam.setData(data);
        String res = this.wxService.sendSubscribe(sendParam);
        Map wxRes = (Map)JSON.parseObject((String)res, Map.class);
        String errcode = MapUtils.getString((Map)wxRes, (Object)"errcode");
        if (StringUtils.equals((CharSequence)errcode, (CharSequence)"0")) {
            if (StringUtils.isNotBlank((CharSequence)taskCollaborator)) {
                sUserVO = this.portalClient.querySUserByPk(taskCollaborator);
                if (sUserVO == null || StringUtils.isBlank((CharSequence)sUserVO.getWexinOpenid())) {
                    return ResponseData.create((Object)"\u534f\u4f5c\u8005\u672a\u7ed1\u5b9a\u5fae\u4fe1", (String)"-1", (String)"\u534f\u4f5c\u8005\u672a\u7ed1\u5b9a\u5fae\u4fe1", (boolean)false);
                }
                sendParam = new WXSendSubscribe();
                sendParam.setTemplate_id("3Ru-v3teVKn7HIkESzRgCZABOMKbJxo6VXbNh6KXEdY");
                sendParam.setPage("pages/developTask/taskInfoDetail?taskId=" + taskInfo.getTaskId());
                sendParam.setMiniprogram_state(this.miniprogram_state);
                sendParam.setTouser(sUserVO.getWexinOpenid());
                sendParam.setData(data);
                res = this.wxService.sendSubscribe(sendParam);
                Map wxTaskCollaboratorRes = (Map)JSON.parseObject((String)res, Map.class);
                String taskCollaboratorErrcode = MapUtils.getString((Map)wxTaskCollaboratorRes, (Object)"errcode");
                if (StringUtils.equals((CharSequence)taskCollaboratorErrcode, (CharSequence)"0")) {
                    return ResponseData.create((Object)"\u53d1\u9001\u6210\u529f", (String)"0", (String)"\u53d1\u9001\u6210\u529f", (boolean)true);
                }
                return ResponseData.create((Object)"\u534f\u4f5c\u8005\u6d88\u606f\u53d1\u9001\u5931\u8d25", (String)"-1", (String)"\u534f\u4f5c\u8005\u6d88\u606f\u53d1\u9001\u5931\u8d25", (boolean)false);
            }
            return ResponseData.create((Object)"\u53d1\u9001\u6210\u529f", (String)"0", (String)"\u53d1\u9001\u6210\u529f", (boolean)true);
        }
        return ResponseData.create((Object)"\u53d1\u9001\u5931\u8d25", (String)"-1", (String)"\u53d1\u9001\u5931\u8d25", (boolean)false);
    }
}

