/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAdapterAppService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAdapterAppDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAdapterAppController
extends BaseController<PaasAdapterAppDTO, PaasAdapterAppService> {
    @RequestMapping(value={"/api/paas/adapter/apps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAdapterAppDTO>> queryPaasAdapterAppAll(PaasAdapterAppDTO dto) {
        List outputVo = ((PaasAdapterAppService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/adapter/app/{adapterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAdapterAppDTO> queryByPk(@PathVariable(value="adapterId") String adapterId) {
        PaasAdapterAppDTO inVo = new PaasAdapterAppDTO();
        inVo.setAdapterId(adapterId);
        PaasAdapterAppDTO outputVo = (PaasAdapterAppDTO)((PaasAdapterAppService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/adapter/app"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAdapterAppDTO inPaasAdapterAppDTO) {
        int outputVo = ((PaasAdapterAppService)this.getService()).deleteByPk((Object)inPaasAdapterAppDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/adapter/app"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAdapterAppDTO inPaasAdapterAppDTO) {
        this.setUserInfoToVO(inPaasAdapterAppDTO);
        inPaasAdapterAppDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inPaasAdapterAppDTO.setLastModifyUser(inPaasAdapterAppDTO.getLoginUserId());
        int outputVo = ((PaasAdapterAppService)this.getService()).updateByPk((Object)inPaasAdapterAppDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/adapter/app"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAdapterApp(@RequestBody PaasAdapterAppDTO inPaasAdapterAppDTO) {
        this.setUserInfoToVO(inPaasAdapterAppDTO);
        inPaasAdapterAppDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasAdapterAppDTO.setCreateUser(inPaasAdapterAppDTO.getLoginUserId());
        inPaasAdapterAppDTO.setLastModifyTime(inPaasAdapterAppDTO.getCreateTime());
        inPaasAdapterAppDTO.setLastModifyUser(inPaasAdapterAppDTO.getLoginUserId());
        if (StringUtils.isBlank((CharSequence)inPaasAdapterAppDTO.getAdapterId())) {
            inPaasAdapterAppDTO.setAdapterId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasAdapterAppService)this.getService()).insert((Object)inPaasAdapterAppDTO);
        return this.getResponseData(outputVo);
    }
}

