/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasMarketAppinfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasMarketSysinfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasMarketAppinfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasMarketSysinfoDTO;
import com.irdstudio.allinapaas.design.console.types.MarketType;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasMarketSysinfoController
extends BaseController<PaasMarketSysinfoDTO, PaasMarketSysinfoService> {
    @Autowired
    @Qualifier(value="paasMarketAppinfoServiceImpl")
    private PaasMarketAppinfoService paasMarketAppinfoService;

    @RequestMapping(value={"/api/paas/market/sysinfos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasMarketSysinfoDTO>> queryPaasMarketSysinfoAll(PaasMarketSysinfoDTO vo) {
        List outputVo = ((PaasMarketSysinfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/market/sysinfo/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasMarketSysinfoDTO> queryByPk(@PathVariable(value="subsId") String subsId) {
        PaasMarketSysinfoDTO inVo = new PaasMarketSysinfoDTO();
        inVo.setSubsId(subsId);
        PaasMarketSysinfoDTO outputVo = (PaasMarketSysinfoDTO)((PaasMarketSysinfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/market/sysinfo"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasMarketSysinfoDTO inPaasMarketSysinfoVo) {
        int outputVo = ((PaasMarketSysinfoService)this.getService()).deleteByPk((Object)inPaasMarketSysinfoVo);
        PaasMarketAppinfoDTO appParam = new PaasMarketAppinfoDTO();
        appParam.setSubsCode(inPaasMarketSysinfoVo.getSubsCode());
        this.paasMarketAppinfoService.deleteBySysCode(appParam);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/market/sysinfo"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasMarketSysinfoDTO inPaasMarketSysinfoVo) {
        int outputVo = ((PaasMarketSysinfoService)this.getService()).updateByPk((Object)inPaasMarketSysinfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/market/sysinfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasMarketSysinfo(@RequestBody PaasMarketSysinfoDTO inPaasMarketSysinfoVo) {
        int outputVo = ((PaasMarketSysinfoService)this.getService()).insert((Object)inPaasMarketSysinfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/market/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, List>> queryPaasMarketTree() {
        PaasMarketSysinfoDTO sysParam = new PaasMarketSysinfoDTO();
        sysParam.setMarketType(MarketType.Original.getCode());
        sysParam.setSize(Integer.valueOf(1000));
        List outputVo = ((PaasMarketSysinfoService)this.getService()).queryList((Object)sysParam);
        PaasMarketSysinfoDTO appParam = new PaasMarketSysinfoDTO();
        appParam.setMarketType(MarketType.Product.getCode());
        appParam.setSize(Integer.valueOf(1000));
        List appList = ((PaasMarketSysinfoService)this.getService()).queryList((Object)appParam);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("sys", outputVo);
        result.put("app", appList);
        return this.getResponseData(result);
    }
}

