/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SModuleInfoDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ModuleSyncController
extends AbstractController {
    @Autowired
    private SSubsInfoPortalService sSubsInfoService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private PaasEcsInfoPortalService paasEcsInfoService;

    @RequestMapping(value={"/s/module/info/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> queryAppsCheckLogAll(@RequestBody Map<String, String> syncParams) {
        String syncData = syncParams.get("syncData");
        String subsId = syncParams.get("subsId");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if (StringUtils.equals((CharSequence)"SSubsInfo", (CharSequence)syncData)) {
            SModuleInfoDTO portalParam = new SModuleInfoDTO();
            portalParam.setPortalSyncData(YesOrNO.YES.getCode());
            portalParam.setSize(Integer.valueOf(1000));
            AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
            List portalSyncList = portalClient.querySModuleInfoAll(portalParam);
            if (CollectionUtils.isNotEmpty((Collection)portalSyncList)) {
                SSubsInfoDTO subsParam = new SSubsInfoDTO();
                if (StringUtils.isNotBlank((CharSequence)subsId)) {
                    subsParam.setSubsId(subsId);
                }
                List subsList = this.sSubsInfoService.queryList((Object)subsParam);
                for (SSubsInfoDTO sub : subsList) {
                    PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
                    appParam.setSubsId(sub.getSubsId());
                    appParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                    List appsList = this.paasAppsInfoService.queryListByPage((Object)appParam);
                    sub.setAppsList(appsList);
                    Integer tbNum = this.sSubsInfoService.countSubsInfoTbNum(sub.getSubsId());
                    sub.setTbNum(tbNum);
                    sub.setAppNum(appParam.getTotal());
                }
                for (SModuleInfoDTO portal : portalSyncList) {
                    String moduleCode = portal.getModuleCode();
                    PaasEcsInfoDTO portalEcs = new PaasEcsInfoDTO();
                    portalEcs.setEnvId("pedestal");
                    portalEcs.setAppCodeLike(moduleCode);
                    portalEcs.setSubsId("S09001");
                    List ecsList = this.paasEcsInfoService.queryListByPage((Object)portalEcs);
                    if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                        for (PaasEcsInfoDTO ecs : ecsList) {
                            String ecsPortString;
                            String ecsIpString = ecs.getEcsIp();
                            if (ecsIpString.isEmpty() || (ecsPortString = ecs.getEcsPort()).isEmpty()) continue;
                            String urlString = "http://" + ecsIpString + ":" + ecsPortString + "/" + ecs.getAppCode() + "/api/s/subs/info/sync";
                            HttpPost syncPost = new HttpPost(urlString);
                            StringEntity createEntity = new StringEntity(JSON.toJSONString((Object)subsList), "UTF-8");
                            syncPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                            syncPost.setEntity((HttpEntity)createEntity);
                            try {
                                HttpResponse response = httpClient.execute((HttpUriRequest)syncPost);
                                String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                                logger.info(moduleCode + "\u95e8\u6237\u6a21\u5757\u540c\u6b65\u6570\u636e\u7ed3\u679c {}", (Object)json);
                            }
                            catch (Exception e) {
                                logger.error(moduleCode + e.getMessage(), (Throwable)e);
                            }
                        }
                        continue;
                    }
                    logger.info("\u95e8\u6237\u6a21\u5757{}\u672a\u914d\u7f6e\u670d\u52a1\u5668\uff0c \u8df3\u8fc7\u540c\u6b65", (Object)moduleCode);
                }
            }
            return this.getResponseData("\u540c\u6b65\u7cfb\u7edf\u6570\u636e\u6210\u529f");
        }
        return this.getResponseData("\u6682\u4e0d\u652f\u6301\u540c\u6b65\u6b64\u6570\u636e");
    }
}

