/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskInfoService;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskTemplateService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskTemplateDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskExecuteController
extends AbstractController {
    @Autowired
    private PaasTaskTemplateService paasTaskTemplateService;
    @Autowired
    private PaasTaskInfoService paasTaskInfoService;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    private ConcurrentMap<String, Boolean> taskDebounce = AbstractMetaTask.taskDebounce;

    @RequestMapping(value={"/api/paas/task/info/exec"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> executePaasTask(@RequestParam(value="taskId") String taskId) {
        PaasTaskInfoDTO inVo = new PaasTaskInfoDTO();
        inVo.setTaskId(taskId);
        try {
            PaasTaskInfoDTO task = (PaasTaskInfoDTO)this.paasTaskInfoService.queryByPk((Object)inVo);
            int outputVo = 0;
            if (Objects.nonNull(task)) {
                if (this.taskDebounce.get(taskId) != null && ((Boolean)this.taskDebounce.get(taskId)).booleanValue()) {
                    outputVo = 1;
                } else {
                    PaasTaskTemplateDTO taskExecClassInfo = new PaasTaskTemplateDTO();
                    String taskType = task.getTaskType();
                    taskExecClassInfo.setTaskType(taskType);
                    taskExecClassInfo = (PaasTaskTemplateDTO)this.paasTaskTemplateService.queryByPk((Object)taskExecClassInfo);
                    this.taskDebounce.put(taskId, true);
                    this.setUserInfoToVO(task);
                    try {
                        Class<?> excelTaskClazz = Class.forName(taskExecClassInfo.getTaskClass());
                        Constructor<?> constructor = excelTaskClazz.getConstructor(PaasTaskInfoDTO.class);
                        AbstractMetaTask excelTask = (AbstractMetaTask)constructor.newInstance(task);
                        this.applicationThreadPool.add((Callable)excelTask);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u6267\u884c\u4efb\u52a1\u5f02\u5e38 " + e.getMessage(), e);
                    }
                }
            } else {
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
                outputVo = -1;
            }
            return this.getResponseData(outputVo);
        }
        catch (Exception e) {
            this.taskDebounce.put(taskId, false);
            logger.error(e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @RequestMapping(value={"/api/paas/task/info/exec/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> getExecutePaasTaskStat(@RequestParam(value="taskId") String taskId) {
        int outputVo = 0;
        if (this.taskDebounce.get(taskId) != null && ((Boolean)this.taskDebounce.get(taskId)).booleanValue()) {
            outputVo = 1;
        }
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/paas/task/info/batch/exec"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> executeBatchPaasTask(@RequestBody Map<String, Object> params) {
        List taskList;
        String subsId = MapUtils.getString(params, (Object)"subsId");
        String taskType = MapUtils.getString(params, (Object)"taskType");
        String allSelected = MapUtils.getString(params, (Object)"allSelected");
        String taskIdList = MapUtils.getString(params, (Object)"taskIdList");
        boolean outputVo = false;
        if (this.taskDebounce.get(subsId) != null && ((Boolean)this.taskDebounce.get(subsId)).booleanValue()) {
            outputVo = true;
            return this.getResponseData(1, "\u7cfb\u7edf\u7ec4\u4ef6\u5bfc\u5165\u6279\u91cf\u4efb\u52a1\u6b63\u5728\u6267\u884c", "");
        }
        PaasTaskInfoDTO taskInfoParam = new PaasTaskInfoDTO();
        taskInfoParam.setSubsId(subsId);
        taskInfoParam.setTaskType(taskType);
        if (!StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)allSelected)) {
            String[] taskIds = StringUtils.split((String)taskIdList, (String)",");
            taskInfoParam.setTaskIdList(Arrays.asList(taskIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(taskList = this.paasTaskInfoService.queryList((Object)taskInfoParam)))) {
            int len = taskList.size();
            ResponseData futureList = new ArrayList(len);
            this.taskDebounce.put(subsId, true);
            try {
                ResponseData newList;
                for (PaasTaskInfoDTO task : taskList) {
                    PaasTaskTemplateDTO taskExecClassInfo = new PaasTaskTemplateDTO();
                    taskExecClassInfo.setTaskType(task.getTaskType());
                    taskExecClassInfo = (PaasTaskTemplateDTO)this.paasTaskTemplateService.queryByPk((Object)taskExecClassInfo);
                    this.setUserInfoToVO(task);
                    try {
                        Class<?> excelTaskClazz = Class.forName(taskExecClassInfo.getTaskClass());
                        Constructor<?> constructor = excelTaskClazz.getConstructor(PaasTaskInfoDTO.class);
                        AbstractMetaTask excelTask = (AbstractMetaTask)constructor.newInstance(task);
                        Future future = this.applicationThreadPool.add((Callable)excelTask);
                        futureList.add(future);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u6267\u884cPaas\u4efb\u52a1\u5f02\u5e38 " + e.getMessage(), e);
                    }
                }
                while (!futureList.isEmpty()) {
                    newList = new ArrayList(len);
                    for (Future f : futureList) {
                        if (f.isDone()) continue;
                        newList.add(f);
                    }
                    futureList = newList;
                }
                newList = this.getResponseData(0, "\u6279\u91cf\u6267\u884cPaas\u4efb\u52a1\u6210\u529f", "");
                return newList;
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u6267\u884cPaas\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
                ResponseData responseData = this.getResponseData(-1, "", "\u6279\u91cf\u6267\u884cPaas\u4efb\u52a1\u5931\u8d25 " + e.getMessage());
                return responseData;
            }
            finally {
                this.taskDebounce.put(subsId, false);
            }
        }
        return this.getResponseData(-1, "", "\u6ca1\u6709Paas\u4efb\u52a1\u53ef\u4ee5\u6267\u884c");
    }
}

