/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasTemplateDuService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasTemplateDuDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateActionService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateComService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateParamService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateSqlService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateActionDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateComDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateParamDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateSqlDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateSummaryDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.types.AppAdminType;
import com.irdstudio.allinapaas.portal.console.types.AppCreateWay;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTemplateInfoPortalController
extends BaseController<PaasTemplateInfoDTO, PaasTemplateInfoPortalService> {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    @Qualifier(value="paasTemplateInfoService")
    private PaasTemplateInfoService paasTemplateInfoService;
    @Autowired
    @Qualifier(value="paasTemplateParamService")
    private PaasTemplateParamService paasTemplateParamService;
    @Autowired
    private PaasTemplateSqlService paasTemplateSqlService;
    @Autowired
    private PaasTemplateDuService paasTemplateDuService;
    @Autowired
    private PaasTemplateActionService paasTemplateActionService;
    @Autowired
    private PaasTemplateComService paasTemplateComService;
    @Autowired
    @Qualifier(value="paasAppsInfoServiceImpl")
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    @Qualifier(value="sSubsInfoService")
    private SSubsInfoService sSubsInfoService;

    @PostMapping(value={"/api/portal/paas/template/info/import2sys"})
    @ResponseBody
    public ResponseData<Boolean> importProdIntoPaasSys(@RequestParam(value="sysCode") String sysCode, @RequestBody PaasTemplateInfoDTO inPaasTemplateInfoVo) {
        boolean flag = true;
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(UUIDUtil.getUUID());
        appInfo.setAppCode(inPaasTemplateInfoVo.getAppTemplateId());
        appInfo.setAppName(inPaasTemplateInfoVo.getAppTemplateName());
        appInfo.setAppVersion(inPaasTemplateInfoVo.getAppTemplateVersion());
        appInfo.setRefMarketAppid(inPaasTemplateInfoVo.getAppTemplateId());
        appInfo.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        appInfo.setAppTemplateName(inPaasTemplateInfoVo.getAppTemplateName());
        SSubsInfoDTO sys = new SSubsInfoDTO();
        sys.setSubsCode(sysCode);
        sys = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sys);
        if (sys != null) {
            appInfo.setSubsId(sys.getSubsCode());
            appInfo.setSubsCode(sys.getSubsCode());
            appInfo.setSubsName(sys.getSubsName());
        }
        appInfo.setAppType(inPaasTemplateInfoVo.getAppType());
        appInfo.setAppAdminType(AppAdminType.CrossApp.getCode());
        appInfo.setAppCreateWay(AppCreateWay.TemplateCreate.getCode());
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setSubsCode(sysCode);
        appParam = this.paasAppsInfoService.querySysCodeAppOrder(appParam);
        if (appParam != null) {
            Integer order = appParam.getAppOrder();
            if (order == null) {
                order = 0;
            }
            appInfo.setAppOrder(Integer.valueOf(order + 1));
        } else {
            appInfo.setAppOrder(Integer.valueOf(1));
        }
        int num = this.paasAppsInfoService.insert((Object)appInfo);
        flag = num > 0;
        return this.getResponseData(flag);
    }

    @PostMapping(value={"/api/portal/paas/template/info"})
    @ResponseBody
    public ResponseData<Integer> insertPaasTemplateInfo(@RequestBody PaasTemplateInfoDTO inPaasTemplateInfoVo) {
        this.setUserInfoToVO(inPaasTemplateInfoVo);
        inPaasTemplateInfoVo.setCreateUser(inPaasTemplateInfoVo.getLoginUserId());
        inPaasTemplateInfoVo.setUpdateUser(inPaasTemplateInfoVo.getLoginUserId());
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        inPaasTemplateInfoVo.setCreateTime(nowTime);
        inPaasTemplateInfoVo.setUpdateTime(nowTime);
        int outputVo = this.paasTemplateInfoService.insert((Object)inPaasTemplateInfoVo);
        if (StringUtils.isBlank((CharSequence)inPaasTemplateInfoVo.getArchType())) {
            PaasTemplateParamDTO database_name = new PaasTemplateParamDTO();
            database_name.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
            database_name.setParamCode("database_name");
            database_name.setParamValue(inPaasTemplateInfoVo.getAppTemplateId());
            database_name.setParamName("\u6570\u636e\u5e93\u540d");
            database_name.setParamGroup("DPL");
            database_name.setParamSource(ParamSource.Const.getCode());
            this.paasTemplateParamService.insert((Object)database_name);
            PaasTemplateParamDTO database_password = new PaasTemplateParamDTO();
            database_password.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
            database_password.setParamCode("database_password");
            database_password.setParamValue("Zaqpwdxsw@2");
            database_password.setParamName("\u6570\u636e\u5e93\u670d\u52a1\u5668\u5bc6\u7801");
            database_password.setParamGroup("DPL");
            database_password.setParamSource(ParamSource.Const.getCode());
            this.paasTemplateParamService.insert((Object)database_password);
            PaasTemplateParamDTO database_username = new PaasTemplateParamDTO();
            database_username.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
            database_username.setParamCode("database_username");
            database_username.setParamValue("root");
            database_username.setParamName("\u6570\u636e\u5e93\u670d\u52a1\u5668\u7528\u6237\u540d");
            database_username.setParamGroup("DPL");
            database_username.setParamSource(ParamSource.Const.getCode());
            this.paasTemplateParamService.insert((Object)database_username);
            PaasTemplateParamDTO server_port = new PaasTemplateParamDTO();
            server_port.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
            server_port.setParamCode("server_port");
            server_port.setParamValue("8080");
            server_port.setParamName("\u670d\u52a1\u90e8\u7f72\u7aef\u53e3");
            server_port.setParamGroup("DPL");
            server_port.setParamSource(ParamSource.Const.getCode());
            this.paasTemplateParamService.insert((Object)server_port);
        }
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/api/portal/paas/template/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTemplateInfoDTO inPaasTemplateInfoVo) {
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        List appList = this.paasAppsInfoService.queryListByPage((Object)appParam);
        if (CollectionUtils.isNotEmpty((Collection)appList)) {
            return this.getResponseData(-1, "", "\u6709\u5173\u8054\u7684\u5e94\u7528\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        int outputVo = this.paasTemplateInfoService.deleteByPk((Object)inPaasTemplateInfoVo);
        PaasTemplateParamDTO paasTemplateParamVO = new PaasTemplateParamDTO();
        paasTemplateParamVO.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        this.paasTemplateParamService.deleteByAppTemplateId(paasTemplateParamVO);
        PaasTemplateSqlDTO sqlParam = new PaasTemplateSqlDTO();
        sqlParam.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        this.paasTemplateSqlService.deleteByAppTemplateId(sqlParam);
        PaasTemplateDuDTO duParam = new PaasTemplateDuDTO();
        duParam.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        this.paasTemplateDuService.deleteByAppTemplateId(duParam);
        PaasTemplateActionDTO actionParam = new PaasTemplateActionDTO();
        actionParam.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        this.paasTemplateActionService.deleteByAppTemplateId(actionParam);
        PaasTemplateComDTO comParam = new PaasTemplateComDTO();
        comParam.setAppTemplateId(inPaasTemplateInfoVo.getAppTemplateId());
        this.paasTemplateComService.deleteByAppTemplateId(comParam);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/portal/paas/template/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTemplateInfoDTO inPaasTemplateInfoVo) {
        int outputVo = this.paasTemplateInfoService.updateByPk((Object)inPaasTemplateInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/portal/paas/template/info/{appTemplateId}"})
    @ResponseBody
    public ResponseData<PaasTemplateInfoDTO> queryByPk(@PathVariable(value="appTemplateId") String appTemplateId) {
        PaasTemplateInfoDTO inVo = new PaasTemplateInfoDTO();
        inVo.setAppTemplateId(appTemplateId);
        PaasTemplateInfoDTO outputVo = (PaasTemplateInfoDTO)this.paasTemplateInfoService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/template/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateInfoDTO>> queryPaasTemplateInfoAll(PaasTemplateInfoDTO vo) {
        String sysId = this.request.getParameter("sysId");
        if (StringUtils.isNotBlank((CharSequence)sysId)) {
            // empty if block
        }
        List outputVo = null;
        this.setUserInfoToVO(vo);
        if (StringUtils.contains((CharSequence)vo.getAppType(), (CharSequence)",")) {
            vo.setAppTypes(Arrays.asList(StringUtils.split((String)vo.getAppType(), (String)",")));
            vo.setAppType(null);
        }
        outputVo = this.paasTemplateInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/template/infos/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateSummaryDTO>> queryTemplateSummary(PaasTemplateInfoDTO vo) {
        List outputVo = null;
        outputVo = this.paasTemplateInfoService.queryTemplateSummary(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/template/infos/prod"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateInfoDTO>> queryAllProdAppsByPage(PaasTemplateInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasTemplateInfoService.queryAllProdAppsByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/template/infos/component"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateInfoDTO>> queryAllComponentByPage(PaasTemplateInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasTemplateInfoService.queryAllComponentByPage(vo);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/portal/paas/template/info/helpfile/view"}, method={RequestMethod.GET})
    public void templateFileStream(@RequestParam(value="appTemplateId") String appTemplateId, @RequestParam(value="path") String path, @RequestParam(value="root", required=false) String root, HttpServletResponse response) throws IOException {
        block19: {
            File targetFile;
            block20: {
                path = URLDecoder.decode(path, "UTF-8");
                PaasTemplateInfoDTO templateParam = new PaasTemplateInfoDTO();
                templateParam.setAppTemplateId(appTemplateId);
                PaasTemplateInfoDTO templateInfo = (PaasTemplateInfoDTO)this.paasTemplateInfoService.queryByPk((Object)templateParam);
                AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(templateInfo.getAppTemplateId(), templateInfo.getAppTemplateGitUrl());
                templateRepoPullTask.syncRun();
                String appTemplatePath = templateRepoPullTask.getAppTemplatePath();
                File templateHelpDir = new File(appTemplatePath, templateInfo.getAppTemplateId() + "-help");
                if (StringUtils.equals((CharSequence)root, (CharSequence)"true")) {
                    templateHelpDir = new File(appTemplatePath);
                }
                targetFile = new File(templateHelpDir, path);
                String suffix = this.getFileSuffix(targetFile);
                if (targetFile == null) break block20;
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int bytesRead;
                    response.setContentType("application/" + suffix);
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
                    ServletOutputStream out = response.getOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(targetFile));
                    bos = new BufferedOutputStream((OutputStream)out);
                    byte[] buff = new byte[2048];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    ResourceCloseUtil.closeInputStream((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block19;
                }
                finally {
                    ResourceCloseUtil.closeInputStream(bis);
                    ResourceCloseUtil.closeOutputStream(bos);
                }
                ResourceCloseUtil.closeOutputStream((OutputStream)bos);
                break block19;
            }
            response.setContentType("application/text;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            try (PrintWriter rsp = response.getWriter();){
                rsp.write("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
    }

    private String getFileSuffix(File file) {
        String fileName = file.getName();
        String[] names = StringUtils.split((String)fileName, (String)".");
        return (names.length > 1 ? names[names.length - 1] : "text").toLowerCase();
    }

    @RequestMapping(value={"/api/portal/paas/template/info/helpfiles"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<TemplateFile>> fetchAppTemplateRepoHelpFiles(@RequestParam(value="appTemplateId") String appTemplateId, @RequestParam(value="root", required=false) String root) {
        PaasTemplateInfoDTO templateParam = new PaasTemplateInfoDTO();
        templateParam.setAppTemplateId(appTemplateId);
        PaasTemplateInfoDTO templateInfo = (PaasTemplateInfoDTO)this.paasTemplateInfoService.queryByPk((Object)templateParam);
        AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(templateInfo.getAppTemplateId(), templateInfo.getAppTemplateGitUrl());
        templateRepoPullTask.syncRun();
        String appTemplatePath = templateRepoPullTask.getAppTemplatePath();
        File templateHelpDir = new File(appTemplatePath, templateInfo.getAppTemplateId() + "-help");
        if (StringUtils.equals((CharSequence)root, (CharSequence)"true")) {
            templateHelpDir = new File(appTemplatePath);
        }
        ArrayList<TemplateFile> files = new ArrayList<TemplateFile>();
        if (templateHelpDir.exists() && templateHelpDir.isDirectory()) {
            File[] subFiles;
            int id = 1;
            for (File file : subFiles = templateHelpDir.listFiles()) {
                if (StringUtils.equalsAny((CharSequence)file.getName(), (CharSequence[])new CharSequence[]{".git", ".gitignore"})) continue;
                TemplateFile templateFile = new TemplateFile();
                templateFile.setAppTemplateId(appTemplateId);
                templateFile.setId(String.valueOf(id++));
                templateFile.setText(file.getName());
                templateFile.setpId("root");
                templateFile.setSuffix(this.getFileSuffix(file));
                templateFile.setType(file.isDirectory() ? "d" : "f");
                templateFile.setPath(this.wrapTemplateFilePath(templateHelpDir.getAbsolutePath(), file.getAbsolutePath()));
                files.add(templateFile);
                this.recursionTemplateHelpFile(file, templateHelpDir, appTemplateId, templateFile.getId(), files);
            }
        }
        return this.getResponseData(files);
    }

    private String wrapTemplateFilePath(String appTemplatePath, String filePath) {
        String newPath = StringUtils.replaceOnce((String)filePath, (String)appTemplatePath, (String)"");
        newPath = StringUtils.replace((String)newPath, (String)File.separator, (String)"/");
        return newPath;
    }

    private void recursionTemplateHelpFile(File parentFile, File templateHelpDir, String appTemplateId, String pId, List<TemplateFile> files) {
        File[] subFiles;
        if (parentFile == null || parentFile.isFile()) {
            return;
        }
        int id = 1;
        for (File file : subFiles = parentFile.listFiles()) {
            TemplateFile templateFile = new TemplateFile();
            templateFile.setAppTemplateId(appTemplateId);
            templateFile.setId(pId + String.valueOf(id++));
            templateFile.setText(file.getName());
            templateFile.setpId(pId);
            templateFile.setSuffix(this.getFileSuffix(file));
            templateFile.setType(file.isDirectory() ? "d" : "f");
            templateFile.setPath(this.wrapTemplateFilePath(templateHelpDir.getAbsolutePath(), file.getAbsolutePath()));
            files.add(templateFile);
            this.recursionTemplateHelpFile(file, templateHelpDir, appTemplateId, templateFile.getId(), files);
        }
    }

    @RequestMapping(value={"/api/portal/paas/template/infos/counts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateInfoDTO>> queryListWithCountByPage(PaasTemplateInfoDTO paasTemplateInfo) {
        this.setUserInfoToVO(paasTemplateInfo);
        List outputVo = this.paasTemplateInfoService.queryListWithCountByPage(paasTemplateInfo);
        return this.getResponseData(outputVo);
    }

    public static class TemplateFile {
        private String appTemplateId;
        private String id;
        private String text;
        private String type;
        private String suffix;
        private String pId;
        private String path;

        public String getAppTemplateId() {
            return this.appTemplateId;
        }

        public void setAppTemplateId(String appTemplateId) {
            this.appTemplateId = appTemplateId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getpId() {
            return this.pId;
        }

        public void setpId(String pId) {
            this.pId = pId;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }
}

