/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.SSubsDatasourcePortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsDatasourceDTO;
import com.irdstudio.allinapaas.portal.console.types.SSubsDSType;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SSubsDatasourcePortalController
extends AbstractController {
    @Autowired
    protected SSubsDatasourcePortalService sSubsDatasourceService;

    @RequestMapping(value={"/api/portal/s/subs/datasources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsDatasourceDTO>> querySSubsDatasourceAll(SSubsDatasourceDTO vo) {
        List outputVo = this.sSubsDatasourceService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/datasource/{subsId}/{subsDsCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SSubsDatasourceDTO> queryByPk(@PathVariable(value="subsId") String subsId, @PathVariable(value="subsDsCode") String subsDsCode) {
        SSubsDatasourceDTO inVo = new SSubsDatasourceDTO();
        inVo.setSubsId(subsId);
        inVo.setSubsDsCode(subsDsCode);
        SSubsDatasourceDTO outputVo = (SSubsDatasourceDTO)this.sSubsDatasourceService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/datasource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SSubsDatasourceDTO inSSubsDatasourceVo) {
        int outputVo = this.sSubsDatasourceService.deleteByPk((Object)inSSubsDatasourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/datasource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SSubsDatasourceDTO inSSubsDatasourceVo) {
        int outputVo = this.sSubsDatasourceService.updateByPk((Object)inSSubsDatasourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/datasource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSSubsDatasource(@RequestBody SSubsDatasourceDTO inSSubsDatasourceVo) {
        this.setUserInfoToVO(inSSubsDatasourceVo);
        int outputVo = this.sSubsDatasourceService.insert((Object)inSSubsDatasourceVo);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/portal/s/subs/datasource/connection/test"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> dsConnectionTest(@RequestParam(value="subsId") String subsId, @RequestParam(value="subsDsCode") String subsDsCode) {
        SSubsDatasourceDTO inVo = new SSubsDatasourceDTO();
        inVo.setSubsId(subsId);
        inVo.setSubsDsCode(subsDsCode);
        SSubsDatasourceDTO ds = (SSubsDatasourceDTO)this.sSubsDatasourceService.queryByPk((Object)inVo);
        SSubsDSType dsType = SSubsDSType.getByCode((String)ds.getSubsDsType());
        if (dsType == null) {
            dsType = SSubsDSType.MYSQL;
        }
        String dbms = dsType.getDbms();
        String dbUrl = ds.getDsConnStr();
        String dbUser = ds.getDsUserId();
        String dbPwd = ds.getDsUserPwd();
        String driverClass = "com.mysql.jdbc.Driver";
        switch (dbms) {
            case "425": {
                driverClass = "com.mysql.jdbc.Driver";
                break;
            }
            case "125": {
                driverClass = "oracle.jdbc.driver.OracleDriver";
                break;
            }
            default: {
                driverClass = "com.mysql.jdbc.Driver";
            }
        }
        DBImportPlugin readPlugin = DBImportPlugin.Factory.getInstance((int)Integer.valueOf(dbms));
        Connection conn = null;
        try {
            conn = readPlugin.getDBConnection(dbUrl, dbUser, dbPwd);
            if (conn != null) {
                ResponseData responseData = this.getResponseData("\u8fde\u63a5\u6210\u529f");
                return responseData;
            }
            ResponseData responseData = this.getResponseData("\u8fde\u63a5\u5931\u8d25");
            return responseData;
        }
        catch (Exception e) {
            ResponseData responseData = this.getResponseData("\u8fde\u63a5\u5931\u8d25\uff0c" + e.getMessage());
            return responseData;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

