/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.manager.console.web.controller.api;

import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasDocTemplateController
extends BaseController<PaasDocTemplateDTO, PaasDocTemplateService> {
    @RequestMapping(value={"/api/paas/doc/templates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasDocTemplateDTO>> queryPaasDocTemplateAll(PaasDocTemplateDTO vo) {
        List outputVo = ((PaasDocTemplateService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/doc/template/{docTid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasDocTemplateDTO> queryByPk(@PathVariable(value="docTid") String docTid) {
        PaasDocTemplateDTO inVo = new PaasDocTemplateDTO();
        inVo.setDocTid(docTid);
        PaasDocTemplateDTO outputVo = (PaasDocTemplateDTO)((PaasDocTemplateService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/doc/template"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasDocTemplateDTO inPaasDocTemplateVo) {
        int outputVo = ((PaasDocTemplateService)this.getService()).deleteByPk((Object)inPaasDocTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/doc/template"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasDocTemplateDTO inPaasDocTemplateVo) {
        int outputVo = ((PaasDocTemplateService)this.getService()).updateByPk((Object)inPaasDocTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/doc/template"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasDocTemplate(@RequestBody PaasDocTemplateDTO inPaasDocTemplateVo) {
        this.setUserInfoToVO(inPaasDocTemplateVo);
        inPaasDocTemplateVo.setCreateUser(inPaasDocTemplateVo.getLoginUserId());
        inPaasDocTemplateVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((String)inPaasDocTemplateVo.getDocTid())) {
            inPaasDocTemplateVo.setDocTid(UUIDUtil.getUUID());
        }
        int outputVo = ((PaasDocTemplateService)this.getService()).insert((Object)inPaasDocTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/doc/template/max"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> queryDirMaxOrder(@RequestBody PaasDocTemplateDTO inPaasDocTemplateVo) {
        int outputVo = ((PaasDocTemplateService)this.getService()).queryDirMaxOrder(inPaasDocTemplateVo);
        return this.getResponseData(outputVo);
    }
}

