/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.ops.console.web.controller.api;

import com.irdstudio.allinapaas.admin.console.facade.PaasSubsToolService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsToolDTO;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasCbaFtpController
extends AbstractController {
    @Autowired
    private PaasSubsToolService paasSubsToolService;
    @Value(value="${tdp.ftp.path:/tdpaas/ftp/}")
    private String ftpRootPath;

    @RequestMapping(value={"/api/paas/ftp/dirs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> getFtpDirs(@RequestParam(value="cbaCode", required=true) String cbaCode, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="envId", required=false) String envId) {
        PaasSubsToolDTO ftpToolInfo = new PaasSubsToolDTO();
        ftpToolInfo.setCbaCode(cbaCode);
        ftpToolInfo.setEnvId(envId);
        List ftpInfos = this.paasSubsToolService.queryListByPage((Object)ftpToolInfo);
        if (CollectionUtils.isEmpty((Collection)ftpInfos)) {
            return this.getResponseData(Collections.emptyList());
        }
        ftpToolInfo = (PaasSubsToolDTO)ftpInfos.get(0);
        logger.info("FTP\u670d\u52a1\u5668\u4fe1\u606f\u4fe1\u606f\uff1a{}", (Object)ftpToolInfo.getToolUrl());
        String rootPath = this.ftpRootPath;
        logger.info("ftp\u6839\u76ee\u5f55:{}", (Object)rootPath);
        RemoteSSHClient sshClient = new RemoteSSHClient(ftpToolInfo.getToolUrl(), ftpToolInfo.getToolUserId(), ftpToolInfo.getToolPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
        }
        Object targetPath = this.ftpRootPath;
        if (StringUtils.isNotBlank((CharSequence)subsId)) {
            targetPath = (String)targetPath + (((String)targetPath).endsWith("/") ? "" : "/") + subsId;
        }
        List fileList = sshClient.fetchFiles((String)targetPath, false);
        return this.getResponseData(fileList);
    }

    @RequestMapping(value={"/api/paas/ftp/download"}, method={RequestMethod.GET})
    @ResponseBody
    public void ftpDownLoad(@RequestParam(value="cbaCode", required=true) String cbaCode, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="path", required=true) String path, @RequestParam(value="text", required=true) String text, HttpServletResponse response) {
        OutputStream bos = null;
        try {
            PaasSubsToolDTO ftpToolInfo = new PaasSubsToolDTO();
            ftpToolInfo.setCbaCode(cbaCode);
            ftpToolInfo.setEnvId(envId);
            List ftpInfos = this.paasSubsToolService.queryListByPage((Object)ftpToolInfo);
            if (CollectionUtils.isEmpty((Collection)ftpInfos)) {
                throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            ftpToolInfo = (PaasSubsToolDTO)ftpInfos.get(0);
            RemoteSSHClient sshClient = new RemoteSSHClient(ftpToolInfo.getToolUrl(), ftpToolInfo.getToolUserId(), ftpToolInfo.getToolPwd());
            boolean loginFlag = sshClient.connect();
            if (!loginFlag) {
                logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            path = StringUtils.replace((String)path, (String)"../", (String)"");
            String targetPath = this.ftpRootPath + "/" + path + "/" + text;
            String fileName = text;
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            response.setContentType("application/" + suffix + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            sshClient.download(targetPath.replace("//", "/").replace("//", "/"), (OutputStream)out);
            out.flush();
            return;
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u4e0b\u8f7d\u5f02\u5e38", e);
        }
        finally {
            ResourceCloseUtil.closeOutputStream(bos);
        }
    }

    @RequestMapping(value={"/api/summary/paas/tool/ftp"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySummaryPaasFtp(@RequestBody Map<String, Object> params) {
        String subsId = MapUtils.getString(params, (Object)"subsId");
        String cbaCode = MapUtils.getString(params, (Object)"cbaCode");
        String envId = "peds";
        int num = 0;
        try {
            ResponseData<List<Map<String, Object>>> treeData = this.getFtpDirs(cbaCode, subsId, envId);
            num = ((List)treeData.getRows()).size();
        }
        catch (Exception treeData) {
            // empty catch block
        }
        ArrayList list = new ArrayList();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("cName", "\u76ee\u5f55");
        item.put("name", "\u76ee\u5f55");
        item.put("num", num);
        list.add(item);
        return this.getResponseData(list);
    }
}

